/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public abstract class AtomicCancelableLazyValue<T> {
    private static final int TIMEOUT = 50;
    private volatile T myValue;
    private final ReentrantLock myLock = new ReentrantLock();

    @NotNull
    public final T getValue() {
        T curValue = this.myValue;
        if (curValue != null) {
            T t = curValue;
            if (t == null) {
                AtomicCancelableLazyValue.$$$reportNull$$$0(0);
            }
            return t;
        }
        Object object = ProgressIndicatorUtils.computeWithLockAndCheckingCanceled((Lock)this.myLock, (int)50, (TimeUnit)TimeUnit.MILLISECONDS, () -> {
            T value = this.myValue;
            if (value == null) {
                RecursionGuard.StackStamp stamp = RecursionManager.markStack();
                value = this.compute();
                if (stamp.mayCacheNow()) {
                    this.myValue = value;
                }
            }
            return value;
        });
        if (object == null) {
            AtomicCancelableLazyValue.$$$reportNull$$$0(1);
        }
        return (T)object;
    }

    @NotNull
    protected abstract T compute();

    public boolean isComputed() {
        return this.myValue != null;
    }

    @NotNull
    public static <T> AtomicCancelableLazyValue<T> createValue(final @NotNull NotNullFactory<? extends T> value) {
        if (value == null) {
            AtomicCancelableLazyValue.$$$reportNull$$$0(2);
        }
        return new AtomicCancelableLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object object = value.create();
                if (object == null) {
                    1.$$$reportNull$$$0(0);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/AtomicCancelableLazyValue$1", "compute"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/AtomicCancelableLazyValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/AtomicCancelableLazyValue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

