/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.FrameWrapperKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DisposableWindow;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0016J(\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020%H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/ui/MyJDialog;", "Ljavax/swing/JDialog;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "Lcom/intellij/openapi/wm/IdeFrame$Child;", "Lcom/intellij/ui/DisposableWindow;", "owner", "Lcom/intellij/openapi/ui/FrameWrapper;", "parent", "Lcom/intellij/openapi/wm/IdeFrame;", "<init>", "(Lcom/intellij/openapi/ui/FrameWrapper;Lcom/intellij/openapi/wm/IdeFrame;)V", "getComponent", "Ljavax/swing/JComponent;", "getStatusBar", "Lcom/intellij/openapi/wm/StatusBar;", "getBalloonLayout", "Lcom/intellij/ui/BalloonLayout;", "suggestChildFrameBounds", "Ljava/awt/Rectangle;", "getProject", "Lcom/intellij/openapi/project/Project;", "notifyProjectActivation", "", "setFrameTitle", "title", "", "dispose", "isWindowDisposed", "", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "paint", "g", "Ljava/awt/Graphics;", "reshape", "x", "", "y", "width", "height", "intellij.platform.ide.impl"})
final class MyJDialog
extends JDialog
implements UiDataProvider,
IdeFrame.Child,
DisposableWindow {
    @NotNull
    private final FrameWrapper owner;
    @NotNull
    private final IdeFrame parent;

    public MyJDialog(@NotNull FrameWrapper owner, @NotNull IdeFrame parent) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(ComponentUtil.getWindow((Component)parent.getComponent()));
        this.owner = owner;
        this.parent = parent;
        JRootPane jRootPane = this.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        this.setGlassPane(new IdeGlassPaneImpl(jRootPane, false, 2, null));
        this.getRootPane().putClientProperty("Window.style", "small");
        this.setBackground(UIUtil.getPanelBackground());
        MouseGestureManager.getInstance().add((IdeFrame)this);
        this.setFocusTraversalPolicy(new IdeFocusTraversalPolicy());
    }

    @NotNull
    public JComponent getComponent() {
        JRootPane jRootPane = this.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        return jRootPane;
    }

    @Nullable
    public StatusBar getStatusBar() {
        return null;
    }

    @Nullable
    public BalloonLayout getBalloonLayout() {
        return null;
    }

    @NotNull
    public Rectangle suggestChildFrameBounds() {
        Rectangle rectangle = this.parent.suggestChildFrameBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"suggestChildFrameBounds(...)");
        return rectangle;
    }

    @Nullable
    public Project getProject() {
        return this.parent.getProject();
    }

    public void notifyProjectActivation() {
        this.parent.notifyProjectActivation();
    }

    public void setFrameTitle(@NotNull String title2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        this.setTitle(title2);
    }

    @Override
    public void dispose() {
        if (this.owner.isDisposing) {
            return;
        }
        this.owner.isDisposing = true;
        Disposer.dispose((Disposable)this.owner);
        super.dispose();
        this.rootPane = null;
    }

    public boolean isWindowDisposed() {
        return this.owner.isDisposed();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = IdeFrame.KEY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"KEY");
        sink.set(dataKey, (Object)this);
        if (!this.owner.isDisposing) {
            DataSink.Companion.uiDataSnapshot(sink, (DataProvider)this.owner);
        }
        DataKey dataKey2 = CommonDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"PROJECT");
        sink.set(dataKey2, (Object)this.getProject());
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        UISettings.Companion.setupAntialiasing(g);
        super.paint(g);
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        if (FrameWrapperKt.access$getLOG$p().isTraceEnabled()) {
            FrameWrapperKt.access$getLOG$p().trace(new Throwable("FrameWrapper dialog bounds changed to " + x + ", " + y + ", " + width + ", " + height));
        }
        super.reshape(x, y, width, height);
    }
}

