/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.KeyboardFocusManager;
import java.awt.event.InputEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@ApiStatus.Internal
public final class ToggleActionCommand
extends AbstractCommand {
    public static final String PREFIX = "%toggle";
    public static final String ON = "on";
    public static final String OFF = "off";

    public ToggleActionCommand(String text2, int line) {
        super(text2, line, true);
    }

    @Override
    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        boolean on;
        if (context == null) {
            ToggleActionCommand.$$$reportNull$$$0(0);
        }
        String[] args = this.getText().substring(PREFIX.length()).trim().split(" ");
        String syntaxText = "Syntax error, expected: %toggle on|off actionName";
        if (args.length != 2) {
            context.error(syntaxText, this.getLine());
            Promise promise = Promises.rejectedPromise((Throwable)new RuntimeException(syntaxText));
            if (promise == null) {
                ToggleActionCommand.$$$reportNull$$$0(1);
            }
            return promise;
        }
        if (ON.equalsIgnoreCase(args[0])) {
            on = true;
        } else if (OFF.equalsIgnoreCase(args[0])) {
            on = false;
        } else {
            context.error(syntaxText, this.getLine());
            Promise promise = Promises.rejectedPromise((Throwable)new RuntimeException(syntaxText));
            if (promise == null) {
                ToggleActionCommand.$$$reportNull$$$0(2);
            }
            return promise;
        }
        String actionId = args[1];
        AnAction action2 = ActionManager.getInstance().getAction(actionId);
        if (action2 == null) {
            context.error("Unknown action id=" + actionId, this.getLine());
            Promise promise = Promises.rejectedPromise((Throwable)new RuntimeException("Unknown action id=" + actionId));
            if (promise == null) {
                ToggleActionCommand.$$$reportNull$$$0(3);
            }
            return promise;
        }
        if (!(action2 instanceof ToggleAction)) {
            String text2 = "Action is not a toggle action id=" + actionId;
            context.error(text2, this.getLine());
            Promise promise = Promises.rejectedPromise((String)text2);
            if (promise == null) {
                ToggleActionCommand.$$$reportNull$$$0(4);
            }
            return promise;
        }
        InputEvent inputEvent = ActionCommand.getInputEvent(actionId);
        ActionCallback result2 = new ActionCallback();
        context.getRobot().delay(Registry.intValue((String)"actionSystem.playback.delay"));
        IdeFocusManager fm = IdeFocusManager.getGlobalInstance();
        fm.doWhenFocusSettlesDown(() -> {
            Presentation presentation2 = action2.getTemplatePresentation().clone();
            AnActionEvent event = new AnActionEvent(inputEvent, DataManager.getInstance().getDataContext(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()), "unknown", presentation2, ActionManager.getInstance(), 0);
            ActionUtil.performDumbAwareUpdate((AnAction)action2, (AnActionEvent)event, (boolean)true);
            boolean state2 = Toggleable.isSelected((Presentation)event.getPresentation());
            if (state2 != on) {
                ActionManager.getInstance().tryToExecute(action2, inputEvent, null, "unknown", true).doWhenProcessed(result2.createSetDoneRunnable());
            } else {
                result2.setDone();
            }
        });
        Promise promise = Promises.toPromise((ActionCallback)result2);
        if (promise == null) {
            ToggleActionCommand.$$$reportNull$$$0(5);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/playback/commands/ToggleActionCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/playback/commands/ToggleActionCommand";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

