/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UpdateOptions;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="UpdatesConfigurable", storages={@Storage(value="updates.xml", roamingType=RoamingType.DISABLED, exportable=true)})
public class UpdateSettings
implements PersistentStateComponentWithModificationTracker<UpdateOptions> {
    private UpdateOptions myState = new UpdateOptions();

    public static UpdateSettings getInstance() {
        return (UpdateSettings)ApplicationManager.getApplication().getService(UpdateSettings.class);
    }

    @NotNull
    public UpdateOptions getState() {
        UpdateOptions updateOptions = this.myState;
        if (updateOptions == null) {
            UpdateSettings.$$$reportNull$$$0(0);
        }
        return updateOptions;
    }

    public void loadState(@NotNull UpdateOptions state2) {
        if (state2 == null) {
            UpdateSettings.$$$reportNull$$$0(1);
        }
        this.myState = state2;
    }

    @Nullable
    public String getLastBuildChecked() {
        return this.myState.getLastBuildChecked();
    }

    @NotNull
    public List<String> getStoredPluginHosts() {
        List<String> list2 = this.myState.getPluginHosts();
        if (list2 == null) {
            UpdateSettings.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public boolean isCheckNeeded() {
        return this.myState.isCheckNeeded();
    }

    public void setCheckNeeded(boolean value) {
        this.myState.setCheckNeeded(value);
    }

    public boolean isPluginsAutoUpdateEnabled() {
        return this.myState.isPluginsAutoUpdateEnabled();
    }

    public void setPluginsAutoUpdateEnabled(boolean value) {
        this.myState.setPluginsAutoUpdateEnabled(value);
    }

    public boolean isPluginsCheckNeeded() {
        return this.myState.isPluginsCheckNeeded();
    }

    public void setPluginsCheckNeeded(boolean value) {
        this.myState.setPluginsCheckNeeded(value);
    }

    public boolean isShowWhatsNewEditor() {
        return this.myState.isShowWhatsNewEditor();
    }

    public int getWhatsNewShownFor() {
        return this.myState.getWhatsNewShownFor();
    }

    public void setWhatsNewShownFor(int version) {
        this.myState.setWhatsNewShownFor(version);
    }

    public long getLastTimeChecked() {
        return this.myState.getLastTimeChecked();
    }

    @NotNull
    public List<String> getIgnoredBuildNumbers() {
        List<String> list2 = this.myState.getIgnoredBuildNumbers();
        if (list2 == null) {
            UpdateSettings.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public ChannelStatus getSelectedChannelStatus() {
        ChannelStatus channelStatus = ChannelStatus.fromCode(this.myState.getUpdateChannelType());
        if (channelStatus == null) {
            UpdateSettings.$$$reportNull$$$0(4);
        }
        return channelStatus;
    }

    public void setSelectedChannelStatus(@NotNull ChannelStatus channel) {
        if (channel == null) {
            UpdateSettings.$$$reportNull$$$0(5);
        }
        this.myState.setUpdateChannelType(channel.getCode());
    }

    @NotNull
    public List<ChannelStatus> getActiveChannels() {
        UpdateStrategyCustomization tweaker = UpdateStrategyCustomization.getInstance();
        List<ChannelStatus> list2 = Stream.of(ChannelStatus.values()).filter(ch -> ch == ChannelStatus.EAP || ch == ChannelStatus.RELEASE || tweaker.isChannelActive((ChannelStatus)((Object)ch))).collect(Collectors.toList());
        if (list2 == null) {
            UpdateSettings.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public ChannelStatus getSelectedActiveChannel() {
        ChannelStatus current;
        UpdateStrategyCustomization tweaker = UpdateStrategyCustomization.getInstance();
        ChannelStatus channelStatus = tweaker.isChannelActive(current = this.getSelectedChannelStatus()) ? current : this.getActiveChannels().stream().filter(ch -> ch.compareTo(current) > 0).findFirst().orElse(ChannelStatus.RELEASE);
        if (channelStatus == null) {
            UpdateSettings.$$$reportNull$$$0(7);
        }
        return channelStatus;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public List<String> getPluginHosts() {
        List<String> list2 = this.getStoredPluginHosts();
        if (list2 == null) {
            UpdateSettings.$$$reportNull$$$0(8);
        }
        return list2;
    }

    public void forceCheckForUpdateAfterRestart() {
        this.myState.setLastTimeChecked(0L);
    }

    public void saveLastCheckedInfo() {
        this.myState.setLastBuildChecked(ApplicationInfo.getInstance().getBuild().asString());
        this.myState.setLastTimeChecked(System.currentTimeMillis());
    }

    public boolean isThirdPartyPluginsAllowed() {
        return this.myState.isThirdPartyPluginsAllowed();
    }

    public void setThirdPartyPluginsAllowed(boolean value) {
        this.myState.setThirdPartyPluginsAllowed(value);
    }

    public boolean isObsoleteCustomRepositoriesCleanNeeded() {
        return this.myState.isObsoleteCustomRepositoriesCleanNeeded();
    }

    public void setObsoleteCustomRepositoriesCleanNeeded(boolean value) {
        this.myState.setObsoleteCustomRepositoriesCleanNeeded(value);
    }

    public long getStateModificationCount() {
        return this.myState.getModificationCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/UpdateSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStoredPluginHosts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredBuildNumbers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChannelStatus";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveChannels";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedActiveChannel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginHosts";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedChannelStatus";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 5 -> new IllegalArgumentException(string);
        };
    }
}

