/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PlatformUpdates;
import com.intellij.openapi.updateSettings.impl.Product;
import com.intellij.openapi.updateSettings.impl.UpdateChain;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.BuildRange;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.graph.impl.ShortestPathFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\"\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateStrategy;", "", "currentBuild", "Lcom/intellij/openapi/util/BuildNumber;", "product", "Lcom/intellij/openapi/updateSettings/impl/Product;", "settings", "Lcom/intellij/openapi/updateSettings/impl/UpdateSettings;", "customization", "Lcom/intellij/openapi/updateSettings/UpdateStrategyCustomization;", "<init>", "(Lcom/intellij/openapi/util/BuildNumber;Lcom/intellij/openapi/updateSettings/impl/Product;Lcom/intellij/openapi/updateSettings/impl/UpdateSettings;Lcom/intellij/openapi/updateSettings/UpdateStrategyCustomization;)V", "checkForUpdates", "Lcom/intellij/openapi/updateSettings/impl/PlatformUpdates;", "isApplicable", "", "candidate", "Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "ignoredBuilds", "", "", "compareBuilds", "", "n1", "n2", "patches", "Lcom/intellij/openapi/updateSettings/impl/UpdateChain;", "newBuild", "from", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nUpdateStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateStrategy.kt\ncom/intellij/openapi/updateSettings/impl/UpdateStrategy\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n608#2:104\n1#3:105\n774#4:106\n865#4,2:107\n1869#4:109\n1869#4:110\n1869#4,2:111\n1870#4:113\n1870#4:114\n*S KotlinDebug\n*F\n+ 1 UpdateStrategy.kt\ncom/intellij/openapi/updateSettings/impl/UpdateStrategy\n*L\n32#1:104\n67#1:106\n67#1:107,2\n68#1:109\n69#1:110\n71#1:111,2\n69#1:113\n68#1:114\n*E\n"})
public final class UpdateStrategy {
    @NotNull
    private final BuildNumber currentBuild;
    @Nullable
    private final Product product;
    @NotNull
    private final UpdateSettings settings;
    @NotNull
    private final UpdateStrategyCustomization customization;

    @JvmOverloads
    public UpdateStrategy(@NotNull BuildNumber currentBuild, @Nullable Product product, @NotNull UpdateSettings settings, @NotNull UpdateStrategyCustomization customization) {
        Intrinsics.checkNotNullParameter((Object)currentBuild, (String)"currentBuild");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)customization, (String)"customization");
        this.currentBuild = currentBuild;
        this.product = product;
        this.settings = settings;
        this.customization = customization;
    }

    public /* synthetic */ UpdateStrategy(BuildNumber buildNumber, Product product, UpdateSettings updateSettings, UpdateStrategyCustomization updateStrategyCustomization, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            product = null;
        }
        if ((n & 4) != 0) {
            UpdateSettings updateSettings2 = UpdateSettings.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)updateSettings2, (String)"getInstance(...)");
            updateSettings = updateSettings2;
        }
        if ((n & 8) != 0) {
            updateStrategyCustomization = UpdateStrategyCustomization.Companion.getInstance();
        }
        this(buildNumber, product, updateSettings, updateStrategyCustomization);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PlatformUpdates checkForUpdates() {
        PlatformUpdates platformUpdates;
        void $this$sortedBy$iv;
        if (this.product == null || this.product.getChannels().isEmpty()) {
            return PlatformUpdates.Empty.INSTANCE;
        }
        ChannelStatus channelStatus = this.settings.getSelectedChannelStatus();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)channelStatus), (String)"getSelectedChannelStatus(...)");
        ChannelStatus selectedChannel = channelStatus;
        List<String> list2 = this.settings.getIgnoredBuildNumbers();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getIgnoredBuildNumbers(...)");
        Set ignoredBuilds = CollectionsKt.toSet((Iterable)list2);
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.product.getChannels()), arg_0 -> UpdateStrategy.checkForUpdates$lambda$0(this, selectedChannel, arg_0));
        boolean $i$f$sortedBy = false;
        Pair pair = (Pair)SequencesKt.maxWithOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                UpdateChannel ch = (UpdateChannel)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)ch.getStatus());
                ch = (UpdateChannel)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)ch.getStatus())));
            }
        }), UpdateStrategy::checkForUpdates$lambda$2), arg_0 -> UpdateStrategy.checkForUpdates$lambda$3(this, ignoredBuilds, arg_0)), (arg_0, arg_1) -> UpdateStrategy.checkForUpdates$lambda$4(this, arg_0, arg_1));
        if (pair != null) {
            Pair pair2 = pair;
            boolean bl = false;
            BuildInfo newBuild = (BuildInfo)pair2.component1();
            UpdateChannel channel = (UpdateChannel)pair2.component2();
            platformUpdates = new PlatformUpdates.Loaded(newBuild, channel, this.patches(newBuild, this.product, this.currentBuild));
        } else {
            platformUpdates = PlatformUpdates.Empty.INSTANCE;
        }
        return platformUpdates;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApplicable(BuildInfo candidate, Set<String> ignoredBuilds) {
        if (!this.customization.isNewerVersion(candidate.getNumber(), this.currentBuild)) return false;
        if (ignoredBuilds.contains(candidate.getNumber().asStringWithoutProductCode())) return false;
        BuildRange buildRange = candidate.getTarget();
        if (buildRange == null) return true;
        boolean bl = buildRange.inRange(this.currentBuild);
        if (!bl) return false;
        return true;
    }

    private final int compareBuilds(BuildNumber n1, BuildNumber n2) {
        int preferSameMajorVersion = Boolean.compare(this.customization.haveSameMajorVersion(this.currentBuild, n1), this.customization.haveSameMajorVersion(this.currentBuild, n2));
        return preferSameMajorVersion != 0 ? preferSameMajorVersion : n1.compareTo(n2);
    }

    /*
     * WARNING - void declaration
     */
    private final UpdateChain patches(BuildInfo newBuild, Product product, BuildNumber from) {
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object v0;
        Object it;
        block9: {
            Iterable iterable = newBuild.getPatches();
            for (Object t : iterable) {
                it = (PatchInfo)t;
                boolean bl = false;
                if (!(((PatchInfo)it).isAvailable() && ((PatchInfo)it).getFromBuild().compareTo(from) == 0)) continue;
                v0 = t;
                break block9;
            }
            v0 = null;
        }
        PatchInfo single = v0;
        if (single != null) {
            Object[] objectArray = new BuildNumber[]{from, newBuild.getNumber()};
            return new UpdateChain(CollectionsKt.listOf((Object[])objectArray), single.getSize());
        }
        ChannelStatus channelStatus = this.settings.getSelectedChannelStatus();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)channelStatus), (String)"getSelectedChannelStatus(...)");
        ChannelStatus selectedChannel = channelStatus;
        MultiMap upgrades = new MultiMap();
        Map sizes = new LinkedHashMap();
        Regex number = new Regex("\\d+");
        it = product.getChannels();
        boolean $i$f$filter = false;
        void var11_13 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            UpdateChannel ch = (UpdateChannel)element$iv$iv;
            boolean bl = false;
            if (!this.customization.canBeUsedForIntermediatePatches(ch, selectedChannel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UpdateChannel channel = (UpdateChannel)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = channel.getBuilds();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                BuildInfo build2 = (BuildInfo)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)build2.getNumber().withoutProductCode(), (String)"withoutProductCode(...)");
                Iterable $this$forEach$iv3 = build2.getPatches();
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    Integer maxSize;
                    BuildNumber fromBuild;
                    BuildNumber toBuild;
                    PatchInfo patch = (PatchInfo)element$iv3;
                    boolean bl3 = false;
                    if (!patch.isAvailable()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)patch.getFromBuild().withoutProductCode(), (String)"withoutProductCode(...)");
                    upgrades.putValue((Object)toBuild, (Object)fromBuild);
                    if (patch.getSize() == null || (maxSize = (Integer)SequencesKt.maxOrNull((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)number, (CharSequence)patch.getSize(), (int)0, (int)2, null), UpdateStrategy::patches$lambda$2$0$0$0)))) == null) continue;
                    Map map2 = sizes;
                    Pair pair = TuplesKt.to((Object)TuplesKt.to((Object)fromBuild, (Object)toBuild), (Object)maxSize);
                    map2.put(pair.getFirst(), pair.getSecond());
                }
            }
        }
        InboundSemiGraph<BuildNumber> graph2 = new InboundSemiGraph<BuildNumber>((MultiMap<BuildNumber, BuildNumber>)upgrades){
            final /* synthetic */ MultiMap<BuildNumber, BuildNumber> $upgrades;
            {
                this.$upgrades = $upgrades;
            }

            public Set<BuildNumber> getNodes() {
                Set set = this.$upgrades.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
                Collection collection = this.$upgrades.values();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
                return SetsKt.plus((Set)set, (Iterable)collection);
            }

            public Iterator<BuildNumber> getIn(BuildNumber n) {
                Intrinsics.checkNotNullParameter((Object)n, (String)"n");
                return this.$upgrades.get((Object)n).iterator();
            }
        };
        List path = new ShortestPathFinder((InboundSemiGraph)graph2).findPath((Object)from.withoutProductCode(), (Object)newBuild.getNumber().withoutProductCode());
        if (path == null || path.size() <= 2) {
            return null;
        }
        int total = 0;
        int n = path.size();
        for (int i2 = 1; i2 < n; ++i2) {
            Integer size2 = (Integer)sizes.get(TuplesKt.to(path.get(i2 - 1), path.get(i2)));
            if (size2 == null) {
                total = -1;
                break;
            }
            total += size2.intValue();
        }
        return new UpdateChain(path, total > 0 ? String.valueOf(total) : null);
    }

    @JvmOverloads
    public UpdateStrategy(@NotNull BuildNumber currentBuild, @Nullable Product product, @NotNull UpdateSettings settings) {
        Intrinsics.checkNotNullParameter((Object)currentBuild, (String)"currentBuild");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this(currentBuild, product, settings, null, 8, null);
    }

    @JvmOverloads
    public UpdateStrategy(@NotNull BuildNumber currentBuild, @Nullable Product product) {
        Intrinsics.checkNotNullParameter((Object)currentBuild, (String)"currentBuild");
        this(currentBuild, product, null, null, 12, null);
    }

    @JvmOverloads
    public UpdateStrategy(@NotNull BuildNumber currentBuild) {
        Intrinsics.checkNotNullParameter((Object)currentBuild, (String)"currentBuild");
        this(currentBuild, null, null, null, 14, null);
    }

    private static final boolean checkForUpdates$lambda$0(UpdateStrategy this$0, ChannelStatus $selectedChannel, UpdateChannel ch) {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        return this$0.customization.isChannelApplicableForUpdates(ch, $selectedChannel);
    }

    private static final Sequence checkForUpdates$lambda$2(UpdateChannel ch) {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)ch.getBuilds()), arg_0 -> UpdateStrategy.checkForUpdates$lambda$2$0(ch, arg_0));
    }

    private static final Pair checkForUpdates$lambda$2$0(UpdateChannel $ch, BuildInfo build2) {
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        return TuplesKt.to((Object)build2, (Object)$ch);
    }

    private static final boolean checkForUpdates$lambda$3(UpdateStrategy this$0, Set $ignoredBuilds, Pair p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this$0.isApplicable((BuildInfo)p.getFirst(), $ignoredBuilds);
    }

    private static final int checkForUpdates$lambda$4(UpdateStrategy this$0, Pair p1, Pair p2) {
        return this$0.compareBuilds(((BuildInfo)p1.getFirst()).getNumber(), ((BuildInfo)p2.getFirst()).getNumber());
    }

    private static final Integer patches$lambda$2$0$0$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.toIntOrNull((String)it.getValue());
    }
}

