/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.windows;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.SuggestedIde;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.DownloadResult;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.InstallationResult;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.UltimateInstallationInfo;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.UltimateInstallationServiceKt;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.UltimateInstaller;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.UltimateInstallerKt;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.windows.PathInfo;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.PathKt;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Shell32Util;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0013H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/windows/WindowsInstaller;", "Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/UltimateInstaller;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/project/Project;)V", "postfix", "", "getPostfix", "()Ljava/lang/String;", "installUltimate", "Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/InstallationResult;", "downloadResult", "Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/DownloadResult;", "providePath", "Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/windows/PathInfo;", "installPath", "Ljava/nio/file/Path;", "suggestedIde", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/SuggestedIde;", "findExePath", "installSilently", "path", "provideInstallPath", "startUltimate", "", "installationResult", "getUltimateInstallationDirectory", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nWindowsInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsInstaller.kt\ncom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/windows/WindowsInstaller\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,112:1\n52#2:113\n*S KotlinDebug\n*F\n+ 1 WindowsInstaller.kt\ncom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/windows/WindowsInstaller\n*L\n86#1:113\n*E\n"})
public final class WindowsInstaller
extends UltimateInstaller {
    @NotNull
    private final String postfix;

    public WindowsInstaller(@NotNull CoroutineScope scope, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(scope, project2);
        this.postfix = ".exe";
    }

    @Override
    @NotNull
    public String getPostfix() {
        return this.postfix;
    }

    @Override
    @Nullable
    public InstallationResult installUltimate(@NotNull DownloadResult downloadResult2) {
        Intrinsics.checkNotNullParameter((Object)downloadResult2, (String)"downloadResult");
        Path downloadPath = downloadResult2.getDownloadPath();
        Path path = this.provideInstallPath(downloadResult2);
        if (path == null) {
            return null;
        }
        Path installPath = path;
        SuggestedIde suggestedIde = downloadResult2.getSuggestedIde();
        PathInfo pathInfo = this.providePath(installPath, suggestedIde);
        if (pathInfo == null) {
            return null;
        }
        PathInfo pathInfo2 = pathInfo;
        if (pathInfo2.getAlreadyInstalled()) {
            return new InstallationResult(pathInfo2.getPath(), new UltimateInstallationInfo(suggestedIde));
        }
        return this.installSilently(downloadPath, installPath, downloadResult2);
    }

    private final PathInfo providePath(Path installPath, SuggestedIde suggestedIde) {
        Path path = installPath;
        int counter = 0;
        while (true) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(installPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || counter++ > 10) break;
            if (this.findExePath(path, suggestedIde) != null) {
                return new PathInfo(installPath, true);
            }
            Path fileName = path.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)installPath.getParent().resolve(fileName + " " + counter), (String)"resolve(...)");
        }
        return counter > 10 ? null : new PathInfo(path, false);
    }

    private final String findExePath(Path installPath, SuggestedIde suggestedIde) {
        String exeName = UltimateInstallationServiceKt.isPycharmProfessional(suggestedIde) ? "pycharm64" : "idea64";
        Path exePath = installPath.resolve("bin").resolve(exeName + ".exe");
        Intrinsics.checkNotNull((Object)exePath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(exePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? ((Object)exePath).toString() : null;
    }

    private final InstallationResult installSilently(Path path, Path installPath, DownloadResult downloadResult2) {
        String[] stringArray = new String[]{"cmd.exe", "/c"};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray);
        stringArray = new String[]{path + " /S /D=" + installPath};
        GeneralCommandLine generalCommandLine2 = generalCommandLine.withParameters(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"withParameters(...)");
        GeneralCommandLine command = generalCommandLine2;
        boolean result2 = UltimateInstallerKt.runCommand(command);
        if (!result2) {
            PathKt.delete((Path)downloadResult2.getDownloadPath(), (boolean)true);
            return null;
        }
        return new InstallationResult(installPath, new UltimateInstallationInfo(downloadResult2.getSuggestedIde()));
    }

    private final Path provideInstallPath(DownloadResult downloadResult2) {
        String version = downloadResult2.getBuildVersion();
        String name2 = downloadResult2.getSuggestedIde().getName() + " " + version;
        Path path = this.getUltimateInstallationDirectory();
        return NioPathUtil.toNioPathOrNull((String)(path + File.separator + name2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean startUltimate(@NotNull InstallationResult installationResult2) {
        void v2;
        Intrinsics.checkNotNullParameter((Object)installationResult2, (String)"installationResult");
        Path appPath = installationResult2.getAppPath();
        String string = this.findExePath(appPath, installationResult2.getInstallationInfo().getSuggestedIde());
        if (string == null) {
            return false;
        }
        String exePath = string;
        String basePath = this.getProject().getBasePath();
        Object object = new String[]{"", exePath};
        object = CollectionsKt.mutableListOf((Object[])object);
        boolean condition$iv = basePath != null;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void $this$startUltimate_u24lambda_u240 = $this$applyIf$iv;
            boolean bl = false;
            String string2 = basePath;
            Intrinsics.checkNotNull((Object)string2);
            $this$startUltimate_u24lambda_u240.add(string2);
            v2 = $this$startUltimate_u24lambda_u240;
        } else {
            v2 = $this$applyIf$iv;
        }
        void parameters = v2;
        parameters.add(this.getTrialParameter());
        String[] stringArray = new String[]{"cmd", "/c", "start"};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray).withParameters((List)parameters);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withParameters(...)");
        GeneralCommandLine command = generalCommandLine;
        return UltimateInstallerKt.runCommand(command);
    }

    @Override
    @Nullable
    public Path getUltimateInstallationDirectory() {
        Path path;
        try {
            String string = Shell32Util.getKnownFolderPath((Guid.GUID)KnownFolders.FOLDERID_UserProgramFiles);
            path = string != null ? NioPathUtil.toNioPathOrNull((String)string) : null;
        }
        catch (Exception e) {
            Path localAppData;
            String string = Shell32Util.getKnownFolderPath((Guid.GUID)KnownFolders.FOLDERID_LocalAppData);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKnownFolderPath(...)");
            Path path2 = NioPathUtil.toNioPathOrNull((String)string);
            if (path2 == null) {
                String string2 = SystemProperties.getUserHome();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUserHome(...)");
                Path path3 = NioPathUtil.toNioPathOrNull((String)string2);
                path2 = path3 != null ? path3.resolve("AppData/Local") : null;
            }
            Path path4 = localAppData = path2;
            path = path4 != null ? path4.resolve("Programs") : null;
        }
        return path;
    }
}

