/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.openapi.vfs.encoding.IncompatibleEncodingDialog;
import com.intellij.util.Function;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeFileEncodingAction
extends AnAction
implements DumbAware,
LightEditCompatible {
    private final boolean allowDirectories;

    public ChangeFileEncodingAction() {
        this(false);
    }

    public ChangeFileEncodingAction(boolean allowDirectories) {
        this.allowDirectories = allowDirectories;
    }

    private boolean checkEnabled(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(0);
        }
        if (this.allowDirectories && virtualFile.isDirectory()) {
            return true;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document2 = documentManager.getDocument(virtualFile);
        if (document2 == null) {
            return false;
        }
        return EncodingUtil.checkCanConvert(virtualFile) == null || EncodingUtil.checkCanReload(virtualFile, null) == null;
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile myFile;
        if (e == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(1);
        }
        boolean enabled2 = (myFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null && this.checkEnabled(myFile);
        e.getPresentation().setEnabled(enabled2);
        e.getPresentation().setVisible(myFile != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext2;
        ListPopup popup2;
        if (e == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(3);
        }
        if ((popup2 = this.createPopup(dataContext2 = e.getDataContext(), null)) != null) {
            popup2.showInBestPositionFor(dataContext2);
        }
    }

    @Nullable
    public ListPopup createPopup(@NotNull DataContext dataContext2, @Nullable ActionGroup extraActions) {
        byte[] bytes;
        VirtualFile virtualFile;
        if (dataContext2 == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(4);
        }
        if ((virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext2)) == null) {
            return null;
        }
        boolean enabled2 = this.checkEnabled(virtualFile);
        if (!enabled2) {
            return null;
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document2 = documentManager.getDocument(virtualFile);
        if (!this.allowDirectories && virtualFile.isDirectory() || document2 == null && !virtualFile.isDirectory()) {
            return null;
        }
        try {
            bytes = virtualFile.isDirectory() ? null : VfsUtilCore.loadBytes((VirtualFile)virtualFile);
        }
        catch (IOException e) {
            return null;
        }
        DefaultActionGroup group2 = this.createActionGroup(virtualFile, editor2, document2, bytes, null);
        DefaultActionGroup popupGroup = new DefaultActionGroup();
        if (extraActions != null) {
            popupGroup.add((AnAction)extraActions);
            popupGroup.addSeparator();
        }
        popupGroup.add((AnAction)group2);
        return JBPopupFactory.getInstance().createActionGroupPopup(this.getTemplatePresentation().getText(), (ActionGroup)popupGroup, dataContext2, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
    }

    @NotNull
    public DefaultActionGroup createActionGroup(@Nullable VirtualFile myFile, final Editor editor2, final Document document2, final byte[] bytes, final @Nullable @NlsActions.ActionText String clearItemText) {
        final class MyAction
        extends ChooseFileEncodingAction {
            MyAction(VirtualFile virtualFile) {
                super(virtualFile);
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyAction.$$$reportNull$$$0(0);
                }
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    MyAction.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2, @NotNull DataContext dataContext2) {
                if (button2 == null) {
                    MyAction.$$$reportNull$$$0(2);
                }
                if (dataContext2 == null) {
                    MyAction.$$$reportNull$$$0(3);
                }
                DefaultActionGroup defaultActionGroup = this.createMyActionGroup();
                if (defaultActionGroup == null) {
                    MyAction.$$$reportNull$$$0(4);
                }
                return defaultActionGroup;
            }

            @NotNull
            DefaultActionGroup createMyActionGroup() {
                DefaultActionGroup defaultActionGroup = this.createCharsetsActionGroup(clearItemText, null, (Function<? super Charset, String>)((Function)charset -> IdeBundle.message((String)"action.text.change.encoding", (Object[])new Object[]{charset.displayName()})));
                if (defaultActionGroup == null) {
                    MyAction.$$$reportNull$$$0(5);
                }
                return defaultActionGroup;
            }

            @Override
            protected void chosen(@Nullable VirtualFile virtualFile, @NotNull Charset charset) {
                if (charset == null) {
                    MyAction.$$$reportNull$$$0(6);
                }
                ChangeFileEncodingAction.this.chosen(document2, editor2, virtualFile, bytes, charset);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction$1MyAction";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "button";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "charset";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction$1MyAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPopupActionGroup";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createMyActionGroup";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "createPopupActionGroup";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "chosen";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 4, 5 -> new IllegalStateException(string);
                };
            }
        }
        DefaultActionGroup defaultActionGroup = new MyAction(myFile).createMyActionGroup();
        if (defaultActionGroup == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(5);
        }
        return defaultActionGroup;
    }

    protected boolean chosen(Document document2, Editor editor2, @Nullable VirtualFile virtualFile, byte[] bytes, @NotNull Charset charset) {
        Project project2;
        if (charset == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(6);
        }
        if (virtualFile == null) {
            return false;
        }
        String text2 = document2.getText();
        EncodingUtil.Magic8 isSafeToConvert = EncodingUtil.isSafeToConvertTo(virtualFile, text2, bytes, charset);
        EncodingUtil.Magic8 isSafeToReload = EncodingUtil.isSafeToReloadIn(virtualFile, text2, bytes, charset);
        Project project3 = project2 = editor2 == null ? null : editor2.getProject();
        if (project2 == null) {
            project2 = ProjectLocator.getInstance().guessProjectForFile(virtualFile);
        }
        return ChangeFileEncodingAction.changeTo(Objects.requireNonNull(project2), document2, editor2, virtualFile, charset, isSafeToConvert, isSafeToReload);
    }

    public static boolean changeTo(final @NotNull Project project2, @NotNull Document document2, Editor editor2, @NotNull VirtualFile virtualFile, @NotNull Charset charset, @NotNull EncodingUtil.Magic8 isSafeToConvert, @NotNull EncodingUtil.Magic8 isSafeToReload) {
        Runnable redo;
        Runnable undo;
        if (project2 == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(7);
        }
        if (document2 == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(8);
        }
        if (virtualFile == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(9);
        }
        if (charset == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(10);
        }
        if (isSafeToConvert == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(11);
        }
        if (isSafeToReload == null) {
            ChangeFileEncodingAction.$$$reportNull$$$0(12);
        }
        Charset oldCharset = virtualFile.getCharset();
        if (isSafeToConvert == EncodingUtil.Magic8.ABSOLUTELY && isSafeToReload == EncodingUtil.Magic8.ABSOLUTELY) {
            EncodingProjectManager encodingManager = EncodingProjectManager.getInstance((Project)project2);
            undo = () -> ChangeFileEncodingAction.lambda$changeTo$0((EncodingManager)encodingManager, virtualFile, oldCharset);
            redo = () -> ChangeFileEncodingAction.lambda$changeTo$1((EncodingManager)encodingManager, virtualFile, charset);
        } else {
            IncompatibleEncodingDialog dialog2 = new IncompatibleEncodingDialog(virtualFile, charset, isSafeToReload, isSafeToConvert);
            dialog2.show();
            if (dialog2.getExitCode() == 10) {
                undo = () -> EncodingUtil.reloadIn(virtualFile, oldCharset, project2);
                redo = () -> EncodingUtil.reloadIn(virtualFile, charset, project2);
            } else if (dialog2.getExitCode() == 20) {
                undo = () -> EncodingUtil.saveIn(project2, document2, editor2, virtualFile, oldCharset);
                redo = () -> EncodingUtil.saveIn(project2, document2, editor2, virtualFile, charset);
            } else {
                return false;
            }
        }
        GlobalUndoableAction action2 = new GlobalUndoableAction(new VirtualFile[]{virtualFile}){

            public void undo() {
                Application application = ApplicationManager.getApplication();
                application.invokeLater(undo, ModalityState.nonModal(), project2.getDisposed());
            }

            public void redo() {
                Application application = ApplicationManager.getApplication();
                application.invokeLater(redo, ModalityState.nonModal(), project2.getDisposed());
            }
        };
        redo.run();
        CommandProcessor.getInstance().executeCommand(project2, () -> ChangeFileEncodingAction.lambda$changeTo$6(project2, (UndoableAction)action2), IdeBundle.message((String)"change.encoding.command.name", (Object[])new Object[]{virtualFile.getName()}), null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        return true;
    }

    private static /* synthetic */ void lambda$changeTo$6(Project project2, UndoableAction action2) {
        UndoManager undoManager = UndoManager.getInstance((Project)project2);
        undoManager.undoableActionPerformed(action2);
    }

    private static /* synthetic */ void lambda$changeTo$1(EncodingManager encodingManager, VirtualFile virtualFile, Charset charset) {
        encodingManager.setEncoding(virtualFile, charset);
    }

    private static /* synthetic */ void lambda$changeTo$0(EncodingManager encodingManager, VirtualFile virtualFile, Charset oldCharset) {
        encodingManager.setEncoding(virtualFile, oldCharset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isSafeToConvert";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isSafeToReload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/encoding/ChangeFileEncodingAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "chosen";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "changeTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

