/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.core.CoreBundle;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Forceable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.GentleFlusherBase;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSPaths;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.openapi.vfs.newvfs.persistent.VFSAttributesStorage;
import com.intellij.openapi.vfs.newvfs.persistent.recovery.VFSRecoveryInfo;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThreadSafeThrottler;
import com.intellij.util.io.DataEnumerator;
import com.intellij.util.io.ScannableDataEnumeratorEx;
import com.intellij.util.io.SimpleStringPersistentEnumerator;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.io.storage.VFSContentStorage;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class PersistentFSConnection {
    private static final Logger LOG = Logger.getInstance(PersistentFSConnection.class);
    private static final int INSIST_TO_RESTART_AFTER_ERRORS_COUNT = SystemProperties.getIntProperty((String)"vfs.insist-to-restart-after-n-errors", (int)1000);
    @NotNull
    private final NotNullLazyValue<? extends IntList> freeRecords;
    @NotNull
    private final PersistentFSPaths persistentFSPaths;
    @NotNull
    private final VFSAttributesStorage attributesStorage;
    @NotNull
    private final VFSContentStorage contentStorage;
    @NotNull
    private final PersistentFSRecordsStorage records;
    @NotNull
    private final ScannableDataEnumeratorEx<String> namesEnumerator;
    @NotNull
    private final SimpleStringPersistentEnumerator enumeratedAttributes;
    private volatile boolean closed;
    private final AtomicInteger corruptionsDetected;
    @NotNull
    private final VFSRecoveryInfo recoveryInfo;
    private final ThreadSafeThrottler corruptionNotificationThrottler;

    PersistentFSConnection(@NotNull PersistentFSPaths paths, @NotNull PersistentFSRecordsStorage records, @NotNull ScannableDataEnumeratorEx<String> names, @NotNull VFSAttributesStorage attributes, @NotNull VFSContentStorage contents, @NotNull SimpleStringPersistentEnumerator enumeratedAttributes, @NotNull NotNullLazyValue<? extends IntList> freeRecords, @NotNull VFSRecoveryInfo info) throws IOException {
        if (paths == null) {
            PersistentFSConnection.$$$reportNull$$$0(0);
        }
        if (records == null) {
            PersistentFSConnection.$$$reportNull$$$0(1);
        }
        if (names == null) {
            PersistentFSConnection.$$$reportNull$$$0(2);
        }
        if (attributes == null) {
            PersistentFSConnection.$$$reportNull$$$0(3);
        }
        if (contents == null) {
            PersistentFSConnection.$$$reportNull$$$0(4);
        }
        if (enumeratedAttributes == null) {
            PersistentFSConnection.$$$reportNull$$$0(5);
        }
        if (freeRecords == null) {
            PersistentFSConnection.$$$reportNull$$$0(6);
        }
        if (info == null) {
            PersistentFSConnection.$$$reportNull$$$0(7);
        }
        this.closed = false;
        this.corruptionsDetected = new AtomicInteger();
        this.corruptionNotificationThrottler = new ThreadSafeThrottler(5L, TimeUnit.MINUTES);
        if (!(names instanceof Forceable) || !(names instanceof Closeable)) {
            throw new IllegalArgumentException("names(" + String.valueOf(names) + ") must implement Forceable & Closeable");
        }
        this.records = records;
        this.namesEnumerator = names;
        this.attributesStorage = attributes;
        this.contentStorage = contents;
        this.persistentFSPaths = paths;
        this.freeRecords = freeRecords;
        this.enumeratedAttributes = enumeratedAttributes;
        this.recoveryInfo = info;
    }

    @VisibleForTesting
    @NotNull
    public DataEnumerator<String> attributesEnumerator() {
        SimpleStringPersistentEnumerator simpleStringPersistentEnumerator = this.enumeratedAttributes;
        if (simpleStringPersistentEnumerator == null) {
            PersistentFSConnection.$$$reportNull$$$0(8);
        }
        return simpleStringPersistentEnumerator;
    }

    int enumerateAttributeId(@NotNull String attributeId) {
        int enumeratedAttributeId;
        if (attributeId == null) {
            PersistentFSConnection.$$$reportNull$$$0(9);
        }
        if ((enumeratedAttributeId = this.enumeratedAttributes.enumerate(attributeId)) > VFSAttributesStorage.MAX_ATTRIBUTE_ID) {
            throw new IllegalStateException("attribute[" + attributeId + "] assigned id[" + enumeratedAttributeId + "] which is above max " + VFSAttributesStorage.MAX_ATTRIBUTE_ID + ". Current list of attributes: " + this.enumeratedAttributes.dumpToString());
        }
        return enumeratedAttributeId;
    }

    @VisibleForTesting
    @NotNull
    public VFSContentStorage contents() {
        VFSContentStorage vFSContentStorage = this.contentStorage;
        if (vFSContentStorage == null) {
            PersistentFSConnection.$$$reportNull$$$0(10);
        }
        return vFSContentStorage;
    }

    @VisibleForTesting
    @NotNull
    public VFSAttributesStorage attributes() {
        VFSAttributesStorage vFSAttributesStorage = this.attributesStorage;
        if (vFSAttributesStorage == null) {
            PersistentFSConnection.$$$reportNull$$$0(11);
        }
        return vFSAttributesStorage;
    }

    @VisibleForTesting
    @NotNull
    public ScannableDataEnumeratorEx<String> names() {
        ScannableDataEnumeratorEx<String> scannableDataEnumeratorEx = this.namesEnumerator;
        if (scannableDataEnumeratorEx == null) {
            PersistentFSConnection.$$$reportNull$$$0(12);
        }
        return scannableDataEnumeratorEx;
    }

    @NotNull
    public PersistentFSRecordsStorage records() {
        PersistentFSRecordsStorage persistentFSRecordsStorage = this.records;
        if (persistentFSRecordsStorage == null) {
            PersistentFSConnection.$$$reportNull$$$0(13);
        }
        return persistentFSRecordsStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    IntList freeRecords() {
        NotNullLazyValue<? extends IntList> notNullLazyValue = this.freeRecords;
        // MONITORENTER : notNullLazyValue
        IntArrayList intArrayList = new IntArrayList((IntList)this.freeRecords.getValue());
        // MONITOREXIT : notNullLazyValue
        if (intArrayList != null) return intArrayList;
        PersistentFSConnection.$$$reportNull$$$0(14);
        return intArrayList;
    }

    long creationTimestamp() throws IOException {
        return this.records.getTimestamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int reserveFreeRecord() {
        if (!this.freeRecords.isComputed()) {
            return -1;
        }
        NotNullLazyValue<? extends IntList> notNullLazyValue = this.freeRecords;
        synchronized (notNullLazyValue) {
            IntList records = (IntList)this.freeRecords.getValue();
            return records.isEmpty() ? -1 : records.removeInt(records.size() - 1);
        }
    }

    @TestOnly
    int persistentModCount() {
        return this.records.getGlobalModCount();
    }

    public boolean isDirty() {
        return this.records.isDirty() || ((Forceable)this.namesEnumerator).isDirty() || this.attributesStorage.isDirty() || this.contentStorage.isDirty();
    }

    @VisibleForTesting
    public void force() throws IOException {
        ((Forceable)this.namesEnumerator).force();
        this.attributesStorage.force();
        this.contentStorage.force();
        this.records.force();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.force();
        try {
            this.freeRecords.getValue();
        }
        catch (Throwable ex) {
            LOG.info("Free records loading is failed", ex);
        }
        try {
            PersistentFSConnection.closeStorages(this.records, this.namesEnumerator, this.attributesStorage, this.contentStorage);
        }
        finally {
            this.closed = true;
        }
    }

    @NotNull
    public PersistentFSPaths paths() {
        PersistentFSPaths persistentFSPaths = this.persistentFSPaths;
        if (persistentFSPaths == null) {
            PersistentFSConnection.$$$reportNull$$$0(15);
        }
        return persistentFSPaths;
    }

    int corruptionsDetected() {
        return this.corruptionsDetected.get();
    }

    @NotNull
    public VFSRecoveryInfo recoveryInfo() {
        VFSRecoveryInfo vFSRecoveryInfo = this.recoveryInfo;
        if (vFSRecoveryInfo == null) {
            PersistentFSConnection.$$$reportNull$$$0(16);
        }
        return vFSRecoveryInfo;
    }

    static void closeStorages(@Nullable PersistentFSRecordsStorage records, @Nullable ScannableDataEnumeratorEx<String> names, @Nullable VFSAttributesStorage attributes, @Nullable VFSContentStorage contents) throws IOException {
        if (names instanceof Closeable) {
            ((Closeable)names).close();
        }
        if (attributes != null) {
            attributes.close();
        }
        if (contents != null) {
            contents.close();
        }
        if (records != null) {
            records.close();
        }
    }

    void markAsCorruptedAndScheduleRebuild(@NotNull Throwable cause) throws RuntimeException, Error {
        if (cause == null) {
            PersistentFSConnection.$$$reportNull$$$0(17);
        }
        try {
            int corruptions = this.corruptionsDetected.incrementAndGet();
            this.records.setErrorsAccumulated(corruptions);
            if (corruptions == 1) {
                this.force();
            }
            this.corruptionNotificationThrottler.runThrottled(System.nanoTime(), () -> {
                Application app = ApplicationManager.getApplication();
                if (app != null && !app.isHeadlessEnvironment()) {
                    boolean insistRestart = corruptions >= INSIST_TO_RESTART_AFTER_ERRORS_COUNT;
                    PersistentFSConnection.showCorruptionNotification(insistRestart);
                }
            });
        }
        catch (IOException ioException) {
            LOG.error((Throwable)ioException);
        }
    }

    @VisibleForTesting
    public static void scheduleVFSRebuild(@NotNull Path corruptionMarkerFile, @Nullable String message, @Nullable Throwable errorCause) {
        if (corruptionMarkerFile == null) {
            PersistentFSConnection.$$$reportNull$$$0(18);
        }
        VFSCorruptedException corruptedException = new VFSCorruptedException(message == null ? "(No specific reason of corruption was given)" : message, errorCause);
        if (errorCause == null) {
            LOG.info("VFS rebuild is requested: creating VFS rebuild marker. Message: " + message);
        } else {
            LOG.warn("VFS is corrupted: creating VFS rebuild marker.", (Throwable)corruptedException);
        }
        try {
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            try (PrintStream stream = new PrintStream((OutputStream)out2, false, StandardCharsets.UTF_8);){
                stream.println("VFS files are corrupted and must be rebuilt from the scratch on next startup");
                corruptedException.printStackTrace(stream);
            }
            Files.write(corruptionMarkerFile, out2.toByteArray(), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        }
        catch (IOException ex) {
            LOG.info("Can't create VFS corruption marker", (Throwable)ex);
        }
    }

    @VisibleForTesting
    public void scheduleVFSRebuild(@Nullable String message, @Nullable Throwable errorCause) {
        PersistentFSConnection.scheduleVFSRebuild(this.persistentFSPaths.getCorruptionMarkerFile(), message, errorCause);
    }

    public void scheduleDefragmentation() throws IOException {
        this.records.updateFlags(1, 0);
    }

    static void ensureIdIsValid(int id2) {
        assert (id2 > 0) : id2;
    }

    void ensureFileIdIsValid(int fileId) throws IndexOutOfBoundsException {
        if (!this.records.isValidFileId(fileId)) {
            int maxAllocatedID = this.records.maxAllocatedID();
            throw new IndexOutOfBoundsException("fileId[" + fileId + "] is outside valid/allocated ids range [1.." + maxAllocatedID + "], VFS.status: {" + this.describeConsistencyStatus() + "}");
        }
    }

    String describeConsistencyStatus() {
        try {
            return "wasClosedProperly=" + this.records.wasClosedProperly() + ", wasAlwaysClosedProperly=" + this.records.wasAlwaysClosedProperly();
        }
        catch (IOException e) {
            return "(unknown: " + e.getMessage() + ")";
        }
    }

    private static void showCorruptionNotification(boolean insisting) {
        AnAction restartIdeAction = ActionManager.getInstance().getAction("RestartIde");
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("IDE Caches");
        if (insisting) {
            notificationGroup.createNotification(CoreBundle.message((String)"vfs.corruption.notification.title", (Object[])new Object[0]), CoreBundle.message((String)"vfs.corruption.notification.text", (Object[])new Object[0]), NotificationType.INFORMATION).setImportant(true).addAction(restartIdeAction).notify(null);
        } else {
            notificationGroup.createNotification(CoreBundle.message((String)"vfs.corruption.notification.insist.title", (Object[])new Object[0]), CoreBundle.message((String)"vfs.corruption.notification.insist.text", (Object[])new Object[0]), NotificationType.ERROR).addAction(restartIdeAction).notify(null);
        }
    }

    @NotNull
    static Closeable startFlusher(@NotNull ScheduledExecutorService scheduler, @NotNull PersistentFSConnection connection, boolean gentleFlusher) {
        if (scheduler == null) {
            PersistentFSConnection.$$$reportNull$$$0(19);
        }
        if (connection == null) {
            PersistentFSConnection.$$$reportNull$$$0(20);
        }
        return gentleFlusher ? new GentleVFSFlusher(connection, scheduler) : new ClassicVFSFlusher(connection, scheduler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 11, 12, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumeratedAttributes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "freeRecords";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSConnection";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "corruptionMarkerFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheduler";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSConnection";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "attributesEnumerator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "contents";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "attributes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "names";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "records";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "freeRecords";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "paths";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "recoveryInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "enumerateAttributeId";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "markAsCorruptedAndScheduleRebuild";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "scheduleVFSRebuild";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "startFlusher";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 11, 12, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }

    private static final class VFSCorruptedException
    extends Exception {
        VFSCorruptedException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static final class GentleVFSFlusher
    extends GentleFlusherBase {
        private static final long FLUSHING_PERIOD_MS = TimeUnit.SECONDS.toMillis(1L);
        private static final int MIN_CONTENTION_QUOTA = 2;
        private static final int INITIAL_CONTENTION_QUOTA = 16;
        private static final int MAX_CONTENTION_QUOTA = 32;
        private final PersistentFSConnection connection;
        private int lastModCount;
        private long lastSuccessfulFlushTimestampMs;

        private GentleVFSFlusher(@NotNull PersistentFSConnection connection, @NotNull ScheduledExecutorService scheduler) {
            if (connection == null) {
                GentleVFSFlusher.$$$reportNull$$$0(0);
            }
            if (scheduler == null) {
                GentleVFSFlusher.$$$reportNull$$$0(1);
            }
            super("VFSFlusher", scheduler, FLUSHING_PERIOD_MS, 2, 32, 16, TelemetryManager.getInstance().getMeter(PlatformScopesKt.Indexes));
            this.lastSuccessfulFlushTimestampMs = 0L;
            this.connection = connection;
        }

        @Override
        protected boolean betterPostponeFlushNow() {
            int currentModCount = this.connection.records.getGlobalModCount();
            if (this.lastModCount != currentModCount) {
                this.lastModCount = currentModCount;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected GentleFlusherBase.FlushResult flushAsMuchAsPossibleWithinQuota(IntRef contentionQuota) throws IOException {
            if (!this.connection.isDirty()) {
                return GentleFlusherBase.FlushResult.NOTHING_TO_FLUSH_NOW;
            }
            if (System.currentTimeMillis() - this.lastSuccessfulFlushTimestampMs < FLUSHING_PERIOD_MS) {
                return GentleFlusherBase.FlushResult.NOTHING_TO_FLUSH_NOW;
            }
            int unspentContentionQuota = contentionQuota.get();
            try {
                if ((unspentContentionQuota -= GentleVFSFlusher.competingThreads()) < 0) {
                    GentleFlusherBase.FlushResult flushResult = GentleFlusherBase.FlushResult.HAS_MORE_TO_FLUSH;
                    return flushResult;
                }
                if (this.connection.namesEnumerator instanceof Forceable) {
                    ((Forceable)this.connection.namesEnumerator).force();
                    if ((unspentContentionQuota -= GentleVFSFlusher.competingThreads()) < 0) {
                        GentleFlusherBase.FlushResult flushResult = GentleFlusherBase.FlushResult.HAS_MORE_TO_FLUSH;
                        return flushResult;
                    }
                }
                this.connection.attributesStorage.force();
                if ((unspentContentionQuota -= GentleVFSFlusher.competingThreads()) < 0) {
                    GentleFlusherBase.FlushResult flushResult = GentleFlusherBase.FlushResult.HAS_MORE_TO_FLUSH;
                    return flushResult;
                }
                this.connection.contentStorage.force();
                if ((unspentContentionQuota -= GentleVFSFlusher.competingThreads()) < 0) {
                    GentleFlusherBase.FlushResult flushResult = GentleFlusherBase.FlushResult.HAS_MORE_TO_FLUSH;
                    return flushResult;
                }
                this.connection.records.force();
                unspentContentionQuota -= GentleVFSFlusher.competingThreads();
                this.lastSuccessfulFlushTimestampMs = System.currentTimeMillis();
                GentleFlusherBase.FlushResult flushResult = GentleFlusherBase.FlushResult.FLUSHED_ALL;
                return flushResult;
            }
            finally {
                contentionQuota.set(unspentContentionQuota);
            }
        }

        @Override
        public boolean hasSomethingToFlush() {
            return this.connection.isDirty();
        }

        private static int competingThreads() {
            ReentrantReadWriteLock storageLock = StorageLockContext.defaultContextLock();
            if (storageLock.isWriteLocked()) {
                return storageLock.getQueueLength() + 1;
            }
            int readers = storageLock.getReadLockCount();
            return storageLock.getQueueLength() + readers;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scheduler";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSConnection$GentleVFSFlusher";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClassicVFSFlusher
    implements Runnable,
    Closeable {
        public static final long FLUSHING_PERIOD_MS = TimeUnit.SECONDS.toMillis(5L);
        private final PersistentFSConnection connection;
        private int lastModCount;
        private final Future<?> scheduledFuture;

        private ClassicVFSFlusher(@NotNull PersistentFSConnection connection, @NotNull ScheduledExecutorService scheduler) {
            if (connection == null) {
                ClassicVFSFlusher.$$$reportNull$$$0(0);
            }
            if (scheduler == null) {
                ClassicVFSFlusher.$$$reportNull$$$0(1);
            }
            this.scheduledFuture = scheduler.scheduleWithFixedDelay(this, FLUSHING_PERIOD_MS, FLUSHING_PERIOD_MS, TimeUnit.MILLISECONDS);
            this.connection = connection;
        }

        @Override
        public void run() {
            if (this.lastModCount == this.connection.records.getGlobalModCount() && this.connection.isDirty() && !HeavyProcessLatch.INSTANCE.isRunning()) {
                try {
                    this.connection.force();
                }
                catch (AlreadyDisposedException | RejectedExecutionException e) {
                    LOG.warn("Stop flushing: pool is shutting down or whole application is closing", (Throwable)new Exception(e));
                    this.scheduledFuture.cancel(false);
                }
                catch (Throwable t) {
                    LOG.error("Unhandled exception during flush (reschedule regularly)", t);
                }
            }
            this.lastModCount = this.connection.records.getGlobalModCount();
        }

        @Override
        public void close() {
            this.scheduledFuture.cancel(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scheduler";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSConnection$ClassicVFSFlusher";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

