/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.IPersistentFSRecordsStorage;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorage;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.Unmappable;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class PersistentFSRecordsLockFreeOverMMappedFile
implements PersistentFSRecordsStorage,
IPersistentFSRecordsStorage,
Unmappable {
    private static final int UNALLOCATED_RECORDS_TO_CHECK_ZEROED_REGULAR = SystemProperties.getIntProperty((String)"vfs.check-unallocated-records-zeroed", (int)4);
    private static final int UNALLOCATED_RECORDS_TO_CHECK_ZEROED_CRASHED = UNALLOCATED_RECORDS_TO_CHECK_ZEROED_REGULAR * 1000;
    public static final int NULL_OWNER_PID = 0;
    public static final int DEFAULT_MAPPED_CHUNK_SIZE = SystemProperties.getIntProperty((String)"vfs.records-storage.memory-mapped.mapped-chunk-size", (int)0x4000000);
    private static final VarHandle INT_HANDLE = MethodHandles.byteBufferViewVarHandle(int[].class, ByteOrder.nativeOrder()).withInvokeExactBehavior();
    private static final VarHandle LONG_HANDLE = MethodHandles.byteBufferViewVarHandle(long[].class, ByteOrder.nativeOrder()).withInvokeExactBehavior();
    @NotNull
    private final MMappedFileStorage storage;
    private transient MMappedFileStorage.Page headerPage;
    private final AtomicInteger globalModCount;
    private final transient int pageSize;
    private final transient int recordsPerPage;
    private final transient int recordsOnHeaderPage;
    private final transient HeaderAccessor headerAccessor;
    private int cachedMaxAllocatedId;
    private final boolean wasClosedProperly;
    private final boolean wasAlwaysClosedProperly;
    private volatile int owningProcessId;

    public PersistentFSRecordsLockFreeOverMMappedFile(@NotNull MMappedFileStorage storage) throws IOException {
        int unAllocatedRecordsToCheck;
        if (storage == null) {
            PersistentFSRecordsLockFreeOverMMappedFile.$$$reportNull$$$0(0);
        }
        this.globalModCount = new AtomicInteger(0);
        this.headerAccessor = new HeaderAccessor(this);
        this.owningProcessId = 0;
        int pageSize = storage.pageSize();
        if (pageSize < 40) {
            throw new IllegalArgumentException("pageSize(=" + pageSize + ") must fit header(=40 b)");
        }
        this.storage = storage;
        this.pageSize = pageSize;
        this.recordsPerPage = pageSize / 40;
        this.recordsOnHeaderPage = (pageSize - 40) / 40;
        this.headerPage = this.storage.pageByOffset(0L);
        int modCount = this.getIntHeaderField(8);
        this.globalModCount.set(modCount);
        this.cachedMaxAllocatedId = this.maxAllocatedID();
        int ownerProcessId = this.getIntHeaderField(12);
        boolean bl = this.wasClosedProperly = ownerProcessId == 0;
        if (!this.wasClosedProperly) {
            this.updateFlags(2, 0);
            this.wasAlwaysClosedProperly = false;
        } else {
            this.wasAlwaysClosedProperly = !this.getFlag(2);
        }
        int n = unAllocatedRecordsToCheck = this.wasClosedProperly ? UNALLOCATED_RECORDS_TO_CHECK_ZEROED_REGULAR : UNALLOCATED_RECORDS_TO_CHECK_ZEROED_CRASHED;
        if (unAllocatedRecordsToCheck > 0) {
            this.checkUnAllocatedRegionIsZeroed(unAllocatedRecordsToCheck);
        }
    }

    @Override
    public <R> R readRecord(int recordId, @NotNull IPersistentFSRecordsStorage.RecordReader<R> reader) throws IOException {
        if (reader == null) {
            PersistentFSRecordsLockFreeOverMMappedFile.$$$reportNull$$$0(1);
        }
        long recordOffsetInFile = this.recordOffsetInFile(recordId);
        int recordOffsetOnPage = this.storage.toOffsetInPage(recordOffsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
        RecordAccessor recordAccessor = new RecordAccessor(recordId, recordOffsetOnPage, page, this);
        return reader.readRecord(recordAccessor);
    }

    @Override
    public int updateRecord(int recordId, @NotNull IPersistentFSRecordsStorage.RecordUpdater updater) throws IOException {
        MMappedFileStorage.Page page;
        if (updater == null) {
            PersistentFSRecordsLockFreeOverMMappedFile.$$$reportNull$$$0(2);
        }
        int trueRecordId = recordId <= 0 ? this.allocateRecord() : recordId;
        long recordOffsetInFile = this.recordOffsetInFile(recordId);
        int recordOffsetOnPage = this.storage.toOffsetInPage(recordOffsetInFile);
        RecordAccessor recordAccessor = new RecordAccessor(recordId, recordOffsetOnPage, page = this.storage.pageByOffset(recordOffsetInFile), this);
        boolean updated = updater.updateRecord(recordAccessor);
        if (updated) {
            this.incrementRecordVersion(recordAccessor.pageBuffer, recordOffsetOnPage);
        }
        return trueRecordId;
    }

    @Override
    public <R> R readHeader(@NotNull IPersistentFSRecordsStorage.HeaderReader<R> reader) throws IOException {
        if (reader == null) {
            PersistentFSRecordsLockFreeOverMMappedFile.$$$reportNull$$$0(3);
        }
        return reader.readHeader(this.headerAccessor);
    }

    @Override
    public void updateHeader(@NotNull IPersistentFSRecordsStorage.HeaderUpdater updater) throws IOException {
        if (updater == null) {
            PersistentFSRecordsLockFreeOverMMappedFile.$$$reportNull$$$0(4);
        }
        if (updater.updateHeader(this.headerAccessor)) {
            this.incrementGlobalModCount();
        }
    }

    @Override
    public int allocateRecord() throws IOException {
        int newAllocatedRecords;
        int allocatedRecords;
        MMappedFileStorage.Page headerPage = this.headerPage();
        ByteBuffer headerPageBuffer = headerPage.rawPageBuffer();
        while (!INT_HANDLE.compareAndSet(headerPageBuffer, 4, allocatedRecords = INT_HANDLE.getVolatile(headerPageBuffer, 4), newAllocatedRecords = allocatedRecords + 1)) {
        }
        long recordOffsetInFile = this.recordOffsetInFile(newAllocatedRecords);
        int recordOffsetOnPage = this.storage.toOffsetInPage(recordOffsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
        ByteBuffer pageBuffer = page.rawPageBuffer();
        this.incrementRecordVersion(pageBuffer, recordOffsetOnPage);
        return newAllocatedRecords;
    }

    @Override
    public void setAttributeRecordId(int recordId, int attributeRecordId) throws IOException {
        PersistentFSRecordsLockFreeOverMMappedFile.checkValidIdField(recordId, attributeRecordId, "attributeRecordId");
        this.setIntField(recordId, 12, attributeRecordId);
    }

    @Override
    public int getAttributeRecordId(int recordId) throws IOException {
        return this.getIntField(recordId, 12);
    }

    @Override
    public int getParent(int recordId) throws IOException {
        return this.getIntField(recordId, 0);
    }

    @Override
    public void setParent(int recordId, int parentId) throws IOException {
        this.checkParentIdIsValid(parentId);
        this.setIntField(recordId, 0, parentId);
    }

    @Override
    public int getNameId(int recordId) throws IOException {
        return this.getIntField(recordId, 4);
    }

    @Override
    public int updateNameId(int recordId, int nameId) throws IOException {
        PersistentFSConnection.ensureIdIsValid(nameId);
        return this.getAndSetIntField(recordId, 4, nameId);
    }

    @Override
    public boolean setFlags(int recordId, @PersistentFS.Attributes int newFlags) throws IOException {
        long recordOffsetInFile = this.recordOffsetInFile(recordId);
        int recordOffsetOnPage = this.storage.toOffsetInPage(recordOffsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
        ByteBuffer pageBuffer = page.rawPageBuffer();
        return this.setIntFieldIfChanged(pageBuffer, recordOffsetOnPage, 8, newFlags);
    }

    @Override
    public @PersistentFS.Attributes int getFlags(int recordId) throws IOException {
        return this.getIntField(recordId, 8);
    }

    @Override
    public long getLength(int recordId) throws IOException {
        return this.getLongField(recordId, 32);
    }

    @Override
    public boolean setLength(int recordId, long newLength) throws IOException {
        long recordOffsetInFile = this.recordOffsetInFile(recordId);
        int recordOffsetOnPage = this.storage.toOffsetInPage(recordOffsetInFile);
        int fieldOffsetOnPage = recordOffsetOnPage + 32;
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
        ByteBuffer pageBuffer = page.rawPageBuffer();
        long storedLength = LONG_HANDLE.getVolatile(pageBuffer, fieldOffsetOnPage);
        if (storedLength != newLength) {
            PersistentFSRecordsLockFreeOverMMappedFile.setLongVolatile(pageBuffer, fieldOffsetOnPage, newLength);
            this.incrementRecordVersion(pageBuffer, recordOffsetOnPage);
            return true;
        }
        return false;
    }

    @Override
    public long getTimestamp(int recordId) throws IOException {
        return this.getLongField(recordId, 24);
    }

    @Override
    public boolean setTimestamp(int recordId, long newTimestamp) throws IOException {
        long recordOffsetInFile = this.recordOffsetInFile(recordId);
        int recordOffsetOnPage = this.storage.toOffsetInPage(recordOffsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
        ByteBuffer pageBuffer = page.rawPageBuffer();
        return this.setLongFieldIfChanged(pageBuffer, recordOffsetOnPage, 24, newTimestamp);
    }

    @Override
    public int getModCount(int recordId) throws IOException {
        return this.getIntField(recordId, 20);
    }

    @Override
    public int getContentRecordId(int recordId) throws IOException {
        return this.getIntField(recordId, 16);
    }

    @Override
    public boolean setContentRecordId(int recordId, int newContentRecordId) throws IOException {
        PersistentFSRecordsLockFreeOverMMappedFile.checkValidIdField(recordId, newContentRecordId, "contentRecordId");
        long recordOffsetInFile = this.recordOffsetInFile(recordId);
        int recordOffsetOnPage = this.storage.toOffsetInPage(recordOffsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
        ByteBuffer pageBuffer = page.rawPageBuffer();
        return this.setIntFieldIfChanged(pageBuffer, recordOffsetOnPage, 16, newContentRecordId);
    }

    @Override
    public void markRecordAsModified(int recordId) throws IOException {
        long recordOffsetInFile = this.recordOffsetInFile(recordId);
        int recordOffsetOnPage = this.storage.toOffsetInPage(recordOffsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
        this.incrementRecordVersion(page.rawPageBuffer(), recordOffsetOnPage);
    }

    @Override
    public void cleanRecord(int recordId) throws IOException {
        this.checkRecordIdIsValid(recordId);
        int recordSizeInInts = 10;
        long recordOffsetInFile = this.recordOffsetInFile(recordId);
        int recordOffsetOnPage = this.storage.toOffsetInPage(recordOffsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
        ByteBuffer pageBuffer = page.rawPageBuffer();
        for (int wordNo = 0; wordNo < recordSizeInInts; ++wordNo) {
            int offsetOfWord = recordOffsetOnPage + wordNo * 4;
            PersistentFSRecordsLockFreeOverMMappedFile.setIntVolatile(pageBuffer, offsetOfWord, 0);
        }
        this.incrementGlobalModCount();
    }

    @Override
    public boolean processAllRecords(@NotNull PersistentFSRecordsStorage.FsRecordProcessor processor2) throws IOException {
        if (processor2 == null) {
            PersistentFSRecordsLockFreeOverMMappedFile.$$$reportNull$$$0(5);
        }
        int recordsCount = this.maxAllocatedID();
        for (int recordId = 1; recordId <= recordsCount; ++recordId) {
            processor2.process(recordId, this.getNameId(recordId), this.getFlags(recordId), this.getParent(recordId), this.getAttributeRecordId(recordId), this.getContentRecordId(recordId), false);
        }
        return true;
    }

    @Override
    public long getTimestamp() {
        return this.getLongHeaderField(16);
    }

    @Override
    public boolean wasClosedProperly() {
        return this.wasClosedProperly;
    }

    @Override
    public boolean wasAlwaysClosedProperly() {
        return this.wasAlwaysClosedProperly;
    }

    @NotNull
    public OwnershipInfo tryAcquireExclusiveAccess(int acquiringProcessId, long acquiringTimestampMs, boolean forcibly) throws IOException {
        int currentOwnerProcessId;
        if (acquiringProcessId == 0) {
            throw new IllegalArgumentException("acquiringPid(=" + acquiringProcessId + ") must be !=0");
        }
        ByteBuffer headerPageBuffer = this.headerPage().rawPageBuffer();
        do {
            if ((currentOwnerProcessId = INT_HANDLE.getVolatile(headerPageBuffer, 12)) == acquiringProcessId) {
                this.owningProcessId = acquiringProcessId;
                long ownershipAcquiredMs = LONG_HANDLE.getVolatile(headerPageBuffer, 24);
                return new OwnershipInfo(acquiringProcessId, ownershipAcquiredMs);
            }
            if (currentOwnerProcessId == 0 || forcibly) continue;
            long ownershipAcquiredMs = LONG_HANDLE.getVolatile(headerPageBuffer, 24);
            return new OwnershipInfo(currentOwnerProcessId, ownershipAcquiredMs);
        } while (!INT_HANDLE.compareAndSet(headerPageBuffer, 12, currentOwnerProcessId, acquiringProcessId));
        this.owningProcessId = acquiringProcessId;
        LONG_HANDLE.setVolatile(headerPageBuffer, 24, acquiringTimestampMs);
        this.storage.fsync();
        return new OwnershipInfo(acquiringProcessId, acquiringTimestampMs);
    }

    private int tryReleaseExclusiveAccess(int ownerProcessId) {
        int currentOwnerProcessId;
        ByteBuffer headerPageBuffer = this.headerPage().rawPageBuffer();
        do {
            if ((currentOwnerProcessId = INT_HANDLE.getVolatile(headerPageBuffer, 12)) == 0) {
                return 0;
            }
            if (currentOwnerProcessId == ownerProcessId) continue;
            return currentOwnerProcessId;
        } while (!INT_HANDLE.compareAndSet(headerPageBuffer, 12, currentOwnerProcessId, 0));
        LONG_HANDLE.setVolatile(headerPageBuffer, 24, 0L);
        return 0;
    }

    @Override
    public int getErrorsAccumulated() {
        return this.getIntHeaderField(32);
    }

    @Override
    public void setErrorsAccumulated(int errors) {
        this.setIntHeaderField(32, errors);
        this.incrementGlobalModCount();
    }

    @Override
    public void setVersion(int version) {
        this.setIntHeaderField(0, version);
        this.setLongHeaderField(16, System.currentTimeMillis());
        this.incrementGlobalModCount();
    }

    @Override
    public int getVersion() {
        return this.getIntHeaderField(0);
    }

    @Override
    public int getGlobalModCount() {
        return this.globalModCount.get();
    }

    @Override
    public int getFlags() {
        return this.getIntHeaderField(36);
    }

    @Override
    public boolean updateFlags(int flagsToAdd, int flagsToRemove) {
        int newFlags;
        int currentFlags;
        ByteBuffer headerBuffer = this.headerPage().rawPageBuffer();
        do {
            if ((newFlags = (currentFlags = INT_HANDLE.getVolatile(headerBuffer, 36)) & ~flagsToRemove | flagsToAdd) != currentFlags) continue;
            return false;
        } while (!INT_HANDLE.compareAndSet(headerBuffer, 36, currentFlags, newFlags));
        return true;
    }

    @Override
    public int recordsCount() {
        return this.allocatedRecordsCount();
    }

    @Override
    public int maxAllocatedID() {
        return this.allocatedRecordsCount();
    }

    @Override
    public boolean isValidFileId(int fileId) {
        if (fileId <= 0) {
            return false;
        }
        int cachedMaxAllocatedID = this.cachedMaxAllocatedId;
        if (fileId <= cachedMaxAllocatedID) {
            return true;
        }
        return this.isValidFileIdStrict(fileId);
    }

    private boolean isValidFileIdStrict(int fileId) {
        int actualMaxAllocatedID = this.maxAllocatedID();
        this.cachedMaxAllocatedId = Math.max(this.cachedMaxAllocatedId, actualMaxAllocatedID);
        return fileId <= actualMaxAllocatedID;
    }

    @Override
    public boolean isDirty() {
        return this.globalModCount.get() != this.getIntHeaderField(8);
    }

    @Override
    public void force() throws IOException {
        int storedModCount;
        int currentModCount;
        ByteBuffer headerPageBuffer = this.headerPage().rawPageBuffer();
        while ((currentModCount = this.globalModCount.get()) > (storedModCount = INT_HANDLE.getVolatile(headerPageBuffer, 8)) && !INT_HANDLE.compareAndSet(headerPageBuffer, 8, storedModCount, currentModCount)) {
        }
        if (MMappedFileStorage.FSYNC_ON_FLUSH_BY_DEFAULT) {
            this.storage.fsync();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.storage.isOpen()) {
            int ourPid = this.owningProcessId;
            int currentOwnerPid = this.tryReleaseExclusiveAccess(ourPid);
            this.force();
            this.storage.close();
            this.headerPage = null;
            if (currentOwnerPid != 0) {
                FSRecords.LOG.warn("Storage is exclusively owned by another process[pid: " + currentOwnerPid + ", our pid: " + ourPid + "]");
            }
        }
    }

    public void closeAndUnsafelyUnmap() throws IOException {
        this.close();
        this.storage.closeAndUnsafelyUnmap();
    }

    @Override
    public void closeAndClean() throws IOException {
        this.close();
        this.storage.closeAndClean();
    }

    @VisibleForTesting
    public long recordOffsetInFileUnchecked(int recordId) {
        int recordNo = recordId - 1;
        if (recordNo < this.recordsOnHeaderPage) {
            return 40L + (long)recordNo * 40L;
        }
        int fullPages = recordNo / this.recordsPerPage;
        int recordsOnLastPage = recordNo % this.recordsPerPage;
        int recordsExcessBecauseOfHeader = this.recordsPerPage - this.recordsOnHeaderPage;
        int recordsReallyOnLastPage = recordsOnLastPage + recordsExcessBecauseOfHeader;
        return (long)(fullPages + recordsReallyOnLastPage / this.recordsPerPage) * (long)this.pageSize + (long)(recordsReallyOnLastPage % this.recordsPerPage) * 40L;
    }

    private long recordOffsetInFile(int recordId) throws IndexOutOfBoundsException {
        this.checkRecordIdIsValid(recordId);
        return this.recordOffsetInFileUnchecked(recordId);
    }

    private void checkRecordIdIsValid(int recordId) throws IndexOutOfBoundsException {
        if (!this.isValidFileId(recordId)) {
            throw new IndexOutOfBoundsException("recordId(=" + recordId + ") is outside of allocated IDs range (0, " + this.maxAllocatedID() + "], (wasClosedProperly: " + this.wasClosedProperly() + ", wasAlwaysClosedProperly: " + this.wasAlwaysClosedProperly() + ")");
        }
    }

    private void checkParentIdIsValid(int parentId) throws IndexOutOfBoundsException {
        if (parentId == 0) {
            return;
        }
        if (!this.isValidFileId(parentId)) {
            throw new IndexOutOfBoundsException("parentId(=" + parentId + ") is outside of allocated IDs range [0, " + this.maxAllocatedID() + "], (wasClosedProperly: " + this.wasClosedProperly() + ", wasAlwaysClosedProperly: " + this.wasAlwaysClosedProperly() + ")");
        }
    }

    private static void checkValidIdField(int recordId, int fieldValue, @NotNull String fieldName) {
        if (fieldName == null) {
            PersistentFSRecordsLockFreeOverMMappedFile.$$$reportNull$$$0(6);
        }
        if (fieldValue < 0) {
            throw new IllegalArgumentException("file[id: " + recordId + "]." + fieldName + "(=" + fieldValue + ") must be >=0");
        }
    }

    private int allocatedRecordsCount() {
        return this.getIntHeaderField(4);
    }

    private void setLongField(int recordId, @FieldOffset int fieldRelativeOffset, long fieldValue) throws IOException {
        long recordOffsetInFile = this.recordOffsetInFile(recordId);
        int recordOffsetOnPage = this.storage.toOffsetInPage(recordOffsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
        ByteBuffer pageBuffer = page.rawPageBuffer();
        PersistentFSRecordsLockFreeOverMMappedFile.setLongVolatile(pageBuffer, recordOffsetOnPage + fieldRelativeOffset, fieldValue);
        this.incrementRecordVersion(pageBuffer, recordOffsetOnPage);
    }

    private long getLongField(int recordId, @FieldOffset int fieldRelativeOffset) throws IOException {
        long recordOffsetInFile = this.recordOffsetInFile(recordId);
        int recordOffsetOnPage = this.storage.toOffsetInPage(recordOffsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
        ByteBuffer pageBuffer = page.rawPageBuffer();
        return LONG_HANDLE.getVolatile(pageBuffer, recordOffsetOnPage + fieldRelativeOffset);
    }

    private boolean setLongFieldIfChanged(ByteBuffer pageBuffer, int recordOffsetOnPage, @FieldOffset int fieldRelativeOffset, long newValue) {
        int fieldOffsetOnPage = recordOffsetOnPage + fieldRelativeOffset;
        long oldValue = LONG_HANDLE.getVolatile(pageBuffer, fieldOffsetOnPage);
        if (oldValue != newValue) {
            PersistentFSRecordsLockFreeOverMMappedFile.setLongVolatile(pageBuffer, fieldOffsetOnPage, newValue);
            this.incrementRecordVersion(pageBuffer, recordOffsetOnPage);
            return true;
        }
        return false;
    }

    private void setIntField(int recordId, @FieldOffset int fieldRelativeOffset, int fieldValue) throws IOException {
        long recordOffsetInFile = this.recordOffsetInFile(recordId);
        int recordOffsetOnPage = this.storage.toOffsetInPage(recordOffsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
        ByteBuffer pageBuffer = page.rawPageBuffer();
        PersistentFSRecordsLockFreeOverMMappedFile.setIntVolatile(pageBuffer, recordOffsetOnPage + fieldRelativeOffset, fieldValue);
        this.incrementRecordVersion(pageBuffer, recordOffsetOnPage);
    }

    private int getAndSetIntField(int recordId, @FieldOffset int fieldRelativeOffset, int fieldValue) throws IOException {
        long recordOffsetInFile = this.recordOffsetInFile(recordId);
        int recordOffsetOnPage = this.storage.toOffsetInPage(recordOffsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
        ByteBuffer pageBuffer = page.rawPageBuffer();
        int previousValue = PersistentFSRecordsLockFreeOverMMappedFile.getAndSetIntVolatile(pageBuffer, recordOffsetOnPage + fieldRelativeOffset, fieldValue);
        this.incrementRecordVersion(pageBuffer, recordOffsetOnPage);
        return previousValue;
    }

    private int getIntField(int recordId, @FieldOffset int fieldRelativeOffset) throws IOException {
        long recordOffsetInFile = this.recordOffsetInFile(recordId);
        int recordOffsetOnPage = this.storage.toOffsetInPage(recordOffsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
        ByteBuffer pageBuffer = page.rawPageBuffer();
        return INT_HANDLE.getVolatile(pageBuffer, recordOffsetOnPage + fieldRelativeOffset);
    }

    private boolean setIntFieldIfChanged(ByteBuffer pageBuffer, int recordOffsetOnPage, int fieldRelativeOffset, int newValue) {
        int fieldOffsetOnPage = recordOffsetOnPage + fieldRelativeOffset;
        int oldValue = INT_HANDLE.getVolatile(pageBuffer, fieldOffsetOnPage);
        if (oldValue != newValue) {
            PersistentFSRecordsLockFreeOverMMappedFile.setIntVolatile(pageBuffer, fieldOffsetOnPage, newValue);
            this.incrementRecordVersion(pageBuffer, recordOffsetOnPage);
            return true;
        }
        return false;
    }

    private void incrementRecordVersion(@NotNull ByteBuffer pageBuffer, int recordOffsetOnPage) {
        if (pageBuffer == null) {
            PersistentFSRecordsLockFreeOverMMappedFile.$$$reportNull$$$0(7);
        }
        int globalModCount = this.incrementGlobalModCount();
        PersistentFSRecordsLockFreeOverMMappedFile.setIntVolatile(pageBuffer, recordOffsetOnPage + 20, globalModCount);
    }

    private int incrementGlobalModCount() {
        int modCount = this.globalModCount.incrementAndGet();
        if (modCount < 0) {
            throw new IllegalStateException("GlobalModCount(=" + modCount + ") is negative: overflow?");
        }
        return modCount;
    }

    private void setLongHeaderField(int headerRelativeOffsetBytes, long headerValue) {
        PersistentFSRecordsLockFreeOverMMappedFile.checkHeaderOffset(headerRelativeOffsetBytes);
        PersistentFSRecordsLockFreeOverMMappedFile.setLongVolatile(this.headerPage().rawPageBuffer(), headerRelativeOffsetBytes, headerValue);
    }

    private long getLongHeaderField(int headerRelativeOffsetBytes) {
        PersistentFSRecordsLockFreeOverMMappedFile.checkHeaderOffset(headerRelativeOffsetBytes);
        return LONG_HANDLE.getVolatile(this.headerPage().rawPageBuffer(), headerRelativeOffsetBytes);
    }

    private void setIntHeaderField(int headerRelativeOffsetBytes, int headerValue) {
        PersistentFSRecordsLockFreeOverMMappedFile.checkHeaderOffset(headerRelativeOffsetBytes);
        PersistentFSRecordsLockFreeOverMMappedFile.setIntVolatile(this.headerPage().rawPageBuffer(), headerRelativeOffsetBytes, headerValue);
    }

    private int getIntHeaderField(int headerRelativeOffsetBytes) {
        PersistentFSRecordsLockFreeOverMMappedFile.checkHeaderOffset(headerRelativeOffsetBytes);
        return INT_HANDLE.getVolatile(this.headerPage().rawPageBuffer(), headerRelativeOffsetBytes);
    }

    private MMappedFileStorage.Page headerPage() {
        MMappedFileStorage.Page page = this.headerPage;
        if (page == null) {
            throw new AlreadyDisposedException("File records storage is already closed");
        }
        return page;
    }

    private static void checkHeaderOffset(int headerRelativeOffset) {
        if (0 > headerRelativeOffset || headerRelativeOffset >= 40) {
            throw new IndexOutOfBoundsException("headerFieldOffset(=" + headerRelativeOffset + ") is outside of header [0, 40) ");
        }
    }

    private static void setIntVolatile(ByteBuffer pageBuffer, int offsetInBuffer, int value) {
        INT_HANDLE.setVolatile(pageBuffer, offsetInBuffer, value);
    }

    private static int getAndSetIntVolatile(ByteBuffer pageBuffer, int offsetInBuffer, int value) {
        return INT_HANDLE.getAndSet(pageBuffer, offsetInBuffer, value);
    }

    private static void setLongVolatile(ByteBuffer pageBuffer, int offsetInBuffer, long value) {
        LONG_HANDLE.setVolatile(pageBuffer, offsetInBuffer, value);
    }

    private void checkUnAllocatedRegionIsZeroed(int recordsToCheck) throws IOException {
        int maxBytesRemainsOnPage;
        int bytesToCheck;
        long actualFileSize;
        int maxAllocatedID = this.maxAllocatedID();
        int firstUnAllocatedId = maxAllocatedID + 1;
        long unallocatedRegionStartingOffsetInFile = this.recordOffsetInFileUnchecked(firstUnAllocatedId);
        int unallocatedRegionStartingOffsetOnPage = this.storage.toOffsetInPage(unallocatedRegionStartingOffsetInFile);
        if ((long)unallocatedRegionStartingOffsetOnPage >= (actualFileSize = this.storage.actualFileSize())) {
            return;
        }
        MMappedFileStorage.Page lastPage = this.storage.pageByOffset(unallocatedRegionStartingOffsetInFile);
        ByteBuffer lastPageBuffer = lastPage.rawPageBuffer();
        int firstNonZeroOffsetInPage = PersistentFSRecordsLockFreeOverMMappedFile.firstNonZeroByteOffset(lastPageBuffer, unallocatedRegionStartingOffsetOnPage, bytesToCheck = Math.min(recordsToCheck * 40, maxBytesRemainsOnPage = lastPageBuffer.limit() - unallocatedRegionStartingOffsetOnPage));
        if (firstNonZeroOffsetInPage >= 0) {
            int bytesToCheckAdditionally = Math.min(maxBytesRemainsOnPage, 65536);
            int lastNonZeroOffsetInPage = PersistentFSRecordsLockFreeOverMMappedFile.lastNonZeroByteOffset(lastPageBuffer, unallocatedRegionStartingOffsetOnPage, bytesToCheckAdditionally);
            int nonZeroBytesBeyondEOF = lastNonZeroOffsetInPage - unallocatedRegionStartingOffsetOnPage + 1;
            int nonZeroedRecordsCount = nonZeroBytesBeyondEOF / 40 + 1;
            throw new CorruptedException("Non-empty records detected beyond current EOF => storage is corrupted.\n\tmax allocated id(=" + maxAllocatedID + ")\n\tfirst un-allocated offset: " + unallocatedRegionStartingOffsetInFile + "\n\tcontent beyond allocated region(" + recordsToCheck + " records max): \n" + this.dumpRecordsAsHex(firstUnAllocatedId, firstUnAllocatedId + recordsToCheck) + "\n=" + nonZeroedRecordsCount + " total non-zero records on the page, in range [" + unallocatedRegionStartingOffsetInFile + ".." + (unallocatedRegionStartingOffsetInFile + (long)nonZeroBytesBeyondEOF) + "), wasClosedProperly=" + this.wasClosedProperly + ", wasAlwaysClosedProperly=" + this.wasAlwaysClosedProperly);
        }
    }

    private static int firstNonZeroByteOffset(@NotNull ByteBuffer buffer2, int startingOffset, int maxBytesToCheck) {
        if (buffer2 == null) {
            PersistentFSRecordsLockFreeOverMMappedFile.$$$reportNull$$$0(8);
        }
        for (int i2 = 0; i2 < maxBytesToCheck; ++i2) {
            byte b = buffer2.get(startingOffset + i2);
            if (b == 0) continue;
            return startingOffset + i2;
        }
        return -1;
    }

    private static int lastNonZeroByteOffset(@NotNull ByteBuffer buffer2, int startingOffset, int maxBytesToCheck) {
        if (buffer2 == null) {
            PersistentFSRecordsLockFreeOverMMappedFile.$$$reportNull$$$0(9);
        }
        int lastNonZeroOffset = -1;
        for (int i2 = 0; i2 < maxBytesToCheck; ++i2) {
            byte b = buffer2.get(startingOffset + i2);
            if (b == 0) continue;
            lastNonZeroOffset = startingOffset + i2;
        }
        return lastNonZeroOffset;
    }

    public String dumpRecordsAsHex(int firstRecordId, int lastRecordId) throws IOException {
        if (firstRecordId > lastRecordId) {
            return "<no records in range " + firstRecordId + " .. " + lastRecordId + ">";
        }
        long actualFileSize = this.storage.actualFileSize();
        StringBuilder sb = new StringBuilder();
        for (int recordId = firstRecordId; recordId <= lastRecordId; ++recordId) {
            String recordAsHex;
            if (recordId == 0) {
                recordAsHex = "<header>";
            } else {
                long recordOffsetInFile = this.recordOffsetInFileUnchecked(recordId);
                if (recordOffsetInFile >= actualFileSize) {
                    recordAsHex = "<EOF: outside of allocated file region>";
                } else {
                    int recordOffsetInPage = this.storage.toOffsetInPage(recordOffsetInFile);
                    MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
                    ByteBuffer pageBuffer = page.rawPageBuffer();
                    ByteBuffer recordSlice = pageBuffer.slice(recordOffsetInPage, 40);
                    recordAsHex = IOUtil.toHexString((ByteBuffer)recordSlice);
                }
            }
            sb.append("[#%06d/max=%06d]: ".formatted(recordId, this.maxAllocatedID())).append(recordAsHex).append('\n');
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageBuffer";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsLockFreeOverMMappedFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readRecord";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateRecord";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "readHeader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateHeader";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllRecords";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkValidIdField";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "incrementRecordVersion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "firstNonZeroByteOffset";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lastNonZeroByteOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class HeaderAccessor
    implements IPersistentFSRecordsStorage.HeaderForUpdate {
        @NotNull
        private final PersistentFSRecordsLockFreeOverMMappedFile records;

        private HeaderAccessor(@NotNull PersistentFSRecordsLockFreeOverMMappedFile records) {
            if (records == null) {
                HeaderAccessor.$$$reportNull$$$0(0);
            }
            this.records = records;
        }

        @Override
        public long getTimestamp() {
            return this.records.getTimestamp();
        }

        @Override
        public int getVersion() throws IOException {
            return this.records.getVersion();
        }

        @Override
        public int getGlobalModCount() {
            return this.records.getGlobalModCount();
        }

        @Override
        public void setVersion(int version) {
            this.records.setVersion(version);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsLockFreeOverMMappedFile$HeaderAccessor", "<init>"));
        }
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static final class FileHeader {
        static final int VERSION_OFFSET = 0;
        static final int RECORDS_ALLOCATED_OFFSET = 4;
        static final int GLOBAL_MOD_COUNT_OFFSET = 8;
        static final int OWNER_PROCESS_ID_OFFSET = 12;
        static final int CREATION_TIMESTAMP_OFFSET = 16;
        static final int OWNERSHIP_ACQUIRED_TIMESTAMP_OFFSET = 24;
        static final int ERRORS_ACCUMULATED_OFFSET = 32;
        static final int FLAGS_OFFSET = 36;
        public static final int HEADER_SIZE = 40;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static final class RecordLayout {
        static final int PARENT_REF_OFFSET = 0;
        static final int NAME_REF_OFFSET = 4;
        static final int FLAGS_OFFSET = 8;
        static final int ATTR_REF_OFFSET = 12;
        static final int CONTENT_REF_OFFSET = 16;
        static final int MOD_COUNT_OFFSET = 20;
        static final int TIMESTAMP_OFFSET = 24;
        static final int LENGTH_OFFSET = 32;
        public static final int RECORD_SIZE_IN_BYTES = 40;
    }

    private static final class RecordAccessor
    implements IPersistentFSRecordsStorage.RecordForUpdate {
        private final int recordId;
        private final int recordOffsetInPage;
        private final transient ByteBuffer pageBuffer;
        @NotNull
        private final PersistentFSRecordsLockFreeOverMMappedFile records;

        private RecordAccessor(int recordId, int recordOffsetInPage, MMappedFileStorage.Page recordPage, @NotNull PersistentFSRecordsLockFreeOverMMappedFile records) {
            if (records == null) {
                RecordAccessor.$$$reportNull$$$0(0);
            }
            this.recordId = recordId;
            this.recordOffsetInPage = recordOffsetInPage;
            this.pageBuffer = recordPage.rawPageBuffer();
            this.records = records;
        }

        @Override
        public int recordId() {
            return this.recordId;
        }

        @Override
        public int getAttributeRecordId() {
            return this.getIntField(12);
        }

        @Override
        public int getParent() {
            return this.getIntField(0);
        }

        @Override
        public int getNameId() {
            return this.getIntField(4);
        }

        @Override
        public long getLength() {
            return this.getLongField(32);
        }

        @Override
        public long getTimestamp() {
            return this.getLongField(24);
        }

        @Override
        public int getModCount() {
            return this.getIntField(20);
        }

        @Override
        public int getContentRecordId() {
            return this.getIntField(16);
        }

        @Override
        public @PersistentFS.Attributes int getFlags() {
            return this.getIntField(8);
        }

        @Override
        public void setAttributeRecordId(int attributeRecordId) {
            PersistentFSRecordsLockFreeOverMMappedFile.checkValidIdField(this.recordId, attributeRecordId, "attributeRecordId");
            this.setIntField(12, attributeRecordId);
        }

        @Override
        public void setParent(int parentId) {
            this.records.checkParentIdIsValid(parentId);
            this.setIntField(0, parentId);
        }

        @Override
        public void setNameId(int nameId) {
            PersistentFSRecordsLockFreeOverMMappedFile.checkValidIdField(this.recordId, nameId, "nameId");
            this.setIntField(4, nameId);
        }

        @Override
        public boolean setFlags(@PersistentFS.Attributes int flags) {
            return this.setIntFieldIfChanged(8, flags);
        }

        @Override
        public boolean setLength(long length) {
            return this.setLongFieldIfChanged(32, length);
        }

        @Override
        public boolean setTimestamp(long timestamp) {
            return this.setLongFieldIfChanged(24, timestamp);
        }

        @Override
        public boolean setContentRecordId(int contentRecordId) {
            PersistentFSRecordsLockFreeOverMMappedFile.checkValidIdField(this.recordId, contentRecordId, "contentRecordId");
            return this.setIntFieldIfChanged(16, contentRecordId);
        }

        private long getLongField(int fieldRelativeOffset) {
            return LONG_HANDLE.getVolatile(this.pageBuffer, this.recordOffsetInPage + fieldRelativeOffset);
        }

        private boolean setLongFieldIfChanged(int fieldRelativeOffset, long newValue) {
            int fieldOffsetInPage = this.recordOffsetInPage + fieldRelativeOffset;
            long oldValue = LONG_HANDLE.getVolatile(this.pageBuffer, fieldOffsetInPage);
            if (oldValue != newValue) {
                PersistentFSRecordsLockFreeOverMMappedFile.setLongVolatile(this.pageBuffer, fieldOffsetInPage, newValue);
                return true;
            }
            return false;
        }

        private int getIntField(int fieldRelativeOffset) {
            return INT_HANDLE.getVolatile(this.pageBuffer, this.recordOffsetInPage + fieldRelativeOffset);
        }

        private void setIntField(int fieldRelativeOffset, int newValue) {
            PersistentFSRecordsLockFreeOverMMappedFile.setIntVolatile(this.pageBuffer, this.recordOffsetInPage + fieldRelativeOffset, newValue);
        }

        private boolean setIntFieldIfChanged(int fieldRelativeOffset, int newValue) {
            int fieldOffsetInPage = this.recordOffsetInPage + fieldRelativeOffset;
            int oldValue = INT_HANDLE.getVolatile(this.pageBuffer, fieldOffsetInPage);
            if (oldValue != newValue) {
                PersistentFSRecordsLockFreeOverMMappedFile.setIntVolatile(this.pageBuffer, fieldOffsetInPage, newValue);
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsLockFreeOverMMappedFile$RecordAccessor", "<init>"));
        }
    }

    public static final class OwnershipInfo {
        public final int ownerProcessPid;
        public final long ownershipAcquiredAtMs;

        public OwnershipInfo(int ownerProcessPid, long ownershipAcquiredAtMs) {
            if (ownerProcessPid < 0) {
                throw new IllegalArgumentException("pid(=" + ownerProcessPid + ") must be positive");
            }
            this.ownerProcessPid = ownerProcessPid;
            this.ownershipAcquiredAtMs = ownershipAcquiredAtMs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OwnershipInfo info = (OwnershipInfo)o;
            return this.ownerProcessPid == info.ownerProcessPid && this.ownershipAcquiredAtMs == info.ownershipAcquiredAtMs;
        }

        public int hashCode() {
            int result2 = this.ownerProcessPid;
            result2 = 31 * result2 + Long.hashCode(this.ownershipAcquiredAtMs);
            return result2;
        }

        public String toString() {
            return "OwnershipInfo{owner pid: " + this.ownerProcessPid + ", acquired at: " + this.ownershipAcquiredAtMs + "}";
        }
    }

    @Target(value={ElementType.TYPE_USE})
    public static @interface FieldOffset {
    }
}

