/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.vfs.newvfs.monitoring.VfsUsageCollector;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;

final class VFSErrorsToFUSReporter
implements AppLifecycleListener {
    VFSErrorsToFUSReporter() {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            throw ExtensionNotApplicableException.create();
        }
    }

    public void appWillBeClosed(boolean isRestart) {
        FSRecordsImpl fsRecords = FSRecords.getInstanceIfCreatedAndNotDisposed();
        if (fsRecords == null) {
            return;
        }
        long sessionDurationMs = System.currentTimeMillis() - ApplicationManager.getApplication().getStartTime();
        VfsUsageCollector.logVfsInternalErrors(fsRecords.getCreationTimestamp(), sessionDurationMs, fsRecords.corruptionsDetected());
    }
}

