/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent.mapped.content;

import com.intellij.openapi.util.ThreadLocalCachedByteArray;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.CompressionUtil;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import org.jetbrains.annotations.NotNull;

public interface CompressingAlgo {
    public static final int ZIP_ID = 1;
    public static final int LZ4_ID = 2;
    public static final int NONE_ID = 3;

    public int algoID();

    public boolean shouldCompress(@NotNull ByteArraySequence var1);

    public ByteArraySequence compress(@NotNull ByteArraySequence var1, boolean var2) throws IOException;

    default public ByteArraySequence compress(@NotNull ByteArraySequence input) throws IOException {
        if (input == null) {
            CompressingAlgo.$$$reportNull$$$0(0);
        }
        return this.compress(input, false);
    }

    public void decompress(@NotNull ByteBuffer var1, byte[] var2) throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/openapi/vfs/newvfs/persistent/mapped/content/CompressingAlgo", "compress"));
    }

    public static class NoCompressionAlgo
    implements CompressingAlgo {
        @Override
        public boolean shouldCompress(@NotNull ByteArraySequence input) {
            if (input == null) {
                NoCompressionAlgo.$$$reportNull$$$0(0);
            }
            return false;
        }

        @Override
        public int algoID() {
            return 3;
        }

        @Override
        public ByteArraySequence compress(@NotNull ByteArraySequence input, boolean mayReturnReusableBufferHint) throws IOException {
            if (input == null) {
                NoCompressionAlgo.$$$reportNull$$$0(1);
            }
            throw new UnsupportedOperationException("Method should not be called since shouldCompress() returns false");
        }

        @Override
        public void decompress(@NotNull ByteBuffer bufferWithCompressedData, byte[] bufferForDecompression) throws IOException {
            if (bufferWithCompressedData == null) {
                NoCompressionAlgo.$$$reportNull$$$0(2);
            }
            throw new UnsupportedOperationException("Method should not be called since shouldCompress() returns false");
        }

        public String toString() {
            return "NONE";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bufferWithCompressedData";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/mapped/content/CompressingAlgo$NoCompressionAlgo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldCompress";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compress";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "decompress";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Lz4Algo
    implements CompressingAlgo {
        private final int compressContentLargerThan;
        private static final ThreadLocalCachedByteArray threadLocalBuffer = new ThreadLocalCachedByteArray();

        public Lz4Algo(int compressContentLargerThan) {
            this.compressContentLargerThan = compressContentLargerThan;
        }

        @Override
        public int algoID() {
            return 2;
        }

        @Override
        public boolean shouldCompress(@NotNull ByteArraySequence contentBytes) {
            if (contentBytes == null) {
                Lz4Algo.$$$reportNull$$$0(0);
            }
            return contentBytes.length() > this.compressContentLargerThan;
        }

        @Override
        public ByteArraySequence compress(@NotNull ByteArraySequence input, boolean mayReturnReusableBufferHint) throws IOException {
            if (input == null) {
                Lz4Algo.$$$reportNull$$$0(1);
            }
            try {
                LZ4Compressor compressor = CompressionUtil.compressor();
                int compressedLengthMax = compressor.maxCompressedLength(input.length());
                byte[] compressedBytes = mayReturnReusableBufferHint ? threadLocalBuffer.getBuffer(compressedLengthMax) : new byte[compressedLengthMax];
                int actualCompressedLength = compressor.compress(input.getInternalBuffer(), input.getOffset(), input.length(), compressedBytes, 0, compressedBytes.length);
                return new ByteArraySequence(compressedBytes, 0, actualCompressedLength);
            }
            catch (LZ4Exception e) {
                throw new IOException("Compressing " + input.length() + " bytes failed", e);
            }
        }

        @Override
        public void decompress(@NotNull ByteBuffer bufferWithCompressedData, byte[] bufferForDecompression) throws IOException {
            if (bufferWithCompressedData == null) {
                Lz4Algo.$$$reportNull$$$0(2);
            }
            int compressedSize = bufferWithCompressedData.remaining();
            byte[] compressedBytes = threadLocalBuffer.getBuffer(compressedSize);
            bufferWithCompressedData.get(compressedBytes, 0, compressedSize);
            try {
                int bytesUsedFromCompressedData = CompressionUtil.decompressor().decompress(compressedBytes, 0, bufferForDecompression, 0, bufferForDecompression.length);
                if (bytesUsedFromCompressedData != compressedSize) {
                    throw new IOException("Decompressed bytes[" + bytesUsedFromCompressedData + "b out of " + compressedSize + "b] != compressed bytes[" + bufferForDecompression.length + "] => storage is likely corrupted");
                }
            }
            catch (LZ4Exception e) {
                throw new IOException("Decompressing " + compressedSize + " bytes into " + bufferForDecompression.length + " bytes failed", e);
            }
        }

        public String toString() {
            return "LZ4[ > " + this.compressContentLargerThan + "b ]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentBytes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bufferWithCompressedData";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/mapped/content/CompressingAlgo$Lz4Algo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldCompress";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compress";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "decompress";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ZipAlgo
    implements CompressingAlgo {
        private final int compressContentLargerThan;

        public ZipAlgo(int compressContentLargerThan) {
            this.compressContentLargerThan = compressContentLargerThan;
        }

        @Override
        public int algoID() {
            return 1;
        }

        @Override
        public boolean shouldCompress(@NotNull ByteArraySequence contentBytes) {
            if (contentBytes == null) {
                ZipAlgo.$$$reportNull$$$0(0);
            }
            return contentBytes.length() > this.compressContentLargerThan;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteArraySequence compress(@NotNull ByteArraySequence input, boolean mayReturnReusableBufferHint) throws IOException {
            if (input == null) {
                ZipAlgo.$$$reportNull$$$0(1);
            }
            Deflater deflater = new Deflater();
            try {
                deflater.setInput(input.getInternalBuffer(), input.getOffset(), input.length());
                deflater.finish();
                UnsyncByteArrayOutputStream compressedBytesStream = new UnsyncByteArrayOutputStream(input.length() / 2);
                byte[] buffer2 = new byte[1024];
                while (!deflater.finished()) {
                    int bytesDeflated = deflater.deflate(buffer2);
                    compressedBytesStream.write(buffer2, 0, bytesDeflated);
                }
                ByteArraySequence byteArraySequence = compressedBytesStream.toByteArraySequence();
                return byteArraySequence;
            }
            finally {
                deflater.end();
            }
        }

        @Override
        public void decompress(@NotNull ByteBuffer bufferWithCompressedData, byte[] bufferForDecompression) throws IOException {
            if (bufferWithCompressedData == null) {
                ZipAlgo.$$$reportNull$$$0(2);
            }
            int contentSize = bufferWithCompressedData.remaining();
            Inflater inflater = new Inflater();
            try {
                inflater.setInput(bufferWithCompressedData);
                int bytesInflated = inflater.inflate(bufferForDecompression);
                if (bytesInflated != bufferForDecompression.length) {
                    throw new IOException("Decompressed bytes[" + bytesInflated + "b out of " + contentSize + "b] != compressed bytes[" + bufferForDecompression.length + "] => storage is likely corrupted");
                }
                if (!inflater.finished()) {
                    throw new IOException("Decompressed bytes[" + bytesInflated + "b out of " + contentSize + "b] but compressed stream is not finished yet => storage is likely corrupted");
                }
            }
            catch (DataFormatException e) {
                throw new IOException("Decompression [" + contentSize + "b] was failed => storage is likely corrupted", e);
            }
            finally {
                inflater.end();
            }
        }

        public String toString() {
            return "ZIP[ > " + this.compressContentLargerThan + "b ]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentBytes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bufferWithCompressedData";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/mapped/content/CompressingAlgo$ZipAlgo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldCompress";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compress";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "decompress";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

