/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.ToolWindowManagerState;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.awt.Component;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ToolWindowManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020,H\u0016J\b\u0010\r\u001a\u00020.H\u0016J \u00100\u001a\u00020.2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00101\u001a\u00020,2\u0006\u00102\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u0007@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000bR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000fR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u00063"}, d2={"Lcom/intellij/openapi/wm/impl/ToolWindowManagerStateImpl;", "Lcom/intellij/openapi/wm/impl/ToolWindowManagerState;", "<init>", "()V", "isNewUi", "", "layout", "Lcom/intellij/openapi/wm/impl/DesktopLayout;", "getLayout", "()Lcom/intellij/openapi/wm/impl/DesktopLayout;", "setLayout", "(Lcom/intellij/openapi/wm/impl/DesktopLayout;)V", "value", "noStateLoaded", "getNoStateLoaded", "()Z", "oldLayout", "getOldLayout", "layoutToRestoreLater", "getLayoutToRestoreLater", "setLayoutToRestoreLater", "recentToolWindows", "Ljava/util/LinkedList;", "", "getRecentToolWindows", "()Ljava/util/LinkedList;", "scheduledLayout", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "getScheduledLayout", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "isEditorComponentActive", "projectFrame", "Ljavax/swing/JFrame;", "getProjectFrame", "()Ljavax/swing/JFrame;", "setProjectFrame", "(Ljavax/swing/JFrame;)V", "moreButton", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "getMoreButton", "()Lcom/intellij/openapi/wm/ToolWindowAnchor;", "setMoreButton", "(Lcom/intellij/openapi/wm/ToolWindowAnchor;)V", "getState", "Lorg/jdom/Element;", "loadState", "", "state", "writeLayout", "parent", "isV2", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nToolWindowManagerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowManagerState.kt\ncom/intellij/openapi/wm/impl/ToolWindowManagerStateImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1869#2,2:151\n1869#2,2:154\n1#3:153\n*S KotlinDebug\n*F\n+ 1 ToolWindowManagerState.kt\ncom/intellij/openapi/wm/impl/ToolWindowManagerStateImpl\n*L\n81#1:151,2\n128#1:154,2\n*E\n"})
public final class ToolWindowManagerStateImpl
implements ToolWindowManagerState {
    private final boolean isNewUi = ExperimentalUI.Companion.isNewUI();
    @NotNull
    private DesktopLayout layout = new DesktopLayout(null, null, 3, null);
    private boolean noStateLoaded;
    @Nullable
    private DesktopLayout oldLayout;
    @Nullable
    private DesktopLayout layoutToRestoreLater;
    @NotNull
    private final LinkedList<String> recentToolWindows = new LinkedList();
    @NotNull
    private final AtomicProperty<DesktopLayout> scheduledLayout = new AtomicProperty(null);
    @Nullable
    private JFrame projectFrame;
    @NotNull
    private ToolWindowAnchor moreButton;

    public ToolWindowManagerStateImpl() {
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"LEFT");
        this.moreButton = toolWindowAnchor;
    }

    @Override
    @NotNull
    public DesktopLayout getLayout() {
        return this.layout;
    }

    @Override
    public void setLayout(@NotNull DesktopLayout desktopLayout) {
        Intrinsics.checkNotNullParameter((Object)desktopLayout, (String)"<set-?>");
        this.layout = desktopLayout;
    }

    @Override
    public boolean getNoStateLoaded() {
        return this.noStateLoaded;
    }

    @Override
    @Nullable
    public DesktopLayout getOldLayout() {
        return this.oldLayout;
    }

    @Override
    @Nullable
    public DesktopLayout getLayoutToRestoreLater() {
        return this.layoutToRestoreLater;
    }

    @Override
    public void setLayoutToRestoreLater(@Nullable DesktopLayout desktopLayout) {
        this.layoutToRestoreLater = desktopLayout;
    }

    @Override
    @NotNull
    public LinkedList<String> getRecentToolWindows() {
        return this.recentToolWindows;
    }

    @Override
    @NotNull
    public AtomicProperty<DesktopLayout> getScheduledLayout() {
        return this.scheduledLayout;
    }

    @Override
    public boolean isEditorComponentActive() {
        ThreadingAssertions.assertEventDispatchThread();
        return ComponentUtil.getParentOfType(EditorsSplitters.class, (Component)IdeFocusManager.getGlobalInstance().getFocusOwner()) != null;
    }

    @Override
    @Nullable
    public JFrame getProjectFrame() {
        return this.projectFrame;
    }

    @Override
    public void setProjectFrame(@Nullable JFrame jFrame) {
        this.projectFrame = jFrame;
    }

    @Override
    @NotNull
    public ToolWindowAnchor getMoreButton() {
        return this.moreButton;
    }

    @Override
    public void setMoreButton(@NotNull ToolWindowAnchor toolWindowAnchor) {
        Intrinsics.checkNotNullParameter((Object)toolWindowAnchor, (String)"<set-?>");
        this.moreButton = toolWindowAnchor;
    }

    @Nullable
    public Element getState() {
        DesktopLayout desktopLayout;
        if (this.getProjectFrame() == null) {
            return null;
        }
        Element element = new Element("state");
        this.writeLayout(this.getLayout(), element, this.isNewUi);
        DesktopLayout desktopLayout2 = this.getOldLayout();
        if (desktopLayout2 != null) {
            DesktopLayout it = desktopLayout2;
            boolean bl = false;
            this.writeLayout(it, element, !this.isNewUi);
        }
        if ((desktopLayout = this.getLayoutToRestoreLater()) != null && (desktopLayout = desktopLayout.writeExternal("layout-to-restore")) != null) {
            DesktopLayout it = desktopLayout;
            boolean bl = false;
            element.addContent((Element)it);
        }
        if (!((Collection)this.getRecentToolWindows()).isEmpty()) {
            Element recentState = new Element("recentWindows");
            Iterable $this$forEach$iv = this.getRecentToolWindows();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                recentState.addContent(new Element("value").addContent(it));
            }
            element.addContent(recentState);
        }
        if (!Intrinsics.areEqual((Object)this.getMoreButton(), (Object)ToolWindowAnchor.LEFT)) {
            element.addContent(new Element("moreButton").setAttribute("side", this.getMoreButton().toString()));
        }
        return element;
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull Element state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        boolean layoutIsScheduled = false;
        for (Element element : state2.getChildren()) {
            String string;
            if (JDOMUtil.isEmpty((Element)element) || (string = element.getName()) == null) continue;
            int n = -1;
            switch (string.hashCode()) {
                case -1109722326: {
                    if (string.equals("layout")) {
                        n = 1;
                    }
                    break;
                }
                case -447497497: {
                    if (string.equals("moreButton")) {
                        n = 2;
                    }
                    break;
                }
                case 290835391: {
                    if (string.equals("layout-to-restore")) {
                        n = 3;
                    }
                    break;
                }
                case -1343084632: {
                    if (string.equals("recentWindows")) {
                        n = 4;
                    }
                    break;
                }
                case -1291263162: {
                    if (string.equals("layoutV2")) {
                        n = 5;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    DesktopLayout layout2 = new DesktopLayout(null, null, 3, null);
                    Intrinsics.checkNotNull((Object)element);
                    DesktopLayout.readExternal$default(layout2, element, false, 2, null);
                    if (this.isNewUi) {
                        this.oldLayout = layout2;
                        break;
                    }
                    this.getScheduledLayout().set((Object)layout2);
                    layoutIsScheduled = true;
                    break;
                }
                case 5: {
                    DesktopLayout layout2 = new DesktopLayout(null, null, 3, null);
                    Intrinsics.checkNotNull((Object)element);
                    DesktopLayout.readExternal$default(layout2, element, false, 2, null);
                    if (this.isNewUi) {
                        this.getScheduledLayout().set((Object)layout2);
                        layoutIsScheduled = true;
                        break;
                    }
                    this.oldLayout = layout2;
                    break;
                }
                case 3: {
                    void it;
                    DesktopLayout layout2;
                    DesktopLayout desktopLayout = layout2 = new DesktopLayout(null, null, 3, null);
                    ToolWindowManagerStateImpl toolWindowManagerStateImpl = this;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)element);
                    DesktopLayout.readExternal$default((DesktopLayout)it, element, false, 2, null);
                    toolWindowManagerStateImpl.setLayoutToRestoreLater(layout2);
                    break;
                }
                case 4: {
                    this.getRecentToolWindows().clear();
                    List list2 = element.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Content it = (Content)element$iv;
                        boolean bl = false;
                        this.getRecentToolWindows().add(it.getValue());
                    }
                    break;
                }
                case 2: {
                    ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.fromText((String)element.getAttributeValue("side"));
                    Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"fromText(...)");
                    this.setMoreButton(toolWindowAnchor);
                }
            }
        }
        if (!layoutIsScheduled) {
            this.noStateLoaded();
        }
    }

    public void noStateLoaded() {
        this.noStateLoaded = true;
    }

    private final void writeLayout(DesktopLayout layout2, Element parent, boolean isV2) {
        Element element = layout2.writeExternal(isV2 ? "layoutV2" : "layout");
        if (element == null) {
            return;
        }
        parent.addContent(element);
    }
}

