/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.impl.WindowManagerImplKt;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u00a8\u0006\u0003"}, d2={"getNativeNormalBounds", "Ljava/awt/Rectangle;", "Ljava/awt/Window;", "intellij.platform.ide.impl"})
public final class WinUiUtilKt {
    @Nullable
    public static final Rectangle getNativeNormalBounds(@NotNull Window $this$getNativeNormalBounds) {
        Intrinsics.checkNotNullParameter((Object)$this$getNativeNormalBounds, (String)"<this>");
        try {
            if (!SystemInfoRt.isWindows) {
                return null;
            }
            User32 user32 = User32.INSTANCE;
            if (user32 == null) {
                return null;
            }
            User32 user322 = user32;
            Field peerField = Component.class.getDeclaredField("peer");
            peerField.setAccessible(true);
            Object object = peerField.get($this$getNativeNormalBounds);
            if (object == null) {
                return null;
            }
            Object peer = object;
            Method getHWnd = peer.getClass().getMethod("getHWnd", new Class[0]);
            Object object2 = getHWnd.invoke(peer, new Object[0]);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Long");
            WinDef.HWND hwnd = new WinDef.HWND(new Pointer(((Long)object2).longValue()));
            WinUser.WINDOWPLACEMENT placement = new WinUser.WINDOWPLACEMENT();
            if (!user322.GetWindowPlacement(hwnd, placement).booleanValue()) {
                return null;
            }
            WinDef.RECT rECT = placement.rcNormalPosition;
            if (rECT == null) {
                return null;
            }
            WinDef.RECT result2 = rECT;
            return result2.toRectangle();
        }
        catch (Exception e) {
            if (e instanceof ProcessCanceledException || e instanceof CancellationException) {
                throw e;
            }
            WindowManagerImplKt.IDE_FRAME_EVENT_LOG.warn("An error occurred when trying to get the native window bounds from the OS", (Throwable)e);
            return null;
        }
    }
}

