/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.toolWindow.ToolWindowEventSource;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.FocusUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

final class ToolWindowsWidget
implements CustomStatusBarWidget,
Disposable,
UISettingsListener {
    private final LazyInitializer.LazyValue<JLabel> myComponent;
    private final Alarm myAlarm;
    private final StatusBar myStatusBar;
    private JBPopup popup;
    private boolean wasExited;

    ToolWindowsWidget(@NotNull Disposable parent, StatusBar statusBar) {
        if (parent == null) {
            ToolWindowsWidget.$$$reportNull$$$0(0);
        }
        this.wasExited = false;
        this.myStatusBar = statusBar;
        this.myComponent = LazyInitializer.create(() -> {
            JLabel result2 = new JLabel();
            BaseButtonBehavior behavior2 = new BaseButtonBehavior(result2, TimedDeadzone.NULL, null){

                protected void execute(MouseEvent e) {
                    ToolWindowsWidget.this.performAction();
                }
            };
            behavior2.setupListeners();
            behavior2.setActionTrigger(501);
            return result2;
        });
        IdeEventQueue.getInstance().addDispatcher(e -> {
            if (e instanceof MouseEvent) {
                this.dispatchMouseEvent((MouseEvent)e);
            }
            return false;
        }, parent);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(UISettingsListener.TOPIC, (Object)this);
        FocusUtil.addFocusOwnerListener((Disposable)this, __ -> this.updateIcon());
        this.myAlarm = new Alarm(parent);
        this.updateIcon();
    }

    private void dispatchMouseEvent(MouseEvent e) {
        JLabel myComponent = (JLabel)this.myComponent.get();
        Component component2 = e.getComponent();
        if (component2 != null && SwingUtilities.isDescendingFrom(component2, SwingUtilities.getWindowAncestor(myComponent))) {
            int id2 = e.getID();
            if (id2 == 503 && myComponent.isShowing()) {
                this.mouseMoved(e);
            } else if (id2 == 505) {
                this.mouseExited(e.getLocationOnScreen());
            }
        }
    }

    private void mouseMoved(MouseEvent e) {
        JLabel myComponent = (JLabel)this.myComponent.get();
        Point p = e.getLocationOnScreen();
        Point screen = myComponent.getLocationOnScreen();
        if (new Rectangle(screen.x - 4, screen.y - 2, myComponent.getWidth() + 4, myComponent.getHeight() + 4).contains(p)) {
            this.mouseEntered();
            this.wasExited = false;
        } else if (!this.wasExited) {
            this.wasExited = this.mouseExited(p);
        }
    }

    private boolean mouseExited(Point currentLocationOnScreen) {
        this.myAlarm.cancelAllRequests();
        if (this.popup != null && this.popup.isVisible()) {
            Point screen = this.popup.getLocationOnScreen();
            Rectangle popupScreenRect = new Rectangle(screen.x, screen.y, this.popup.getSize().width, this.popup.getSize().height);
            if (!popupScreenRect.contains(currentLocationOnScreen)) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(() -> {
                    if (this.popup != null && this.popup.isVisible()) {
                        this.popup.cancel();
                    }
                }, 300);
                return true;
            }
        }
        return false;
    }

    private void mouseEntered() {
        boolean active = ApplicationManager.getApplication().isActive();
        if (!active) {
            return;
        }
        if (this.myAlarm.isEmpty()) {
            this.myAlarm.addRequest(() -> {
                Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myComponent.get()));
                if (project2 == null) {
                    return;
                }
                UIEventLogger.ToolWindowsWidgetPopupShown.log(project2);
                ArrayList<ToolWindow> toolWindows = new ArrayList<ToolWindow>();
                ToolWindowManagerImpl toolWindowManager = (ToolWindowManagerImpl)ToolWindowManager.getInstance((Project)project2);
                for (ToolWindow toolWindow2 : toolWindowManager.getToolWindows()) {
                    if (!toolWindow2.isAvailable() || !toolWindow2.isShowStripeButton()) continue;
                    toolWindows.add(toolWindow2);
                }
                toolWindows.sort((o1, o2) -> StringUtil.naturalCompare((String)o1.getStripeTitle(), (String)o2.getStripeTitle()));
                JBList list2 = new JBList(toolWindows);
                list2.setCellRenderer((ListCellRenderer)new ToolWindowsWidgetCellRenderer());
                Dimension size2 = list2.getPreferredSize();
                JComponent c = (JComponent)this.myComponent.get();
                Insets padding = UIUtil.getListViewportPadding((boolean)false);
                RelativePoint point = new RelativePoint((Component)c, new Point(-4, -padding.top - padding.bottom - 4 - size2.height + (SystemInfo.isMac ? 2 : 0)));
                if (this.popup != null && this.popup.isVisible()) {
                    return;
                }
                list2.setSelectedIndex(list2.getItemsCount() - 1);
                PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder((JList)list2);
                this.popup = builder.setAutoselectOnMouseMove(true).setRequestFocus(false).setItemChosenCallback(selectedValue -> {
                    if (this.popup != null) {
                        this.popup.closeOk(null);
                    }
                    toolWindowManager.activateToolWindow(selectedValue.getId(), null, true, ToolWindowEventSource.ToolWindowsWidget);
                }).createPopup();
                list2.setVisibleRowCount(30);
                this.popup.show(point);
            }, 300);
        }
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            ToolWindowsWidget.$$$reportNull$$$0(1);
        }
        this.updateIcon();
    }

    private void performAction() {
        if (this.isActive()) {
            UIEventLogger.ToolWindowsWidgetPopupClicked.log(this.myStatusBar.getProject());
            UISettings.getInstance().setHideToolStripes(!UISettings.getInstance().getHideToolStripes());
            UISettings.getInstance().fireUISettingsChanged();
        }
    }

    private void updateIcon() {
        JLabel myComponent = (JLabel)this.myComponent.get();
        myComponent.setToolTipText(null);
        if (this.isActive()) {
            Icon icon2;
            boolean changes = false;
            if (!myComponent.isVisible()) {
                myComponent.setVisible(true);
                changes = true;
            }
            Icon icon3 = icon2 = UISettings.getInstance().getHideToolStripes() ? AllIcons.General.TbShown : AllIcons.General.TbHidden;
            if (icon2 != myComponent.getIcon()) {
                myComponent.setIcon(icon2);
                changes = true;
            }
            if (changes) {
                myComponent.revalidate();
                myComponent.repaint();
            }
        } else {
            myComponent.setVisible(false);
            myComponent.setToolTipText(null);
        }
    }

    private boolean isActive() {
        return this.myStatusBar.getProject() != null;
    }

    public JComponent getComponent() {
        return (JComponent)this.myComponent.get();
    }

    @NotNull
    public String ID() {
        return "ToolWindows Widget";
    }

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
        this.popup = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/status/ToolWindowsWidget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "uiSettingsChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ToolWindowsWidgetCellRenderer
    implements ListCellRenderer<ToolWindow> {
        private final JPanel myPanel;
        private final JLabel myTextLabel = new JLabel();
        private final JLabel myShortcutLabel = new JLabel();

        private ToolWindowsWidgetCellRenderer() {
            this.myPanel = JBUI.Panels.simplePanel().addToLeft((Component)this.myTextLabel).addToRight((Component)this.myShortcutLabel);
            this.myShortcutLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)JBUIScale.scale((int)8), (int)1, (int)0));
            this.myPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)10));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ToolWindow> list2, ToolWindow value, int index, boolean isSelected, boolean cellHasFocus) {
            UIUtil.setBackgroundRecursively((Component)this.myPanel, (Color)UIUtil.getListBackground((boolean)isSelected, (boolean)true));
            this.myTextLabel.setText(value.getStripeTitle());
            this.myTextLabel.setIcon(value.getIcon());
            this.myTextLabel.setForeground(UIUtil.getListForeground((boolean)isSelected, (boolean)true));
            String activateActionId = ActivateToolWindowAction.Manager.getActionIdForToolWindow(value.getId());
            KeyboardShortcut shortcut = ActionManager.getInstance().getKeyboardShortcut(activateActionId);
            if (shortcut != null) {
                this.myShortcutLabel.setText(KeymapUtil.getShortcutText((Shortcut)shortcut));
            } else {
                this.myShortcutLabel.setText("");
            }
            this.myShortcutLabel.setForeground(isSelected ? UIManager.getColor("MenuItem.acceleratorSelectionForeground") : UIManager.getColor("MenuItem.acceleratorForeground"));
            return this.myPanel;
        }
    }
}

