/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status.widget;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.StatusBarWidgetProvider;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0013\u0010\u001b\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/wm/impl/status/widget/StatusBarWidgetProviderToFactoryAdapter;", "Lcom/intellij/openapi/wm/StatusBarWidgetFactory;", "project", "Lcom/intellij/openapi/project/Project;", "frame", "Lcom/intellij/openapi/wm/IdeFrame;", "provider", "Lcom/intellij/openapi/wm/StatusBarWidgetProvider;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/IdeFrame;Lcom/intellij/openapi/wm/StatusBarWidgetProvider;)V", "widgetWasCreated", "", "myWidget", "Lcom/intellij/openapi/wm/StatusBarWidget;", "getId", "", "getDisplayName", "isAvailable", "isConfigurable", "createWidget", "widget", "getWidget$annotations", "()V", "getWidget", "()Lcom/intellij/openapi/wm/StatusBarWidget;", "disposeWidget", "", "equals", "other", "", "hashCode", "", "intellij.platform.ide.impl"})
public final class StatusBarWidgetProviderToFactoryAdapter
implements StatusBarWidgetFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final IdeFrame frame;
    @JvmField
    @NotNull
    public final StatusBarWidgetProvider provider;
    private boolean widgetWasCreated;
    @Nullable
    private StatusBarWidget myWidget;

    public StatusBarWidgetProviderToFactoryAdapter(@NotNull Project project2, @NotNull IdeFrame frame, @NotNull StatusBarWidgetProvider provider) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.project = project2;
        this.frame = frame;
        this.provider = provider;
    }

    @NotNull
    public String getId() {
        Object object = this.getWidget();
        if (object == null || (object = object.ID()) == null) {
            String string = this.provider.getClass().getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        }
        return object;
    }

    @NotNull
    public String getDisplayName() {
        StatusBarWidget statusBarWidget = this.getWidget();
        if (statusBarWidget == null) {
            return "";
        }
        StatusBarWidget widget2 = statusBarWidget;
        StatusBarWidget.WidgetPresentation widgetPresentation = widget2.getPresentation();
        String result2 = widgetPresentation != null ? widgetPresentation.getTooltipText() : null;
        CharSequence charSequence = result2;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return result2;
        }
        return ApplicationManager.getApplication().isInternal() ? widget2.ID() : "";
    }

    public boolean isAvailable(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return this.provider.isCompatibleWith(this.frame) && this.getWidget() != null;
    }

    public boolean isConfigurable() {
        return !(((CharSequence)this.getDisplayName()).length() == 0);
    }

    @NotNull
    public StatusBarWidget createWidget(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        StatusBarWidget statusBarWidget = this.getWidget();
        Intrinsics.checkNotNull((Object)statusBarWidget);
        return statusBarWidget;
    }

    private final StatusBarWidget getWidget() {
        if (!this.widgetWasCreated) {
            this.myWidget = this.provider.getWidget(this.project);
            this.widgetWasCreated = true;
        }
        return this.myWidget;
    }

    private static /* synthetic */ void getWidget$annotations() {
    }

    public void disposeWidget(@NotNull StatusBarWidget widget2) {
        Intrinsics.checkNotNullParameter((Object)widget2, (String)"widget");
        this.myWidget = null;
        this.widgetWasCreated = false;
        Disposer.dispose((Disposable)((Disposable)widget2));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        StatusBarWidgetProviderToFactoryAdapter adapter = (StatusBarWidgetProviderToFactoryAdapter)other;
        return Intrinsics.areEqual((Object)this.provider, (Object)adapter.provider) && Intrinsics.areEqual((Object)this.project, (Object)adapter.project);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.provider, this.project};
        return Objects.hash(objectArray);
    }
}

