/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.WelcomeScreenCustomization;
import com.intellij.openapi.wm.WelcomeScreenLeftPanel;
import com.intellij.openapi.wm.WelcomeScreenTab;
import com.intellij.openapi.wm.WelcomeTabFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractWelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.ProjectsTab;
import com.intellij.openapi.wm.impl.welcomeScreen.TreeWelcomeScreenLeftPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenComponentFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenEventCollector;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UpdateScaleHelper;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedWelcomeScreen
extends AbstractWelcomeScreen {
    private final JPanel leftSidebarHolder = new NonOpaquePanel();
    private final WelcomeScreenLeftPanel myLeftSidebar;
    private final CardLayoutPanel<WelcomeScreenTab, WelcomeScreenTab, JPanel> mainPanel;
    private Disposable currentDisposable = null;
    private ProjectsTab myProjectsTab = null;

    TabbedWelcomeScreen() {
        this(true);
    }

    @ApiStatus.Internal
    public TabbedWelcomeScreen(boolean addLogo) {
        this(WelcomeTabFactory.WELCOME_TAB_FACTORY_EP.getExtensionList(), new TreeWelcomeScreenLeftPanel(), addLogo, true);
    }

    public TabbedWelcomeScreen(List<? extends WelcomeTabFactory> welcomeTabFactories, WelcomeScreenLeftPanel leftSidebar, boolean addLogo, boolean addQuickAccessPanel) {
        this.setBackground(WelcomeScreenUIManager.getMainTabListBackground());
        this.mainPanel = TabbedWelcomeScreen.createCardPanel();
        this.myLeftSidebar = leftSidebar;
        this.myLeftSidebar.addSelectionListener((Disposable)this, tab -> {
            this.mainPanel.select((WelcomeScreenTab)tab, true);
            WelcomeScreenEventCollector.logTabSelected(tab);
        });
        if (addLogo) {
            JComponent logoComponent = WelcomeScreenComponentFactory.createSmallLogo();
            logoComponent.setFocusable(false);
            logoComponent.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
            this.leftSidebarHolder.add((Component)logoComponent, "North");
        }
        this.leftSidebarHolder.add((Component)this.myLeftSidebar.getComponent(), "Center");
        if (addQuickAccessPanel) {
            JComponent quickAccessPanel = TabbedWelcomeScreen.createQuickAccessPanel((Disposable)this);
            this.leftSidebarHolder.add((Component)quickAccessPanel, "South");
        }
        this.updateLeftSidebarHolderSize();
        JComponent centralPanel = this.mainPanel;
        JComponent mainPanelToolbar = TabbedWelcomeScreen.createMainPanelToolbar((Disposable)this);
        if (mainPanelToolbar != null) {
            centralPanel = new JPanel(new BorderLayout());
            centralPanel.add(this.mainPanel, "Center");
            centralPanel.add((Component)mainPanelToolbar, "South");
        }
        this.add((Component)this.createLeftPanel(this.leftSidebarHolder), "West");
        this.add(centralPanel, "Center");
        if (ExperimentalUI.isNewUI()) {
            this.setBorder(JBUI.Borders.customLineTop((Color)JBColor.border()));
            centralPanel.setBorder(JBUI.Borders.customLineLeft((Color)JBColor.border()));
        }
        this.loadTabs(welcomeTabFactories);
    }

    @ApiStatus.Internal
    @NotNull
    protected BorderLayoutPanel createLeftPanel(JPanel content2) {
        BorderLayoutPanel panel2 = new BorderLayoutPanel();
        panel2.addToCenter((Component)content2);
        BorderLayoutPanel borderLayoutPanel = panel2;
        if (borderLayoutPanel == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(0);
        }
        return borderLayoutPanel;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getParent() != null) {
            this.updateLeftSidebarHolderSize();
        }
    }

    private void updateLeftSidebarHolderSize() {
        this.leftSidebarHolder.setPreferredSize(new Dimension(JBUI.scale((int)224), this.leftSidebarHolder.getPreferredSize().height));
    }

    @Override
    public void dispose() {
        super.dispose();
        WelcomeScreenEventCollector.logWelcomeScreenHide();
    }

    public void addSelectionListener(@NotNull Disposable disposable, @NotNull Consumer<? super WelcomeScreenTab> action2) {
        if (disposable == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(1);
        }
        if (action2 == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(2);
        }
        this.myLeftSidebar.addSelectionListener(disposable, action2);
    }

    public void addSelectionListener(@NotNull Consumer<? super WelcomeScreenTab> action2) {
        if (action2 == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(3);
        }
        this.myLeftSidebar.addSelectionListener((Disposable)this, action2);
    }

    public void loadTabs() {
        this.loadTabs(WelcomeTabFactory.WELCOME_TAB_FACTORY_EP.getExtensionList());
    }

    private void loadTabs(List<? extends WelcomeTabFactory> welcomeTabFactories) {
        this.myLeftSidebar.removeAllTabs();
        this.myProjectsTab = null;
        if (this.currentDisposable != null) {
            Disposer.dispose((Disposable)this.currentDisposable);
        }
        this.currentDisposable = Disposer.newDisposable((Disposable)this, (String)"TabbedWelcomeScreen tabs");
        for (WelcomeTabFactory welcomeTabFactory : welcomeTabFactories) {
            if (!welcomeTabFactory.isApplicable()) continue;
            for (WelcomeScreenTab alsoTab : welcomeTabFactory.createWelcomeTabs((WelcomeScreen)this, this.currentDisposable)) {
                this.myLeftSidebar.addRootTab(alsoTab);
                if (!(alsoTab instanceof ProjectsTab)) continue;
                this.myProjectsTab = (ProjectsTab)alsoTab;
            }
        }
        this.myLeftSidebar.init();
    }

    public void setTabListVisible(boolean visible) {
        this.leftSidebarHolder.setVisible(visible);
    }

    @ApiStatus.Internal
    public void switchToProjectsTab() {
        if (this.myProjectsTab != null) {
            this.myLeftSidebar.selectTab((WelcomeScreenTab)this.myProjectsTab);
        }
    }

    @ApiStatus.Experimental
    public void selectTab(@NotNull WelcomeScreenTab tab) {
        if (tab == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(4);
        }
        this.myLeftSidebar.selectTab(tab);
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public void navigateToTabAndSetMainComponent(@NotNull DefaultWelcomeScreenTab tab, Component component2) {
        boolean wasSelected;
        if (tab == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(5);
        }
        if (!(wasSelected = this.myLeftSidebar.selectTab((WelcomeScreenTab)tab))) {
            return;
        }
        JComponent panel2 = (JComponent)tab.myAssociatedComponent.getComponent(0);
        panel2.removeAll();
        panel2.add(component2, "Center");
        this.revalidate();
        this.repaint();
        this.leftSidebarHolder.setVisible(false);
    }

    private static JComponent createQuickAccessPanel(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(6);
        }
        NonOpaquePanel result2 = new NonOpaquePanel((LayoutManager)new FlowLayout(0, 0, 0));
        List customizations = WelcomeScreenCustomization.WELCOME_SCREEN_CUSTOMIZATION.getExtensionsIfPointIsRegistered();
        List actions = customizations.stream().map(c -> c.createQuickAccessActions(parentDisposable)).filter(Objects::nonNull).flatMap(l -> l.stream()).toList();
        if (!actions.isEmpty()) {
            DefaultActionGroup group2 = new DefaultActionGroup(actions);
            ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("WelcomeScreen.QuickPanel", (ActionGroup)group2, true);
            toolbar2.setTargetComponent((JComponent)result2);
            toolbar2.setMinimumButtonSize((Dimension)new JBDimension(26, 26));
            JComponent toolbarComponent = toolbar2.getComponent();
            toolbarComponent.setOpaque(false);
            toolbarComponent.setBorder(null);
            result2.add(toolbarComponent);
        }
        customizations.stream().map(c -> c.createQuickAccessComponent(parentDisposable)).filter(Objects::nonNull).forEach(((JPanel)result2)::add);
        if (ExperimentalUI.isNewUI()) {
            result2.setBorder((Border)JBUI.Borders.empty((int)15, (int)14));
        } else {
            result2.setBorder((Border)JBUI.Borders.empty((int)5, (int)10));
        }
        return result2;
    }

    @Nullable
    private static JComponent createMainPanelToolbar(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(7);
        }
        return WelcomeScreenCustomization.WELCOME_SCREEN_CUSTOMIZATION.getExtensionsIfPointIsRegistered().stream().map(c -> c.createMainPanelToolbar(parentDisposable)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @NotNull
    private static CardLayoutPanel<WelcomeScreenTab, WelcomeScreenTab, JPanel> createCardPanel() {
        return new CardLayoutPanel<WelcomeScreenTab, WelcomeScreenTab, JPanel>(){

            @Override
            protected WelcomeScreenTab prepare(WelcomeScreenTab key) {
                key.updateComponent();
                return key;
            }

            @Override
            protected JPanel create(WelcomeScreenTab screenTab) {
                return JBUI.Panels.simplePanel((Component)screenTab.getAssociatedComponent());
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/TabbedWelcomeScreen";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tab";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftPanel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/TabbedWelcomeScreen";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectTab";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "navigateToTabAndSetMainComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createQuickAccessPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createMainPanelToolbar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    public static abstract class DefaultWelcomeScreenTab
    implements WelcomeScreenTab,
    Accessible {
        protected final JComponent myKeyComponent;
        private final UpdateScaleHelper keyUpdateScaleHelper;
        private final JBLabel myLabel;
        private final WelcomeScreenEventCollector.TabType myType;
        private JComponent myAssociatedComponent;
        private final UpdateScaleHelper associatedUpdateScaleHelper;

        public DefaultWelcomeScreenTab(@NotNull @Nls String tabName) {
            if (tabName == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(0);
            }
            this(tabName, null, WelcomeScreenEventCollector.TabType.TabNavOther);
        }

        public DefaultWelcomeScreenTab(@NotNull @Nls String tabName, @Nullable Icon icon2) {
            if (tabName == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(1);
            }
            this(tabName, icon2, WelcomeScreenEventCollector.TabType.TabNavOther);
        }

        DefaultWelcomeScreenTab(@NotNull @Nls String tabName, @NotNull WelcomeScreenEventCollector.TabType tabType) {
            if (tabName == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(2);
            }
            if (tabType == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(3);
            }
            this(tabName, null, tabType);
        }

        DefaultWelcomeScreenTab(@NotNull @Nls String tabName, @Nullable Icon icon2, @NotNull WelcomeScreenEventCollector.TabType tabType) {
            if (tabName == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(4);
            }
            if (tabType == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(5);
            }
            this.keyUpdateScaleHelper = new UpdateScaleHelper();
            this.associatedUpdateScaleHelper = new UpdateScaleHelper();
            this.myLabel = new JBLabel(tabName, icon2, 2);
            this.myType = tabType;
            this.myKeyComponent = ((BorderLayoutPanel)JBUI.Panels.simplePanel().addToLeft((Component)this.myLabel).withBackground(WelcomeScreenUIManager.getMainTabListBackground())).withBorder((Border)JBUI.Borders.empty((int)8, (int)0));
        }

        @NotNull
        public JComponent getKeyComponent(@NotNull JComponent parent) {
            if (parent == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(6);
            }
            this.keyUpdateScaleHelper.saveScaleAndUpdateUIIfChanged(this.myKeyComponent);
            JComponent jComponent = this.myKeyComponent;
            if (jComponent == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(7);
            }
            return jComponent;
        }

        @NotNull
        public JComponent getAssociatedComponent() {
            if (this.myAssociatedComponent == null) {
                this.myAssociatedComponent = this.buildComponent();
            }
            this.associatedUpdateScaleHelper.saveScaleAndUpdateUIIfChanged(this.myAssociatedComponent);
            JComponent jComponent = this.myAssociatedComponent;
            if (jComponent == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(8);
            }
            return jComponent;
        }

        WelcomeScreenEventCollector.TabType getType() {
            return this.myType;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this.myLabel.getAccessibleContext();
        }

        protected abstract JComponent buildComponent();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabName";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/TabbedWelcomeScreen$DefaultWelcomeScreenTab";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/TabbedWelcomeScreen$DefaultWelcomeScreenTab";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyComponent";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAssociatedComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getKeyComponent";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8 -> new IllegalStateException(string);
            };
        }
    }
}

