/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.ide.HelpTooltip;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.ToolWindowsGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.AbstractSquareStripeButton;
import com.intellij.toolWindow.MoreSquareStripeButtonKt;
import com.intellij.ui.UIBundle;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u0014\u001a\u00020\nH\u0014J\b\u0010\u0015\u001a\u00020\nH\u0016R\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/intellij/toolWindow/AbstractMoreSquareStripeButton;", "Lcom/intellij/openapi/wm/impl/AbstractSquareStripeButton;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "minimumSize", "Ljava/util/function/Supplier;", "Ljava/awt/Dimension;", "<init>", "(Lcom/intellij/openapi/actionSystem/AnAction;Ljava/util/function/Supplier;)V", "update", "", "updateState", "project", "Lcom/intellij/openapi/project/Project;", "isAvailable", "", "side", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "getSide", "()Lcom/intellij/openapi/wm/ToolWindowAnchor;", "updateToolTipText", "updateUI", "intellij.platform.ide.impl"})
public abstract class AbstractMoreSquareStripeButton
extends AbstractSquareStripeButton {
    public AbstractMoreSquareStripeButton(@NotNull AnAction action2, @Nullable Supplier<Dimension> minimumSize) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        super(action2, MoreSquareStripeButtonKt.access$createPresentation(), minimumSize);
    }

    public /* synthetic */ AbstractMoreSquareStripeButton(AnAction anAction, Supplier supplier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            supplier = null;
        }
        this(anAction, supplier);
    }

    @Override
    public void update() {
        super.update();
        this.updateState((Project)this.getDataContext().getData(CommonDataKeys.PROJECT));
    }

    public final void updateState(@Nullable Project project2) {
        boolean available = project2 != null && this.isAvailable(project2);
        this.myPresentation.setEnabledAndVisible(available);
        this.setEnabled(available);
        this.setVisible(available);
    }

    protected boolean isAvailable(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        List<ActivateToolWindowAction> list2 = ToolWindowsGroup.getToolWindowActions(project2, true);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getToolWindowActions(...)");
        return !((Collection)list2).isEmpty();
    }

    @NotNull
    public abstract ToolWindowAnchor getSide();

    @Override
    protected void updateToolTipText() {
        ToolWindowAnchor toolWindowAnchor;
        new HelpTooltip().setTitle(UIBundle.message((String)"tool.window.new.stripe.more.title", (Object[])new Object[0])).setLocation(Intrinsics.areEqual((Object)(toolWindowAnchor = this.getSide()), (Object)ToolWindowAnchor.LEFT) ? HelpTooltip.Alignment.RIGHT : (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.TOP) ? HelpTooltip.Alignment.BOTTOM : HelpTooltip.Alignment.LEFT)).setInitialDelay(0).setHideDelay(0).installOn((JComponent)this);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.myPresentation.setIcon(MoreSquareStripeButtonKt.access$scaleIcon());
    }
}

