/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.Cell;
import com.intellij.ui.TableSpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.Convertor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.ListIterator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;

public class TableSpeedSearch
extends TableSpeedSearchBase<JTable> {
    private static final PairFunction<Object, Cell, String> TO_STRING = (o, cell) -> o == null || o instanceof Boolean ? "" : o.toString();
    private final PairFunction<Object, ? super Cell, String> myToStringConvertor;

    protected TableSpeedSearch(JTable table2, Void sig, Convertor<Object, String> toStringConvertor) {
        this(table2, sig, (PairFunction<Object, ? super Cell, String>)((PairFunction)(o, c) -> (String)toStringConvertor.convert(o)));
    }

    protected TableSpeedSearch(JTable table2, Void sig, PairFunction<Object, ? super Cell, String> toStringConvertor) {
        super(table2, sig);
        this.myToStringConvertor = toStringConvertor;
    }

    @NotNull
    public static TableSpeedSearch installOn(JTable table2) {
        return TableSpeedSearch.installOn(table2, TO_STRING);
    }

    @NotNull
    public static TableSpeedSearch installOn(JTable table2, Convertor<Object, String> toStringConvertor) {
        return TableSpeedSearch.installOn(table2, (PairFunction<Object, ? super Cell, String>)((PairFunction)(o, c) -> (String)toStringConvertor.convert(o)));
    }

    @NotNull
    public static TableSpeedSearch installOn(JTable table2, PairFunction<Object, ? super Cell, String> toStringConvertor) {
        TableSpeedSearch search = new TableSpeedSearch(table2, null, toStringConvertor);
        search.setupListeners();
        TableSpeedSearch tableSpeedSearch = search;
        if (tableSpeedSearch == null) {
            TableSpeedSearch.$$$reportNull$$$0(0);
        }
        return tableSpeedSearch;
    }

    @Deprecated
    public TableSpeedSearch(JTable table2) {
        this(table2, TO_STRING);
    }

    @Deprecated
    public TableSpeedSearch(JTable table2, Convertor<Object, String> toStringConvertor) {
        this(table2, (PairFunction<Object, ? super Cell, String>)((PairFunction)(o, c) -> (String)toStringConvertor.convert(o)));
    }

    @Deprecated
    public TableSpeedSearch(JTable table2, PairFunction<Object, ? super Cell, String> toStringConvertor) {
        super(table2);
        this.myToStringConvertor = toStringConvertor;
        table2.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        new MySelectAllAction(table2, this).registerCustomShortcutSet(table2, null);
    }

    @Override
    public void setFilteringMode(boolean filteringMode) {
        super.setFilteringMode(filteringMode);
    }

    @Override
    public void setupListeners() {
        super.setupListeners();
        ((JTable)this.myComponent).putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        new MySelectAllAction((JTable)this.myComponent, this).registerCustomShortcutSet(this.myComponent, null);
    }

    @Override
    protected boolean isSpeedSearchEnabled() {
        boolean tableIsNotEmpty = ((JTable)this.myComponent).getRowCount() != 0 && ((JTable)this.myComponent).getColumnCount() != 0;
        return tableIsNotEmpty && !((JTable)this.myComponent).isEditing() && super.isSpeedSearchEnabled();
    }

    @Override
    @NotNull
    protected ListIterator<Object> getElementIterator(int startingViewIndex) {
        final int count = this.getElementCount();
        ListIterator<Object> listIterator = new AbstractList<Object>(this){

            @Override
            public Object get(int index) {
                return index;
            }

            @Override
            public int size() {
                return count;
            }
        }.listIterator(startingViewIndex);
        if (listIterator == null) {
            TableSpeedSearch.$$$reportNull$$$0(1);
        }
        return listIterator;
    }

    @Override
    protected int getElementCount() {
        return ((JTable)this.myComponent).getRowCount() * ((JTable)this.myComponent).getColumnCount();
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        if (element instanceof Integer) {
            int index = (Integer)element;
            int row2 = index / ((JTable)this.myComponent).getColumnCount();
            int col = index % ((JTable)this.myComponent).getColumnCount();
            ((JTable)this.myComponent).getSelectionModel().setSelectionInterval(row2, row2);
            ((JTable)this.myComponent).getColumnModel().getSelectionModel().setSelectionInterval(col, col);
            TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
        } else {
            ((JTable)this.myComponent).getSelectionModel().clearSelection();
            ((JTable)this.myComponent).getColumnModel().getSelectionModel().clearSelection();
        }
    }

    @Override
    protected int getSelectedIndex() {
        int row2 = ((JTable)this.myComponent).getSelectedRow();
        int col = ((JTable)this.myComponent).getSelectedColumn();
        return row2 > -1 && col > -1 ? row2 * ((JTable)this.myComponent).getColumnCount() + col : -1;
    }

    @Override
    protected String getElementText(Object element) {
        int index = (Integer)element;
        int row2 = index / ((JTable)this.myComponent).getColumnCount();
        int col = index % ((JTable)this.myComponent).getColumnCount();
        Object value = ((JTable)this.myComponent).getValueAt(row2, col);
        return (String)this.myToStringConvertor.fun(value, (Object)new Cell(row2, col));
    }

    @NotNull
    private IntList findAllFilteredRows(String s) {
        IntArrayList rows = new IntArrayList();
        String _s = s.trim();
        block0: for (int row2 = 0; row2 < ((JTable)this.myComponent).getRowCount(); ++row2) {
            for (int col = 0; col < ((JTable)this.myComponent).getColumnCount(); ++col) {
                int index = row2 * ((JTable)this.myComponent).getColumnCount() + col;
                if (!this.isMatchingElement(index, _s)) continue;
                rows.add(row2);
                continue block0;
            }
        }
        IntArrayList intArrayList = rows;
        if (intArrayList == null) {
            TableSpeedSearch.$$$reportNull$$$0(2);
        }
        return intArrayList;
    }

    @Override
    protected boolean isMatchingRow(int modelRow, String pattern) {
        int columns = ((JTable)this.myComponent).getColumnCount();
        for (int col = 0; col < columns; ++col) {
            Object value = ((JTable)this.myComponent).getModel().getValueAt(modelRow, col);
            String str = (String)this.myToStringConvertor.fun(value, (Object)new Cell(modelRow, col));
            if (str == null || !this.compare(str, pattern)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ui/TableSpeedSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "installOn";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementIterator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllFilteredRows";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class MySelectAllAction
    extends DumbAwareAction {
        @NotNull
        private final JTable myTable;
        @NotNull
        private final TableSpeedSearch mySearch;

        MySelectAllAction(@NotNull JTable table2, @NotNull TableSpeedSearch search) {
            if (table2 == null) {
                MySelectAllAction.$$$reportNull$$$0(0);
            }
            if (search == null) {
                MySelectAllAction.$$$reportNull$$$0(1);
            }
            this.myTable = table2;
            this.mySearch = search;
            this.copyShortcutFrom(ActionManager.getInstance().getAction("$SelectAll"));
            this.setEnabledInModalContext(true);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectAllAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabled(this.mySearch.isPopupActive() && this.myTable.getRowSelectionAllowed() && this.myTable.getSelectionModel().getSelectionMode() == 2);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MySelectAllAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectAllAction.$$$reportNull$$$0(4);
            }
            ListSelectionModel sm = this.myTable.getSelectionModel();
            String query = this.mySearch.getEnteredPrefix();
            if (query == null) {
                return;
            }
            IntList filtered = this.mySearch.findAllFilteredRows(query);
            if (filtered.isEmpty()) {
                return;
            }
            boolean alreadySelected = Arrays.equals(filtered.toIntArray(), this.myTable.getSelectedRows());
            if (alreadySelected) {
                int anchor = sm.getAnchorSelectionIndex();
                sm.setSelectionInterval(anchor, anchor);
                sm.setAnchorSelectionIndex(anchor);
                this.mySearch.findAndSelectElement(query);
            } else {
                int anchor = -1;
                Object currentElement = this.mySearch.findElement(query);
                if (currentElement instanceof Integer) {
                    int index = (Integer)currentElement;
                    anchor = index / this.myTable.getColumnCount();
                }
                if (anchor == -1) {
                    anchor = filtered.getInt(0);
                }
                sm.clearSelection();
                for (int i2 = 0; i2 < filtered.size(); ++i2) {
                    int value = filtered.getInt(i2);
                    sm.addSelectionInterval(value, value);
                }
                sm.setAnchorSelectionIndex(anchor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "search";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/TableSpeedSearch$MySelectAllAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/TableSpeedSearch$MySelectAllAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

