/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.ui.colorpicker.ColorIndicatorKt;
import com.intellij.ui.colorpicker.ColorPickerModelKt;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ui/colorpicker/ColorIndicator;", "Ljavax/swing/JComponent;", "color", "Ljava/awt/Color;", "<init>", "(Ljava/awt/Color;)V", "value", "getColor", "()Ljava/awt/Color;", "setColor", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class ColorIndicator
extends JComponent {
    @NotNull
    private Color color;

    public ColorIndicator(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.color = color;
    }

    public /* synthetic */ ColorIndicator(Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            color = ColorPickerModelKt.getDEFAULT_PICKER_COLOR();
        }
        this(color);
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Color value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.color = value;
        this.repaint();
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Object originalAntialiasing = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color originalColor = ((Graphics2D)g).getColor();
        Stroke originalStroke = ((Graphics2D)g).getStroke();
        int left = this.getInsets().left;
        int top = this.getInsets().top;
        int circleWidth = this.getWidth() - this.getInsets().left - this.getInsets().right;
        int circleHeight = this.getHeight() - this.getInsets().top - this.getInsets().bottom;
        ((Graphics2D)g).setColor(this.color);
        g.fillOval(left, top, circleWidth, circleHeight);
        ((Graphics2D)g).setStroke(ColorIndicatorKt.access$getBORDER_STROKE$p());
        ((Graphics2D)g).setColor((Color)ColorIndicatorKt.access$getBORDER$p());
        g.drawOval(left, top, circleWidth, circleHeight);
        ((Graphics2D)g).setColor(originalColor);
        ((Graphics2D)g).setStroke(originalStroke);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, originalAntialiasing);
    }

    public ColorIndicator() {
        this(null, 1, null);
    }
}

