/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.ui.content.impl.ToolWindowContentPostProcessor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentManagerImpl
implements ContentManager,
PropertyChangeListener,
Disposable.Parent {
    private static final Logger LOG = Logger.getInstance(ContentManagerImpl.class);
    private ContentUI myUI;
    private final List<Content> contents;
    private final List<ContentManagerImpl> myNestedManagers;
    private final EventDispatcher<ContentManagerListener> myDispatcher;
    private final List<Content> mySelection;
    private final boolean myCanCloseContents;
    private JPanel myComponent;
    private final Set<Content> myContentWithChangedComponent;
    private boolean myDisposed;
    private final Project myProject;
    private final List<UiDataProvider> myDataProviders;
    private final ArrayList<Content> mySelectionHistory;

    public ContentManagerImpl(@NotNull ContentUI contentUI, boolean canCloseContents, @NotNull Project project2) {
        if (contentUI == null) {
            ContentManagerImpl.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(1);
        }
        this(contentUI, canCloseContents, project2, (Disposable)project2);
    }

    public ContentManagerImpl(@NotNull ContentUI contentUI, boolean canCloseContents, @NotNull Project project2, @NotNull Disposable parentDisposable) {
        if (contentUI == null) {
            ContentManagerImpl.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            ContentManagerImpl.$$$reportNull$$$0(4);
        }
        this(canCloseContents, project2, parentDisposable, (ContentManager contentManager, Supplier<JPanel> componentGetter) -> {
            ((ContentManagerImpl)contentManager).myUI = contentUI;
            contentUI.setManager(contentManager);
            return contentUI;
        });
    }

    @ApiStatus.Experimental
    public ContentManagerImpl(boolean canCloseContents, @NotNull Project project2, @NotNull Disposable parentDisposable, @NotNull ContentUiProducer contentUiProducer) {
        ContentUI ui;
        if (project2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            ContentManagerImpl.$$$reportNull$$$0(6);
        }
        if (contentUiProducer == null) {
            ContentManagerImpl.$$$reportNull$$$0(7);
        }
        this.contents = new ArrayList<Content>();
        this.myNestedManagers = new SmartList();
        this.myDispatcher = EventDispatcher.create(ContentManagerListener.class);
        this.mySelection = new ArrayList<Content>();
        this.myContentWithChangedComponent = new HashSet<Content>();
        this.myDataProviders = new SmartList();
        this.mySelectionHistory = new ArrayList();
        this.myProject = project2;
        this.myCanCloseContents = canCloseContents;
        this.myUI = ui = contentUiProducer.createContent(this, () -> {
            LOG.assertTrue(this.myComponent == null);
            this.myComponent = new MyNonOpaquePanel();
            return this.myComponent;
        });
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        if (ui instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)ui));
        }
    }

    public void addNestedManager(final @NotNull ContentManagerImpl manager2) {
        if (manager2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(8);
        }
        this.myNestedManagers.add(manager2);
        Disposer.register((Disposable)manager2, (Disposable)new Disposable(){

            public void dispose() {
                ContentManagerImpl.this.removeNestedManager(manager2);
            }
        });
    }

    public void removeNestedManager(@NotNull ContentManagerImpl manager2) {
        if (manager2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(9);
        }
        this.myNestedManagers.remove(manager2);
    }

    public boolean canCloseContents() {
        return this.myCanCloseContents;
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myComponent = new MyNonOpaquePanel();
            this.myComponent.add((Component)this.myUI.getComponent(), "Center");
        }
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            ContentManagerImpl.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        Content selected;
        if (requestor == null) {
            ContentManagerImpl.$$$reportNull$$$0(11);
        }
        if ((selected = this.getSelectedContent()) == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                ContentManagerImpl.$$$reportNull$$$0(12);
            }
            return actionCallback;
        }
        BusyObject busyObject2 = selected.getBusyObject();
        ActionCallback actionCallback = busyObject2 != null ? busyObject2.getReady(requestor) : ActionCallback.DONE;
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(13);
        }
        return actionCallback;
    }

    @Nullable
    public static ContentManager getContentManager(@Nullable Component component2) {
        ContentManager contentManager;
        if (component2 instanceof MyNonOpaquePanel) {
            MyNonOpaquePanel o = (MyNonOpaquePanel)((Object)component2);
            contentManager = o.getContentManager();
        } else {
            contentManager = null;
        }
        return contentManager;
    }

    public void addContent(@NotNull Content content2, int order) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(14);
        }
        this.doAddContent(content2, order);
    }

    public void addContent(@NotNull Content content2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(15);
        }
        this.doAddContent(content2, -1);
    }

    private void doAddContent(@NotNull Content content2, int index) {
        ToolWindowContentUi toolWindowContentUi;
        ToolWindowContentPostProcessor contentReplacer;
        Object object;
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.assertEventDispatchThread();
        String tabName = content2.getTabName();
        if (tabName != null && (object = this.myUI) instanceof ToolWindowContentUi && (contentReplacer = (ToolWindowContentPostProcessor)ToolWindowContentPostProcessor.EP_NAME.findFirstSafe(arg_0 -> this.lambda$doAddContent$2(content2, toolWindowContentUi = (ToolWindowContentUi)object, arg_0))) != null) {
            contentReplacer.postprocessContent(this.myProject, content2, toolWindowContentUi.getWindow());
        }
        if (this.contents.contains(content2)) {
            this.contents.remove(content2);
            this.contents.add(index < 0 ? this.contents.size() : index, content2);
            return;
        }
        if (!((Boolean)Content.TEMPORARY_REMOVED_KEY.get((UserDataHolder)content2, (Object)false)).booleanValue() && this.getContentCount() == 0 && !this.isEmpty()) {
            ContentManager oldManager = content2.getManager();
            for (ContentManagerImpl nestedManager : this.myNestedManagers) {
                if (nestedManager.isEmpty()) continue;
                nestedManager.doAddContent(content2, index);
                if (content2.getManager() == oldManager) continue;
                return;
            }
        }
        ((ContentImpl)content2).setManager(this);
        int insertIndex = index < 0 ? this.contents.size() : index;
        this.contents.add(insertIndex, content2);
        content2.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireContentAdded(content2, insertIndex);
        if (this.myUI.isToSelectAddedContent() || this.mySelection.isEmpty() && !this.myUI.canBeEmptySelection()) {
            if (this.myUI.isSingleSelection()) {
                this.setSelectedContent(content2);
            } else {
                this.addSelectedContent(content2);
            }
            if (this.myComponent != null && this.myComponent.isFocusOwner() && this.contents.size() == 1) {
                this.requestFocus(content2, true);
            }
        }
        Disposer.register((Disposable)this, (Disposable)content2);
    }

    public boolean removeContent(@NotNull Content content2, boolean dispose) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(17);
        }
        boolean wasFocused = UIUtil.isFocusAncestor((Component)content2.getComponent());
        return this.removeContent(content2, dispose, wasFocused, false).isDone();
    }

    @NotNull
    public ActionCallback removeContent(@NotNull Content content2, boolean dispose, boolean requestFocus, boolean forcedFocus) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(18);
        }
        ActionCallback result2 = new ActionCallback();
        this.doRemoveContent(content2, dispose).doWhenDone(() -> {
            if (requestFocus) {
                Content current = this.getSelectedContent();
                if (current == null) {
                    ToolWindowManager.getInstance((Project)this.myProject).activateEditorComponent();
                    result2.setDone();
                } else {
                    this.setSelectedContent(current, true, true, !forcedFocus).notify(result2);
                }
            } else {
                result2.setDone();
            }
        });
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(19);
        }
        return actionCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private ActionCallback doRemoveContent(@NotNull Content content2, boolean dispose) {
        block25: {
            block24: {
                int newSize;
                int indexToSelect;
                int indexToBeRemoved;
                block23: {
                    int selectedIndex;
                    block22: {
                        if (content2 == null) {
                            ContentManagerImpl.$$$reportNull$$$0(20);
                        }
                        ThreadingAssertions.assertEventDispatchThread();
                        indexToBeRemoved = this.getIndexOfContent(content2);
                        if (indexToBeRemoved == -1) {
                            ActionCallback actionCallback = ActionCallback.REJECTED;
                            if (actionCallback == null) {
                                ContentManagerImpl.$$$reportNull$$$0(21);
                            }
                            return actionCallback;
                        }
                        Content selection = this.mySelection.isEmpty() ? null : this.mySelection.get(this.mySelection.size() - 1);
                        int n = selectedIndex = selection != null ? this.contents.indexOf(selection) : -1;
                        if (!this.fireContentRemoveQuery(content2, indexToBeRemoved) || !content2.isValid()) {
                            ActionCallback actionCallback = ActionCallback.REJECTED;
                            ActionCallback actionCallback2 = actionCallback;
                            if (actionCallback2 == null) {
                                ContentManagerImpl.$$$reportNull$$$0(22);
                            }
                            return actionCallback2;
                        }
                        boolean wasSelected = this.isSelected(content2);
                        if (wasSelected) {
                            this.removeFromSelection(content2);
                        }
                        indexToSelect = -1;
                        if (!wasSelected) break block22;
                        int i2 = indexToBeRemoved - 1;
                        if (i2 >= 0) {
                            indexToSelect = i2;
                            break block23;
                        } else if (this.getContentCount() > 1) {
                            indexToSelect = 0;
                        }
                        break block23;
                    }
                    if (selectedIndex > indexToBeRemoved) {
                        indexToSelect = selectedIndex - 1;
                    }
                }
                this.mySelectionHistory.remove(content2);
                this.myContentWithChangedComponent.remove(content2);
                this.contents.remove(content2);
                content2.removePropertyChangeListener((PropertyChangeListener)this);
                this.fireContentRemoved(content2, indexToBeRemoved);
                ((ContentImpl)content2).setManager(null);
                if (dispose) {
                    Disposer.dispose((Disposable)content2);
                }
                if ((newSize = this.contents.size()) <= 0) break block24;
                if (indexToSelect > -1) {
                    Content toSelect;
                    Content content3 = toSelect = !this.mySelectionHistory.isEmpty() ? this.mySelectionHistory.get(0) : this.contents.get(indexToSelect);
                    if (!this.isSelected(toSelect)) {
                        if (this.myUI.isSingleSelection()) {
                            ActionCallback result2 = new ActionCallback();
                            this.setSelectedContentCB(toSelect).notify(result2);
                            ActionCallback actionCallback = result2;
                            ActionCallback actionCallback3 = actionCallback;
                            if (actionCallback3 == null) {
                                ContentManagerImpl.$$$reportNull$$$0(23);
                            }
                            return actionCallback3;
                        }
                        this.addSelectedContent(toSelect);
                    }
                }
                break block25;
            }
            this.mySelection.clear();
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        ActionCallback actionCallback4 = actionCallback;
        if (actionCallback4 == null) {
            ContentManagerImpl.$$$reportNull$$$0(24);
        }
        return actionCallback4;
        finally {
            if (ApplicationManager.getApplication().isDispatchThread() && !this.myDisposed && this.contents.isEmpty()) {
                this.myUI.getComponent().updateUI();
            }
        }
    }

    public void removeAllContents(boolean dispose) {
        if (this.contents.isEmpty()) {
            return;
        }
        for (Content content2 : List.copyOf(this.contents)) {
            this.removeContent(content2, dispose);
        }
    }

    public int getContentCount() {
        return this.contents.size();
    }

    public boolean isEmpty() {
        boolean empty = super.isEmpty();
        if (!empty) {
            return false;
        }
        for (ContentManager contentManager : this.myNestedManagers) {
            if (contentManager.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Content @NotNull [] getContents() {
        Content[] contentArray = this.contents.toArray(new Content[0]);
        if (contentArray == null) {
            ContentManagerImpl.$$$reportNull$$$0(25);
        }
        return contentArray;
    }

    public int getRecursiveContentCount() {
        int count = this.contents.size();
        for (ContentManagerImpl nestedManager : this.myNestedManagers) {
            count += nestedManager.getRecursiveContentCount();
        }
        return count;
    }

    @NotNull
    public @NotNull List<@NotNull Content> getContentsRecursively() {
        ArrayList<Content> list2 = new ArrayList<Content>();
        this.collectContentsRecursively(list2);
        ArrayList<Content> arrayList = list2;
        if (arrayList == null) {
            ContentManagerImpl.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    private void collectContentsRecursively(@NotNull @NotNull List<@NotNull Content> to) {
        if (to == null) {
            ContentManagerImpl.$$$reportNull$$$0(27);
        }
        to.addAll(this.contents);
        for (ContentManagerImpl nestedManager : this.myNestedManagers) {
            nestedManager.collectContentsRecursively(to);
        }
    }

    public Content findContent(String displayName) {
        for (Content content2 : this.contents) {
            if (!content2.getDisplayName().equals(displayName)) continue;
            return content2;
        }
        return null;
    }

    public Content getContent(int index) {
        return index >= 0 && index < this.contents.size() ? this.contents.get(index) : null;
    }

    public Content getContent(@NotNull JComponent component2) {
        Content[] contents;
        if (component2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(28);
        }
        for (Content content2 : contents = this.getContents()) {
            if (!SwingUtilities.isDescendingFrom(component2, content2.getComponent())) continue;
            return content2;
        }
        return null;
    }

    public int getIndexOfContent(@NotNull Content content2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(29);
        }
        return this.contents.indexOf(content2);
    }

    @NotNull
    public String getCloseActionName() {
        String string = this.myUI.getCloseActionName();
        if (string == null) {
            ContentManagerImpl.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string = this.myUI.getCloseAllButThisActionName();
        if (string == null) {
            ContentManagerImpl.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public String getPreviousContentActionName() {
        String string = this.myUI.getPreviousContentActionName();
        if (string == null) {
            ContentManagerImpl.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    public String getNextContentActionName() {
        String string = this.myUI.getNextContentActionName();
        if (string == null) {
            ContentManagerImpl.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public List<AnAction> getAdditionalPopupActions(@NotNull Content content2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(34);
        }
        List<AnAction> list2 = Collections.emptyList();
        if (list2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(35);
        }
        return list2;
    }

    public boolean canCloseAllContents() {
        if (!this.canCloseContents()) {
            return false;
        }
        for (Content content2 : this.contents) {
            if (!content2.isCloseable()) continue;
            return true;
        }
        return false;
    }

    public void addSelectedContent(@NotNull Content content2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(36);
        }
        if (!this.checkSelectionChangeShouldBeProcessed(content2, false)) {
            return;
        }
        if (this.getIndexOfContent(content2) == -1) {
            throw new IllegalArgumentException("content not found: " + String.valueOf(content2));
        }
        if (!this.isSelected(content2)) {
            this.mySelection.add(content2);
            this.fireSelectionChanged(content2, ContentManagerEvent.ContentOperation.add);
        }
    }

    private boolean checkSelectionChangeShouldBeProcessed(@NotNull Content content2, boolean implicit) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(37);
        }
        if (!this.myUI.canChangeSelectionTo(content2, implicit)) {
            return false;
        }
        boolean result2 = !this.isSelected(content2) || this.myContentWithChangedComponent.contains(content2);
        this.myContentWithChangedComponent.remove(content2);
        return result2;
    }

    public void removeFromSelection(@NotNull Content content2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(38);
        }
        if (!this.isSelected(content2)) {
            return;
        }
        this.mySelection.remove(content2);
        this.fireSelectionChanged(content2, ContentManagerEvent.ContentOperation.remove);
    }

    public boolean isSelected(@NotNull Content content2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(39);
        }
        return this.mySelection.contains(content2);
    }

    public Content @NotNull [] getSelectedContents() {
        Content[] contentArray = this.mySelection.toArray(new Content[0]);
        if (contentArray == null) {
            ContentManagerImpl.$$$reportNull$$$0(40);
        }
        return contentArray;
    }

    @Nullable
    public Content getSelectedContent() {
        return this.mySelection.isEmpty() ? null : this.mySelection.get(0);
    }

    public void setSelectedContent(@NotNull Content content2, boolean requestFocus) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(41);
        }
        this.setSelectedContentCB(content2, requestFocus);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content2, boolean requestFocus) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(42);
        }
        ActionCallback actionCallback = this.setSelectedContentCB(content2, requestFocus, true);
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(43);
        }
        return actionCallback;
    }

    public void setSelectedContent(@NotNull Content content2, boolean requestFocus, boolean forcedFocus) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(44);
        }
        this.setSelectedContentCB(content2, requestFocus, forcedFocus);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content2, boolean requestFocus, boolean forcedFocus) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(45);
        }
        ActionCallback actionCallback = this.setSelectedContent(content2, requestFocus, forcedFocus, false);
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(46);
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback setSelectedContent(@NotNull Content content2, boolean requestFocus, boolean forcedFocus, boolean implicit) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(47);
        }
        this.mySelectionHistory.remove(content2);
        this.mySelectionHistory.add(0, content2);
        if (this.isSelected(content2) && requestFocus) {
            this.requestFocusWithFallback(content2);
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                ContentManagerImpl.$$$reportNull$$$0(48);
            }
            return actionCallback;
        }
        if (!this.checkSelectionChangeShouldBeProcessed(content2, implicit)) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                ContentManagerImpl.$$$reportNull$$$0(49);
            }
            return actionCallback;
        }
        if (!this.contents.contains(content2)) {
            for (ContentManagerImpl manager2 : this.myNestedManagers) {
                ActionCallback nestedCallback = manager2.setSelectedContent(content2, requestFocus, forcedFocus, implicit);
                if (nestedCallback == ActionCallback.REJECTED) continue;
                ActionCallback actionCallback = nestedCallback;
                if (actionCallback == null) {
                    ContentManagerImpl.$$$reportNull$$$0(50);
                }
                return actionCallback;
            }
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                ContentManagerImpl.$$$reportNull$$$0(51);
            }
            return actionCallback;
        }
        boolean focused = this.isSelectionHoldsFocus();
        Content[] old = this.getSelectedContents();
        if (this.myDisposed || this.getIndexOfContent(content2) == -1) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                ContentManagerImpl.$$$reportNull$$$0(52);
            }
            return actionCallback;
        }
        for (Content each : old) {
            this.removeFromSelection(each);
        }
        this.addSelectedContent(content2);
        if (requestFocus || focused) {
            this.requestFocusWithFallback(content2);
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(53);
        }
        return actionCallback;
    }

    private boolean isSelectionHoldsFocus() {
        Content[] selection;
        boolean focused = false;
        for (Content each : selection = this.getSelectedContents()) {
            if (!ContentManagerImpl.isFocusAncestorStrict(each.getComponent())) continue;
            focused = true;
            break;
        }
        return focused;
    }

    private static boolean isFocusAncestorStrict(JComponent component2) {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            return false;
        }
        return SwingUtilities.isDescendingFrom(owner, component2);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(54);
        }
        ActionCallback actionCallback = this.setSelectedContentCB(content2, false);
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(55);
        }
        return actionCallback;
    }

    public void setSelectedContent(@NotNull Content content2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(56);
        }
        this.setSelectedContentCB(content2);
    }

    public ActionCallback selectPreviousContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = selectedContent == null ? -1 : this.getIndexOfContent(selectedContent);
        index = (index - 1 + contentCount) % contentCount;
        Content content2 = this.getContent(index);
        if (content2 == null) {
            return null;
        }
        return this.setSelectedContentCB(content2, true);
    }

    public ActionCallback selectNextContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = selectedContent == null ? -1 : this.getIndexOfContent(selectedContent);
        index = (index + 1) % contentCount;
        Content content2 = this.getContent(index);
        if (content2 == null) {
            return null;
        }
        return this.setSelectedContentCB(content2, true);
    }

    public void addContentManagerListener(@NotNull ContentManagerListener l) {
        if (l == null) {
            ContentManagerImpl.$$$reportNull$$$0(57);
        }
        if (Registry.is((String)"ide.content.manager.listeners.order.fix")) {
            this.myDispatcher.getListeners().add(l);
            return;
        }
        this.myDispatcher.getListeners().add(0, l);
    }

    public void removeContentManagerListener(@NotNull ContentManagerListener l) {
        if (l == null) {
            ContentManagerImpl.$$$reportNull$$$0(58);
        }
        this.myDispatcher.removeListener((EventListener)l);
    }

    private void fireContentAdded(@NotNull Content content2, int newIndex) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(59);
        }
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content2, newIndex, ContentManagerEvent.ContentOperation.add);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentAdded(e);
    }

    private void fireContentRemoved(@NotNull Content content2, int oldIndex) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(60);
        }
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content2, oldIndex, ContentManagerEvent.ContentOperation.remove);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentRemoved(e);
    }

    private void fireSelectionChanged(@NotNull Content content2, ContentManagerEvent.ContentOperation operation2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(61);
        }
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content2, this.getIndexOfContent(content2), operation2);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).selectionChanged(e);
    }

    private boolean fireContentRemoveQuery(@NotNull Content content2, int oldIndex) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(62);
        }
        ContentManagerEvent event = new ContentManagerEvent((Object)this, content2, oldIndex, ContentManagerEvent.ContentOperation.undefined);
        for (ContentManagerListener listener2 : this.myDispatcher.getListeners()) {
            listener2.contentRemoveQuery(event);
            if (!event.isConsumed()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ActionCallback requestFocus(Content content2, boolean forced) {
        Content toSelect;
        Content content3 = toSelect = content2 == null ? this.getSelectedContent() : content2;
        if (toSelect == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                ContentManagerImpl.$$$reportNull$$$0(63);
            }
            return actionCallback;
        }
        assert (this.contents.contains(toSelect));
        JComponent preferredFocusableComponent = toSelect.getPreferredFocusableComponent();
        ActionCallback actionCallback = preferredFocusableComponent != null ? this.getFocusManager().requestFocusInProject((Component)preferredFocusableComponent, this.myProject) : ActionCallback.REJECTED;
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(64);
        }
        return actionCallback;
    }

    private void requestFocusWithFallback(Content content2) {
        this.requestFocus(content2, true).doWhenRejected(() -> this.getFocusManager().requestFocusInProject((Component)this.getComponent(), this.myProject));
    }

    private IdeFocusManager getFocusManager() {
        return IdeFocusManager.getInstance((Project)this.myProject);
    }

    public void addDataProvider(@NotNull DataProvider provider) {
        if (provider == null) {
            ContentManagerImpl.$$$reportNull$$$0(65);
        }
        this.addUiDataProvider(Utils.wrapToUiDataProvider(provider));
    }

    public void addUiDataProvider(@NotNull UiDataProvider provider) {
        if (provider == null) {
            ContentManagerImpl.$$$reportNull$$$0(66);
        }
        this.myDataProviders.add(provider);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        if (event == null) {
            ContentManagerImpl.$$$reportNull$$$0(67);
        }
        if ("component".equals(event.getPropertyName())) {
            this.myContentWithChangedComponent.add((Content)event.getSource());
        }
    }

    @NotNull
    public ContentFactory getFactory() {
        ContentFactory contentFactory = ContentFactory.getInstance();
        if (contentFactory == null) {
            ContentManagerImpl.$$$reportNull$$$0(68);
        }
        return contentFactory;
    }

    public void beforeTreeDispose() {
        if (!this.myDisposed) {
            this.myUI.beforeDispose();
        }
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.contents.clear();
        this.myNestedManagers.clear();
        this.mySelection.clear();
        this.myContentWithChangedComponent.clear();
        this.myUI = null;
        this.myDispatcher.getListeners().clear();
        this.myDataProviders.clear();
        this.myComponent = null;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public boolean isSingleSelection() {
        return this.myUI.isSingleSelection();
    }

    @Nullable
    public ContentUI getUI() {
        return this.myUI;
    }

    private /* synthetic */ boolean lambda$doAddContent$2(Content content2, ToolWindowContentUi toolWindowContentUi, ToolWindowContentPostProcessor ep) {
        return ep.isEnabled(this.myProject, content2, toolWindowContentUi.getWindow());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12, 13, 19, 21, 22, 23, 24, 25, 26, 30, 31, 32, 33, 35, 40, 43, 46, 48, 49, 50, 51, 52, 53, 55, 63, 64, 68 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentUI";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentUiProducer";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 40: 
            case 43: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 63: 
            case 64: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/content/impl/ContentManagerImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 29: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 54: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/content/impl/ContentManagerImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "removeContent";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doRemoveContent";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentsRecursively";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseActionName";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseAllButThisActionName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousContentActionName";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextContentActionName";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPopupActions";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedContents";
                break;
            }
            case 43: 
            case 46: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "setSelectedContentCB";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "setSelectedContent";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "requestFocus";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addNestedManager";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeNestedManager";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 40: 
            case 43: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 63: 
            case 64: 
            case 68: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addContent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doAddContent";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeContent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveContent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectContentsRecursively";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getIndexOfContent";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalPopupActions";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addSelectedContent";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "checkSelectionChangeShouldBeProcessed";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "removeFromSelection";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 41: 
            case 44: 
            case 47: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedContent";
                break;
            }
            case 42: 
            case 45: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedContentCB";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "addContentManagerListener";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "removeContentManagerListener";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "fireContentAdded";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "fireContentRemoved";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "fireSelectionChanged";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "fireContentRemoveQuery";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "addDataProvider";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "addUiDataProvider";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "propertyChange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 12, 13, 19, 21, 22, 23, 24, 25, 26, 30, 31, 32, 33, 35, 40, 43, 46, 48, 49, 50, 51, 52, 53, 55, 63, 64, 68 -> new IllegalStateException(string);
        };
    }

    public static interface ContentUiProducer {
        public ContentUI createContent(@NotNull ContentManager var1, @NotNull @NotNull Supplier<@NotNull JPanel> var2);
    }

    private final class MyNonOpaquePanel
    extends JBPanelWithEmptyText
    implements UiDataProvider {
        MyNonOpaquePanel() {
            super((LayoutManager)new BorderLayout());
            this.setOpaque(false);
        }

        @NotNull
        ContentManager getContentManager() {
            ContentManagerImpl contentManagerImpl = ContentManagerImpl.this;
            if (contentManagerImpl == null) {
                MyNonOpaquePanel.$$$reportNull$$$0(0);
            }
            return contentManagerImpl;
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                MyNonOpaquePanel.$$$reportNull$$$0(1);
            }
            for (Object dataProvider : ContainerUtil.concat(ContentManagerImpl.this.myDataProviders, Arrays.asList(ContentManagerImpl.this.myUI, DataManager.getDataProvider((JComponent)((Object)this))))) {
                DataSink.uiDataSnapshot((DataSink)sink, dataProvider);
            }
            sink.set(PlatformDataKeys.CONTENT_MANAGER, (Object)ContentManagerImpl.this);
            if (ContentManagerImpl.this.getContentCount() > 1) {
                sink.set(PlatformDataKeys.NONEMPTY_CONTENT_MANAGER, (Object)ContentManagerImpl.this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/content/impl/ContentManagerImpl$MyNonOpaquePanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/content/impl/ContentManagerImpl$MyNonOpaquePanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

