/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.screenmenu;

import com.intellij.ui.mac.screenmenu.Menu;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MenuBar
extends Menu {
    private static long[] ourLastMenuBarPeers;
    @Nullable
    private Window myFrame;
    private final WindowListener myListener;

    public MenuBar(@Nullable String title2, @NotNull JFrame frame) {
        if (frame == null) {
            MenuBar.$$$reportNull$$$0(0);
        }
        super(title2);
        this.myListener = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                MenuBar.this.refillIfNeeded();
            }
        };
        this.setFrame(frame);
    }

    public synchronized void setFrame(@Nullable Window frame) {
        Objects.requireNonNull(this.myListener);
        if (this.myFrame != null) {
            this.myFrame.removeWindowListener(this.myListener);
        }
        this.myFrame = frame;
        if (this.myFrame != null) {
            this.myFrame.addWindowListener(this.myListener);
        }
    }

    private synchronized void refillIfNeeded() {
        if (Arrays.equals(this.myCachedPeers, ourLastMenuBarPeers)) {
            return;
        }
        this.refillImpl(true);
    }

    @Override
    synchronized void refillImpl(boolean onAppKit) {
        if (this.myCachedPeers != null && this.myFrame != null && this.myFrame.isActive()) {
            ourLastMenuBarPeers = this.myCachedPeers;
            this.nativeRefill(0L, this.myCachedPeers, onAppKit);
        }
    }

    @Override
    public synchronized void dispose() {
        this.setFrame(null);
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/ui/mac/screenmenu/MenuBar", "<init>"));
    }
}

