/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptorWithPath;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.FontUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.StatusText;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ColorOptionsTree
extends Tree {
    private final String myCategoryName;
    private final DefaultTreeModel myTreeModel;
    private static final Comparator<EditorSchemeAttributeDescriptor> ATTR_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.toString(), (String)o2.toString());

    public ColorOptionsTree(@NotNull String categoryName) {
        if (categoryName == null) {
            ColorOptionsTree.$$$reportNull$$$0(0);
        }
        super(ColorOptionsTree.createTreeModel());
        this.myTreeModel = (DefaultTreeModel)this.getModel();
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
        this.myCategoryName = categoryName;
        TreeSpeedSearch.installOn((JTree)((Object)this), true, TreeSpeedSearch.NODE_PRESENTATION_FUNCTION);
    }

    public void fillOptions(@NotNull ColorAndFontOptions options2) {
        if (options2 == null) {
            ColorOptionsTree.$$$reportNull$$$0(1);
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (EditorSchemeAttributeDescriptor description : this.getOrderedDescriptors(options2)) {
            if (!description.getGroup().equals(this.myCategoryName)) continue;
            List<String> path = ColorOptionsTree.extractPath(description);
            if (path != null && path.size() > 1) {
                MyTreeNode groupNode = ColorOptionsTree.ensureGroup(root, path, 0);
                groupNode.add(new MyTreeNode(description, path.get(path.size() - 1)));
                continue;
            }
            root.add(new MyTreeNode(description));
        }
        this.myTreeModel.setRoot(root);
    }

    public void setEmptyText(@NlsContexts.StatusText @NotNull String text2, @Nullable ActionListener linkListener2) {
        if (text2 == null) {
            ColorOptionsTree.$$$reportNull$$$0(2);
        }
        StatusText statusText = this.getEmptyText();
        if (linkListener2 != null) {
            statusText.clear();
            statusText.appendText(text2 + " ");
            statusText.appendText(IdeBundle.message((String)"link.more", (Object[])new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, linkListener2);
        } else {
            statusText.setText(text2);
        }
    }

    private static TreeModel createTreeModel() {
        return new DefaultTreeModel((TreeNode)new DefaultMutableTreeTableNode());
    }

    private Collection<EditorSchemeAttributeDescriptor> getOrderedDescriptors(@NotNull ColorAndFontOptions options2) {
        if (options2 == null) {
            ColorOptionsTree.$$$reportNull$$$0(3);
        }
        ArrayList<EditorSchemeAttributeDescriptor> list2 = new ArrayList<EditorSchemeAttributeDescriptor>();
        for (EditorSchemeAttributeDescriptor description : options2.getCurrentDescriptions()) {
            if (!description.getGroup().equals(this.myCategoryName)) continue;
            list2.add(description);
        }
        list2.sort(ATTR_COMPARATOR);
        return list2;
    }

    @Nullable
    public EditorSchemeAttributeDescriptor getSelectedDescriptor() {
        Object selectedValue = this.getSelectedValue();
        return selectedValue instanceof EditorSchemeAttributeDescriptor ? (EditorSchemeAttributeDescriptor)selectedValue : null;
    }

    @Nullable
    public Object getSelectedValue() {
        Object selectedNode = this.getLastSelectedPathComponent();
        if (selectedNode instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)selectedNode).getUserObject();
        }
        return null;
    }

    public void selectOptionByType(final @NotNull String attributeType) {
        if (attributeType == null) {
            ColorOptionsTree.$$$reportNull$$$0(4);
        }
        if (Objects.equals(ObjectUtils.doIfNotNull((Object)this.getSelectedDescriptor(), d -> d.getType()), attributeType)) {
            return;
        }
        this.selectPath(this.findOption(this.myTreeModel.getRoot(), new DescriptorMatcher(){

            @Override
            public boolean matches(@NotNull Object data2) {
                if (data2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (data2 instanceof EditorSchemeAttributeDescriptor) {
                    return attributeType.equals(((EditorSchemeAttributeDescriptor)data2).getType());
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/application/options/colors/ColorOptionsTree$1", "matches"));
            }
        }));
    }

    public void selectOptionByName(@NotNull String name2) {
        if (name2 == null) {
            ColorOptionsTree.$$$reportNull$$$0(5);
        }
        final String optionName = name2.replace(FontUtil.rightArrow((Font)StartupUiUtil.getLabelFont()), EditorSchemeAttributeDescriptorWithPath.getNameSeparator());
        this.selectPath(this.findOption(this.myTreeModel.getRoot(), new DescriptorMatcher(){

            @Override
            public boolean matches(@NotNull Object data2) {
                if (data2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return !optionName.isEmpty() && StringUtil.containsIgnoreCase((String)data2.toString(), (String)optionName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/application/options/colors/ColorOptionsTree$2", "matches"));
            }
        }));
    }

    @Nullable
    private TreePath findOption(@NotNull Object nodeObject, @NotNull DescriptorMatcher matcher) {
        if (nodeObject == null) {
            ColorOptionsTree.$$$reportNull$$$0(6);
        }
        if (matcher == null) {
            ColorOptionsTree.$$$reportNull$$$0(7);
        }
        for (int i2 = 0; i2 < this.myTreeModel.getChildCount(nodeObject); ++i2) {
            Object data2;
            Object childObject = this.myTreeModel.getChild(nodeObject, i2);
            if (childObject instanceof MyTreeNode && matcher.matches(data2 = ((MyTreeNode)childObject).getUserObject())) {
                return new TreePath(this.myTreeModel.getPathToRoot((MyTreeNode)childObject));
            }
            TreePath pathInChild = this.findOption(childObject, matcher);
            if (pathInChild == null) continue;
            return pathInChild;
        }
        return null;
    }

    private void selectPath(@Nullable TreePath path) {
        if (path != null) {
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }

    @Nullable
    private static List<String> extractPath(@NotNull EditorSchemeAttributeDescriptor descriptor) {
        if (descriptor == null) {
            ColorOptionsTree.$$$reportNull$$$0(8);
        }
        if (descriptor instanceof EditorSchemeAttributeDescriptorWithPath) {
            String name2 = descriptor.toString();
            ArrayList<String> path = new ArrayList<String>();
            int separatorStart = name2.indexOf(EditorSchemeAttributeDescriptorWithPath.getNameSeparator());
            int nextChunkStart = 0;
            while (separatorStart > 0) {
                path.add(name2.substring(nextChunkStart, separatorStart));
                nextChunkStart = separatorStart + EditorSchemeAttributeDescriptorWithPath.getNameSeparator().length();
                separatorStart = name2.indexOf(EditorSchemeAttributeDescriptorWithPath.getNameSeparator(), nextChunkStart);
            }
            if (nextChunkStart < name2.length()) {
                path.add(name2.substring(nextChunkStart));
            }
            return path;
        }
        return null;
    }

    private static MyTreeNode ensureGroup(@NotNull DefaultMutableTreeNode root, @NotNull List<String> path, int index) {
        if (root == null) {
            ColorOptionsTree.$$$reportNull$$$0(9);
        }
        if (path == null) {
            ColorOptionsTree.$$$reportNull$$$0(10);
        }
        String groupName = path.get(index++);
        for (int i2 = 0; i2 < root.getChildCount(); ++i2) {
            TreeNode child = root.getChildAt(i2);
            if (!(child instanceof MyTreeNode) || !groupName.equals(child.toString())) continue;
            return index < path.size() - 1 ? ColorOptionsTree.ensureGroup((MyTreeNode)child, path, index) : (MyTreeNode)child;
        }
        MyTreeNode groupNode = new MyTreeNode(groupName);
        root.add(groupNode);
        return index < path.size() - 1 ? ColorOptionsTree.ensureGroup(groupNode, path, index) : groupNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/colors/ColorOptionsTree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fillOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setEmptyText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrderedDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "selectOptionByType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "selectOptionByName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findOption";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "extractPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureGroup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyTreeNode
    extends DefaultMutableTreeNode {
        private final String myName;

        MyTreeNode(@NotNull EditorSchemeAttributeDescriptor descriptor, @NotNull String name2) {
            if (descriptor == null) {
                MyTreeNode.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                MyTreeNode.$$$reportNull$$$0(1);
            }
            super(descriptor);
            this.myName = name2;
        }

        MyTreeNode(@NotNull EditorSchemeAttributeDescriptor descriptor) {
            if (descriptor == null) {
                MyTreeNode.$$$reportNull$$$0(2);
            }
            super(descriptor);
            this.myName = descriptor.toString();
        }

        MyTreeNode(@NotNull String groupName) {
            if (groupName == null) {
                MyTreeNode.$$$reportNull$$$0(3);
            }
            super(groupName);
            this.myName = groupName;
        }

        @Override
        public String toString() {
            return this.myName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "groupName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/application/options/colors/ColorOptionsTree$MyTreeNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface DescriptorMatcher {
        public boolean matches(@NotNull Object var1);
    }
}

