/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.extensions.PluginDescriptor;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DefaultIdeaErrorLogger {
    @Nullable
    public static VMOptions.MemoryKind getOOMErrorKind(@NotNull Throwable t) {
        if (t == null) {
            DefaultIdeaErrorLogger.$$$reportNull$$$0(0);
        }
        String message = t.getMessage();
        if (t instanceof OutOfMemoryError) {
            if (message != null) {
                if (message.contains("unable to create") && message.contains("native thread")) {
                    return null;
                }
                if (message.contains("Metaspace")) {
                    return VMOptions.MemoryKind.METASPACE;
                }
                if (message.contains("direct buffer memory")) {
                    return VMOptions.MemoryKind.DIRECT_BUFFERS;
                }
            }
            return VMOptions.MemoryKind.HEAP;
        }
        if (t instanceof VirtualMachineError && message != null && message.contains("CodeCache")) {
            return VMOptions.MemoryKind.CODE_CACHE;
        }
        return null;
    }

    @Nullable
    public static ErrorReportSubmitter findSubmitter(@NotNull Throwable t, @Nullable IdeaPluginDescriptor plugin) {
        PluginDescriptor descriptor;
        List reporters;
        if (t == null) {
            DefaultIdeaErrorLogger.$$$reportNull$$$0(1);
        }
        if (t instanceof MessagePool.TooManyErrorsException || t instanceof AbstractMethodError && plugin == null) {
            return null;
        }
        try {
            reporters = ErrorReportSubmitter.EP_NAME.getExtensionList();
        }
        catch (Throwable ignored) {
            return null;
        }
        if (plugin != null) {
            for (ErrorReportSubmitter reporter : reporters) {
                descriptor = reporter.getPluginDescriptor();
                if (descriptor == null || !plugin.getPluginId().equals((Object)descriptor.getPluginId())) continue;
                return reporter;
            }
        }
        if (plugin == null || PluginManagerCore.isDevelopedByJetBrains((PluginDescriptor)plugin)) {
            for (ErrorReportSubmitter reporter : reporters) {
                descriptor = reporter.getPluginDescriptor();
                if (descriptor != null && !PluginManagerCore.CORE_ID.equals((Object)descriptor.getPluginId())) continue;
                return reporter;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "t";
        objectArray2[1] = "com/intellij/diagnostic/DefaultIdeaErrorLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOOMErrorKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findSubmitter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

