/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.EventWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.util.ui.EDT;
import java.awt.AWTEvent;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.SingleWriterRecorder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
@ApiStatus.Internal
public abstract class PreciseEventWatcher
implements EventWatcher,
Disposable {
    private final SingleWriterRecorder waitingTimesHistogram = new SingleWriterRecorder(2);
    private final SingleWriterRecorder queueSizesHistogram = new SingleWriterRecorder(2);
    private final SingleWriterRecorder executionTimeHistogram = new SingleWriterRecorder(2);
    private final SingleWriterRecorder awtEventDispatchTimeHistogram = new SingleWriterRecorder(2);
    private Histogram intervalWaitingTimes = null;
    private Histogram intervalQueueSizes = null;
    private Histogram intervalExecutionTimes = null;
    private Histogram intervalAWTDispatchTimes = null;
    protected long awtEventExecutionStartedNs = -1L;

    protected Histogram getWaitingTimeHistogram() {
        this.intervalWaitingTimes = this.waitingTimesHistogram.getIntervalHistogram(this.intervalWaitingTimes);
        return this.intervalWaitingTimes;
    }

    protected Histogram getQueueSizeHistogram() {
        this.intervalQueueSizes = this.queueSizesHistogram.getIntervalHistogram(this.intervalQueueSizes);
        return this.intervalQueueSizes;
    }

    protected Histogram getExecutionTimeHistogram() {
        this.intervalExecutionTimes = this.executionTimeHistogram.getIntervalHistogram(this.intervalExecutionTimes);
        return this.intervalExecutionTimes;
    }

    protected Histogram getAWTEventDispatchTimeHistogram() {
        this.intervalAWTDispatchTimes = this.awtEventDispatchTimeHistogram.getIntervalHistogram(this.intervalAWTDispatchTimes);
        return this.intervalAWTDispatchTimes;
    }

    /*
     * WARNING - void declaration
     */
    public void runnableTaskFinished(@NotNull Runnable runnable2, long waitedInQueueNs, int queueSize, long executionDurationNs, boolean bl) {
        void wasInSkippedItems;
        if (runnable2 == null) {
            PreciseEventWatcher.$$$reportNull$$$0(0);
        }
        if (wasInSkippedItems == false) {
            this.waitingTimesHistogram.recordValue(waitedInQueueNs);
            this.queueSizesHistogram.recordValue((long)queueSize);
            this.executionTimeHistogram.recordValue(executionDurationNs);
        }
    }

    public void edtEventStarted(@NotNull AWTEvent event, long startedAtMs) {
        if (event == null) {
            PreciseEventWatcher.$$$reportNull$$$0(1);
        }
        EDT.assertIsEdt();
        this.awtEventExecutionStartedNs = System.nanoTime();
    }

    public void edtEventFinished(@NotNull AWTEvent event, long finishedAtMs) {
        if (event == null) {
            PreciseEventWatcher.$$$reportNull$$$0(2);
        }
        if (this.awtEventExecutionStartedNs <= 0L) {
            return;
        }
        long awtEventExecutionDurationNs = System.nanoTime() - this.awtEventExecutionStartedNs;
        if (awtEventExecutionDurationNs > TimeUnit.HOURS.toNanos(1L) || awtEventExecutionDurationNs < 0L) {
            return;
        }
        this.awtEventDispatchTimeHistogram.recordValue(awtEventExecutionDurationNs);
        this.edtEventFinishedExt(event, awtEventExecutionDurationNs);
    }

    protected void edtEventFinishedExt(@NotNull AWTEvent event, long executionDurationNs) {
        if (event == null) {
            PreciseEventWatcher.$$$reportNull$$$0(3);
        }
    }

    public void reset() {
        this.awtEventExecutionStartedNs = -1L;
    }

    public void logTimeMillis(@NotNull String processId, long startedAtMs, @NotNull Class<? extends Runnable> clazz) {
        if (processId == null) {
            PreciseEventWatcher.$$$reportNull$$$0(4);
        }
        if (clazz == null) {
            PreciseEventWatcher.$$$reportNull$$$0(5);
        }
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnableClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/PreciseEventWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runnableTaskFinished";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "edtEventStarted";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "edtEventFinished";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "edtEventFinishedExt";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "logTimeMillis";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

