/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class WindowsDefenderStatisticsCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("defender", 4);
    private static final EventId1<Status> PROTECTION_CHECK_EVENT = GROUP.registerEvent("protection", (EventField)EventFields.Enum((String)"status", Status.class));
    private static final EventId1<Reaction> NOTIFICATION_EVENT = GROUP.registerEvent("notification", (EventField)EventFields.Enum((String)"reaction", Reaction.class));
    private static final EventId1<Boolean> AUTO_CONFIG_EVENT = GROUP.registerEvent("auto_config", (EventField)EventFields.Boolean((String)"success"));
    private static final EventId1<ExcludedScope> TRUST_DIALOG_EVENT = GROUP.registerEvent("excluded_from_trust_dialog", (EventField)EventFields.Enum((String)"excluded_folders", ExcludedScope.class));
    private static final EventId CHECKBOX_SHOWN_IN_TRUST_DIALOG = GROUP.registerEvent("checkbox_shown_in_trust_dialog");

    static void protectionCheckSkipped(@NotNull Project project2) {
        if (project2 == null) {
            WindowsDefenderStatisticsCollector.$$$reportNull$$$0(0);
        }
        PROTECTION_CHECK_EVENT.log(project2, (Object)Status.Skipped);
    }

    static void protectionCheckStatus(@NotNull Project project2, @Nullable Boolean status2) {
        if (project2 == null) {
            WindowsDefenderStatisticsCollector.$$$reportNull$$$0(1);
        }
        PROTECTION_CHECK_EVENT.log(project2, (Object)(status2 == Boolean.TRUE ? Status.Enabled : (status2 == Boolean.FALSE ? Status.Disabled : Status.Error)));
    }

    static void auto(@NotNull Project project2) {
        if (project2 == null) {
            WindowsDefenderStatisticsCollector.$$$reportNull$$$0(2);
        }
        NOTIFICATION_EVENT.log(project2, (Object)Reaction.Auto);
    }

    static void manual(@NotNull Project project2) {
        if (project2 == null) {
            WindowsDefenderStatisticsCollector.$$$reportNull$$$0(3);
        }
        NOTIFICATION_EVENT.log(project2, (Object)Reaction.Manual);
    }

    static void suppressed(@NotNull Project project2, boolean globally) {
        if (project2 == null) {
            WindowsDefenderStatisticsCollector.$$$reportNull$$$0(4);
        }
        NOTIFICATION_EVENT.log(project2, (Object)(globally ? Reaction.GlobalMute : Reaction.ProjectMute));
    }

    static void configured(@Nullable Project project2, boolean success2) {
        AUTO_CONFIG_EVENT.log(project2, (Object)success2);
    }

    public static void excludedFromTrustDialog(boolean parentExcluded) {
        TRUST_DIALOG_EVENT.log((Object)(parentExcluded ? ExcludedScope.PARENT_FOLDER : ExcludedScope.PROJECT_ONLY));
    }

    public static void checkboxShownInTrustDialog() {
        CHECKBOX_SHOWN_IN_TRUST_DIALOG.log();
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/diagnostic/WindowsDefenderStatisticsCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "protectionCheckSkipped";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "protectionCheckStatus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "auto";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "manual";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "suppressed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum Status {
        Skipped,
        Enabled,
        Disabled,
        Error;

    }

    private static enum Reaction {
        Auto,
        Manual,
        ProjectMute,
        GlobalMute;

    }

    private static enum ExcludedScope {
        PROJECT_ONLY,
        PARENT_FOLDER;

    }
}

