/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeEventQueueKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.ui.popup.IdePopupEventDispatcher;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class IdePopupManager
implements IdeEventQueue.EventDispatcher {
    private static final Logger LOG = Logger.getInstance(IdePopupManager.class);
    private final List<IdePopupEventDispatcher> myDispatchStack = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myIgnoreNextKeyTypedEvent;

    boolean isPopupActive() {
        for (IdePopupEventDispatcher each : this.myDispatchStack) {
            if (each.getComponent() != null && UIUtil.isShowing((Component)each.getComponent())) continue;
            this.myDispatchStack.remove(each);
        }
        return !this.myDispatchStack.isEmpty();
    }

    @Override
    public boolean dispatch(@NotNull AWTEvent e) {
        if (e == null) {
            IdePopupManager.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(this.isPopupActive());
        if (e.getID() == 208 || e.getID() == 206) {
            if (IdeEventQueueKt.getSkipWindowDeactivationEvents()) {
                LOG.warn("Skipped " + String.valueOf(e));
                return false;
            }
            if (!this.isPopupActive()) {
                return false;
            }
            Window sourceWindow = ((WindowEvent)e).getWindow();
            if (SystemInfo.isLinux && !sourceWindow.isShowing()) {
                return false;
            }
            Window focusedWindow = ((WindowEvent)e).getOppositeWindow();
            this.maybeCloseAllPopups(focusedWindow, sourceWindow);
            return false;
        }
        if (e instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)e;
            Object source = keyEvent.getSource();
            if (this.myIgnoreNextKeyTypedEvent) {
                if (400 == e.getID()) {
                    return true;
                }
                this.myIgnoreNextKeyTypedEvent = false;
            } else if (SystemInfo.isMac && 512 == keyEvent.getModifiersEx() && Registry.is((String)"ide.mac.alt.mnemonic.without.ctrl") && source instanceof Component && (400 == e.getID() && !IdeEventQueue.getInstance().isInputMethodEnabled() || IdeKeyEventDispatcher.hasMnemonicInWindow((Component)source, keyEvent))) {
                this.myIgnoreNextKeyTypedEvent = true;
                return false;
            }
        }
        if (e instanceof KeyEvent || e instanceof MouseEvent || e instanceof InputMethodEvent) {
            for (int i2 = this.myDispatchStack.size() - 1; i2 >= 0 && i2 < this.myDispatchStack.size(); --i2) {
                boolean dispatched = this.myDispatchStack.get(i2).dispatch(e);
                if (!dispatched) continue;
                return true;
            }
        }
        return false;
    }

    private void maybeCloseAllPopups(Window focused, Window sourceWindow) {
        IdeFrame ultimateParentWindowForEvent;
        JBCefBrowserBase browser;
        if (focused == null && (focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) == null && (browser = JBCefBrowserBase.getFocusedBrowser()) != null && browser.getComponent() != null) {
            focused = SwingUtilities.getWindowAncestor(browser.getComponent());
        }
        Component ultimateParentForFocusedComponent = UIUtil.findUltimateParent((Component)focused);
        Component ultimateParentForEventWindow = UIUtil.findUltimateParent((Component)sourceWindow);
        boolean shouldCloseAllPopup = false;
        if (ultimateParentForEventWindow == null || ultimateParentForFocusedComponent == null) {
            shouldCloseAllPopup = true;
        }
        if (!shouldCloseAllPopup && ultimateParentForEventWindow instanceof IdeFrame && (ultimateParentWindowForEvent = (IdeFrame)ultimateParentForEventWindow).isInFullScreen() && !ultimateParentForFocusedComponent.equals(ultimateParentForEventWindow)) {
            shouldCloseAllPopup = true;
        }
        if (shouldCloseAllPopup) {
            this.closeAllPopups();
        }
    }

    public void push(IdePopupEventDispatcher dispatcher) {
        this.myDispatchStack.remove(dispatcher);
        this.myDispatchStack.add(dispatcher);
    }

    public void remove(IdePopupEventDispatcher dispatcher) {
        this.myDispatchStack.remove(dispatcher);
    }

    public boolean closeAllPopups(boolean forceRestoreFocus) {
        if (this.myDispatchStack.isEmpty()) {
            return false;
        }
        boolean closed = true;
        for (IdePopupEventDispatcher each : this.myDispatchStack) {
            if (forceRestoreFocus) {
                each.setRestoreFocusSilently();
            }
            closed &= each.close();
        }
        return closed;
    }

    public boolean closeAllPopups() {
        return this.closeAllPopups(true);
    }

    public boolean requestDefaultFocus(boolean forced) {
        if (!this.isPopupActive()) {
            return false;
        }
        return this.myDispatchStack.get(this.myDispatchStack.size() - 1).requestFocus();
    }

    public boolean isPopupWindow(Window w) {
        return this.myDispatchStack.stream().flatMap(IdePopupEventDispatcher::getPopupStream).filter(popup2 -> !popup2.isDisposed()).map(JBPopup::getContent).anyMatch(jbPopupContent -> SwingUtilities.getWindowAncestor(jbPopupContent) == w);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/IdePopupManager", "dispatch"));
    }
}

