/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.LayoutNameInputDialogKt;
import com.intellij.ide.actions.ValidationMoment;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.toolWindow.ToolWindowDefaultLayoutManager;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0016\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0016R-\u0010\u0004\u001a\u0015\u0012\u000b\u0012\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/actions/LayoutNameValidator;", "Lcom/intellij/openapi/ui/InputValidator;", "<init>", "()V", "setErrorText", "Lkotlin/Function1;", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "", "getSetErrorText", "()Lkotlin/jvm/functions/Function1;", "setSetErrorText", "(Lkotlin/jvm/functions/Function1;)V", "validationMoment", "Lcom/intellij/ide/actions/ValidationMoment;", "getValidationMoment", "()Lcom/intellij/ide/actions/ValidationMoment;", "setValidationMoment", "(Lcom/intellij/ide/actions/ValidationMoment;)V", "checkInput", "", "inputString", "canClose", "intellij.platform.ide.impl"})
final class LayoutNameValidator
implements InputValidator {
    public Function1<? super String, Unit> setErrorText;
    @NotNull
    private ValidationMoment validationMoment = ValidationMoment.WHEN_DIALOG_SHOWN;

    public LayoutNameValidator() {
        LayoutNameInputDialogKt.access$setValidatorBeingInitialized$p(this);
    }

    @NotNull
    public final Function1<String, Unit> getSetErrorText() {
        Function1<? super String, Unit> function1 = this.setErrorText;
        if (function1 != null) {
            return function1;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"setErrorText");
        return null;
    }

    public final void setSetErrorText(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.setErrorText = function1;
    }

    @NotNull
    public final ValidationMoment getValidationMoment() {
        return this.validationMoment;
    }

    public final void setValidationMoment(@NotNull ValidationMoment validationMoment) {
        Intrinsics.checkNotNullParameter((Object)((Object)validationMoment), (String)"<set-?>");
        this.validationMoment = validationMoment;
    }

    public boolean checkInput(@Nullable String inputString) {
        String string;
        ToolWindowDefaultLayoutManager manager2 = ToolWindowDefaultLayoutManager.Companion.getInstance();
        int maxLength = Registry.Companion.intValue("ide.max.tool.window.layout.name.length", 50);
        boolean isEmpty = false;
        boolean isTooLong = false;
        boolean isAlreadyExisting = false;
        CharSequence charSequence = inputString;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            isEmpty = true;
            isTooLong = false;
            isAlreadyExisting = false;
        } else {
            isEmpty = false;
            isTooLong = inputString.length() > maxLength;
            isAlreadyExisting = manager2.getLayoutNames().contains(inputString);
        }
        boolean isValid = !isEmpty && !isTooLong && !isAlreadyExisting;
        boolean shouldEnableOkButton = isValid || isAlreadyExisting;
        if (isTooLong) {
            Object[] objectArray = new Object[]{maxLength};
            string = IdeBundle.message((String)"dialog.layout.name.too.long", (Object[])objectArray);
        } else {
            string = isAlreadyExisting ? IdeBundle.message((String)"dialog.layout.already.exists", (Object[])new Object[0]) : null;
        }
        String errorMessage = string;
        return switch (WhenMappings.$EnumSwitchMapping$0[this.validationMoment.ordinal()]) {
            case 1 -> shouldEnableOkButton;
            case 2 -> {
                this.getSetErrorText().invoke((Object)(isTooLong ? errorMessage : null));
                yield shouldEnableOkButton;
            }
            case 3 -> {
                this.getSetErrorText().invoke((Object)(isAlreadyExisting ? errorMessage : null));
                yield isValid;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public boolean canClose(@Nullable String inputString) {
        return this.checkInput(inputString);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValidationMoment.values().length];
            try {
                nArray[ValidationMoment.WHEN_DIALOG_SHOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationMoment.WHEN_TYPING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationMoment.WHEN_OK_PRESSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

