/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.actions.OccurenceNavigatorFinder;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateSession;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehavior;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@ApiStatus.NonExtendable
public abstract class OccurenceNavigatorActionBase
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.FrontendOtherwiseBackend {
    private static final Logger LOG = Logger.getInstance(OccurenceNavigatorActionBase.class);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OccurenceNavigatorActionBase.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            OccurenceNavigatorActionBase.$$$reportNull$$$0(1);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        OccurenceNavigator navigator = this.getNavigator(e.getDataContext());
        if (navigator == null || !this.hasOccurenceToGo(navigator)) {
            return;
        }
        OccurenceNavigator.OccurenceInfo occurenceInfo = this.go(navigator);
        if (occurenceInfo == null) {
            return;
        }
        Navigatable descriptor = occurenceInfo.getNavigateable();
        if (descriptor != null && descriptor.canNavigate()) {
            descriptor.navigate(true);
        }
        OccurenceNavigatorActionBase.displayOccurrencesInfoInStatusBar(project2, occurenceInfo.getOccurenceNumber(), occurenceInfo.getOccurencesCount());
    }

    public static void displayOccurrencesInfoInStatusBar(Project project2, int occurrenceNumber, int occurenceCount) {
        if (occurrenceNumber > 0 && occurenceCount > 0) {
            WindowManager.getInstance().getStatusBar(project2).setInfo(IdeBundle.message((String)"message.occurrence.N.of.M", (Object[])new Object[]{occurrenceNumber, occurenceCount}));
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            OccurenceNavigatorActionBase.$$$reportNull$$$0(2);
        }
        Presentation presentation2 = event.getPresentation();
        presentation2.putClientProperty(ActionRemoteBehavior.SKIP_FALLBACK_UPDATE, null);
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation2.setEnabled(false);
            presentation2.setVisible(!ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()));
            return;
        }
        UpdateSession session = event.getUpdateSession();
        OccurenceNavigator navigator = (OccurenceNavigator)session.compute((Object)this, "getNavigator", ActionUpdateThread.EDT, () -> this.getNavigator(event.getDataContext()));
        if (navigator == null) {
            presentation2.setEnabled(false);
            presentation2.setVisible(!ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()));
            return;
        }
        presentation2.setVisible(true);
        if (navigator instanceof DeputyOccurenceNavigator) {
            presentation2.setEnabled(false);
            return;
        }
        presentation2.putClientProperty(ActionRemoteBehavior.SKIP_FALLBACK_UPDATE, (Object)Boolean.TRUE);
        try {
            boolean enabled2 = Boolean.TRUE.equals(session.compute((Object)navigator, "hasOccurenceToGo", navigator.getActionUpdateThread(), () -> this.hasOccurenceToGo(navigator)));
            presentation2.setEnabled(enabled2);
            String description = this.getDescription(navigator);
            if (StringUtil.isEmpty((String)description)) {
                LOG.error((Throwable)PluginException.createByClass((String)("Empty description provided by " + navigator.getClass().getName()), null, (Class)navigator.getClass()));
            } else {
                presentation2.setText(description);
            }
        }
        catch (IndexNotReadyException e) {
            presentation2.setEnabled(false);
        }
    }

    protected abstract OccurenceNavigator.OccurenceInfo go(OccurenceNavigator var1);

    protected abstract boolean hasOccurenceToGo(OccurenceNavigator var1);

    @NlsActions.ActionText
    protected abstract String getDescription(OccurenceNavigator var1);

    @Nullable
    protected OccurenceNavigator getNavigator(DataContext dataContext2) {
        ContentManager contentManager = ContentManagerUtil.getContentManagerFromContext(dataContext2, false);
        if (contentManager != null) {
            OccurenceNavigator navigator;
            Content content2 = contentManager.getSelectedContent();
            OccurenceNavigator occurenceNavigator = navigator = content2 != null ? OccurenceNavigatorFinder.findNavigator(content2.getComponent()) : null;
            if (navigator != null) {
                return navigator;
            }
        }
        return OccurenceNavigatorActionBase.getOccurenceNavigatorFromContext(dataContext2);
    }

    @Nullable
    private static OccurenceNavigator getOccurenceNavigatorFromContext(@NotNull DataContext dataContext2) {
        Component component2;
        if (dataContext2 == null) {
            OccurenceNavigatorActionBase.$$$reportNull$$$0(3);
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        for (Component c = component2 = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext2); c != null; c = c.getParent()) {
            if (!(c instanceof OccurenceNavigator)) continue;
            return (OccurenceNavigator)c;
        }
        if (project2 == null) {
            return null;
        }
        for (ToolWindow toolWindow2 : JBIterable.of((Object[])((ToolWindow[])PlatformDataKeys.LAST_ACTIVE_TOOL_WINDOWS.getData(dataContext2)))) {
            OccurenceNavigator navigator = OccurenceNavigatorFinder.findNavigator(toolWindow2.getComponent());
            if (navigator == null) continue;
            return navigator;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/OccurenceNavigatorActionBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/OccurenceNavigatorActionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOccurenceNavigatorFromContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    @ApiStatus.Internal
    public static interface DeputyOccurenceNavigator
    extends OccurenceNavigator {
        @NotNull
        default public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = super.getActionUpdateThread();
            if (actionUpdateThread == null) {
                DeputyOccurenceNavigator.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        default public boolean hasNextOccurence() {
            return false;
        }

        default public boolean hasPreviousOccurence() {
            return false;
        }

        default public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            return null;
        }

        default public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            return null;
        }

        @NotNull
        default public String getNextOccurenceActionName() {
            return "";
        }

        @NotNull
        default public String getPreviousOccurenceActionName() {
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/OccurenceNavigatorActionBase$DeputyOccurenceNavigator", "getActionUpdateThread"));
        }
    }
}

