/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.ide.actions.ToolwindowFusEventFields;
import com.intellij.ide.actions.WindowAction;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.FusAwareAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JWindow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ResizeToolWindowAction
extends AnAction
implements DumbAware,
FusAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public final void update(@NotNull AnActionEvent e) {
        Window windowAncestor;
        boolean isActiveEditorPresented;
        if (e == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(1);
        }
        Project project2 = e.getProject();
        Editor editor2 = (Editor)e.getData(CommonDataKeys.HOST_EDITOR);
        if (editor2 == null) {
            editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        }
        boolean bl = isActiveEditorPresented = editor2 != null && !ConsoleViewUtil.isConsoleViewEditor(editor2) && !editor2.isViewer();
        if (project2 == null || isActiveEditorPresented) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        ToolWindow window = ResizeToolWindowAction.getToolWindow(e);
        if (window == null) {
            windowAncestor = null;
        } else {
            @Nullable JComponent component2 = window.getComponent();
            windowAncestor = ComponentUtil.getWindow((Component)component2);
        }
        if (windowAncestor instanceof JWindow) {
            windowAncestor = windowAncestor.getOwner();
        }
        if (windowAncestor instanceof IdeFrame && !(windowAncestor instanceof IdeFrame.Child) && window.isAvailable() && window.isVisible() && window.getType() != ToolWindowType.FLOATING && window.getType() != ToolWindowType.WINDOWED) {
            this.update(e, window);
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @Nullable
    private static ToolWindow getToolWindow(@NotNull AnActionEvent e) {
        ToolWindow toolWindow2;
        if (e == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(2);
        }
        return (toolWindow2 = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW)) != null ? toolWindow2 : (ToolWindow)ArrayUtil.getFirstElement((Object[])((ToolWindow[])e.getData(PlatformDataKeys.LAST_ACTIVE_TOOL_WINDOWS)));
    }

    protected abstract void update(@NotNull AnActionEvent var1, @NotNull ToolWindow var2);

    public final void actionPerformed(@NotNull AnActionEvent e) {
        ToolWindow window;
        if (e == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(3);
        }
        if ((window = ResizeToolWindowAction.getToolWindow(e)) == null) {
            return;
        }
        this.actionPerformed(e, window);
    }

    @Override
    @NotNull
    public List<EventPair<?>> getAdditionalUsageData(@NotNull AnActionEvent event) {
        Project project2;
        if (event == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(4);
        }
        ToolWindow toolWindow2 = (project2 = event.getProject()) == null ? null : ResizeToolWindowAction.getToolWindow(event);
        List<Object> list2 = toolWindow2 != null ? Collections.singletonList(ToolwindowFusEventFields.TOOLWINDOW.with((Object)toolWindow2.getId())) : Collections.emptyList();
        if (list2 == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(5);
        }
        return list2;
    }

    protected abstract void actionPerformed(@NotNull AnActionEvent var1, @NotNull ToolWindow var2);

    private static void stretch(@NotNull ToolWindow window, boolean isHorizontalStretching, boolean isIncrementAction) {
        if (window == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(6);
        }
        ToolWindowAnchor anchor = window.getAnchor();
        Dimension size2 = WindowAction.getPreferredDelta();
        if (isHorizontalStretching && !anchor.isHorizontal()) {
            int scroll = size2.width * Registry.intValue((String)"ide.windowSystem.hScrollChars");
            boolean positive = anchor == ToolWindowAnchor.LEFT == isIncrementAction;
            ((ToolWindowEx)window).stretchWidth(positive ? scroll : -scroll);
        } else if (!isHorizontalStretching && anchor.isHorizontal()) {
            int scroll = size2.height * Registry.intValue((String)"ide.windowSystem.vScrollChars");
            boolean positive = anchor == ToolWindowAnchor.TOP != isIncrementAction;
            ((ToolWindowEx)window).stretchHeight(positive ? scroll : -scroll);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ResizeToolWindowAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ResizeToolWindowAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalUsageData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindow";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalUsageData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "stretch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6 -> new IllegalArgumentException(string);
        };
    }

    public static final class Down
    extends ResizeToolWindowAction {
        @Override
        protected void update(@NotNull AnActionEvent event, @NotNull ToolWindow window) {
            if (event == null) {
                Down.$$$reportNull$$$0(0);
            }
            if (window == null) {
                Down.$$$reportNull$$$0(1);
            }
            event.getPresentation().setEnabled(window.getAnchor().isHorizontal());
        }

        @Override
        protected void actionPerformed(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow2) {
            if (e == null) {
                Down.$$$reportNull$$$0(2);
            }
            if (toolWindow2 == null) {
                Down.$$$reportNull$$$0(3);
            }
            ResizeToolWindowAction.stretch(toolWindow2, false, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/ResizeToolWindowAction$Down";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Up
    extends ResizeToolWindowAction {
        @Override
        protected void update(@NotNull AnActionEvent event, @NotNull ToolWindow window) {
            if (event == null) {
                Up.$$$reportNull$$$0(0);
            }
            if (window == null) {
                Up.$$$reportNull$$$0(1);
            }
            event.getPresentation().setEnabled(window.getAnchor().isHorizontal());
        }

        @Override
        protected void actionPerformed(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow2) {
            if (e == null) {
                Up.$$$reportNull$$$0(2);
            }
            if (toolWindow2 == null) {
                Up.$$$reportNull$$$0(3);
            }
            ResizeToolWindowAction.stretch(toolWindow2, false, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/ResizeToolWindowAction$Up";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Right
    extends ResizeToolWindowAction {
        @Override
        protected void update(@NotNull AnActionEvent event, @NotNull ToolWindow window) {
            if (event == null) {
                Right.$$$reportNull$$$0(0);
            }
            if (window == null) {
                Right.$$$reportNull$$$0(1);
            }
            event.getPresentation().setEnabled(!window.getAnchor().isHorizontal());
        }

        @Override
        protected void actionPerformed(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow2) {
            if (e == null) {
                Right.$$$reportNull$$$0(2);
            }
            if (toolWindow2 == null) {
                Right.$$$reportNull$$$0(3);
            }
            ResizeToolWindowAction.stretch(toolWindow2, true, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/ResizeToolWindowAction$Right";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Left
    extends ResizeToolWindowAction {
        @Override
        protected void update(@NotNull AnActionEvent event, @NotNull ToolWindow window) {
            if (event == null) {
                Left.$$$reportNull$$$0(0);
            }
            if (window == null) {
                Left.$$$reportNull$$$0(1);
            }
            event.getPresentation().setEnabled(!window.getAnchor().isHorizontal());
        }

        @Override
        protected void actionPerformed(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow2) {
            if (e == null) {
                Left.$$$reportNull$$$0(2);
            }
            if (toolWindow2 == null) {
                Left.$$$reportNull$$$0(3);
            }
            ResizeToolWindowAction.stretch(toolWindow2, true, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/ResizeToolWindowAction$Left";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

