/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.cache;

import com.intellij.ide.actions.cache.AsyncRecoveryResult;
import com.intellij.ide.actions.cache.CacheInconsistencyProblem;
import com.intellij.ide.actions.cache.RecoveryScope;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bg\u0018\u00002\u00020\u0001J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R#\u0010\u0006\u001a\u00130\u0007\u00a2\u0006\u000e\b\b\u0012\n\b\t\u0012\u0006\b\n0\n8\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001a\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ide/actions/cache/RecoveryAction;", "", "performanceRate", "", "getPerformanceRate", "()I", "presentableName", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "getPresentableName", "()Ljava/lang/String;", "actionKey", "getActionKey", "perform", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/ide/actions/cache/AsyncRecoveryResult;", "recoveryScope", "Lcom/intellij/ide/actions/cache/RecoveryScope;", "performSync", "", "Lcom/intellij/ide/actions/cache/CacheInconsistencyProblem;", "canBeApplied", "", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public interface RecoveryAction {
    public int getPerformanceRate();

    @NotNull
    public String getPresentableName();

    @NotNull
    public String getActionKey();

    @NotNull
    default public CompletableFuture<AsyncRecoveryResult> perform(@NotNull RecoveryScope recoveryScope) {
        Intrinsics.checkNotNullParameter((Object)recoveryScope, (String)"recoveryScope");
        try {
            CompletableFuture<AsyncRecoveryResult> completableFuture = CompletableFuture.completedFuture(new AsyncRecoveryResult(recoveryScope, this.performSync(recoveryScope)));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        catch (Exception e) {
            CompletableFuture<AsyncRecoveryResult> completableFuture = CompletableFuture.failedFuture(e);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(...)");
            return completableFuture;
        }
    }

    @NotNull
    default public List<CacheInconsistencyProblem> performSync(@NotNull RecoveryScope recoveryScope) {
        Intrinsics.checkNotNullParameter((Object)recoveryScope, (String)"recoveryScope");
        throw new NotImplementedError(null, 1, null);
    }

    default public boolean canBeApplied(@NotNull RecoveryScope recoveryScope) {
        Intrinsics.checkNotNullParameter((Object)recoveryScope, (String)"recoveryScope");
        return true;
    }
}

