/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actionsOnSave;

import com.intellij.ide.actionsOnSave.ActionOnSaveComment;
import com.intellij.ide.actionsOnSave.ActionOnSaveContext;
import com.intellij.ide.actionsOnSave.ActionOnSaveInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionOnSaveBackedByOwnConfigurable<Conf extends UnnamedConfigurable>
extends ActionOnSaveInfo {
    private static final Logger LOG = Logger.getInstance(ActionOnSaveBackedByOwnConfigurable.class);
    @NotNull
    private final String myConfigurableId;
    @NotNull
    private final Class<Conf> myConfigurableClass;
    @Nullable
    private Conf myConfigurableWithInitializedUiComponent;

    public ActionOnSaveBackedByOwnConfigurable(@NotNull ActionOnSaveContext context, @NotNull String configurableId, @NotNull Class<Conf> configurableClass) {
        if (context == null) {
            ActionOnSaveBackedByOwnConfigurable.$$$reportNull$$$0(0);
        }
        if (configurableId == null) {
            ActionOnSaveBackedByOwnConfigurable.$$$reportNull$$$0(1);
        }
        if (configurableClass == null) {
            ActionOnSaveBackedByOwnConfigurable.$$$reportNull$$$0(2);
        }
        super(context);
        this.myConfigurableId = configurableId;
        this.myConfigurableClass = configurableClass;
        Configurable configurable = this.getSettings().getConfigurableWithInitializedUiComponent(this.myConfigurableId, false);
        if (configurable instanceof ConfigurableWrapper) {
            configurable = ((ConfigurableWrapper)configurable).getRawConfigurable();
        }
        if (configurable == null) {
            return;
        }
        if (!this.myConfigurableClass.isInstance(configurable)) {
            LOG.error("Unexpected configurable type:" + String.valueOf(configurable.getClass()) + "\n" + String.valueOf(configurable));
            return;
        }
        this.myConfigurableWithInitializedUiComponent = configurable;
    }

    void resetUiOnOwnPageThatIsMirroredOnActionsOnSavePage() {
        if (this.myConfigurableWithInitializedUiComponent != null) {
            this.resetUiOnOwnPageThatIsMirroredOnActionsOnSavePage(this.myConfigurableWithInitializedUiComponent);
            this.getSettings().checkModified(this.myConfigurableId);
        }
    }

    protected void resetUiOnOwnPageThatIsMirroredOnActionsOnSavePage(@NotNull Conf configurable) {
        if (configurable == null) {
            ActionOnSaveBackedByOwnConfigurable.$$$reportNull$$$0(3);
        }
        this.setActionOnSaveEnabled(configurable, this.isActionOnSaveEnabledAccordingToStoredState());
    }

    @Override
    protected void apply() {
    }

    @Override
    protected final boolean isModified() {
        return this.myConfigurableWithInitializedUiComponent != null && this.areOptionsMirroredOnActionsOnSavePageModified(this.myConfigurableWithInitializedUiComponent);
    }

    protected boolean areOptionsMirroredOnActionsOnSavePageModified(@NotNull Conf configurable) {
        if (configurable == null) {
            ActionOnSaveBackedByOwnConfigurable.$$$reportNull$$$0(4);
        }
        return this.isActionOnSaveEnabledAccordingToStoredState() != this.isActionOnSaveEnabledAccordingToUiState(configurable);
    }

    protected final <T> T getValueFromSavedStateOrFromUiState(@NotNull Supplier<? extends T> ifConfigurableNotYetInitialized, @NotNull Function<? super Conf, ? extends T> ifConfigurableAlreadyInitialized) {
        if (ifConfigurableNotYetInitialized == null) {
            ActionOnSaveBackedByOwnConfigurable.$$$reportNull$$$0(5);
        }
        if (ifConfigurableAlreadyInitialized == null) {
            ActionOnSaveBackedByOwnConfigurable.$$$reportNull$$$0(6);
        }
        if (this.myConfigurableWithInitializedUiComponent == null) {
            return ifConfigurableNotYetInitialized.get();
        }
        return ifConfigurableAlreadyInitialized.apply(this.myConfigurableWithInitializedUiComponent);
    }

    protected final void updateUiOnOwnPage(@NotNull Consumer<? super Conf> uiUpdater) {
        if (uiUpdater == null) {
            ActionOnSaveBackedByOwnConfigurable.$$$reportNull$$$0(7);
        }
        this.ensureUiComponentsOnOwnPageInitialized();
        if (this.myConfigurableWithInitializedUiComponent != null) {
            uiUpdater.accept(this.myConfigurableWithInitializedUiComponent);
            this.getSettings().checkModified(this.myConfigurableId);
        }
    }

    private void ensureUiComponentsOnOwnPageInitialized() {
        if (this.myConfigurableWithInitializedUiComponent != null) {
            return;
        }
        Configurable configurable = this.getSettings().getConfigurableWithInitializedUiComponent(this.myConfigurableId, true);
        if (configurable instanceof ConfigurableWrapper) {
            configurable = ((ConfigurableWrapper)configurable).getRawConfigurable();
        }
        if (configurable == null) {
            LOG.error("Failed to initialize configurable with id=" + this.myConfigurableId);
            return;
        }
        if (!this.myConfigurableClass.isInstance(configurable)) {
            LOG.error("Unexpected configurable type:" + String.valueOf(configurable.getClass()) + "\n" + String.valueOf(configurable));
            return;
        }
        this.myConfigurableWithInitializedUiComponent = configurable;
    }

    @Override
    public final boolean isSaveActionApplicable() {
        return this.getValueFromSavedStateOrFromUiState(this::isApplicableAccordingToStoredState, this::isApplicableAccordingToUiState);
    }

    protected boolean isApplicableAccordingToStoredState() {
        return true;
    }

    protected boolean isApplicableAccordingToUiState(@NotNull Conf configurable) {
        if (configurable == null) {
            ActionOnSaveBackedByOwnConfigurable.$$$reportNull$$$0(8);
        }
        return true;
    }

    @Override
    @Nullable
    public final ActionOnSaveComment getComment() {
        return this.getValueFromSavedStateOrFromUiState(this::getCommentAccordingToStoredState, this::getCommentAccordingToUiState);
    }

    @Nullable
    protected ActionOnSaveComment getCommentAccordingToStoredState() {
        return null;
    }

    @Nullable
    protected ActionOnSaveComment getCommentAccordingToUiState(@NotNull Conf configurable) {
        if (configurable == null) {
            ActionOnSaveBackedByOwnConfigurable.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Override
    public final boolean isActionOnSaveEnabled() {
        return this.getValueFromSavedStateOrFromUiState(this::isActionOnSaveEnabledAccordingToStoredState, this::isActionOnSaveEnabledAccordingToUiState);
    }

    protected boolean isActionOnSaveEnabledAccordingToStoredState() {
        return false;
    }

    protected boolean isActionOnSaveEnabledAccordingToUiState(@NotNull Conf configurable) {
        if (configurable == null) {
            ActionOnSaveBackedByOwnConfigurable.$$$reportNull$$$0(10);
        }
        return false;
    }

    @Override
    public final void setActionOnSaveEnabled(boolean enabled2) {
        this.updateUiOnOwnPage(configurable -> this.setActionOnSaveEnabled(configurable, enabled2));
    }

    protected abstract void setActionOnSaveEnabled(@NotNull Conf var1, boolean var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurableId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurableClass";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifConfigurableNotYetInitialized";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifConfigurableAlreadyInitialized";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiUpdater";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actionsOnSave/ActionOnSaveBackedByOwnConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resetUiOnOwnPageThatIsMirroredOnActionsOnSavePage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "areOptionsMirroredOnActionsOnSavePageModified";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueFromSavedStateOrFromUiState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUiOnOwnPage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableAccordingToUiState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommentAccordingToUiState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isActionOnSaveEnabledAccordingToUiState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

