/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.gdpr.Agreements;
import com.intellij.ide.gdpr.ConfirmedConsent;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentAttributes;
import com.intellij.ide.gdpr.ConsentBase;
import com.intellij.ide.gdpr.DataSharingSettingsChangeListener;
import com.intellij.ide.gdpr.Version;
import com.intellij.idea.AppMode;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class ConsentOptions
implements ModificationTracker {
    private static final Logger LOG = Logger.getInstance(ConsentOptions.class);
    private static final String CONSENTS_CONFIRMATION_PROPERTY = "jb.consents.confirmation.enabled";
    private static final String RECONFIRM_CONSENTS_PROPERTY = "test.force.reconfirm.consents";
    private static final String STATISTICS_OPTION_ID = "rsch.send.usage.stat";
    private static final String EAP_FEEDBACK_OPTION_ID = "eap";
    private static final String AI_DATA_COLLECTION_OPTION_ID = "ai.data.collection.and.use.policy";
    private static final Set<String> PER_PRODUCT_CONSENTS = Set.of("eap");
    private final BooleanSupplier myIsEap;
    private String myProductCode;
    private Set<String> myPluginCodes = Set.of();
    private final AtomicLong myModificationCount = new AtomicLong();
    private final IOBackend myBackend;

    public long getModificationCount() {
        return this.myModificationCount.get();
    }

    private static Path getDefaultConsentsFile() {
        return PathManager.getCommonDataPath().resolve(ApplicationNamesInfo.getInstance().getLowercaseProductName()).resolve("consentOptions/cached");
    }

    private static Path getConfirmedConsentsFile() {
        return PathManager.getCommonDataPath().resolve("consentOptions/accepted");
    }

    private static Locale getCurrentLocale() {
        return LocalizationUtil.INSTANCE.getLocale();
    }

    private static Locale getDefaultLocale() {
        return LocalizationUtil.INSTANCE.getDefaultLocale();
    }

    @VisibleForTesting
    public ConsentOptions(IOBackend backend, boolean isEap) {
        this.myBackend = backend;
        this.myIsEap = () -> isEap;
    }

    ConsentOptions(IOBackend backend) {
        this.myBackend = backend;
        this.myIsEap = () -> {
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            return appInfo.isEAP() && appInfo.isVendorJetBrains() && !Agreements.isReleaseAgreementsEnabled();
        };
    }

    public static ConsentOptions getInstance() {
        return InstanceHolder.ourInstance;
    }

    public static boolean needToShowUsageStatsConsent() {
        return (Boolean)ConsentOptions.getInstance().getConsents(ConsentOptions.condUsageStatsConsent()).getSecond();
    }

    public boolean isEAP() {
        return this.myIsEap.getAsBoolean();
    }

    public void setProductCode(String platformCode, Iterable<String> pluginCodes) {
        this.myProductCode = platformCode != null ? platformCode.toLowerCase(ConsentOptions.getDefaultLocale()) : null;
        HashSet<String> codes = new HashSet<String>();
        for (String pluginCode : pluginCodes) {
            codes.add(pluginCode.toLowerCase(ConsentOptions.getDefaultLocale()));
        }
        this.myPluginCodes = codes.isEmpty() ? Set.of() : Collections.unmodifiableSet(codes);
    }

    @Nullable
    public Consent getDefaultUsageStatsConsent() {
        return this.getDefaultConsent(STATISTICS_OPTION_ID);
    }

    @NotNull
    public static Predicate<Consent> condUsageStatsConsent() {
        Predicate<Consent> predicate = consent -> STATISTICS_OPTION_ID.equals(consent.getId());
        if (predicate == null) {
            ConsentOptions.$$$reportNull$$$0(0);
        }
        return predicate;
    }

    @NotNull
    public static Predicate<Consent> condEAPFeedbackConsent() {
        Predicate<Consent> predicate = consent -> ConsentOptions.isProductConsentOfKind(EAP_FEEDBACK_OPTION_ID, consent.getId());
        if (predicate == null) {
            ConsentOptions.$$$reportNull$$$0(1);
        }
        return predicate;
    }

    @NotNull
    public static Predicate<Consent> condAiDataCollectionConsent() {
        Predicate<Consent> predicate = consent -> AI_DATA_COLLECTION_OPTION_ID.equals(consent.getId());
        if (predicate == null) {
            ConsentOptions.$$$reportNull$$$0(2);
        }
        return predicate;
    }

    public Permission isSendingUsageStatsAllowed() {
        return this.getPermission(STATISTICS_OPTION_ID);
    }

    public boolean setSendingUsageStatsAllowed(boolean allowed) {
        return this.setPermission(STATISTICS_OPTION_ID, allowed);
    }

    @NotNull
    public Permission getAiDataCollectionPermission() {
        Permission permission = this.getPermission(AI_DATA_COLLECTION_OPTION_ID);
        if (permission == null) {
            ConsentOptions.$$$reportNull$$$0(3);
        }
        return permission;
    }

    public void setAiDataCollectionPermission(boolean permitted) {
        this.setPermission(AI_DATA_COLLECTION_OPTION_ID, permitted);
    }

    private Permission getPermission(String consentId) {
        ConfirmedConsent confirmedConsent = this.getConfirmedConsent(consentId);
        return confirmedConsent == null ? Permission.UNDEFINED : (confirmedConsent.isAccepted() ? Permission.YES : Permission.NO);
    }

    private boolean setPermission(String consentId, boolean allowed) {
        Consent defConsent = this.getDefaultConsent(consentId);
        if (defConsent != null && !defConsent.isDeleted()) {
            this.setConsents(Collections.singleton(defConsent.derive(allowed)));
            return true;
        }
        return false;
    }

    private String lookupConsentID(String consentId) {
        String productCode = this.myProductCode;
        return productCode != null && PER_PRODUCT_CONSENTS.contains(consentId) ? consentId + "." + productCode : consentId;
    }

    @Nullable
    public String getConfirmedConsentsString() {
        String str;
        Map<String, Map<Locale, Consent>> defaults = this.loadDefaultConsents();
        if (!defaults.isEmpty() && !(str = ConsentOptions.confirmedConsentToExternalString(this.loadConfirmedConsents().values().stream().filter(c -> {
            Consent def;
            Map defaultConsents = (Map)defaults.get(c.getId());
            Consent consent = def = defaultConsents != null ? (Consent)defaultConsents.get(ConsentOptions.getDefaultLocale()) : null;
            if (def != null) {
                return !def.isDeleted();
            }
            for (String prefix : PER_PRODUCT_CONSENTS) {
                if (!ConsentOptions.isProductConsentOfKind(prefix, c.getId())) continue;
                return true;
            }
            return false;
        }))).isBlank()) {
            return str;
        }
        return null;
    }

    public void applyServerUpdates(@Nullable String json) {
        if (json == null || json.isBlank()) {
            return;
        }
        try {
            Map<String, ConfirmedConsent> confirmed2;
            Collection<ConsentAttributes> fromServer = this.fromJson(json);
            Map<String, Map<Locale, Consent>> defaults = this.loadDefaultConsents();
            if (ConsentOptions.applyServerChangesToDefaults(defaults, fromServer)) {
                this.myBackend.writeDefaultConsents(this.consentsToJson(defaults.values().stream().flatMap(it -> it.values().stream())));
            }
            if (ConsentOptions.applyServerChangesToConfirmedConsents(confirmed2 = this.loadConfirmedConsents(), fromServer)) {
                this.myBackend.writeConfirmedConsents(ConsentOptions.confirmedConsentToExternalString(confirmed2.values().stream()));
            }
            this.notifyConsentsUpdated();
        }
        catch (Exception e) {
            LOG.info("Unable to apply server consents", (Throwable)e);
        }
    }

    @NotNull
    public Pair<List<Consent>, Boolean> getConsents() {
        Pair<List<Consent>, Boolean> pair = this.getConsents(consent -> true);
        if (pair == null) {
            ConsentOptions.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @NotNull
    public Pair<List<Consent>, Boolean> getConsents(@NotNull Predicate<? super Consent> filter2) {
        if (filter2 == null) {
            ConsentOptions.$$$reportNull$$$0(5);
        }
        Map<String, Map<Locale, Consent>> allDefaults = this.loadDefaultConsents();
        if (this.isEAP()) {
            allDefaults.remove(STATISTICS_OPTION_ID);
        } else {
            allDefaults.remove(this.lookupConsentID(EAP_FEEDBACK_OPTION_ID));
        }
        Iterator<Map.Entry<String, Map<Locale, Consent>>> it = allDefaults.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Map<Locale, Consent>> entry = it.next();
            Consent consent = entry.getValue().get(ConsentOptions.getDefaultLocale());
            if (consent == null || filter2.test(consent)) continue;
            it.remove();
        }
        if (allDefaults.isEmpty()) {
            return new Pair(List.of(), (Object)Boolean.FALSE);
        }
        Map<String, ConfirmedConsent> allConfirmed = this.loadConfirmedConsents();
        ArrayList<Consent> result2 = new ArrayList<Consent>();
        for (Map.Entry entry : allDefaults.entrySet()) {
            Consent base = (Consent)((Map)entry.getValue()).get(ConsentOptions.getDefaultLocale());
            Consent localized = (Consent)((Map)entry.getValue()).get(ConsentOptions.getCurrentLocale());
            if (base == null || base.isDeleted()) continue;
            ConfirmedConsent confirmed2 = allConfirmed.get(base.getId());
            Consent consent = localized == null || base.getVersion().isNewer(localized.getVersion()) ? base : localized;
            result2.add(confirmed2 == null ? consent : consent.derive(confirmed2.isAccepted()));
        }
        result2.sort(Comparator.comparing(ConsentBase::getId));
        boolean confirmationEnabled = Boolean.parseBoolean(System.getProperty(CONSENTS_CONFIRMATION_PROPERTY, "true")) && !AppMode.isRemoteDevHost();
        return new Pair(result2, (Object)(confirmationEnabled && this.needReconfirm(allDefaults, allConfirmed) ? 1 : 0));
    }

    public void setConsents(@NotNull Collection<Consent> confirmedByUser) {
        if (confirmedByUser == null) {
            ConsentOptions.$$$reportNull$$$0(6);
        }
        ArrayList<ConfirmedConsent> result2 = new ArrayList<ConfirmedConsent>(confirmedByUser.size());
        for (Consent t : confirmedByUser) {
            String idPrefix;
            result2.add(new ConfirmedConsent(t.getId(), t.getVersion(), t.isAccepted(), 0L));
            if (this.myPluginCodes.isEmpty() || (idPrefix = ConsentOptions.getProductConsentKind(this.myProductCode, t.getId())) == null || !PER_PRODUCT_CONSENTS.contains(idPrefix)) continue;
            for (String pluginCode : this.myPluginCodes) {
                result2.add(new ConfirmedConsent(idPrefix + "." + pluginCode, t.getVersion(), t.isAccepted(), 0L));
            }
        }
        this.saveConfirmedConsents(result2);
    }

    @Nullable
    private Consent getDefaultConsent(String consentId) {
        Map<String, Map<Locale, Consent>> defaultConsents = this.loadDefaultConsents();
        Map<Locale, Consent> consentMap = defaultConsents.get(consentId);
        Consent defaultConsent = consentMap.get(ConsentOptions.getDefaultLocale());
        if (defaultConsent == null) {
            return null;
        }
        Consent localizedConsent = consentMap.get(ConsentOptions.getCurrentLocale());
        return localizedConsent == null || defaultConsent.getVersion().isNewer(localizedConsent.getVersion()) ? defaultConsent : localizedConsent;
    }

    @Nullable
    private ConfirmedConsent getConfirmedConsent(String consentId) {
        Consent defConsent = this.getDefaultConsent(consentId);
        if (defConsent != null && defConsent.isDeleted()) {
            return null;
        }
        return this.loadConfirmedConsents().get(defConsent != null ? defConsent.getId() : this.lookupConsentID(consentId));
    }

    private void saveConfirmedConsents(Collection<ConfirmedConsent> updates) {
        if (!updates.isEmpty()) {
            try {
                Map<String, ConfirmedConsent> allConfirmed = this.loadConfirmedConsents();
                long stamp = System.currentTimeMillis();
                for (ConfirmedConsent consent : updates) {
                    consent.setAcceptanceTime(stamp);
                    allConfirmed.put(consent.getId(), consent);
                }
                this.myBackend.writeConfirmedConsents(ConsentOptions.confirmedConsentToExternalString(allConfirmed.values().stream()));
                this.notifyConsentsUpdated();
            }
            catch (IOException e) {
                LOG.info("Unable to save confirmed consents", (Throwable)e);
            }
        }
    }

    private boolean needReconfirm(Map<String, Map<Locale, Consent>> defaults, Map<String, ConfirmedConsent> confirmed2) {
        for (Map<Locale, Consent> consents : defaults.values()) {
            Consent defConsent = consents.get(ConsentOptions.getDefaultLocale());
            if (defConsent == null || defConsent.isDeleted()) continue;
            ConfirmedConsent confirmedConsent = confirmed2.get(defConsent.getId());
            if (confirmedConsent == null) {
                return true;
            }
            String consentId = ConsentOptions.getProductConsentKind(this.myProductCode, defConsent.getId());
            if (consentId != null && PER_PRODUCT_CONSENTS.contains(consentId)) {
                for (String pluginCode : this.myPluginCodes) {
                    ConfirmedConsent pluginConfirmedConsent = confirmed2.get(consentId + "." + pluginCode);
                    if (pluginConfirmedConsent != null) continue;
                    return true;
                }
            }
            Version confirmedVersion = confirmedConsent.getVersion();
            Version defaultVersion = defConsent.getVersion();
            if (Boolean.getBoolean(RECONFIRM_CONSENTS_PROPERTY)) {
                return true;
            }
            if (!confirmedVersion.isOlder(defaultVersion) || confirmedVersion.getMajor() == defaultVersion.getMajor()) continue;
            return true;
        }
        return false;
    }

    private static boolean applyServerChangesToConfirmedConsents(Map<String, ConfirmedConsent> base, Collection<ConsentAttributes> fromServer) {
        boolean changes = false;
        for (ConsentAttributes update2 : fromServer) {
            ConfirmedConsent change;
            ConfirmedConsent current = base.get(update2.consentId);
            if (current == null || (change = new ConfirmedConsent(update2)).getVersion().isOlder(current.getVersion()) || current.getAcceptanceTime() >= update2.acceptanceTime) continue;
            base.put(change.getId(), change);
            changes = true;
        }
        return changes;
    }

    private static boolean applyServerChangesToDefaults(Map<String, Map<Locale, Consent>> base, Collection<ConsentAttributes> fromServer) {
        boolean changes = false;
        for (ConsentAttributes update2 : fromServer) {
            Consent newConsent = new Consent(update2);
            Map<Locale, Consent> current = base.get(newConsent.getId());
            if (current == null) {
                base.put(newConsent.getId(), Map.of(Locale.forLanguageTag(newConsent.getLocale()), newConsent));
                return true;
            }
            Locale newConsentLocale = newConsent.getLocale() != null && !newConsent.getLocale().isEmpty() ? Locale.forLanguageTag(newConsent.getLocale()) : ConsentOptions.getDefaultLocale();
            Consent consent = current.get(newConsentLocale);
            if (consent == null && newConsentLocale != ConsentOptions.getDefaultLocale()) {
                newConsentLocale = ConsentOptions.getDefaultLocale();
                consent = current.get(newConsentLocale);
            }
            if (consent == null || newConsent.isDeleted() || !newConsent.getVersion().isNewer(consent.getVersion())) continue;
            base.get(newConsent.getId()).put(newConsentLocale, newConsent);
            changes = true;
        }
        return changes;
    }

    private Collection<ConsentAttributes> fromJson(@Nullable String json) {
        if (json == null || json.isEmpty()) {
            return List.of();
        }
        try {
            List<ConsentAttributes> data2 = ConsentAttributes.Companion.readListFromJson(json);
            for (ConsentAttributes attributes : data2) {
                attributes.consentId = this.lookupConsentID(attributes.consentId);
            }
            return data2;
        }
        catch (Throwable e) {
            LOG.info(e);
            return List.of();
        }
    }

    private String consentsToJson(Stream<Consent> consents) {
        return ConsentAttributes.Companion.writeListToJson(consents.map(consent -> {
            ConsentAttributes attributes = consent.toConsentAttributes();
            String prefix = ConsentOptions.getProductConsentKind(this.myProductCode, attributes.consentId);
            if (prefix != null) {
                attributes.consentId = prefix;
            }
            return attributes;
        }).toList());
    }

    private static String confirmedConsentToExternalString(Stream<ConfirmedConsent> consents) {
        return consents.map(ConfirmedConsent::toExternalString).collect(Collectors.joining(";"));
    }

    private Map<String, Map<Locale, Consent>> loadDefaultConsents() {
        HashMap<String, Map<Locale, Consent>> result2 = new HashMap<String, Map<Locale, Consent>>();
        Collection<ConsentAttributes> localizedConsentAttributes = this.fromJson(this.myBackend.readLocalizedBundledConsents());
        for (ConsentAttributes attributes : this.fromJson(this.myBackend.readBundledConsents())) {
            HashMap<Locale, Consent> map2 = new HashMap<Locale, Consent>();
            map2.put(ConsentOptions.getDefaultLocale(), new Consent(attributes));
            localizedConsentAttributes.stream().filter(it -> Objects.equals(it.consentId, attributes.consentId)).findFirst().ifPresent(localizedAttributes -> map2.put(ConsentOptions.getCurrentLocale(), new Consent((ConsentAttributes)localizedAttributes)));
            result2.put(attributes.consentId, map2);
        }
        try {
            ConsentOptions.applyServerChangesToDefaults(result2, this.fromJson(this.myBackend.readDefaultConsents()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result2;
    }

    private Map<String, ConfirmedConsent> loadConfirmedConsents() {
        HashMap<String, ConfirmedConsent> result2 = new HashMap<String, ConfirmedConsent>();
        try {
            StringTokenizer tokenizer = new StringTokenizer(this.myBackend.readConfirmedConsents(), ";", false);
            while (tokenizer.hasMoreTokens()) {
                ConfirmedConsent consent = ConfirmedConsent.fromString(tokenizer.nextToken());
                if (consent == null) continue;
                result2.put(consent.getId(), consent);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result2;
    }

    private static boolean isProductConsentOfKind(String consentKind, String consentId) {
        return consentKind != null && consentId.startsWith(consentKind) && (consentId.length() == consentKind.length() || consentId.charAt(consentKind.length()) == '.');
    }

    private static String getProductConsentKind(String productCode, String consentId) {
        if (productCode != null && consentId.endsWith(productCode) && (consentId.length() == productCode.length() || consentId.charAt(consentId.length() - productCode.length() - 1) == '.')) {
            return consentId.substring(0, consentId.length() - productCode.length() - 1);
        }
        return null;
    }

    private void notifyConsentsUpdated() {
        this.myModificationCount.incrementAndGet();
        if (LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            ((DataSharingSettingsChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DataSharingSettingsChangeListener.TOPIC)).consentsUpdated();
        }
    }

    @TestOnly
    @NotNull
    public static Path getDefaultConsentsFileForTests() {
        Path path = ConsentOptions.getDefaultConsentsFile();
        if (path == null) {
            ConsentOptions.$$$reportNull$$$0(7);
        }
        return path;
    }

    @TestOnly
    @NotNull
    public static Path getConfirmedConsentsFileForTests() {
        Path path = ConsentOptions.getConfirmedConsentsFile();
        if (path == null) {
            ConsentOptions.$$$reportNull$$$0(8);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/gdpr/ConsentOptions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmedByUser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "condUsageStatsConsent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "condEAPFeedbackConsent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "condAiDataCollectionConsent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAiDataCollectionPermission";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsents";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/gdpr/ConsentOptions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConsentsFileForTests";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfirmedConsentsFileForTests";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConsents";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setConsents";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 6 -> new IllegalArgumentException(string);
        };
    }

    public static interface IOBackend {
        public void writeDefaultConsents(@NotNull String var1) throws IOException;

        @NotNull
        public String readDefaultConsents() throws IOException;

        @NotNull
        public String readBundledConsents();

        @Nullable
        public String readLocalizedBundledConsents();

        public void writeConfirmedConsents(@NotNull String var1) throws IOException;

        @NotNull
        public String readConfirmedConsents() throws IOException;
    }

    private static final class InstanceHolder {
        static final ConsentOptions ourInstance = new ConsentOptions(new IOBackend(){

            @Override
            public void writeDefaultConsents(@NotNull String data2) throws IOException {
                if (data2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                Path defaultConsentsFile = ConsentOptions.getDefaultConsentsFile();
                Files.createDirectories(defaultConsentsFile.getParent(), new FileAttribute[0]);
                Files.writeString(defaultConsentsFile, (CharSequence)data2, new OpenOption[0]);
            }

            @Override
            @NotNull
            public String readDefaultConsents() throws IOException {
                String string = 1.loadText(Files.newInputStream(ConsentOptions.getDefaultConsentsFile(), new OpenOption[0]));
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            public String readBundledConsents() {
                String string = 1.loadText(ConsentOptions.class.getClassLoader().getResourceAsStream(InstanceHolder.getBundledResourcePath()));
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Override
            @Nullable
            public String readLocalizedBundledConsents() {
                if (ConsentOptions.getCurrentLocale() == ConsentOptions.getDefaultLocale()) {
                    return null;
                }
                for (String localizedPath : LocalizationUtil.INSTANCE.getLocalizedPaths(InstanceHolder.getBundledResourcePath(), ConsentOptions.getCurrentLocale())) {
                    String loadedText = 1.loadText(ConsentOptions.class.getClassLoader().getResourceAsStream(localizedPath));
                    if (loadedText.isEmpty()) continue;
                    return loadedText;
                }
                return null;
            }

            @Override
            public void writeConfirmedConsents(@NotNull String data2) throws IOException {
                if (data2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                Path confirmedConsentsFile = ConsentOptions.getConfirmedConsentsFile();
                Files.createDirectories(confirmedConsentsFile.getParent(), new FileAttribute[0]);
                Files.writeString(confirmedConsentsFile, (CharSequence)data2, new OpenOption[0]);
                if (LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
                    ((DataSharingSettingsChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DataSharingSettingsChangeListener.TOPIC)).consentWritten();
                }
            }

            @Override
            @NotNull
            public String readConfirmedConsents() throws IOException {
                String string = 1.loadText(Files.newInputStream(ConsentOptions.getConfirmedConsentsFile(), new OpenOption[0]));
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static String loadText(InputStream stream) {
                if (stream != null) {
                    String string;
                    block9: {
                        InputStream inputStream = CharsetToolkit.inputStreamSkippingBOM((InputStream)stream);
                        try {
                            string = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                            if (inputStream == null) break block9;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                LOG.info((Throwable)e);
                            }
                        }
                        inputStream.close();
                    }
                    return string;
                }
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "data";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/gdpr/ConsentOptions$InstanceHolder$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/gdpr/ConsentOptions$InstanceHolder$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "readDefaultConsents";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "readBundledConsents";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "readConfirmedConsents";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "writeDefaultConsents";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "writeConfirmedConsents";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 4 -> new IllegalStateException(string);
                };
            }
        });

        private InstanceHolder() {
        }

        private static String getBundledResourcePath() {
            if ("JetBrains".equals(System.getProperty("idea.vendor.name"))) {
                return "consents.json";
            }
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            return appInfo.isVendorJetBrains() ? "consents.json" : "consents-" + appInfo.getShortCompanyName() + ".json";
        }
    }

    public static enum Permission {
        YES,
        NO,
        UNDEFINED;

    }
}

