/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagementPolicy;
import com.intellij.ide.plugins.marketplace.InitSessionResult;
import com.intellij.ide.plugins.newui.DefaultUiPluginManagerController;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@ApiStatus.Internal
public class InstallFromDiskAction
extends DumbAwareAction {
    private static final String PLUGINS_PRESELECTION_PATH = "plugins.preselection.path";
    private InstalledPluginsTableModel myTableModel;
    @NotNull
    private final PluginEnabler myPluginEnabler;
    @Nullable
    private final JComponent myParentComponent;

    InstallFromDiskAction() {
        this(null, (PluginEnabler)PluginEnabler.HEADLESS, null);
    }

    protected InstallFromDiskAction(@Nullable InstalledPluginsTableModel tableModel2, @NotNull PluginEnabler pluginEnabler, @Nullable JComponent parentComponent) {
        if (pluginEnabler == null) {
            InstallFromDiskAction.$$$reportNull$$$0(0);
        }
        super(IdeBundle.messagePointer((String)"action.InstallFromDiskAction.text", (Object[])new Object[0]), AllIcons.Nodes.Plugin);
        if (tableModel2 != null) {
            this.myTableModel = tableModel2;
        }
        this.myPluginEnabler = pluginEnabler;
        this.myParentComponent = parentComponent;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            InstallFromDiskAction.$$$reportNull$$$0(1);
        }
        if (!PluginManagementPolicy.getInstance().isInstallFromDiskAllowed()) {
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(false);
            presentation2.setDescription(IdeBundle.message((String)"action.InstallFromDiskAction.not.allowed.description", (Object[])new Object[0]));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            InstallFromDiskAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            InstallFromDiskAction.$$$reportNull$$$0(3);
        }
        Project project2 = e.getProject();
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        UUID sessionId = UUID.randomUUID();
        InitSessionResult initSessionResult = DefaultUiPluginManagerController.INSTANCE.initSessionSync(sessionId.toString());
        InstalledPluginsTableModel tableModel2 = this.myTableModel == null ? new InstalledPluginsTableModel(null, initSessionResult, sessionId) : this.myTableModel;
        InstallFromDiskAction.installPluginFromDisk(file2, project2, tableModel2, this.myPluginEnabler, this.myParentComponent, (? super PluginInstallCallbackData callbackData) -> this.onPluginInstalledFromDisk((PluginInstallCallbackData)callbackData, project2));
    }

    public static void installPluginFromDisk(@Nullable VirtualFile fileToSelect, @Nullable Project project2, @NotNull InstalledPluginsTableModel tableModel2, @NotNull PluginEnabler pluginEnabler, @Nullable JComponent parentComponent, @NotNull Consumer<? super PluginInstallCallbackData> callback) {
        if (tableModel2 == null) {
            InstallFromDiskAction.$$$reportNull$$$0(4);
        }
        if (pluginEnabler == null) {
            InstallFromDiskAction.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            InstallFromDiskAction.$$$reportNull$$$0(6);
        }
        InstallFromDiskAction.doInstall(fileToSelect, project2, tableModel2, pluginEnabler, parentComponent, callback);
    }

    private static void doInstall(@Nullable VirtualFile fileToSelect, @Nullable Project project2, @NotNull InstalledPluginsTableModel tableModel2, @NotNull PluginEnabler pluginEnabler, @Nullable JComponent parentComponent, @NotNull Consumer<? super PluginInstallCallbackData> callback) {
        FileChooserDescriptor descriptor;
        VirtualFile chosenFile;
        if (tableModel2 == null) {
            InstallFromDiskAction.$$$reportNull$$$0(7);
        }
        if (pluginEnabler == null) {
            InstallFromDiskAction.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            InstallFromDiskAction.$$$reportNull$$$0(9);
        }
        if (!PluginManagementPolicy.getInstance().isInstallFromDiskAllowed()) {
            String message = IdeBundle.message((String)"action.InstallFromDiskAction.not.allowed.description", (Object[])new Object[0]);
            Messages.showErrorDialog((Project)project2, (String)message, (String)IdeBundle.message((String)"action.InstallFromDiskAction.text", (Object[])new Object[0]));
            return;
        }
        if (fileToSelect == null || !fileToSelect.isInLocalFileSystem() || !InstallFromDiskAction.hasValidExtension(fileToSelect)) {
            fileToSelect = InstallFromDiskAction.getFileToSelect(PropertiesComponent.getInstance().getValue(PLUGINS_PRESELECTION_PATH));
        }
        if ((chosenFile = FileChooser.chooseFile((FileChooserDescriptor)(descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(IdeBundle.message((String)"install.plugin.chooser.title", (Object[])new Object[0])).withDescription(IdeBundle.message((String)"install.plugin.chooser.description", (Object[])new Object[0])).withExtensionFilter(IdeBundle.message((String)"install.plugin.chooser.label", (Object[])new Object[0]), new String[]{"zip", "jar"})), (Component)parentComponent, (Project)project2, (VirtualFile)fileToSelect)) != null) {
            PropertiesComponent.getInstance().setValue(PLUGINS_PRESELECTION_PATH, chosenFile.getParent().getPath());
            InstallFromDiskAction.installPluginFromDisk(chosenFile.toNioPath(), project2, tableModel2, pluginEnabler, parentComponent, callback);
        }
    }

    private static boolean hasValidExtension(VirtualFile file2) {
        String extension = file2.getExtension();
        return extension != null && Set.of("zip", "jar").contains(extension.toLowerCase(Locale.ROOT));
    }

    @RequiresEdt
    private static void installPluginFromDisk(Path file2, @Nullable Project project2, @NotNull InstalledPluginsTableModel tableModel2, @NotNull PluginEnabler pluginEnabler, @Nullable JComponent parentComponent, @NotNull Consumer<? super PluginInstallCallbackData> callback) {
        if (tableModel2 == null) {
            InstallFromDiskAction.$$$reportNull$$$0(10);
        }
        if (pluginEnabler == null) {
            InstallFromDiskAction.$$$reportNull$$$0(11);
        }
        if (callback == null) {
            InstallFromDiskAction.$$$reportNull$$$0(12);
        }
        ThreadingAssertions.assertEventDispatchThread();
        PluginInstaller.installFromDisk(tableModel2, pluginEnabler, file2, project2, parentComponent, callback);
    }

    @RequiresEdt
    protected void onPluginInstalledFromDisk(@NotNull PluginInstallCallbackData callbackData, @Nullable Project project2) {
        if (callbackData == null) {
            InstallFromDiskAction.$$$reportNull$$$0(13);
        }
        ThreadingAssertions.assertEventDispatchThread();
        PluginInstaller.installPluginFromCallbackData(callbackData);
    }

    @Nullable
    private static VirtualFile getFileToSelect(@Nullable String path) {
        return path != null ? StandardFileSystems.local().findFileByPath(path) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginEnabler";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/InstallFromDiskAction";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableModel";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/InstallFromDiskAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "installPluginFromDisk";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doInstall";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onPluginInstalledFromDisk";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

