/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.ImageObserver;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PluginImagesComponent
extends JPanel {
    private static final Color CURRENT_IMAGE_FILL_COLOR = JBColor.namedColor((String)"Plugins.ScreenshotPagination.CurrentImage.fillColor", (Color)new JBColor(7106686, 13553878));
    private static final int None = -1;
    private static final int NextImage = -2;
    private static final int PrevImage = -3;
    private static final int FullScreen = -4;
    private final Cursor myHandCursor;
    private final Object myLock;
    private JComponent myParent;
    private final boolean myShowFullContent;
    private List<Image> myImages;
    private int myCurrentImage;
    private boolean myHovered;
    private Object myLoadingState;
    private Object myShowState;
    private JBPopup myFullScreenPopup;

    public PluginImagesComponent() {
        this.myHandCursor = Cursor.getPredefinedCursor(12);
        this.myLock = new Object();
        this.myShowFullContent = false;
        MouseAdapter listener2 = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PluginImagesComponent.this.handleClick(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                PluginImagesComponent.this.handleMMove(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PluginImagesComponent.this.myHovered = true;
                PluginImagesComponent.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PluginImagesComponent.this.myHovered = false;
                PluginImagesComponent.this.repaint();
            }
        };
        this.addMouseListener(listener2);
        this.addMouseMotionListener(listener2);
    }

    private PluginImagesComponent(@NotNull List<Image> images, int currentImage) {
        if (images == null) {
            PluginImagesComponent.$$$reportNull$$$0(0);
        }
        this.myHandCursor = Cursor.getPredefinedCursor(12);
        this.myLock = new Object();
        this.myShowFullContent = true;
        this.myHovered = true;
        this.myImages = images;
        this.myCurrentImage = currentImage;
        this.setOpaque(false);
        MouseAdapter listener2 = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PluginImagesComponent.this.handleClick(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                PluginImagesComponent.this.handleMMove(e);
            }
        };
        this.addMouseListener(listener2);
        this.addMouseMotionListener(listener2);
    }

    public void setParent(@NotNull JComponent parent) {
        if (parent == null) {
            PluginImagesComponent.$$$reportNull$$$0(1);
        }
        this.myParent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(@NotNull PluginUiModel model2) {
        Object state2;
        if (model2 == null) {
            PluginImagesComponent.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myImages = null;
            state2 = this.myLoadingState = new Object();
            this.myShowState = null;
        }
        this.loadImages(model2, state2);
        this.fullRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleImages(@NotNull Object state2, @Nullable List<Image> images) {
        if (state2 == null) {
            PluginImagesComponent.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLoadingState != state2) {
                return;
            }
            this.myShowState = state2;
            this.myLoadingState = null;
            this.myImages = images;
            this.myCurrentImage = 0;
        }
        if (this.myFullScreenPopup != null) {
            this.myFullScreenPopup.cancel();
            this.myFullScreenPopup = null;
        }
        this.fullRepaint();
    }

    private void fullRepaint() {
        Container parent = this.getParent();
        if (parent != null) {
            parent.doLayout();
            parent.revalidate();
            parent.repaint();
        }
    }

    private void loadImages(@NotNull PluginUiModel model2, @NotNull Object state2) {
        if (model2 == null) {
            PluginImagesComponent.$$$reportNull$$$0(4);
        }
        if (state2 == null) {
            PluginImagesComponent.$$$reportNull$$$0(5);
        }
        if (!model2.isFromMarketplace() || model2.getExternalPluginIdForScreenShots() == null || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.handleImages(state2, null);
            return;
        }
        List<String> screenShots = model2.getScreenShots();
        if (ContainerUtil.isEmpty(screenShots)) {
            this.handleImages(state2, null);
            return;
        }
        ProcessIOExecutorService.INSTANCE.execute(() -> {
            ArrayList<Image> images = new ArrayList<Image>();
            File parentDir = new File(PathManager.getPluginTempPath(), "imageCache/" + model2.getExternalPluginIdForScreenShots());
            for (String screenShot : screenShots) {
                try {
                    String name2 = Objects.requireNonNull(StringUtil.substringAfterLast((String)screenShot, (String)"/"));
                    File imageFile = new File(parentDir, name2);
                    if (ApplicationManager.getApplication().isDisposed()) {
                        return;
                    }
                    MarketplaceRequests.Companion.readOrUpdateFile(imageFile.toPath(), screenShot, null, "", stream -> {
                        IOUtil.closeSafe((Logger)Logger.getInstance(PluginImagesComponent.class), (Closeable[])new Closeable[]{stream});
                        return new Object();
                    });
                    Image image2 = Toolkit.getDefaultToolkit().getImage(imageFile.getAbsolutePath());
                    if (image2 == null || image2.getWidth(null) <= 0 || image2.getHeight(null) <= 0) {
                        try (FileInputStream stream2 = new FileInputStream(imageFile);){
                            image2 = ImageIO.read(stream2);
                        }
                    }
                    if (image2 == null || image2.getWidth(null) <= 0 || image2.getHeight(null) <= 0) {
                        Logger.getInstance(PluginImagesComponent.class).info("=== Plugin: " + String.valueOf(model2.getPluginId()) + " screenshot: " + name2 + " not loaded ===");
                        continue;
                    }
                    images.add(image2);
                    if (images.size() < 10) continue;
                    break;
                }
                catch (IOException e) {
                    Logger.getInstance(PluginImagesComponent.class).warn((Throwable)e);
                }
            }
            ApplicationManager.getApplication().invokeLater(() -> this.handleImages(state2, images), ModalityState.stateForComponent((Component)this));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        int width = 0;
        int height = 0;
        Container parent = this.getParent();
        if (parent != null) {
            boolean isImages;
            Object object = this.myLock;
            synchronized (object) {
                isImages = !ContainerUtil.isEmpty(this.myImages);
            }
            if (isImages) {
                width = this.getFullWidth();
                height = (int)((double)width / 1.58) + JBUI.scale((int)28);
            }
        }
        return new Dimension(width, height);
    }

    private int getFullWidth() {
        Container parent = this.getParent();
        if (parent != null && this.myParent != null) {
            return this.myParent.getWidth() - parent.getInsets().left;
        }
        return this.getWidth();
    }

    private void handleMMove(@NotNull MouseEvent e) {
        int state2;
        Cursor newCursor;
        if (e == null) {
            PluginImagesComponent.$$$reportNull$$$0(6);
        }
        Cursor cursor = newCursor = (state2 = this.handleEvent(e, true)) == -1 ? null : this.myHandCursor;
        if (this.getCursor() != newCursor) {
            this.setCursor(newCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClick(@NotNull MouseEvent e) {
        if (e == null) {
            PluginImagesComponent.$$$reportNull$$$0(7);
        }
        if (e.getButton() != 1) {
            return;
        }
        int state2 = this.handleEvent(e, false);
        if (state2 == -1) {
            return;
        }
        if (state2 >= 0) {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myCurrentImage != state2) {
                    this.myCurrentImage = state2;
                    this.repaint();
                }
            }
        } else if (state2 == -4) {
            this.handleFullScreen();
        } else {
            this.showNextImage(state2 == -3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleEvent(@NotNull MouseEvent e, boolean cutFullScreen) {
        int count;
        int mouseY;
        if (e == null) {
            PluginImagesComponent.$$$reportNull$$$0(8);
        }
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.top;
        int width = this.getFullWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom;
        int offset = JBUI.scale((int)28);
        int offset2 = offset * 2;
        int actionOffset = JBUI.scale((int)8);
        int actionSize = this.getActionSize();
        int leftActionX = x + actionOffset;
        int rightActionX = x + width - actionOffset - actionSize;
        int actionY = y + (height - offset - actionSize) / 2;
        int mouseX = e.getX();
        if (new Rectangle(leftActionX, actionY, actionSize, actionSize).contains(mouseX, mouseY = e.getY())) {
            return -3;
        }
        if (new Rectangle(rightActionX, actionY, actionSize, actionSize).contains(mouseX, mouseY)) {
            return -2;
        }
        if (new Rectangle(x + offset, y, width - offset2, height - offset).contains(mouseX, mouseY)) {
            if (cutFullScreen && !new Rectangle(x + offset2, y, width - 2 * offset2, height - offset).contains(mouseX, mouseY)) {
                return -1;
            }
            return -4;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (ContainerUtil.isEmpty(this.myImages)) {
                return -1;
            }
            count = this.myImages.size();
        }
        if (count < 2) {
            return -1;
        }
        int ovalSize = JBUI.scale((int)(this.myShowFullContent ? 8 : 6));
        int ovalGap = JBUI.scale((int)14);
        int ovalsWidth = count * ovalSize + (count - 1) * ovalGap;
        int ovalX = x + (width - ovalsWidth) / 2;
        int ovalY = insets.top + height - (offset + ovalSize) / 2;
        Rectangle bounds = new Rectangle(ovalX, ovalY, ovalSize, ovalSize);
        for (int i2 = 0; i2 < count; ++i2) {
            if (bounds.contains(mouseX, mouseY)) {
                return i2;
            }
            bounds.x += ovalSize + ovalGap;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFullScreen() {
        Object showState;
        int current;
        List<Image> images;
        if (this.myFullScreenPopup != null) {
            this.myFullScreenPopup.cancel();
        }
        if (this.myShowFullContent) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (ContainerUtil.isEmpty(this.myImages)) {
                return;
            }
            images = this.myImages;
            current = this.myCurrentImage;
            showState = this.myShowState;
        }
        final PluginImagesComponent component2 = new PluginImagesComponent(images, current);
        Wrapper panel2 = new Wrapper((JComponent)component2);
        panel2.setPreferredSize(this.getGraphicsConfiguration().getBounds().getSize());
        component2.myFullScreenPopup = this.myFullScreenPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)component2).createPopup();
        component2.myShowState = showState;
        this.myFullScreenPopup.addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                Window window = SwingUtilities.getWindowAncestor(event.asPopup().getContent());
                window.setBackground(Gray.TRANSPARENT);
                window.setOpacity(0.95f);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                PluginImagesComponent.this.myFullScreenPopup = null;
                Object object = PluginImagesComponent.this.myLock;
                synchronized (object) {
                    if (PluginImagesComponent.this.myShowState == component2.myShowState && component2.myCurrentImage != PluginImagesComponent.this.myCurrentImage) {
                        PluginImagesComponent.this.myCurrentImage = component2.myCurrentImage;
                    }
                }
                PluginImagesComponent.this.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginImagesComponent$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeShown";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myFullScreenPopup.showInScreenCoordinates((Component)this, new Point());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showNextImage(boolean left) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myImages == null) {
                return;
            }
            int count = this.myImages.size();
            if (count < 2) {
                return;
            }
            this.myCurrentImage = left ? (this.myCurrentImage > 0 ? --this.myCurrentImage : count - 1) : (this.myCurrentImage < count - 1 ? ++this.myCurrentImage : 0);
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.myShowFullContent) {
            Graphics2D g2d = (Graphics2D)g.create();
            try {
                g2d.setBackground(Gray.get((int)158, (int)158));
                g2d.clearRect(0, 0, this.getWidth(), this.getHeight());
                g2d.setComposite(AlphaComposite.getInstance(3, 0.95f));
                this.paintComponent(g);
                return;
            }
            finally {
                g2d.dispose();
            }
        }
        super.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Image image2;
        int current;
        int count;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myImages == null) {
                return;
            }
            count = this.myImages.size();
            if (count == 0) {
                return;
            }
            current = this.myCurrentImage;
            image2 = this.myImages.get(current);
        }
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.top;
        int width = this.getFullWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom;
        int offset = JBUI.scale((int)28);
        if (!this.myShowFullContent) {
            g.setColor(PluginManagerConfigurable.MAIN_BG_COLOR);
            g.fillRect(x, y, width, height);
        }
        int imageX = insets.left + offset;
        int imageY = insets.top;
        int imageWidth = image2.getWidth(this);
        int imageHeight = image2.getHeight(this);
        int paintWidth = width - 2 * offset;
        int paintHeight = height - offset;
        if (imageWidth <= paintWidth && imageHeight <= paintHeight) {
            StartupUiUtil.drawImage((Graphics)g, (Image)image2, (int)(imageX + (paintWidth - imageWidth) / 2), (int)(imageY + (paintHeight - imageHeight) / 2), (ImageObserver)this);
        } else {
            int zoomedHeight = imageHeight * paintWidth / imageWidth;
            int zoomedWidth = imageWidth * paintHeight / imageHeight;
            if (zoomedWidth <= paintWidth) {
                StartupUiUtil.drawImage((Graphics)g, (Image)image2, (Rectangle)new Rectangle(imageX + (paintWidth - zoomedWidth) / 2, imageY, zoomedWidth, paintHeight), (ImageObserver)this);
            } else if (zoomedHeight <= paintHeight) {
                StartupUiUtil.drawImage((Graphics)g, (Image)image2, (Rectangle)new Rectangle(imageX, imageY + (paintHeight - zoomedHeight) / 2, paintWidth, zoomedHeight), (ImageObserver)this);
            } else {
                StartupUiUtil.drawImage((Graphics)g, (Image)image2, (Rectangle)new Rectangle(imageX, imageY, paintWidth, paintHeight), (ImageObserver)this);
            }
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            if (!this.myShowFullContent) {
                g2.setColor(PluginManagerConfigurable.SEARCH_FIELD_BORDER_COLOR);
                g2.draw(new RoundRectangle2D.Float(x, y, width - 1, height - offset, 7.0f, 7.0f));
            }
            if (count < 2) {
                return;
            }
            int ovalSize = JBUI.scale((int)(this.myShowFullContent ? 8 : 6));
            int ovalGap = JBUI.scale((int)14);
            int ovalsWidth = count * ovalSize + (count - 1) * ovalGap;
            int ovalX = x + (width - ovalsWidth) / 2;
            int ovalY = insets.top + height - (offset + ovalSize) / 2;
            for (int i2 = 0; i2 < count; ++i2) {
                if (i2 == current) {
                    g2.setColor(CURRENT_IMAGE_FILL_COLOR);
                    g2.fillOval(ovalX, ovalY, ovalSize, ovalSize);
                } else {
                    g2.setColor(JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)false));
                    g2.drawOval(ovalX, ovalY, ovalSize - 1, ovalSize - 1);
                }
                ovalX += ovalSize + ovalGap;
            }
            if (this.myHovered) {
                this.paintAction(g2, x, y, width, height, offset, true);
                this.paintAction(g2, x, y, width, height, offset, false);
            }
        }
        finally {
            g2.dispose();
        }
    }

    private void paintAction(Graphics2D g2, int x, int y, int width, int height, int offset, boolean left) {
        int actionOffset = JBUI.scale((int)8);
        int actionSize = this.getActionSize();
        int actionX = left ? x + actionOffset : x + width - actionOffset - actionSize;
        int actionY = y + (height - offset - actionSize) / 2;
        g2.setColor(JBUI.CurrentTheme.Button.buttonColorStart());
        g2.fillOval(actionX, actionY, actionSize, actionSize);
        g2.setColor(JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)false));
        g2.drawOval(actionX, actionY, actionSize, actionSize);
        Icon icon2 = left ? AllIcons.Actions.ArrowCollapse : AllIcons.Actions.ArrowExpand;
        int iconWidth = icon2.getIconWidth();
        int iconHeight = icon2.getIconHeight();
        icon2.paintIcon(this, g2, actionX += (actionSize - iconWidth) / 2, actionY += (actionSize - iconHeight) / 2);
    }

    private int getActionSize() {
        return JBUI.scale((int)(this.myShowFullContent ? 48 : 28));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "images";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/newui/PluginImagesComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setParent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "handleImages";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "loadImages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "handleMMove";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "handleClick";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "handleEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

