/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.UIThemeExportableBean;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.svg.SvgKt;
import com.intellij.util.SVGLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Objects;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIThemeLookAndFeelInfoImpl
extends UIManager.LookAndFeelInfo
implements UIThemeLookAndFeelInfo {
    private final UITheme theme;
    private boolean isInitialized;
    private boolean restartRequired;

    public UIThemeLookAndFeelInfoImpl(@NotNull UITheme theme) {
        if (theme == null) {
            UIThemeLookAndFeelInfoImpl.$$$reportNull$$$0(0);
        }
        super(theme.getName(), theme.isDark() ? "com.intellij.ide.ui.laf.darcula.DarculaLaf" : "com.intellij.ide.ui.laf.IntelliJLaf");
        this.theme = theme;
    }

    @Override
    @Nls
    @NotNull
    public String getName() {
        String string = Objects.requireNonNullElse(this.theme.getName(), this.theme.getId());
        if (string == null) {
            UIThemeLookAndFeelInfoImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public final String getId() {
        String string = this.theme.getId();
        if (string == null) {
            UIThemeLookAndFeelInfoImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public final String getAuthor() {
        return this.theme.getAuthor();
    }

    public final boolean isDark() {
        return this.theme.isDark();
    }

    @Nullable
    public String getEditorSchemeId() {
        return IdeUICustomization.getInstance().getUiThemeEditorSchemeId(this.theme.getId(), this.theme.getEditorSchemeId());
    }

    @NotNull
    public UITheme getTheme() {
        UITheme uITheme = this.theme;
        if (uITheme == null) {
            UIThemeLookAndFeelInfoImpl.$$$reportNull$$$0(3);
        }
        return uITheme;
    }

    @NotNull
    public ClassLoader getProviderClassLoader() {
        ClassLoader classLoader = this.theme.getProviderClassLoader();
        if (classLoader == null) {
            UIThemeLookAndFeelInfoImpl.$$$reportNull$$$0(4);
        }
        return classLoader;
    }

    public void installTheme(UIDefaults defaults) {
        defaults.put("ui.theme.is.dark", (Object)this.theme.isDark());
        defaults.put("ClassLoader", this.theme.getProviderClassLoader());
        this.theme.applyTheme(defaults);
        IconPathPatcher patcher = this.theme.patcher;
        if (patcher != null) {
            IconLoader.installPathPatcher((IconPathPatcher)patcher);
        }
        SvgKt.setSelectionColorPatcherProvider((SVGLoader.SvgElementColorPatcherProvider)this.theme.selectionColorPatcher);
        SVGLoader.SvgElementColorPatcherProvider colorPatcher = this.theme.getColorPatcher();
        if (colorPatcher != null) {
            SVGLoader.setColorPatcherProvider((SVGLoader.SvgElementColorPatcherProvider)colorPatcher);
        }
        this.installBackgroundImage();
        AppUIUtil.updateForDarcula(this.theme.isDark());
        this.isInitialized = true;
    }

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    @Nullable
    protected InputStream getResourceAsStream(@NotNull String path) {
        if (path == null) {
            UIThemeLookAndFeelInfoImpl.$$$reportNull$$$0(5);
        }
        return this.getTheme().getProviderClassLoader().getResourceAsStream(path);
    }

    public void installEditorScheme(@Nullable EditorColorsScheme previousEditorColorSchemeForLaf) {
        String name2;
        EditorColorsManager editorColorManager = EditorColorsManager.getInstance();
        EditorColorsScheme editorColorSchemeToSet = previousEditorColorSchemeForLaf;
        if (editorColorSchemeToSet == null && (name2 = this.getEditorSchemeId()) != null) {
            editorColorSchemeToSet = editorColorManager.getScheme(name2);
        }
        if (editorColorSchemeToSet != null) {
            editorColorManager.setCurrentSchemeOnLafChange(editorColorSchemeToSet);
        }
    }

    private void installBackgroundImage() {
        boolean installed = this.installBackgroundImage(this.theme.getBackground(), "idea.background.editor");
        boolean bl = installed = this.installBackgroundImage(this.theme.getEmptyFrameBackground(), "idea.background.frame") || installed;
        if (installed) {
            IdeBackgroundUtil.resetBackgroundImagePainters();
        }
    }

    private boolean installBackgroundImage(@NotNull Map<String, Object> backgroundProps, @NotNull @NonNls String bgImageProperty) {
        Object path;
        if (backgroundProps == null) {
            UIThemeLookAndFeelInfoImpl.$$$reportNull$$$0(6);
        }
        if (bgImageProperty == null) {
            UIThemeLookAndFeelInfoImpl.$$$reportNull$$$0(7);
        }
        return (path = backgroundProps.get("image")) instanceof String && this.installBackgroundImage(backgroundProps, bgImageProperty, (String)path);
    }

    private boolean installBackgroundImage(@NotNull Map<String, Object> backgroundProps, @NotNull @NonNls String bgImageProperty, @NotNull @NonNls String path) {
        if (backgroundProps == null) {
            UIThemeLookAndFeelInfoImpl.$$$reportNull$$$0(8);
        }
        if (bgImageProperty == null) {
            UIThemeLookAndFeelInfoImpl.$$$reportNull$$$0(9);
        }
        if (path == null) {
            UIThemeLookAndFeelInfoImpl.$$$reportNull$$$0(10);
        }
        try {
            Path tmpImage = FileUtil.createTempFile((String)"ijBackgroundImage", (String)path.substring(path.lastIndexOf(".")), (boolean)true).toPath();
            InputStream stream = this.getResourceAsStream(path);
            if (stream == null) {
                throw new IllegalArgumentException("Can't load background: " + path);
            }
            try (InputStream inputStream = stream;){
                Files.copy(stream, tmpImage, StandardCopyOption.REPLACE_EXISTING);
            }
            Object transparency = backgroundProps.get("transparency");
            String alpha = String.valueOf(transparency instanceof Integer ? (Integer)transparency : 15);
            String fill = UIThemeLookAndFeelInfoImpl.parseEnumValue(backgroundProps.get("fill"), IdeBackgroundUtil.Fill.SCALE);
            String anchor = UIThemeLookAndFeelInfoImpl.parseEnumValue(backgroundProps.get("anchor"), IdeBackgroundUtil.Anchor.CENTER);
            String spec = String.join((CharSequence)",", tmpImage.toString(), alpha, fill, anchor);
            PropertiesComponent propertyComponent = PropertiesComponent.getInstance();
            String currentSpec = propertyComponent.getValue(bgImageProperty);
            propertyComponent.setValue("old." + bgImageProperty, currentSpec);
            propertyComponent.setValue(bgImageProperty, spec);
            return true;
        }
        catch (IOException e) {
            Logger.getInstance(this.getClass()).error((Throwable)e);
            return false;
        }
    }

    @NotNull
    public UIThemeExportableBean describe() {
        UIThemeExportableBean uIThemeExportableBean = this.theme.describe();
        if (uIThemeExportableBean == null) {
            UIThemeLookAndFeelInfoImpl.$$$reportNull$$$0(11);
        }
        return uIThemeExportableBean;
    }

    @ApiStatus.Internal
    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    @ApiStatus.Internal
    public void setRestartRequired(boolean restartRequired) {
        this.restartRequired = restartRequired;
    }

    private static <T extends Enum<T>> String parseEnumValue(Object value, T defaultValue) {
        if (value instanceof String) {
            String name2 = Strings.toUpperCase((String)((String)value));
            for (Enum t : (Enum[])defaultValue.getClass().getEnumConstants()) {
                if (!t.name().equals(name2)) continue;
                return Strings.toLowerCase((String)value.toString());
            }
        }
        return Strings.toLowerCase((String)defaultValue.name());
    }

    public void dispose() {
        IconPathPatcher patcher = this.theme.patcher;
        if (patcher != null) {
            IconLoader.removePathPatcher((IconPathPatcher)patcher);
        }
        SVGLoader.setColorPatcherProvider(null);
        this.unsetBackgroundProperties("idea.background.editor");
        this.unsetBackgroundProperties("idea.background.frame");
        this.isInitialized = false;
    }

    private void unsetBackgroundProperties(String backgroundPropertyKey) {
        PropertiesComponent propertyManager = PropertiesComponent.getInstance();
        String value = propertyManager.getValue("old." + backgroundPropertyKey);
        propertyManager.unsetValue("old." + backgroundPropertyKey);
        if (value != null) {
            propertyManager.setValue(backgroundPropertyKey, value);
        } else if (!this.theme.getBackground().isEmpty()) {
            propertyManager.unsetValue(backgroundPropertyKey);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theme";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/UIThemeLookAndFeelInfoImpl";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundProps";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bgImageProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/UIThemeLookAndFeelInfoImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTheme";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderClassLoader";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsStream";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "installBackgroundImage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 11 -> new IllegalStateException(string);
        };
    }
}

