/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxRenderer;
import com.intellij.ide.ui.laf.darcula.ui.DarculaJBPopupComboPopup;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComboBoxCompositeEditor;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.OffsetIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.WindowRoundedCornersManager;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.listCellRenderer.KotlinUIDslRendererComponent;
import com.intellij.ui.popup.list.ComboBoxPopup;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.basic.DefaultMenuLayout;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class DarculaComboBoxUI
extends BasicComboBoxUI
implements Border,
ErrorBorderCapable {
    public static final Key<Boolean> PAINT_VERTICAL_LINE = Key.create((String)"PAINT_VERTICAL_LINE");
    public static final String DISABLE_SETTING_FOREGROUND = "disable.setting.foreground";
    private static final Color NON_EDITABLE_BACKGROUND = JBColor.namedColor((String)"ComboBox.nonEditableBackground", (Color)JBColor.namedColor((String)"ComboBox.darcula.nonEditableBackground", (Color)new JBColor(0xFCFCFC, 3948353)));
    protected static final int DEFAULT_BORDER_COMPENSATION = 1;
    private final float myArc;
    private final Insets myBorderCompensation;
    private boolean myPaintArrowButton;
    private KeyListener editorKeyListener;
    private FocusListener editorFocusListener;
    private PropertyChangeListener propertyListener;

    public DarculaComboBoxUI() {
        this(DarculaUIUtil.COMPONENT_ARC.getFloat(), (Insets)JBUI.insets((int)1), true);
    }

    @Deprecated
    public DarculaComboBoxUI(float arc, Insets borderCompensation, boolean paintArrowButton) {
        this.myArc = arc;
        this.myBorderCompensation = borderCompensation;
        this.myPaintArrowButton = paintArrowButton;
    }

    @Deprecated
    public DarculaComboBoxUI(JComboBox c) {
        this();
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarculaComboBoxUI();
    }

    @ApiStatus.Internal
    protected boolean isNewBorderSupported(@NotNull JComboBox<?> comboBox) {
        if (comboBox == null) {
            DarculaComboBoxUI.$$$reportNull$$$0(0);
        }
        ComboBoxUI ui = comboBox.getUI();
        if (!(comboBox.getBorder() instanceof DarculaComboBoxBorder)) {
            return false;
        }
        if (!(ui instanceof DarculaComboBoxUI) || ui.getClass() != DarculaComboBoxUI.class) {
            return false;
        }
        return this.myArc == DarculaUIUtil.COMPONENT_ARC.getFloat() && this.myBorderCompensation instanceof JBInsets && this.myBorderCompensation.equals(JBUI.insets((int)1));
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (this.comboBox.getBorder() == null) {
            this.comboBox.setBorder(this);
        }
    }

    @Override
    protected ListCellRenderer<Object> createRenderer() {
        if (ExperimentalUI.isNewUI()) {
            return new DarculaComboBoxRenderer();
        }
        return super.createRenderer();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.comboBox.getBorder() == this) {
            this.comboBox.setBorder(null);
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyListener = this.createPropertyListener();
        this.comboBox.addPropertyChangeListener(this.propertyListener);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this.propertyListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyListener);
            this.propertyListener = null;
        }
    }

    public boolean isPaintArrowButton() {
        return this.myPaintArrowButton;
    }

    public void setPaintArrowButton(boolean paintArrowButton) {
        this.myPaintArrowButton = paintArrowButton;
    }

    public static boolean hasSwingPopup(JComponent component2) {
        return component2.getClientProperty("ComboBox.jbPopup") == null;
    }

    @ApiStatus.Internal
    public ComboPopup getPopup() {
        return this.popup;
    }

    @Override
    protected ComboPopup createPopup() {
        return DarculaComboBoxUI.hasSwingPopup(this.comboBox) ? new CustomComboPopup(this.comboBox) : new DarculaJBPopupComboPopup(this.comboBox);
    }

    protected PropertyChangeListener createPropertyListener() {
        return e -> {
            EditorTextField etf;
            if ("enabled".equals(e.getPropertyName()) && (etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class))) != null) {
                boolean enabled2 = e.getNewValue() == Boolean.TRUE;
                Color color = UIManager.getColor(enabled2 ? "TextField.background" : "ComboBox.disabledBackground");
                etf.setBackground(color);
            }
        };
    }

    @Override
    protected JButton createArrowButton() {
        Color bg = this.comboBox.getBackground();
        Color fg = this.comboBox.getForeground();
        BasicArrowButton button2 = new BasicArrowButton(5, bg, fg, fg, fg){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                try {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                    Rectangle r = DarculaComboBoxUI.getArrowButtonRect(this);
                    g2.translate(r.x, r.y);
                    if (DarculaComboBoxUI.this.myPaintArrowButton) {
                        float lw;
                        float arc = DarculaComboBoxUI.this.myArc;
                        float bw = DarculaUIUtil.BW.getFloat();
                        arc = arc > bw + (lw = DarculaUIUtil.LW.getFloat()) ? arc - bw - lw : 0.0f;
                        Path2D.Float innerShape = new Path2D.Float();
                        ((Path2D)innerShape).moveTo(lw, lw);
                        ((Path2D)innerShape).lineTo((float)r.width - lw - arc, lw);
                        ((Path2D)innerShape).quadTo((float)r.width - lw, lw, (float)r.width - lw, lw + arc);
                        ((Path2D)innerShape).lineTo((float)r.width - lw, (float)r.height - lw - arc);
                        ((Path2D)innerShape).quadTo((float)r.width - lw, (float)r.height - lw, (float)r.width - lw - arc, (float)r.height - lw);
                        ((Path2D)innerShape).lineTo(lw, (float)r.height - lw);
                        innerShape.closePath();
                        g2.setColor(JBUI.CurrentTheme.Arrow.backgroundColor((boolean)DarculaComboBoxUI.this.comboBox.isEnabled(), (boolean)DarculaComboBoxUI.this.comboBox.isEditable()));
                        g2.fill(innerShape);
                        if (DarculaComboBoxUI.this.comboBox.isEditable() || ClientProperty.isTrue((Component)DarculaComboBoxUI.this.comboBox, PAINT_VERTICAL_LINE)) {
                            g2.setColor(DarculaUIUtil.getOutlineColor(DarculaComboBoxUI.this.comboBox.isEnabled(), false));
                            g2.fill(new Rectangle2D.Float(0.0f, lw, DarculaUIUtil.LW.getFloat(), (float)r.height - lw * 2.0f));
                        }
                    }
                    g2.translate(-r.x, -r.y + JBUI.scale((int)1));
                    DarculaComboBoxUI.this.paintArrow(g2, this);
                }
                finally {
                    g2.dispose();
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return DarculaComboBoxUI.getArrowButtonPreferredSize(DarculaComboBoxUI.this.comboBox);
            }
        };
        button2.setBorder((Border)JBUI.Borders.empty());
        button2.setOpaque(false);
        return button2;
    }

    static Rectangle getArrowButtonRect(AbstractButton button2) {
        Rectangle result2 = new Rectangle(button2.getSize());
        JBInsets.removeFrom((Rectangle)result2, (Insets)JBUI.insets((int)1, (int)0, (int)1, (int)1));
        int bw = DarculaUIUtil.BW.get();
        JBInsets.removeFrom((Rectangle)result2, (Insets)new Insets(bw, 0, bw, bw));
        return result2;
    }

    protected void paintArrow(Graphics2D g2, JButton btn) {
        if (ExperimentalUI.isNewUI()) {
            Icon icon2 = this.comboBox.isEnabled() ? AllIcons.General.ChevronDown : IconLoader.getDisabledIcon((Icon)AllIcons.General.ChevronDown);
            Rectangle r = DarculaComboBoxUI.getArrowButtonRect(btn);
            icon2.paintIcon(btn, g2, r.x + (r.width - icon2.getIconWidth()) / 2, r.y + (r.height - icon2.getIconHeight()) / 2);
        } else {
            g2.setColor(JBUI.CurrentTheme.Arrow.foregroundColor((boolean)this.comboBox.isEnabled()));
            g2.fill(DarculaComboBoxUI.getArrowShape(btn));
        }
    }

    private static Dimension getMinimumSize(@NotNull JComboBox<?> comboBox) {
        if (comboBox == null) {
            DarculaComboBoxUI.$$$reportNull$$$0(1);
        }
        Dimension result2 = JBUI.CurrentTheme.ComboBox.minimumSize();
        return DarculaUIUtil.isBorderless(comboBox) ? new Dimension(result2.width, result2.height - JBUIScale.scale((int)4)) : result2;
    }

    @NotNull
    private static Dimension getArrowButtonPreferredSize(@NotNull JComboBox<?> comboBox) {
        if (comboBox == null) {
            DarculaComboBoxUI.$$$reportNull$$$0(2);
        }
        Insets i2 = comboBox.getInsets();
        int height = (DarculaUIUtil.isCompact(comboBox) ? DarculaUIUtil.COMPACT_HEIGHT.get() : DarculaComboBoxUI.getMinimumSize(comboBox).height) + i2.top + i2.bottom;
        return new Dimension(JBUI.CurrentTheme.Component.ARROW_AREA_WIDTH.get() + i2.right, height);
    }

    static Shape getArrowShape(Component button2) {
        Rectangle r = new Rectangle(button2.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1, (int)0, (int)1, (int)1));
        int tW = JBUIScale.scale((int)9);
        int tH = JBUIScale.scale((int)5);
        int xU = (r.width - tW) / 2 - JBUIScale.scale((int)1);
        int yU = (r.height - tH) / 2 + JBUIScale.scale((int)1);
        Path2D.Float path = new Path2D.Float();
        ((Path2D)path).moveTo(xU, yU);
        ((Path2D)path).lineTo(xU + tW, yU);
        ((Path2D)path).lineTo((float)xU + (float)tW / 2.0f, yU + tH);
        ((Path2D)path).lineTo(xU, yU);
        path.closePath();
        return path;
    }

    @ApiStatus.Internal
    @NotNull
    static JBInsets getDefaultComboBoxInsets() {
        JBInsets jBInsets = JBUI.insets((int)3);
        if (jBInsets == null) {
            DarculaComboBoxUI.$$$reportNull$$$0(3);
        }
        return jBInsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        this.checkFocus();
        parent = c.getParent();
        if (parent != null && c.isOpaque()) {
            g.setColor(DarculaUIUtil.isTableCellEditor(c) != false && this.editor != null ? this.editor.getBackground() : parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        g2 = (Graphics2D)g.create();
        var6_5 = this.comboBox.getBorder();
        if (!(var6_5 instanceof DarculaComboBoxBorder)) ** GOTO lbl-1000
        comboBoxBorder = (DarculaComboBoxBorder)var6_5;
        if (this.isNewBorderSupported(this.comboBox)) {
            comboBoxBorder.paintComboBoxBackground(g2, this.comboBox, this.getBackgroundColor());
        } else lbl-1000:
        // 2 sources

        {
            try {
                r = new Rectangle(c.getSize());
                JBInsets.removeFrom((Rectangle)r, (Insets)this.myBorderCompensation);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                g2.translate(r.x, r.y);
                bw = DarculaUIUtil.isBorderless(c) != false ? DarculaUIUtil.LW.getFloat() : DarculaUIUtil.BW.getFloat();
                g2.setColor(this.getBackgroundColor());
                g2.fill(this.getOuterShape(r, bw, this.myArc));
            }
            finally {
                g2.dispose();
            }
        }
        if (!this.comboBox.isEditable()) {
            this.paintCurrentValue(g, this.rectangleForCurrentValue(), this.hasFocus);
        }
        this.currentValuePane.removeAll();
    }

    private Color getBackgroundColor() {
        Color coloredItemColor;
        Color bg = this.comboBox.getBackground();
        if (this.comboBox.isEditable() && this.editor != null) {
            return this.comboBox.isEnabled() ? this.editor.getBackground() : (this.comboBox.isBackgroundSet() && !(bg instanceof UIResource) ? bg : UIUtil.getComboBoxDisabledBackground());
        }
        Object value = this.comboBox.getSelectedItem();
        Color color = coloredItemColor = value instanceof ColoredItem ? ((ColoredItem)value).getColor() : null;
        return (Color)ObjectUtils.notNull((Object)coloredItemColor, (Object)(this.comboBox.isBackgroundSet() && !(bg instanceof UIResource) ? bg : (this.comboBox.isEnabled() ? NON_EDITABLE_BACKGROUND : UIUtil.getComboBoxDisabledBackground())));
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        JComponent cc;
        JLabel cc2;
        SimpleColoredComponent cc3;
        boolean changeOpaque;
        ListCellRenderer<Object> renderer2 = this.comboBox.getRenderer();
        Object value = this.comboBox.getSelectedItem();
        Component c = renderer2.getListCellRendererComponent(this.listBox, value, -1, false, false);
        c.setFont(this.comboBox.getFont());
        c.setBackground(this.getBackgroundColor());
        if (!Boolean.TRUE.equals(this.comboBox.getClientProperty(DISABLE_SETTING_FOREGROUND))) {
            if (hasFocus && !this.isPopupVisible(this.comboBox)) {
                c.setForeground(this.listBox.getForeground());
            } else {
                c.setForeground(this.comboBox.isEnabled() ? this.comboBox.getForeground() : JBColor.namedColor((String)"ComboBox.disabledForeground", (Color)this.comboBox.getForeground()));
            }
        }
        boolean bl = changeOpaque = c instanceof JComponent && DarculaUIUtil.isTableCellEditor(this.comboBox) && c.isOpaque();
        if (changeOpaque) {
            ((JComponent)c).setOpaque(false);
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        Rectangle r = new Rectangle(bounds);
        Icon icon2 = null;
        Insets iPad = null;
        Border border = null;
        boolean enabled2 = true;
        if (c instanceof SimpleColoredComponent) {
            cc3 = (SimpleColoredComponent)c;
            iPad = cc3.getIpad();
            border = cc3.getBorder();
            enabled2 = cc3.isEnabled();
            cc3.setBorder((Border)JBUI.Borders.empty());
            cc3.setIpad((Insets)JBInsets.emptyInsets());
            cc3.setEnabled(this.comboBox.isEnabled());
            icon2 = cc3.getIcon();
            if (!cc3.isIconOnTheRight()) {
                cc3.setIcon(OffsetIcon.getOriginalIcon((Icon)icon2));
            }
        } else if (c instanceof JLabel) {
            cc2 = (JLabel)c;
            border = cc2.getBorder();
            cc2.setBorder((Border)JBUI.Borders.empty());
            icon2 = cc2.getIcon();
            cc2.setIcon(OffsetIcon.getOriginalIcon((Icon)icon2));
            String text2 = cc2.getText();
            int maxWidth = bounds.width - (this.padding == null || StartupUiUtil.isUnderDarcula() ? 0 : this.padding.right);
            if (StringUtil.isNotEmpty((String)text2) && cc2.getPreferredSize().width > maxWidth) {
                int max;
                int max0 = ObjectUtils.binarySearch((int)7, (int)(text2.length() - 1), idx -> {
                    cc2.setText(StringUtil.trimMiddle((String)text2, (int)idx));
                    return Integer.compare(cc.getPreferredSize().width, maxWidth);
                });
                int n = max = max0 < 0 ? -max0 - 2 : max0;
                if (max > 7 && max < text2.length()) {
                    cc2.setText(StringUtil.trimMiddle((String)text2, (int)max));
                }
            }
        } else if (c instanceof JComponent) {
            cc = (JComponent)c;
            border = cc.getBorder();
            cc.setBorder((Border)JBUI.Borders.empty());
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, r.x, r.y, r.width, r.height, shouldValidate);
        if (changeOpaque) {
            ((JComponent)c).setOpaque(true);
        }
        if (c instanceof SimpleColoredComponent) {
            cc3 = (SimpleColoredComponent)c;
            cc3.setIpad(iPad);
            cc3.setIcon(icon2);
            cc3.setBorder(border);
            cc3.setEnabled(enabled2);
        } else if (c instanceof JLabel) {
            cc2 = (JLabel)c;
            cc2.setBorder(border);
            cc2.setIcon(icon2);
        } else if (c instanceof JComponent) {
            cc = (JComponent)c;
            cc.setBorder(border);
        }
    }

    @Override
    protected ComboBoxEditor createEditor() {
        ComboBoxEditor comboBoxEditor = super.createEditor();
        if (comboBoxEditor instanceof BasicComboBoxEditor) {
            JTextField tf = (JTextField)comboBoxEditor.getEditorComponent();
            tf.setColumns(0);
        }
        return comboBoxEditor;
    }

    protected void installEditorKeyListener(@NotNull ComboBoxEditor cbe) {
        Component ec;
        if (cbe == null) {
            DarculaComboBoxUI.$$$reportNull$$$0(4);
        }
        if ((ec = cbe.getEditorComponent()) != null) {
            this.editorKeyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    this.process(e);
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    this.process(e);
                }

                private void process(KeyEvent e) {
                    int code = e.getKeyCode();
                    if ((code == 38 || code == 40) && e.getModifiers() == 0) {
                        DarculaComboBoxUI.this.comboBox.dispatchEvent(e);
                    }
                }
            };
            ec.addKeyListener(this.editorKeyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(c instanceof JComponent)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        float bw = DarculaUIUtil.BW.getFloat();
        Rectangle r = new Rectangle(x, y, width, height);
        try {
            this.checkFocus();
            if (!DarculaUIUtil.isTableCellEditor(c)) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                JBInsets.removeFrom((Rectangle)r, (Insets)this.myBorderCompensation);
                g2.translate(r.x, r.y);
                float lw = DarculaUIUtil.LW.getFloat();
                DarculaUIUtil.Outline op = DarculaUIUtil.getOutline(this.comboBox);
                if (this.comboBox.isEnabled() && op != null) {
                    DarculaUIUtil.paintOutlineBorder(g2, r.width, r.height, this.myArc, true, this.hasFocus, op);
                } else {
                    if (this.hasFocus && !DarculaUIUtil.isBorderless(c)) {
                        DarculaUIUtil.paintOutlineBorder(g2, r.width, r.height, this.myArc, true, true, DarculaUIUtil.Outline.focus);
                    }
                    this.paintBorder(c, g2, DarculaUIUtil.isBorderless(c) ? lw : bw, r, lw, this.myArc);
                }
            } else {
                DarculaUIUtil.paintCellEditorBorder(g2, c, r, this.hasFocus);
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Deprecated
    protected void paintBorder(Component c, Graphics2D g2, float bw, Rectangle r, float lw, float arc) {
        Path2D.Float border = new Path2D.Float(0);
        border.append(this.getOuterShape(r, bw, arc), false);
        arc = arc > lw ? arc - lw : 0.0f;
        border.append(this.getInnerShape(r, bw, lw, arc), false);
        if (this.hasFocus && DarculaUIUtil.isBorderless(c)) {
            DarculaUIUtil.Outline.focus.setGraphicsColor(g2, true);
        } else {
            g2.setColor(DarculaUIUtil.getOutlineColor(c.isEnabled(), this.hasFocus));
        }
        g2.fill(border);
    }

    @Deprecated
    protected RectangularShape getOuterShape(Rectangle r, float bw, float arc) {
        return new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc);
    }

    @Deprecated
    protected RectangularShape getInnerShape(Rectangle r, float bw, float lw, float arc) {
        return new RoundRectangle2D.Float(bw + lw, bw + lw, (float)r.width - (bw + lw) * 2.0f, (float)r.height - (bw + lw) * 2.0f, arc, arc);
    }

    protected void checkFocus() {
        this.hasFocus = DarculaComboBoxUI.hasComboBoxFocus(this.comboBox);
    }

    @ApiStatus.Internal
    public static boolean hasComboBoxFocus(JComboBox<?> comboBox) {
        if (!comboBox.isEnabled()) {
            return false;
        }
        if (DarculaComboBoxUI.hasFocus(comboBox)) {
            return true;
        }
        ComboBoxEditor ed = comboBox.getEditor();
        return ed != null && DarculaComboBoxUI.hasFocus(ed.getEditorComponent());
    }

    protected static boolean hasFocus(Component c) {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return owner != null && SwingUtilities.isDescendingFrom(owner, c);
    }

    @Override
    @Deprecated
    public Insets getBorderInsets(Component c) {
        return DarculaUIUtil.isTableCellEditor(c) || DarculaUIUtil.isCompact(c) ? JBInsets.create((int)2, (int)3) : (DarculaUIUtil.isBorderless(c) ? JBInsets.emptyInsets() : DarculaComboBoxUI.getDefaultComboBoxInsets());
    }

    @Override
    @Deprecated
    public final boolean isBorderOpaque() {
        return false;
    }

    protected Dimension getSizeWithButton(Dimension size2, Dimension editorSize) {
        Insets i2 = this.getInsets();
        Dimension abSize = DarculaComboBoxUI.getArrowButtonPreferredSize(this.comboBox);
        if (DarculaUIUtil.isCompact(this.comboBox) && size2 != null) {
            JBInsets.removeFrom((Dimension)size2, (Insets)this.padding);
        }
        Dimension minSize = DarculaComboBoxUI.getMinimumSize(this.comboBox);
        int editorHeight = editorSize != null ? editorSize.height + i2.top + i2.bottom : 0;
        int editorWidth = editorSize != null ? editorSize.width + i2.left + this.padding.left + this.padding.right : 0;
        editorWidth = Math.max(editorWidth, minSize.width + i2.left);
        int width = size2 != null ? size2.width : 0;
        int height = size2 != null ? size2.height : 0;
        width = Math.max(editorWidth + abSize.width, width + this.padding.left);
        height = Math.max(Math.max(editorHeight, Math.max(abSize.height, height)), (DarculaUIUtil.isCompact(this.comboBox) ? DarculaUIUtil.COMPACT_HEIGHT.get() : minSize.height) + i2.top + i2.bottom);
        return new Dimension(width, height);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getSizeWithButton(super.getMinimumSize(c), this.editor != null ? this.editor.getPreferredSize() : null);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension minSize = super.getMinimumSize(c);
        Insets i2 = c.getInsets();
        minSize.width = DarculaComboBoxUI.getMinimumSize(this.comboBox).width + JBUI.CurrentTheme.Component.ARROW_AREA_WIDTH.get() + i2.left + i2.right;
        return this.getSizeWithButton(minSize, this.editor != null ? this.editor.getMinimumSize() : null);
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        this.installEditorKeyListener(this.comboBox.getEditor());
        Component component2 = this.editor;
        if (component2 instanceof JComponent) {
            JComponent jEditor = (JComponent)component2;
            jEditor.setOpaque(false);
            jEditor.setBorder((Border)JBUI.Borders.empty());
            this.editorFocusListener = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    this.update();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.update();
                }

                private void update() {
                    if (DarculaComboBoxUI.this.comboBox != null) {
                        DarculaComboBoxUI.this.comboBox.repaint();
                    }
                }
            };
            if (this.editor instanceof JTextComponent) {
                this.editor.addFocusListener(this.editorFocusListener);
            } else {
                EditorTextField etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class));
                if (etf != null) {
                    etf.addFocusListener(this.editorFocusListener);
                    Color c = UIManager.getColor(this.comboBox.isEnabled() ? "TextField.background" : "ComboBox.disabledBackground");
                    etf.setBackground(c);
                }
            }
        }
        if (this.editor instanceof JPanel) {
            this.editor.setFocusable(false);
        }
    }

    @Override
    protected void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.editorKeyListener != null) {
            this.editor.removeKeyListener(this.editorKeyListener);
        }
        if (this.editor instanceof JTextComponent) {
            if (this.editorFocusListener != null) {
                this.editor.removeFocusListener(this.editorFocusListener);
            }
        } else {
            EditorTextField etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class));
            if (etf != null && this.editorFocusListener != null) {
                etf.removeFocusListener(this.editorFocusListener);
            }
        }
    }

    @Override
    public boolean isFocusTraversable(JComboBox<?> c) {
        return !this.comboBox.isEditable() || this.editor instanceof ComboBoxCompositeEditor && !((ComboBoxCompositeEditor)this.editor).isEditable();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new BasicComboBoxUI.ComboBoxLayoutManager(){

            @Override
            public void layoutContainer(Container parent) {
                JComboBox cb = (JComboBox)parent;
                if (DarculaComboBoxUI.this.arrowButton != null) {
                    Dimension aps = DarculaComboBoxUI.this.arrowButton.getPreferredSize();
                    if (cb.getComponentOrientation().isLeftToRight()) {
                        DarculaComboBoxUI.this.arrowButton.setBounds(cb.getWidth() - aps.width, 0, aps.width, cb.getHeight());
                    } else {
                        DarculaComboBoxUI.this.arrowButton.setBounds(0, 0, aps.width, cb.getHeight());
                    }
                }
                DarculaComboBoxUI.this.layoutEditor();
            }
        };
    }

    protected void layoutEditor() {
        if (this.comboBox.isEditable() && this.editor != null) {
            Rectangle er = this.rectangleForCurrentValue();
            Dimension eps = this.editor.getPreferredSize();
            if (eps.height < er.height) {
                int delta = (er.height - eps.height) / 2;
                er.y += delta;
            }
            er.height = eps.height;
            this.editor.setBounds(er);
        }
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        Rectangle rect = new Rectangle(this.comboBox.getSize());
        Insets i2 = this.getInsets();
        JBInsets.removeFrom((Rectangle)rect, (Insets)i2);
        rect.width = rect.width - (this.arrowButton != null ? this.arrowButton.getWidth() - i2.left : rect.height);
        JBInsets.removeFrom((Rectangle)rect, (Insets)this.padding);
        rect.width = rect.width + (this.comboBox.isEditable() ? 0 : this.padding.right);
        return rect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/darcula/ui/DarculaComboBoxUI";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cbe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/darcula/ui/DarculaComboBoxUI";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultComboBoxInsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNewBorderSupported";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMinimumSize";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getArrowButtonPreferredSize";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installEditorKeyListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    protected static class CustomComboPopup
    extends BasicComboPopup {
        public CustomComboPopup(JComboBox combo2) {
            super(combo2);
        }

        @Override
        protected JScrollPane createScroller() {
            JBScrollPane sp = new JBScrollPane((Component)this.list, 20, 31);
            sp.setHorizontalScrollBar(null);
            sp.setOverlappingScrollBar(true);
            return sp;
        }

        @Override
        protected void configurePopup() {
            super.configurePopup();
            Border border = UIManager.getBorder("ComboPopup.border");
            this.setBorder((Border)(border != null ? border : (SystemInfo.isMac ? JBUI.Borders.empty() : IdeBorderFactory.createBorder())));
            this.putClientProperty("JComboBox.isCellEditor", DarculaUIUtil.isTableCellEditor(this.comboBox));
        }

        @Override
        public void updateUI() {
            this.setUI(new BasicPopupMenuUI(this){

                @Override
                public void uninstallDefaults() {
                }

                @Override
                public void installDefaults() {
                    if (this.popupMenu.getLayout() == null || this.popupMenu.getLayout() instanceof UIResource) {
                        this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
                    }
                    this.popupMenu.setOpaque(true);
                    LookAndFeel.installColorsAndFont(this.popupMenu, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
                }

                @Override
                public Popup getPopup(JPopupMenu popup2, int x, int y) {
                    Window window;
                    PopupFactory factory = PopupFactory.getSharedInstance();
                    int oldType = -1;
                    boolean isRoundBorder = WindowRoundedCornersManager.isAvailable();
                    if (isRoundBorder) {
                        oldType = PopupUtil.getPopupType((PopupFactory)factory);
                        if (oldType == 2) {
                            oldType = -1;
                        } else {
                            PopupUtil.setPopupType((PopupFactory)factory, (int)2);
                        }
                    }
                    Popup p = super.getPopup(popup2, x, y);
                    if (oldType >= 0) {
                        PopupUtil.setPopupType((PopupFactory)factory, (int)oldType);
                    }
                    if (isRoundBorder && (window = ComponentUtil.getWindow((Component)popup2)) != null) {
                        if (SystemInfoRt.isMac && UIUtil.isUnderDarcula() || SystemInfoRt.isWindows) {
                            WindowRoundedCornersManager.setRoundedCorners(window, JBUI.CurrentTheme.Popup.borderColor((boolean)true));
                            popup2.setBorder(null);
                        } else {
                            WindowRoundedCornersManager.setRoundedCorners(window);
                        }
                    }
                    return p;
                }
            });
        }

        @Override
        public void show(Component invoker, int x, int y) {
            JComboBox jComboBox;
            if (ExperimentalUI.isNewUI()) {
                this.list.setBorder(JBUI.Borders.empty((Insets)this.getListVerticalInset()));
            }
            if ((jComboBox = this.comboBox) instanceof ComboBoxWithWidePopup) {
                ComboBoxWithWidePopup comboBoxWithWidePopup = (ComboBoxWithWidePopup)jComboBox;
                Dimension popupSize = this.comboBox.getSize();
                int minPopupWidth = comboBoxWithWidePopup.getMinimumPopupWidth();
                Insets insets = this.getInsets();
                popupSize.width = Math.max(popupSize.width, minPopupWidth);
                popupSize.setSize(popupSize.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                this.scroller.setMaximumSize(popupSize);
                this.scroller.setPreferredSize(popupSize);
                this.scroller.setMinimumSize(popupSize);
                this.list.revalidate();
            }
            super.show(invoker, x, y);
        }

        @Override
        protected void configureList() {
            super.configureList();
            this.list.setCellRenderer(new MyDelegateRenderer());
            this.list.putClientProperty(RenderingUtil.ALWAYS_PAINT_SELECTION_AS_FOCUSED, true);
        }

        protected void customizeListRendererComponent(JComponent component2) {
            if (!(component2 instanceof DarculaComboBoxRenderer)) {
                component2.setBorder((Border)JBUI.Borders.empty((int)2, (int)8));
            }
        }

        @Override
        protected PropertyChangeListener createPropertyChangeListener() {
            final PropertyChangeListener listener2 = super.createPropertyChangeListener();
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    listener2.propertyChange(evt);
                    if ("renderer".equals(evt.getPropertyName()) && !(list.getCellRenderer() instanceof MyDelegateRenderer)) {
                        list.setCellRenderer(new MyDelegateRenderer());
                    }
                }
            };
        }

        @Override
        protected int getPopupHeightForRowCount(int maxRowCount) {
            int result2 = super.getPopupHeightForRowCount(maxRowCount);
            int rowCount = Math.min(maxRowCount, this.comboBox.getItemCount());
            ListCellRenderer renderer2 = this.list.getCellRenderer();
            for (int i2 = 0; i2 < rowCount; ++i2) {
                Object value = this.list.getModel().getElementAt(i2);
                Component c = renderer2.getListCellRendererComponent(this.list, value, i2, false, false);
                Dimension preferredSize = c.getPreferredSize();
                result2 -= preferredSize.height;
                result2 += UIUtil.updateListRowHeight((Dimension)preferredSize).height;
            }
            Object borderInsets = ExperimentalUI.isNewUI() ? this.getListVerticalInset() : JBInsets.emptyInsets();
            return result2 + borderInsets.top + borderInsets.bottom;
        }

        @NotNull
        private Insets getListVerticalInset() {
            Object object = ComboBoxPopup.isRendererWithInsets(this.comboBox.getRenderer()) ? PopupUtil.getListInsets((boolean)false, (boolean)false) : JBInsets.emptyInsets();
            if (object == null) {
                CustomComboPopup.$$$reportNull$$$0(0);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/laf/darcula/ui/DarculaComboBoxUI$CustomComboPopup", "getListVerticalInset"));
        }

        private final class MyDelegateRenderer
        implements ListCellRenderer {
            private MyDelegateRenderer() {
            }

            public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component2 = CustomComboPopup.this.comboBox.getRenderer().getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
                if (component2 instanceof JComponent && !(component2 instanceof KotlinUIDslRendererComponent)) {
                    CustomComboPopup.this.customizeListRendererComponent((JComponent)component2);
                }
                return component2;
            }
        }
    }
}

