/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.AbstractBundleKt;
import com.intellij.BundleBase;
import com.intellij.DynamicBundle;
import com.intellij.IntelliJResourceBundle;
import com.intellij.ide.plugins.ContentModuleDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginModuleDescriptor;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.ide.ui.search.ConfigurableEntry;
import com.intellij.ide.ui.search.MySearchableOptionProcessor;
import com.intellij.ide.ui.search.SearchableOptionEntry;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImplKt;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.LazyExtension;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.xml.dom.XmlDomReader;
import com.intellij.util.xml.dom.XmlElement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.json.DecodeSequenceMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a4\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\rH\u0002\u001a$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190\"H\u0007\u001a\u0018\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "INDEX_ENTRY_REGEXP", "Lkotlin/text/Regex;", "getINDEX_ENTRY_REGEXP", "()Lkotlin/text/Regex;", "LOCATION_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/ide/ui/search/SearchableOptionsRegistrar$AdditionalLocationProvider;", "getMessageByCoordinate", "", "s", "classLoader", "Ljava/lang/ClassLoader;", "locale", "Ljava/util/Locale;", "findBundle", "Ljava/util/ResourceBundle;", "bundlePath", "processSearchableOptions", "", "processor", "Lcom/intellij/ide/ui/search/MySearchableOptionProcessor;", "doRegisterIndex", "item", "Lcom/intellij/ide/ui/search/ConfigurableEntry;", "localeSpecificLoader", "json", "Lkotlinx/serialization/json/Json;", "decodeFromJsonFormat", "Lkotlin/sequences/Sequence;", "data", "", "serializer", "Lkotlinx/serialization/KSerializer;", "readInXml", "root", "Lcom/intellij/util/xml/dom/XmlElement;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nSearchableOptionIndexLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchableOptionIndexLoader.kt\ncom/intellij/ide/ui/search/SearchableOptionIndexLoaderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,341:1\n60#2,5:342\n13#2:347\n*S KotlinDebug\n*F\n+ 1 SearchableOptionIndexLoader.kt\ncom/intellij/ide/ui/search/SearchableOptionIndexLoaderKt\n*L\n144#1:342,5\n38#1:347\n*E\n"})
public final class SearchableOptionIndexLoaderKt {
    @NotNull
    private static final Logger LOG;
    @ApiStatus.Internal
    @NotNull
    private static final Regex INDEX_ENTRY_REGEXP;
    @NotNull
    private static final ExtensionPointName<SearchableOptionsRegistrar.AdditionalLocationProvider> LOCATION_EP_NAME;
    @NotNull
    private static final Json json;

    @NotNull
    public static final Regex getINDEX_ENTRY_REGEXP() {
        return INDEX_ENTRY_REGEXP;
    }

    private static final String getMessageByCoordinate(String s, ClassLoader classLoader, Locale locale) {
        Sequence matches = Regex.findAll$default((Regex)INDEX_ENTRY_REGEXP, (CharSequence)s, (int)0, (int)2, null);
        List result2 = null;
        String first = null;
        for (MatchResult match : matches) {
            String resolvedMessage;
            ResourceBundle bundle;
            MatchGroupCollection groups = match.getGroups();
            MatchGroup matchGroup = groups.get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            if (SearchableOptionIndexLoaderKt.findBundle(classLoader, locale, matchGroup.getValue()) == null) continue;
            if (!(bundle instanceof IntelliJResourceBundle)) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if (!$this$debug_u24default$iv.isDebugEnabled()) continue;
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Unexpected bundle type due to fallback: " + bundle.getClass().getName(), e$iv);
                continue;
            }
            MatchGroup matchGroup2 = groups.get(2);
            Intrinsics.checkNotNull((Object)matchGroup2);
            String messageKey = matchGroup2.getValue();
            if (BundleBase.replaceMnemonicAmpersand((String)((IntelliJResourceBundle)bundle).getMessageOrNull(messageKey)) == null) continue;
            if (first == null) {
                first = resolvedMessage;
                continue;
            }
            if (result2 == null) {
                result2 = new ArrayList();
                result2.add(first);
            }
            result2.add(resolvedMessage);
        }
        if (result2 == null) {
            String string = first;
            if (string == null) {
                string = s;
            }
            return string;
        }
        if (result2.size() == 2 && StringsKt.contains$default((CharSequence)((CharSequence)result2.get(0)), (CharSequence)"{0}", (boolean)false, (int)2, null)) {
            return StringsKt.replace$default((String)((String)result2.get(0)), (String)"{0}", (String)((String)result2.get(1)), (boolean)false, (int)4, null);
        }
        return CollectionsKt.joinToString$default((Iterable)result2, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    private static final ResourceBundle findBundle(ClassLoader classLoader, Locale locale, String bundlePath) {
        try {
            return AbstractBundleKt._doResolveBundle((ClassLoader)classLoader, (Locale)locale, (String)bundlePath);
        }
        catch (MissingResourceException missingResourceException) {
            if (classLoader instanceof PluginAwareClassLoader) {
                return null;
            }
            Set<ClassLoader> visited = Collections.newSetFromMap(new IdentityHashMap());
            visited.add(classLoader);
            for (LazyExtension extension : DynamicBundle.LanguageBundleEP.EP_NAME.filterableLazySequence()) {
                visited.add(extension.getPluginDescriptor().getClassLoader());
            }
            for (PluginModuleDescriptor descriptor : PluginManagerCore.getPluginSet().getEnabledModules()) {
                if (!visited.add(descriptor.getClassLoader())) continue;
                try {
                    ClassLoader classLoader2 = descriptor.getClassLoader();
                    Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"getClassLoader(...)");
                    ResourceBundle b = AbstractBundleKt._doResolveBundle((ClassLoader)classLoader2, (Locale)locale, (String)bundlePath);
                    return b;
                }
                catch (MissingResourceException missingResourceException2) {
                }
            }
            return null;
        }
    }

    private static final void processSearchableOptions(MySearchableOptionProcessor processor2) {
        Set<ClassLoader> xmlVisited = Collections.newSetFromMap(new IdentityHashMap());
        KSerializer<ConfigurableEntry> serializer2 = ConfigurableEntry.Companion.serializer();
        for (PluginModuleDescriptor module : PluginManagerCore.getPluginSet().getEnabledModules()) {
            ClassLoader classLoader = module.getPluginClassLoader();
            if (!(classLoader instanceof UrlClassLoader)) continue;
            String classifier = !(module instanceof ContentModuleDescriptor) ? "p-" + module.getPluginId().getIdString() : "m-" + ((ContentModuleDescriptor)module).getModuleId().getName();
            String fileName = classifier + "-searchableOptions.json";
            byte[] data2 = ((UrlClassLoader)classLoader).getResourceAsBytes(fileName, false);
            if (data2 != null) {
                Locale locale = LocalizationUtil.INSTANCE.getLocaleOrNullForDefault();
                ClassLoader localeSpecificLoader = LocalizationUtil.getPluginClassLoader$default((LocalizationUtil)LocalizationUtil.INSTANCE, null, null, (int)3, null);
                try {
                    for (ConfigurableEntry item : SearchableOptionIndexLoaderKt.decodeFromJsonFormat(data2, serializer2)) {
                        SearchableOptionIndexLoaderKt.doRegisterIndex(item, classLoader, locale, processor2, localeSpecificLoader);
                    }
                    continue;
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException("Can't parse searchable options " + fileName + " for plugin " + module.getPluginId(), e);
                }
            }
            if (!xmlVisited.add(classLoader)) continue;
            String xmlName = "searchableOptions.xml";
            ((UrlClassLoader)classLoader).processResources("search", arg_0 -> SearchableOptionIndexLoaderKt.processSearchableOptions$lambda$0(xmlName, arg_0), (arg_0, arg_1) -> SearchableOptionIndexLoaderKt.processSearchableOptions$lambda$2((arg_0, arg_1) -> SearchableOptionIndexLoaderKt.processSearchableOptions$lambda$1(processor2, fileName, module, arg_0, arg_1), arg_0, arg_1));
        }
        String xmlName = "searchableOptions.xml";
        LOCATION_EP_NAME.forEachExtensionSafe(arg_0 -> SearchableOptionIndexLoaderKt.processSearchableOptions$lambda$4(arg_0 -> SearchableOptionIndexLoaderKt.processSearchableOptions$lambda$3(xmlName, processor2, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final void doRegisterIndex(ConfigurableEntry item, ClassLoader classLoader, Locale locale, MySearchableOptionProcessor processor2, ClassLoader localeSpecificLoader) {
        Locale locale2;
        Locale locale3;
        String string = item.name;
        ClassLoader classLoader2 = localeSpecificLoader;
        if (classLoader2 == null) {
            classLoader2 = classLoader;
        }
        if ((locale3 = locale) == null) {
            locale3 = Locale.ROOT;
        }
        Locale locale4 = locale3;
        Intrinsics.checkNotNull((Object)locale4);
        String groupName = SearchableOptionIndexLoaderKt.getMessageByCoordinate(string, classLoader2, locale4);
        String string2 = item.id;
        ClassLoader classLoader3 = localeSpecificLoader;
        if (classLoader3 == null) {
            classLoader3 = classLoader;
        }
        if ((locale2 = locale) == null) {
            locale2 = Locale.ROOT;
        }
        Locale locale5 = locale2;
        Intrinsics.checkNotNull((Object)locale5);
        String id2 = SearchableOptionIndexLoaderKt.getMessageByCoordinate(string2, classLoader3, locale5);
        for (SearchableOptionEntry entry : item.entries) {
            String string3;
            Locale locale6;
            MySearchableOptionProcessor mySearchableOptionProcessor = processor2;
            Iterable iterable = new Iterable<String>(entry, classLoader, locale, localeSpecificLoader){
                final /* synthetic */ SearchableOptionEntry $entry$inlined;
                final /* synthetic */ ClassLoader $classLoader$inlined;
                final /* synthetic */ Locale $locale$inlined;
                final /* synthetic */ ClassLoader $localeSpecificLoader$inlined;
                {
                    this.$entry$inlined = searchableOptionEntry;
                    this.$classLoader$inlined = classLoader;
                    this.$locale$inlined = locale;
                    this.$localeSpecificLoader$inlined = classLoader2;
                }

                public Iterator<String> iterator() {
                    Iterator<String> iterator;
                    boolean bl = false;
                    String string = this.$entry$inlined.hit;
                    Locale locale = Locale.ROOT;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                    String string2 = SearchableOptionIndexLoaderKt.access$getMessageByCoordinate(string, this.$classLoader$inlined, locale);
                    Locale locale2 = Locale.ROOT;
                    Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ROOT");
                    String string3 = string2.toLowerCase(locale2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    String h1 = string3;
                    Stream<String> s1 = SearchableOptionsRegistrarImplKt.splitToWordsWithoutStemmingAndStopWords(h1);
                    if (this.$locale$inlined == null) {
                        iterator = s1.iterator();
                    } else {
                        String string4 = this.$entry$inlined.hit;
                        ClassLoader classLoader = this.$localeSpecificLoader$inlined;
                        Intrinsics.checkNotNull((Object)classLoader);
                        String string5 = SearchableOptionIndexLoaderKt.access$getMessageByCoordinate(string4, classLoader, this.$locale$inlined).toLowerCase(this.$locale$inlined);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                        String h2 = string5;
                        Stream<String> s2 = SearchableOptionsRegistrarImplKt.splitToWordsWithoutStemmingAndStopWords(h2);
                        iterator = Stream.concat(s2, s1).iterator();
                    }
                    Iterator<String> iterator2 = iterator;
                    Intrinsics.checkNotNull(iterator2);
                    return iterator2;
                }
            };
            String string4 = id2;
            String string5 = groupName;
            String string6 = entry.hit;
            ClassLoader classLoader4 = localeSpecificLoader;
            if (classLoader4 == null) {
                classLoader4 = classLoader;
            }
            if ((locale6 = locale) == null) {
                locale6 = Locale.ROOT;
            }
            Locale locale7 = locale6;
            Intrinsics.checkNotNull((Object)locale7);
            String string7 = SearchableOptionIndexLoaderKt.getMessageByCoordinate(string6, classLoader4, locale7);
            if (entry.path != null) {
                void it;
                Locale locale8;
                String string8 = string7;
                String string9 = string5;
                String string10 = string4;
                Iterable iterable2 = iterable;
                MySearchableOptionProcessor mySearchableOptionProcessor2 = mySearchableOptionProcessor;
                boolean bl = false;
                ClassLoader classLoader5 = localeSpecificLoader;
                if (classLoader5 == null) {
                    classLoader5 = classLoader;
                }
                if ((locale8 = locale) == null) {
                    locale8 = Locale.ROOT;
                }
                Locale locale9 = locale8;
                Intrinsics.checkNotNull((Object)locale9);
                String string11 = SearchableOptionIndexLoaderKt.getMessageByCoordinate((String)it, classLoader5, locale9);
                mySearchableOptionProcessor = mySearchableOptionProcessor2;
                iterable = iterable2;
                string4 = string10;
                string5 = string9;
                string7 = string8;
                string3 = string11;
            } else {
                string3 = null;
            }
            mySearchableOptionProcessor.putOptionWithHelpId$intellij_platform_ide_impl(iterable, string4, string5, string7, string3);
        }
    }

    @ApiStatus.Internal
    @VisibleForTesting
    @NotNull
    public static final Sequence<ConfigurableEntry> decodeFromJsonFormat(@NotNull byte[] data2, @NotNull KSerializer<ConfigurableEntry> serializer2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        return JvmStreamsKt.decodeToSequence((Json)json, (InputStream)new ByteArrayInputStream(data2), (DeserializationStrategy)((DeserializationStrategy)serializer2), (DecodeSequenceMode)DecodeSequenceMode.WHITESPACE_SEPARATED);
    }

    private static final void readInXml(XmlElement root, MySearchableOptionProcessor processor2) {
        for (XmlElement configurable : root.children("configurable")) {
            if (configurable.getAttributeValue("id") == null || configurable.getAttributeValue("configurable_name") == null) continue;
            for (XmlElement optionElement : configurable.children("option")) {
                String text2;
                String name2;
                String id2;
                if (optionElement.getAttributeValue("hit") == null) continue;
                processor2.putOptionWithHelpId$intellij_platform_ide_impl(CollectionsKt.listOfNotNull((Object)optionElement.getAttributeValue("name")), id2, name2, text2, optionElement.getAttributeValue("path"));
            }
        }
    }

    private static final boolean processSearchableOptions$lambda$0(String $xmlName, String it) {
        Intrinsics.checkNotNull((Object)it);
        return StringsKt.endsWith$default((String)it, (String)$xmlName, (boolean)false, (int)2, null);
    }

    private static final Unit processSearchableOptions$lambda$1(MySearchableOptionProcessor $processor, String $fileName, PluginModuleDescriptor $module, String string, InputStream stream) {
        try {
            Intrinsics.checkNotNull((Object)stream);
            SearchableOptionIndexLoaderKt.readInXml(XmlDomReader.readXmlAsModel((InputStream)stream), $processor);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Can't parse searchable options " + $fileName + " for plugin " + $module.getPluginId(), e);
        }
        return Unit.INSTANCE;
    }

    private static final void processSearchableOptions$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit processSearchableOptions$lambda$3(String $xmlName, MySearchableOptionProcessor $processor, SearchableOptionsRegistrar.AdditionalLocationProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Path path = provider.getAdditionalLocation();
        if (path == null) {
            return Unit.INSTANCE;
        }
        Path additionalLocation = path;
        if (Files.isDirectory(additionalLocation, new LinkOption[0])) {
            AutoCloseable autoCloseable = Files.list(additionalLocation);
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl = false;
                stream.forEach(arg_0 -> SearchableOptionIndexLoaderKt.processSearchableOptions$lambda$3$0$1(arg_0 -> SearchableOptionIndexLoaderKt.processSearchableOptions$lambda$3$0$0($xmlName, $processor, arg_0), arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit processSearchableOptions$lambda$3$0$0(String $xmlName, MySearchableOptionProcessor $processor, Path file2) {
        String fileName = ((Object)file2.getFileName()).toString();
        try {
            if (StringsKt.endsWith$default((String)fileName, (String)$xmlName, (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNull((Object)file2);
                SearchableOptionIndexLoaderKt.readInXml(XmlDomReader.readXmlAsModel((Path)file2), $processor);
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Can't parse searchable options " + $xmlName, e);
        }
        return Unit.INSTANCE;
    }

    private static final void processSearchableOptions$lambda$3$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void processSearchableOptions$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$processSearchableOptions(MySearchableOptionProcessor processor2) {
        SearchableOptionIndexLoaderKt.processSearchableOptions(processor2);
    }

    public static final /* synthetic */ String access$getMessageByCoordinate(String s, ClassLoader classLoader, Locale locale) {
        return SearchableOptionIndexLoaderKt.getMessageByCoordinate(s, classLoader, locale);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MySearchableOptionProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        INDEX_ENTRY_REGEXP = new Regex("\\|b\\|([^|]+)\\|k\\|([^|]+)\\|");
        LOCATION_EP_NAME = new ExtensionPointName("com.intellij.search.additionalOptionsLocation");
        json = JsonKt.Json$default(null, SearchableOptionIndexLoaderKt::json$lambda$0, (int)1, null);
    }
}

