/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.ChangeEditorFontSizeStrategy;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAware;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ChangeEditorFontSizeAction
extends AnAction
implements DumbAware,
ActionRemoteBehaviorSpecification.Frontend {
    private final float myStep;
    private final boolean myGlobal;

    protected ChangeEditorFontSizeAction(float increaseStep, boolean global) {
        this.myStep = increaseStep;
        this.myGlobal = global;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        EditorImpl editor2;
        if (e == null) {
            ChangeEditorFontSizeAction.$$$reportNull$$$0(0);
        }
        if ((editor2 = ChangeEditorFontSizeAction.getEditor(e)) != null) {
            float size2;
            float unscaledSize;
            float step2 = this.myStep;
            if (this.myGlobal) {
                step2 *= UISettingsUtils.getInstance().getCurrentIdeScale();
            }
            if ((unscaledSize = UISettingsUtils.scaleFontSize((float)(size2 = editor2.getFontSize2D() + step2), (float)(1.0f / UISettingsUtils.getInstance().getCurrentIdeScale()))) >= 8.0f && unscaledSize <= (float)EditorFontsConstants.getMaxEditorFontSize()) {
                editor2.setFontSize(size2);
                if (this.myGlobal) {
                    editor2.adjustGlobalFontSize(unscaledSize);
                }
            }
        }
    }

    @Nullable
    private static EditorImpl getEditor(@NotNull AnActionEvent e) {
        Editor editor2;
        if (e == null) {
            ChangeEditorFontSizeAction.$$$reportNull$$$0(1);
        }
        if ((editor2 = (Editor)e.getData(CommonDataKeys.EDITOR)) instanceof EditorImpl) {
            return (EditorImpl)editor2;
        }
        return null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ChangeEditorFontSizeAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        EditorImpl editor2;
        if (e == null) {
            ChangeEditorFontSizeAction.$$$reportNull$$$0(3);
        }
        ChangeEditorFontSizeStrategy strategy = (editor2 = ChangeEditorFontSizeAction.getEditor(e)) == null ? null : (ChangeEditorFontSizeStrategy)editor2.getUserData(ChangeEditorFontSizeStrategy.KEY);
        e.getPresentation().setEnabled(editor2 != null && (strategy == null || !strategy.getOverridesChangeFontSizeActions()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actions/ChangeEditorFontSizeAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actions/ChangeEditorFontSizeAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static final class DecreaseEditorFontSizeGlobal
    extends ChangeEditorFontSizeAction {
        private DecreaseEditorFontSizeGlobal() {
            super(-1.0f, true);
        }
    }

    public static final class IncreaseEditorFontSizeGlobal
    extends ChangeEditorFontSizeAction {
        private IncreaseEditorFontSizeGlobal() {
            super(1.0f, true);
        }
    }

    public static final class DecreaseEditorFontSize
    extends ChangeEditorFontSizeAction {
        private DecreaseEditorFontSize() {
            super(-1.0f, false);
        }
    }

    public static final class IncreaseEditorFontSize
    extends ChangeEditorFontSizeAction {
        private IncreaseEditorFontSize() {
            super(1.0f, false);
        }
    }
}

