/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.dnd.DnDManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorDropHandler;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actions.CopyAction;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EditorTransferHandler
extends TransferHandler {
    private static final TransferHandler TRANSFER_HANDLER_STUB = new TransferHandler(){

        @Override
        protected Transferable createTransferable(JComponent c) {
            return null;
        }
    };
    private static final JComponent COMPONENT_STUB = new JComponent(){

        @Override
        public TransferHandler getTransferHandler() {
            return TRANSFER_HANDLER_STUB;
        }
    };
    private static final MouseEvent MOUSE_EVENT_STUB = new MouseEvent(new Component(){}, 0, 0L, 0, 0, 0, 0, false, 0);

    EditorTransferHandler() {
    }

    @Override
    public boolean importData(@NotNull TransferHandler.TransferSupport support) {
        JComponent jComp;
        Component component2;
        if (support == null) {
            EditorTransferHandler.$$$reportNull$$$0(0);
        }
        return (component2 = support.getComponent()) instanceof JComponent && EditorImpl.handleDrop(EditorTransferHandler.getEditor(jComp = (JComponent)component2), support.getTransferable(), support.getDropAction());
    }

    @Override
    public boolean canImport(@NotNull JComponent comp, DataFlavor @NotNull [] transferFlavors) {
        EditorImpl editor2;
        EditorDropHandler dropHandler;
        if (comp == null) {
            EditorTransferHandler.$$$reportNull$$$0(1);
        }
        if (transferFlavors == null) {
            EditorTransferHandler.$$$reportNull$$$0(2);
        }
        if ((dropHandler = (editor2 = EditorTransferHandler.getEditor(comp)).getDropHandler()) != null && dropHandler.canHandleDrop(transferFlavors)) {
            return true;
        }
        if (Registry.is((String)"debugger.click.disable.breakpoints") && ArrayUtil.contains((Object)GutterDraggableObject.flavor, (Object[])transferFlavors)) {
            return true;
        }
        if (editor2.isViewer()) {
            return false;
        }
        int offset = editor2.getCaretModel().getOffset();
        if (editor2.getDocument().getRangeGuard(offset, offset) != null) {
            return false;
        }
        return ArrayUtil.contains((Object)DataFlavor.stringFlavor, (Object[])transferFlavors);
    }

    @Override
    public int getSourceActions(@NotNull JComponent c) {
        if (c == null) {
            EditorTransferHandler.$$$reportNull$$$0(3);
        }
        return 3;
    }

    @Override
    @Nullable
    protected Transferable createTransferable(@NotNull JComponent c) {
        EditorImpl editor2;
        String s;
        if (c == null) {
            EditorTransferHandler.$$$reportNull$$$0(4);
        }
        if ((s = (editor2 = EditorTransferHandler.getEditor(c)).getSelectionModel().getSelectedText()) == null) {
            return null;
        }
        int selectionStart = editor2.getSelectionModel().getSelectionStart();
        int selectionEnd = editor2.getSelectionModel().getSelectionEnd();
        editor2.setDraggedRange(editor2.getDocument().createRangeMarker(selectionStart, selectionEnd));
        Transferable transferable = CopyAction.getSelection(editor2);
        return transferable == null ? new StringSelection(s) : transferable;
    }

    @Override
    protected void exportDone(@NotNull JComponent source, @Nullable Transferable data2, int action2) {
        if (source == null) {
            EditorTransferHandler.$$$reportNull$$$0(5);
        }
        if (data2 == null) {
            return;
        }
        Component last = DnDManager.getInstance().getLastDropHandler();
        if (last != null) {
            if (!(last instanceof EditorComponentImpl) && !(last instanceof EditorGutterComponentImpl)) {
                return;
            }
            if (last != source && Boolean.TRUE.equals(EditorImpl.DISABLE_REMOVE_ON_DROP.get((UserDataHolder)EditorTransferHandler.getEditor((JComponent)last)))) {
                return;
            }
        }
        EditorImpl editor2 = EditorTransferHandler.getEditor(source);
        if (action2 == 2 && !editor2.isViewer() && editor2.getDraggedRange() != null) {
            ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> EditorTransferHandler.removeDraggedOutFragment(editor2));
        }
        editor2.clearDnDContext();
        if (source != COMPONENT_STUB) {
            this.exportAsDrag(COMPONENT_STUB, MOUSE_EVENT_STUB, 2);
        }
    }

    private static void removeDraggedOutFragment(@NotNull EditorImpl editor2) {
        if (editor2 == null) {
            EditorTransferHandler.$$$reportNull$$$0(6);
        }
        if (!FileDocumentManager.getInstance().requestWriting((Document)editor2.getDocument(), editor2.getProject())) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(editor2.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            DocumentEx doc = editor2.getDocument();
            doc.startGuardedBlockChecking();
            try {
                doc.deleteString(editor2.getDraggedRange().getStartOffset(), editor2.getDraggedRange().getEndOffset());
            }
            catch (ReadOnlyFragmentModificationException e) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler((Document)doc).handle(e);
            }
            finally {
                doc.stopGuardedBlockChecking();
            }
        }), EditorBundle.message((String)"move.selection.command.name", (Object[])new Object[0]), EditorImpl.DND_COMMAND_GROUP, UndoConfirmationPolicy.DEFAULT, (Document)editor2.getDocument());
    }

    @NotNull
    private static EditorImpl getEditor(@NotNull JComponent comp) {
        if (comp == null) {
            EditorTransferHandler.$$$reportNull$$$0(7);
        }
        if (comp instanceof EditorComponentImpl) {
            EditorComponentImpl editorComponent = (EditorComponentImpl)comp;
            EditorImpl editorImpl = editorComponent.getEditor();
            if (editorImpl == null) {
                EditorTransferHandler.$$$reportNull$$$0(8);
            }
            return editorImpl;
        }
        EditorImpl editorImpl = ((EditorGutterComponentImpl)comp).getEditor();
        if (editorImpl == null) {
            EditorTransferHandler.$$$reportNull$$$0(9);
        }
        return editorImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferFlavors";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorTransferHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorTransferHandler";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canImport";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSourceActions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTransferable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "exportDone";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeDraggedOutFragment";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9 -> new IllegalStateException(string);
        };
    }
}

