/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.impl.DisplayedFoldingAnchor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingKeys;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class FoldingAnchorsOverlayStrategy {
    private final EditorImpl myEditor;

    @VisibleForTesting
    public FoldingAnchorsOverlayStrategy(EditorImpl editor2) {
        this.myEditor = editor2;
    }

    @NotNull
    @VisibleForTesting
    public Collection<DisplayedFoldingAnchor> getAnchorsToDisplay(int firstVisibleOffset, int lastVisibleOffset, @NotNull List<FoldRegion> activeFoldRegions) {
        if (activeFoldRegions == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(0);
        }
        Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap();
        FoldRegion[] visibleFoldRegions = this.myEditor.getFoldingModel().fetchVisible();
        if (visibleFoldRegions != null) {
            for (FoldRegion region : visibleFoldRegions) {
                int endLogicalLine;
                int endOffset;
                int startOffset;
                if (!region.isValid() || region.shouldNeverExpand() || (startOffset = region.getStartOffset()) > lastVisibleOffset || (endOffset = region.getEndOffset()) < firstVisibleOffset) continue;
                boolean singleLine = false;
                int startLogicalLine = this.myEditor.getDocument().getLineNumber(startOffset);
                if (startLogicalLine == (endLogicalLine = this.myEditor.getDocument().getLineNumber(endOffset))) {
                    singleLine = true;
                    if (!region.isGutterMarkEnabledForSingleLine() && (!this.myEditor.getSettings().isAllowSingleLogicalLineFolding() || endOffset - startOffset <= 1 || this.myEditor.getSoftWrapModel().getSoftWrapsForRange(startOffset + 1, endOffset - 1).isEmpty())) continue;
                }
                if (FoldingAnchorsOverlayStrategy.skipFoldingAnchor(region)) continue;
                int foldStart = this.myEditor.offsetToVisualLine(startOffset);
                if (!region.isExpanded()) {
                    FoldingAnchorsOverlayStrategy.tryAdding((Int2ObjectMap<DisplayedFoldingAnchor>)result2, region, foldStart, 0, singleLine ? DisplayedFoldingAnchor.Type.COLLAPSED_SINGLE_LINE : DisplayedFoldingAnchor.Type.COLLAPSED, activeFoldRegions);
                    continue;
                }
                int foldEnd = this.myEditor.offsetToVisualLine(endOffset);
                if (foldStart == foldEnd) {
                    FoldingAnchorsOverlayStrategy.tryAdding((Int2ObjectMap<DisplayedFoldingAnchor>)result2, region, foldStart, 0, DisplayedFoldingAnchor.Type.EXPANDED_SINGLE_LINE, activeFoldRegions);
                    continue;
                }
                FoldingAnchorsOverlayStrategy.tryAdding((Int2ObjectMap<DisplayedFoldingAnchor>)result2, region, foldStart, foldEnd - foldStart, DisplayedFoldingAnchor.Type.EXPANDED_TOP, activeFoldRegions);
                FoldingAnchorsOverlayStrategy.tryAdding((Int2ObjectMap<DisplayedFoldingAnchor>)result2, region, foldEnd, foldEnd - foldStart, DisplayedFoldingAnchor.Type.EXPANDED_BOTTOM, activeFoldRegions);
            }
        }
        ObjectCollection objectCollection = result2.values();
        if (objectCollection == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(1);
        }
        return objectCollection;
    }

    private static void tryAdding(@NotNull Int2ObjectMap<DisplayedFoldingAnchor> resultsMap, @NotNull FoldRegion region, int visualLine, int visualHeight, @NotNull DisplayedFoldingAnchor.Type type, @NotNull List<FoldRegion> activeRegions) {
        DisplayedFoldingAnchor prev;
        if (resultsMap == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(2);
        }
        if (region == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(3);
        }
        if (type == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(4);
        }
        if (activeRegions == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(5);
        }
        if ((prev = (DisplayedFoldingAnchor)resultsMap.get(visualLine)) != null && !prev.type.singleLine) {
            if (type.singleLine) {
                return;
            }
            if (region.getGroup() != null && region.getGroup() == prev.foldRegion.getGroup() && type != DisplayedFoldingAnchor.Type.COLLAPSED && type != prev.type) {
                resultsMap.remove(visualLine);
                return;
            }
            if (activeRegions.contains(prev.foldRegion)) {
                return;
            }
            if (!activeRegions.contains(region) && prev.foldRegionVisualLines < visualHeight) {
                return;
            }
        }
        resultsMap.put(visualLine, (Object)new DisplayedFoldingAnchor(region, visualLine, visualHeight, type));
    }

    private static boolean skipFoldingAnchor(@NotNull FoldRegion region) {
        if (region == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(6);
        }
        if (!region.isExpanded()) {
            return Boolean.TRUE.equals(region.getUserData(FoldingKeys.HIDE_GUTTER_RENDERER_FOR_COLLAPSED));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeFoldRegions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FoldingAnchorsOverlayStrategy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultsMap";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FoldingAnchorsOverlayStrategy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchorsToDisplay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorsToDisplay";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryAdding";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "skipFoldingAnchor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

