/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.IntPair;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class IndentsModelImpl
implements IndentsModel {
    private final Map<IntPair, IndentGuideDescriptor> myIndentsByLines;
    private List<IndentGuideDescriptor> myIndents;
    @NotNull
    private final EditorImpl myEditor;

    @ApiStatus.Internal
    public IndentsModelImpl(@NotNull EditorImpl editor2) {
        if (editor2 == null) {
            IndentsModelImpl.$$$reportNull$$$0(0);
        }
        this.myIndentsByLines = CollectionFactory.createSmallMemoryFootprintMap();
        this.myIndents = new ArrayList<IndentGuideDescriptor>();
        this.myEditor = editor2;
    }

    @NotNull
    public List<IndentGuideDescriptor> getIndents() {
        List<IndentGuideDescriptor> list2 = this.myIndents;
        if (list2 == null) {
            IndentsModelImpl.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public IndentGuideDescriptor getCaretIndentGuide() {
        LogicalPosition pos = this.myEditor.getCaretModel().getLogicalPosition();
        int column = pos.column;
        int line = pos.line;
        if (column > 0) {
            for (IndentGuideDescriptor indent : this.myIndents) {
                if (column != indent.indentLevel || line < indent.startLine || line >= indent.endLine) continue;
                return indent;
            }
        }
        return null;
    }

    public IndentGuideDescriptor getDescriptor(int startLine, int endLine) {
        return this.myIndentsByLines.get(new IntPair(startLine, endLine));
    }

    public void assumeIndents(@NotNull List<IndentGuideDescriptor> descriptors2) {
        if (descriptors2 == null) {
            IndentsModelImpl.$$$reportNull$$$0(2);
        }
        this.myIndents = descriptors2;
        this.myIndentsByLines.clear();
        for (IndentGuideDescriptor descriptor : this.myIndents) {
            this.myIndentsByLines.put(new IntPair(descriptor.startLine, descriptor.endLine), descriptor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/IndentsModelImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/IndentsModelImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assumeIndents";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

