/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.inspector;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.inspector.InspectionsGroup;
import com.intellij.openapi.editor.impl.inspector.InspectionsSettingContentService;
import com.intellij.openapi.editor.impl.inspector.RedesignedInspectionsManager;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.editor.markup.InspectionsFUS;
import com.intellij.openapi.editor.markup.InspectionsState;
import com.intellij.openapi.editor.markup.StatusItem;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0005\u001b\u001c\u001d\u001e\u001fB\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "analyzerGetter", "Lkotlin/Function0;", "Lcom/intellij/openapi/editor/markup/AnalyzerStatus;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lkotlin/jvm/functions/Function0;Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "actionList", "", "Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$InspectionAction;", "base", "Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$InspectionsBaseAction;", "fusTabId", "", "myInspectionsSettingAction", "Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$InspectionsSettingAction;", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "Companion", "InspectionsSettingAction", "InspectionsBaseAction", "Link", "InspectionAction", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nInspectionsGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionsGroup.kt\ncom/intellij/openapi/editor/impl/inspector/InspectionsGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,379:1\n1878#2,3:380\n37#3,2:383\n*S KotlinDebug\n*F\n+ 1 InspectionsGroup.kt\ncom/intellij/openapi/editor/impl/inspector/InspectionsGroup\n*L\n92#1:380,3\n107#1:383,2\n*E\n"})
public final class InspectionsGroup
extends DefaultActionGroup
implements ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<AnalyzerStatus> analyzerGetter;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final List<InspectionAction> actionList;
    @Nullable
    private InspectionsBaseAction base;
    private final int fusTabId;
    @NotNull
    private InspectionsSettingAction myInspectionsSettingAction;
    @JvmField
    @NotNull
    public static final DataKey<StatusItem> INSPECTION_TYPED_ERROR = DataKey.Companion.create("INSPECTION_TYPED_ERROR");
    @NotNull
    private static final AtomicInteger idCounter = new AtomicInteger(0);

    public InspectionsGroup(@NotNull Function0<AnalyzerStatus> analyzerGetter, @NotNull EditorImpl editor2) {
        Intrinsics.checkNotNullParameter(analyzerGetter, (String)"analyzerGetter");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.analyzerGetter = analyzerGetter;
        this.editor = editor2;
        this.actionList = new ArrayList();
        this.fusTabId = idCounter.incrementAndGet();
        this.myInspectionsSettingAction = new InspectionsSettingAction(this.analyzerGetter, this.fusTabId);
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (!RedesignedInspectionsManager.isAvailable() || PowerSaveMode.isEnabled()) {
            return new AnAction[0];
        }
        AnActionEvent anActionEvent = e;
        if (anActionEvent == null || (anActionEvent = anActionEvent.getPresentation()) == null) {
            return new AnAction[0];
        }
        AnActionEvent presentation2 = anActionEvent;
        AnalyzerStatus analyzerStatus = (AnalyzerStatus)this.analyzerGetter.invoke();
        presentation2.setVisible(!analyzerStatus.isEmpty());
        if (!presentation2.isVisible()) {
            return new AnAction[0];
        }
        List<StatusItem> newStatus = analyzerStatus.getExpandedStatus();
        if (!analyzerStatus.getShowNavigation()) {
            InspectionsBaseAction action2;
            InspectionsBaseAction inspectionsBaseAction;
            StatusItem item = newStatus.isEmpty() ? new StatusItem("", analyzerStatus.getIcon(), null, null, 12, null) : (StatusItem)CollectionsKt.first(newStatus);
            InspectionsBaseAction inspectionsBaseAction2 = this.base;
            if (inspectionsBaseAction2 != null) {
                InspectionsBaseAction it = inspectionsBaseAction2;
                boolean bl = false;
                it.setItem(item);
                it.setTitle(analyzerStatus.getTitle());
                it.setDescription(analyzerStatus.getDetails());
                inspectionsBaseAction = it;
            } else {
                inspectionsBaseAction = new InspectionsBaseAction(item, this.editor, analyzerStatus.getTitle(), analyzerStatus.getDetails(), null, this.fusTabId, 16, null);
            }
            this.base = action2 = inspectionsBaseAction;
            InspectionsState inspectionsState = analyzerStatus.getInspectionsState();
            if (inspectionsState != null) {
                InspectionsState it = inspectionsState;
                boolean bl = false;
                InspectionsFUS.INSTANCE.infoStateDetected(e.getProject(), this.fusTabId, it);
            }
            AnAction[] anActionArray = new AnAction[]{action2, this.myInspectionsSettingAction};
            return anActionArray;
        }
        List arr = new ArrayList();
        String string = DaemonBundle.message((String)"iw.inspection.show.all", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Link actionLink = new Link(string, (Function0<Unit>)((Function0)() -> InspectionsGroup.getChildren$lambda$2(analyzerStatus)));
        Iterable $this$forEachIndexed$iv = newStatus;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            InspectionAction inspectionAction;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            StatusItem statusItem = (StatusItem)item$iv;
            int index = n;
            boolean bl = false;
            if (index < this.actionList.size()) {
                action = this.actionList.get(index);
                action.setItem((StatusItem)item);
                inspectionAction = action;
            } else {
                action = new InspectionAction((StatusItem)item, this.editor, actionLink, this.fusTabId);
                this.actionList.add(action);
                inspectionAction = action;
            }
            arr.add(inspectionAction);
        }
        arr.add(this.myInspectionsSettingAction);
        Collection $this$toTypedArray$iv = arr;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new AnAction[0]);
    }

    private static final Unit getChildren$lambda$2(AnalyzerStatus $analyzerStatus) {
        $analyzerStatus.getController().toggleProblemsView();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$Companion;", "", "<init>", "()V", "INSPECTION_TYPED_ERROR", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/openapi/editor/markup/StatusItem;", "idCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$InspectionAction;", "Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$InspectionsBaseAction;", "item", "Lcom/intellij/openapi/editor/markup/StatusItem;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "actionLink", "Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$Link;", "fusTabId", "", "<init>", "(Lcom/intellij/openapi/editor/markup/StatusItem;Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$Link;I)V", "itemUpdated", "", "isSecondActionEvent", "", "e", "Ljava/awt/event/InputEvent;", "actionPerformed", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "wrapDataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalContext", "update", "getShortcut", "", "id", "Companion", "MyService", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nInspectionsGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionsGroup.kt\ncom/intellij/openapi/editor/impl/inspector/InspectionsGroup$InspectionAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,379:1\n1#2:380\n*E\n"})
    private static final class InspectionAction
    extends InspectionsBaseAction {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final String leftRight;
        @NotNull
        private static final String url;
        @NotNull
        private static final String PREVIOUS_ACTION_ID = "GotoPreviousError";
        @NotNull
        private static final String NEXT_ACTION_ID = "GotoNextError";

        public InspectionAction(@NotNull StatusItem item, @NotNull EditorImpl editor2, @Nullable Link actionLink, int fusTabId) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                super(item, editor2, null, null, actionLink, fusTabId, 12, null);
                String string = item.getDetailsText();
                if (string == null) break block0;
                String it = string;
                boolean bl = false;
                Object[] objectArray = new Object[]{it};
                this.setTitle(DaemonBundle.message((String)"iw.inspection.title", (Object[])objectArray));
            }
        }

        public /* synthetic */ InspectionAction(StatusItem statusItem, EditorImpl editorImpl, Link link, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                link = null;
            }
            this(statusItem, editorImpl, link, n);
        }

        @Override
        protected void itemUpdated() {
            super.itemUpdated();
            String string = this.getItem().getDetailsText();
            if (string != null) {
                String it = string;
                boolean bl = false;
                Object[] objectArray = new Object[]{it};
                this.setTitle(DaemonBundle.message((String)"iw.inspection.title", (Object[])objectArray));
            } else {
                InspectionAction $this$itemUpdated_u24lambda_u241 = this;
                boolean bl = false;
                $this$itemUpdated_u24lambda_u241.setTitle(null);
            }
        }

        @Override
        protected boolean isSecondActionEvent(@Nullable InputEvent e) {
            return e instanceof MouseEvent && ((MouseEvent)e).getButton() == 3;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String actionId = this.isSecondActionEvent(e.getInputEvent()) ? PREVIOUS_ACTION_ID : NEXT_ACTION_ID;
            AnAction anAction = ActionManager.getInstance().getAction(actionId);
            if (anAction == null) {
                InspectionAction $this$actionPerformed_u24lambda_u240 = this;
                boolean bl = false;
                InspectionsFUS.INSTANCE.actionNotFound(e.getProject(), $this$actionPerformed_u24lambda_u240.getFusTabId(), Intrinsics.areEqual((Object)actionId, (Object)PREVIOUS_ACTION_ID) ? InspectionsFUS.InspectionsActions.GotoPreviousError : InspectionsFUS.InspectionsActions.GotoNextError);
                return;
            }
            AnAction action2 = anAction;
            IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.getEditor().getProject());
            InputEvent inputEvent = e.getInputEvent();
            DataContext dataContext2 = this.getEditor().getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            AnActionEvent $this$actionPerformed_u24lambda_u240 = AnActionEvent.createFromAnAction((AnAction)action2, (InputEvent)inputEvent, (String)"EditorInspectionsToolbar", (DataContext)this.wrapDataContext(dataContext2));
            Intrinsics.checkNotNullExpressionValue((Object)$this$actionPerformed_u24lambda_u240, (String)"createFromAnAction(...)");
            AnActionEvent wrapped = $this$actionPerformed_u24lambda_u240;
            InspectionsFUS.INSTANCE.performAction(e.getProject(), this.getFusTabId(), actionId);
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            Project project3 = project2;
            Runnable performAction2 = () -> InspectionAction.actionPerformed$lambda$1(action2, wrapped, e, project3);
            if (focusManager.getFocusOwner() != this.getEditor().getContentComponent()) {
                ActionCallback actionCallback = focusManager.requestFocus((Component)this.getEditor().getContentComponent(), true).doWhenDone(performAction2);
                Intrinsics.checkNotNull((Object)actionCallback);
            } else {
                performAction2.run();
            }
        }

        private final DataContext wrapDataContext(DataContext originalContext) {
            DataContext dataContext2 = CustomizedDataContext.withSnapshot((DataContext)originalContext, arg_0 -> InspectionAction.wrapDataContext$lambda$0(this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"withSnapshot(...)");
            return dataContext2;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setIcon(this.getItem().getIcon());
            e.getPresentation().setText(this.getItem().getText());
            String nextKey = this.getShortcut(NEXT_ACTION_ID);
            String prevKey = this.getShortcut(PREVIOUS_ACTION_ID);
            Object[] objectArray = new Object[]{InspectionAction.Companion.convertSC(nextKey), InspectionAction.Companion.convertSC(prevKey)};
            String string = DaemonBundle.message((String)"iw.inspection.all.types", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String allTypes = string;
            this.setDescription("<html>" + leftRight + "<p>" + allTypes + "</html><p>");
        }

        private final String getShortcut(String id2) {
            String string;
            Shortcut[] shortcutArray = KeymapUtil.getActiveKeymapShortcuts((String)id2).getShortcuts();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            Shortcut[] shortcuts = shortcutArray;
            if (shortcuts.length == 0) {
                string = "Not set";
            } else {
                String string2 = KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortcutsText(...)");
            }
            return string;
        }

        private static final void actionPerformed$lambda$1(AnAction $action, AnActionEvent $wrapped, AnActionEvent $e, Project $project) {
            block1: {
                $action.actionPerformed($wrapped);
                JComponent jComponent = (JComponent)$e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
                if (jComponent == null) break block1;
                JComponent it = jComponent;
                boolean bl = false;
                if (InspectionAction.Companion.isGotItAvailable()) {
                    MyService.Companion.getInstance($project).startGotIt(it);
                }
            }
        }

        private static final void wrapDataContext$lambda$0(InspectionAction this$0, DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            sink.set(INSPECTION_TYPED_ERROR, (Object)this$0.getItem());
        }

        public static final /* synthetic */ String access$getUrl$cp() {
            return url;
        }

        static {
            Object[] objectArray = new Object[]{InspectionAction.Companion.convertSC("Left Click"), InspectionAction.Companion.convertSC("Right Click")};
            String string = DaemonBundle.message((String)"iw.inspection.next.previous", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            leftRight = string;
            url = "https://surveys.jetbrains.com/s3/inspection-widget-feedback-form";
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002R\u0018\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$InspectionAction$Companion;", "", "<init>", "()V", "leftRight", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "url", "PREVIOUS_ACTION_ID", "NEXT_ACTION_ID", "convertSC", "str", "isGotItAvailable", "", "intellij.platform.ide.impl"})
        public static final class Companion {
            private Companion() {
            }

            private final String convertSC(String str) {
                return "<span style=\"color: " + ColorUtil.toHex((Color)UIUtil.getToolTipForeground()) + ";\"><b>" + str + "</b></span>";
            }

            private final boolean isGotItAvailable() {
                return ApplicationInfoEx.getInstanceEx().isEAP();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Service(value={Service.Level.PROJECT})
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$InspectionAction$MyService;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "currentJob", "Lkotlinx/coroutines/Job;", "startGotIt", "", "component", "Ljavax/swing/JComponent;", "Companion", "intellij.platform.ide.impl"})
        private static final class MyService {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final Project project;
            @NotNull
            private final CoroutineScope scope;
            @Nullable
            private Job currentJob;

            public MyService(@NotNull Project project2, @NotNull CoroutineScope scope) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                this.project = project2;
                CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                this.scope = CoroutineScopeKt.childScope((CoroutineScope)scope, (String)"InspectionWidgetGotItTooltipService", (CoroutineContext)coroutineContext, (boolean)true);
            }

            @NotNull
            public final Project getProject() {
                return this.project;
            }

            @NotNull
            public final CoroutineScope getScope() {
                return this.scope;
            }

            public final void startGotIt(@NotNull JComponent component2) {
                Job job2;
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                ThreadingAssertions.assertEventDispatchThread();
                Job job3 = this.currentJob;
                boolean bl = job3 != null ? job3.isActive() : false;
                if (bl || !kotlinx.coroutines.CoroutineScopeKt.isActive((CoroutineScope)this.scope)) {
                    return;
                }
                this.currentJob = job2 = BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, component2, null){
                    int label;
                    final /* synthetic */ MyService this$0;
                    final /* synthetic */ JComponent $component;
                    {
                        this.this$0 = $receiver;
                        this.$component = $component;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = DelayKt.delay((long)20000L, (Continuation)((Continuation)this));
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                v1 = DaemonBundle.message((String)"iw.inspection.got.it.text", (Object[])new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"message(...)");
                                v2 = new GotItTooltip("redesigned.inspections.tooltip", v1, (Disposable)this.this$0.getProject()).withShowCount(1).withContrastColors(true);
                                v3 = DaemonBundle.message((String)"iw.inspection.got.it.yes", (Object[])new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"message(...)");
                                v4 = v2.withButtonLabel(v3).withGotItButtonAction((Function0<Unit>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(), ()Lkotlin/Unit;)());
                                v5 = DaemonBundle.message((String)"iw.inspection.got.it.no", (Object[])new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"message(...)");
                                tooltip = GotItTooltip.withSecondaryButton$default(v4, v5, null, 2, null);
                                tooltip.show(this.$component, (Function2<? super Component, ? super Balloon, ? extends Point>)GotItTooltip.BOTTOM_MIDDLE);
                                kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.this$0.getScope(), null, (int)1, null);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0() {
                        BrowserUtil.open((String)InspectionAction.access$getUrl$cp());
                        return Unit.INSTANCE;
                    }
                }), (int)2, null);
                HierarchyListener hierarchyListener = arg_0 -> MyService.startGotIt$lambda$0(component2, job2, arg_0);
                component2.addHierarchyListener(hierarchyListener);
                job2.invokeOnCompletion(arg_0 -> MyService.startGotIt$lambda$1(component2, hierarchyListener, arg_0));
            }

            private static final void startGotIt$lambda$0(JComponent $component, Job $job, HierarchyEvent e) {
                if ((e.getChangeFlags() & 2L) != 0L && !$component.isDisplayable()) {
                    Job.DefaultImpls.cancel$default((Job)$job, null, (int)1, null);
                }
            }

            private static final Unit startGotIt$lambda$1(JComponent $component, HierarchyListener $hierarchyListener, Throwable it) {
                $component.removeHierarchyListener($hierarchyListener);
                return Unit.INSTANCE;
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$InspectionAction$MyService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$InspectionAction$MyService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
            @SourceDebugExtension(value={"SMAP\nInspectionsGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionsGroup.kt\ncom/intellij/openapi/editor/impl/inspector/InspectionsGroup$InspectionAction$MyService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,379:1\n30#2,2:380\n*S KotlinDebug\n*F\n+ 1 InspectionsGroup.kt\ncom/intellij/openapi/editor/impl/inspector/InspectionsGroup$InspectionAction$MyService$Companion\n*L\n264#1:380,2\n*E\n"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final MyService getInstance(@NotNull Project project2) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    ComponentManager $this$service$iv = (ComponentManager)project2;
                    boolean $i$f$service = false;
                    Class<MyService> serviceClass$iv = MyService.class;
                    Object object = $this$service$iv.getService(serviceClass$iv);
                    if (object == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                    }
                    return (MyService)object;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0012\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016BM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000f\b\u0002\u0010\u0007\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\t\u0012\u000f\b\u0002\u0010\n\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010$\u001a\u00020%H\u0014J\b\u0010&\u001a\u00020'H\u0016J\u0012\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0014J\u0018\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00102\u001a\u00020\bH\u0016J\u0010\u00103\u001a\u00020%2\u0006\u0010*\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020%2\u0006\u0010*\u001a\u000204H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0007\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R!\u0010\n\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u00067"}, d2={"Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$InspectionsBaseAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "item", "Lcom/intellij/openapi/editor/markup/StatusItem;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "title", "", "Lorg/jetbrains/annotations/Nls;", "description", "actionLink", "Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$Link;", "fusTabId", "", "<init>", "(Lcom/intellij/openapi/editor/markup/StatusItem;Lcom/intellij/openapi/editor/impl/EditorImpl;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$Link;I)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "getDescription", "setDescription", "getActionLink", "()Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$Link;", "setActionLink", "(Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$Link;)V", "getFusTabId", "()I", "value", "getItem", "()Lcom/intellij/openapi/editor/markup/StatusItem;", "setItem", "(Lcom/intellij/openapi/editor/markup/StatusItem;)V", "itemUpdated", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSecondActionEvent", "", "e", "Ljava/awt/event/InputEvent;", "updateCustomComponent", "component", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "createCustomComponent", "place", "update", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "Companion", "intellij.platform.ide.impl"})
    private static class InspectionsBaseAction
    extends DumbAwareAction
    implements CustomComponentAction {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final EditorImpl editor;
        @Nullable
        private String title;
        @Nullable
        private String description;
        @Nullable
        private Link actionLink;
        private final int fusTabId;
        @NotNull
        private StatusItem item;
        @NotNull
        private static final ColorKey ICON_TEXT_COLOR;

        public InspectionsBaseAction(@NotNull StatusItem item, @NotNull EditorImpl editor2, @Nullable String title2, @Nullable String description, @Nullable Link actionLink, int fusTabId) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.editor = editor2;
            this.title = title2;
            this.description = description;
            this.actionLink = actionLink;
            this.fusTabId = fusTabId;
            this.item = item;
        }

        public /* synthetic */ InspectionsBaseAction(StatusItem statusItem, EditorImpl editorImpl, String string, String string2, Link link, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                string = null;
            }
            if ((n2 & 8) != 0) {
                string2 = null;
            }
            if ((n2 & 0x10) != 0) {
                link = null;
            }
            this(statusItem, editorImpl, string, string2, link, n);
        }

        @NotNull
        public final EditorImpl getEditor() {
            return this.editor;
        }

        @Nullable
        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(@Nullable String string) {
            this.title = string;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(@Nullable String string) {
            this.description = string;
        }

        @Nullable
        public final Link getActionLink() {
            return this.actionLink;
        }

        public final void setActionLink(@Nullable Link link) {
            this.actionLink = link;
        }

        protected final int getFusTabId() {
            return this.fusTabId;
        }

        @NotNull
        public final StatusItem getItem() {
            return this.item;
        }

        public final void setItem(@NotNull StatusItem value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (Intrinsics.areEqual((Object)this.item, (Object)value)) {
                return;
            }
            this.item = value;
            this.itemUpdated();
        }

        protected void itemUpdated() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        protected boolean isSecondActionEvent(@Nullable InputEvent e) {
            return false;
        }

        public void updateCustomComponent(@NotNull JComponent component2, @NotNull Presentation presentation2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            component2.setFont((Font)JBFont.small());
            component2.setForeground((Color)JBColor.lazy(() -> InspectionsBaseAction.updateCustomComponent$lambda$0(this)));
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Dimension dimension = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE;
            return new ActionButtonWithText(this, presentation2, place, dimension){
                final /* synthetic */ InspectionsBaseAction this$0;
                {
                    this.this$0 = $receiver;
                    super((AnAction)$receiver, $presentation, $place, $super_call_param$1);
                    this.setBorder((Border)JBUI.Borders.empty());
                    this.setForeground((Color)JBColor.lazy(() -> createCustomComponent.1._init_$lambda$0($receiver)));
                }

                protected int iconTextSpace() {
                    return JBUI.scale((int)2);
                }

                protected boolean checkSkipPressForEvent(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    return e.isMetaDown() || e.getButton() != 1 && !this.this$0.isSecondActionEvent(e);
                }

                public Insets getInsets() {
                    JBInsets jBInsets = JBUI.emptyInsets();
                    Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"emptyInsets(...)");
                    return (Insets)jBInsets;
                }

                protected Insets getMargins() {
                    JBInsets jBInsets = JBUI.insets((int)0, (int)3);
                    Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
                    return (Insets)jBInsets;
                }

                protected void updateToolTipText() {
                    block5: {
                        Object object;
                        createCustomComponent.1 v1;
                        block7: {
                            block6: {
                                block4: {
                                    if (!UISettings.Companion.isIdeHelpTooltipEnabled()) break block4;
                                    HelpTooltip.dispose((Component)this);
                                    HelpTooltip tooltip = new HelpTooltip().setTitle(this.this$0.getTitle()).setDescription(this.this$0.getDescription());
                                    Link link = this.this$0.getActionLink();
                                    if (link != null) {
                                        Link it = link;
                                        boolean bl = false;
                                        tooltip.setLink(it.getText(), () -> createCustomComponent.1.updateToolTipText$lambda$1$0(it));
                                    }
                                    tooltip.installOn((JComponent)this);
                                    break block5;
                                }
                                v1 = this;
                                object = this.this$0.getTitle();
                                if (object == null) break block6;
                                String it = object;
                                createCustomComponent.1 var4_6 = v1;
                                boolean bl = false;
                                String string = it + "\n";
                                v1 = var4_6;
                                object = string;
                                if (string != null) break block7;
                            }
                            object = "";
                        }
                        v1.setToolTipText((String)object + this.this$0.getDescription());
                    }
                }

                private static final Color _init_$lambda$0(InspectionsBaseAction this$0) {
                    Color color = this$0.getEditor().getColorsScheme().getColor(InspectionsBaseAction.access$getICON_TEXT_COLOR$cp());
                    if (color == null) {
                        color = InspectionsBaseAction.access$getICON_TEXT_COLOR$cp().getDefaultColor();
                    }
                    return color;
                }

                private static final void updateToolTipText$lambda$1$0(Link $it) {
                    $it.getAction().invoke();
                }
            };
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setIcon(this.item.getIcon());
            e.getPresentation().setText(this.item.getText());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }

        private static final Color updateCustomComponent$lambda$0(InspectionsBaseAction this$0) {
            Color color = this$0.editor.getColorsScheme().getColor(ICON_TEXT_COLOR);
            if (color == null) {
                color = ICON_TEXT_COLOR.getDefaultColor();
            }
            return color;
        }

        public static final /* synthetic */ ColorKey access$getICON_TEXT_COLOR$cp() {
            return ICON_TEXT_COLOR;
        }

        static {
            ColorKey colorKey = ColorKey.createColorKey((String)"ActionButton.iconTextForeground", (Color)UIUtil.getContextHelpForeground());
            Intrinsics.checkNotNullExpressionValue((Object)colorKey, (String)"createColorKey(...)");
            ICON_TEXT_COLOR = colorKey;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$InspectionsBaseAction$Companion;", "", "<init>", "()V", "ICON_TEXT_COLOR", "Lcom/intellij/openapi/editor/colors/ColorKey;", "intellij.platform.ide.impl"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$InspectionsSettingAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "analyzerGetter", "Lkotlin/Function0;", "Lcom/intellij/openapi/editor/markup/AnalyzerStatus;", "fusTabId", "", "<init>", "(Lkotlin/jvm/functions/Function0;I)V", "getAnalyzerGetter", "()Lkotlin/jvm/functions/Function0;", "getFusTabId", "()I", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "createCustomComponent", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "updateCustomComponent", "", "component", "Ljavax/swing/JComponent;", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.ide.impl"})
    private static final class InspectionsSettingAction
    extends DumbAwareAction
    implements CustomComponentAction {
        @NotNull
        private final Function0<AnalyzerStatus> analyzerGetter;
        private final int fusTabId;

        public InspectionsSettingAction(@NotNull Function0<AnalyzerStatus> analyzerGetter, int fusTabId) {
            Intrinsics.checkNotNullParameter(analyzerGetter, (String)"analyzerGetter");
            this.analyzerGetter = analyzerGetter;
            this.fusTabId = fusTabId;
            this.getTemplatePresentation().setText(DaemonBundle.message((String)"iw.inspection.cog.tooltip", (Object[])new Object[0]));
        }

        @NotNull
        public final Function0<AnalyzerStatus> getAnalyzerGetter() {
            return this.analyzerGetter;
        }

        public final int getFusTabId() {
            return this.fusTabId;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        @NotNull
        public ActionButton createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Dimension dimension = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE;
            return new ActionButton(this, presentation2, place, dimension){};
        }

        public void updateCustomComponent(@NotNull JComponent component2, @NotNull Presentation presentation2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            component2.setFont((Font)JBFont.small());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            Project project3 = project2;
            JComponent jComponent = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
            if (jComponent == null) {
                return;
            }
            JComponent comp = jComponent;
            SwingUtilities.invokeLater(() -> InspectionsSettingAction.actionPerformed$lambda$0(e, this, project3, comp));
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setIcon(AllIcons.General.Gear);
        }

        private static final void actionPerformed$lambda$0(AnActionEvent $e, InspectionsSettingAction this$0, Project $project, JComponent $comp) {
            InspectionsFUS.INSTANCE.signal($e.getProject(), this$0.fusTabId, InspectionsFUS.InspectionsEvent.SHOW_POPUP);
            InspectionsSettingContentService inspectionsSettingContentService = InspectionsSettingContentService.Companion.getInstance();
            Function0<AnalyzerStatus> function0 = this$0.analyzerGetter;
            RelativePoint relativePoint = RelativePoint.getSouthWestOf((JComponent)$comp);
            Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"getSouthWestOf(...)");
            inspectionsSettingContentService.showPopup(function0, $project, relativePoint, this$0.fusTabId);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\"\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J(\u0010\u0010\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/editor/impl/inspector/InspectionsGroup$Link;", "", "text", "", "Lorg/jetbrains/annotations/Nls;", "action", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getText", "()Ljava/lang/String;", "getAction", "()Lkotlin/jvm/functions/Function0;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
    private static final class Link {
        @NotNull
        private final String text;
        @NotNull
        private final Function0<Unit> action;

        public Link(@NotNull String text2, @NotNull Function0<Unit> action2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            this.text = text2;
            this.action = action2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Function0<Unit> getAction() {
            return this.action;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final Function0<Unit> component2() {
            return this.action;
        }

        @NotNull
        public final Link copy(@NotNull String text2, @NotNull Function0<Unit> action2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            return new Link(text2, action2);
        }

        public static /* synthetic */ Link copy$default(Link link, String string, Function0 function0, int n, Object object) {
            if ((n & 1) != 0) {
                string = link.text;
            }
            if ((n & 2) != 0) {
                function0 = link.action;
            }
            return link.copy(string, function0);
        }

        @NotNull
        public String toString() {
            return "Link(text=" + this.text + ", action=" + this.action + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + this.action.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Link)) {
                return false;
            }
            Link link = (Link)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)link.text)) {
                return false;
            }
            return Intrinsics.areEqual(this.action, link.action);
        }
    }
}

