/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOError;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalFsFinder
implements FileLookup.Finder {
    private final boolean myUseVfs;
    @Nullable
    private Path myBaseDir = Path.of(SystemProperties.getUserHome(), new String[0]);

    public LocalFsFinder() {
        this(true);
    }

    public LocalFsFinder(boolean useVfs) {
        this.myUseVfs = useVfs;
    }

    @Override
    public FileLookup.LookupFile find(@NotNull String path) {
        block10: {
            VirtualFile vFile;
            VirtualFile byUrl;
            if (path == null) {
                LocalFsFinder.$$$reportNull$$$0(0);
            }
            if (this.myUseVfs && (byUrl = VirtualFileManager.getInstance().findFileByUrl(path)) != null) {
                return new VfsFile(byUrl);
            }
            String toFind = this.normalize(path);
            if (toFind.isEmpty()) {
                if (this.myUseVfs) {
                    toFind = FileSystems.getDefault().getRootDirectories().iterator().next().toString();
                } else {
                    return SystemInfo.isWindows ? WindowsRootsFile.TOP_ALL : null;
                }
            }
            if (this.myUseVfs && (vFile = LocalFileSystem.getInstance().findFileByPath(toFind)) != null) {
                return new VfsFile(vFile);
            }
            try {
                Path file2 = Path.of(toFind, new String[0]);
                if (file2.isAbsolute()) {
                    return new IoFile(file2);
                }
                if (LocalFsFinder.isIncompleteDrive(toFind) && SystemInfo.isWindows) {
                    return WindowsRootsFile.INCOMPLETE_DRIVES;
                }
            }
            catch (InvalidPathException ignored) {
                if (!LocalFsFinder.isIncompleteUnc(toFind) || !WSLUtil.isSystemCompatible()) break block10;
                return toFind.equals("\\\\") ? WindowsRootsFile.TOP_WSL : WindowsRootsFile.INCOMPLETE_WSL;
            }
        }
        return null;
    }

    @Override
    public String normalize(@NotNull String path) {
        if (path == null) {
            LocalFsFinder.$$$reportNull$$$0(1);
        }
        try {
            Path file2 = Path.of(OSAgnosticPathUtil.expandUserHome((String)path), new String[0]);
            if (!file2.isAbsolute() && this.myBaseDir != null) {
                file2 = this.myBaseDir.resolve(path).toAbsolutePath();
            }
            return LocalFsFinder.trimUncRoot(file2.toString());
        }
        catch (InvalidPathException file2) {
        }
        catch (IOError e) {
            Logger.getInstance(LocalFsFinder.class).info("path=" + path + "; base=" + String.valueOf(this.myBaseDir), (Throwable)e);
        }
        return path;
    }

    @Override
    public String getSeparator() {
        return File.separator;
    }

    @Override
    @NotNull
    public List<String> split(@NotNull String path) {
        ArrayList<String> arrayList;
        if (path == null) {
            LocalFsFinder.$$$reportNull$$$0(2);
        }
        try {
            Path pathObj = Path.of(this.normalize(path), new String[0]);
            ArrayList<String> result2 = new ArrayList<String>(pathObj.getNameCount() + 1);
            Path root = pathObj.getRoot();
            if (root != null) {
                result2.add(LocalFsFinder.trimUncRoot(root.toString()));
            }
            for (Path part : pathObj) {
                result2.add(part.toString());
            }
            arrayList = result2;
        }
        catch (InvalidPathException e) {
            List<String> list2 = LocalFsFinder.isIncompleteUnc(path) ? List.of(LocalFsFinder.trimUncRoot(path)) : FileLookup.Finder.super.split(path);
            if (list2 == null) {
                LocalFsFinder.$$$reportNull$$$0(4);
            }
            return list2;
        }
        if (arrayList == null) {
            LocalFsFinder.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static boolean isIncompleteDrive(String path) {
        return OSAgnosticPathUtil.isDriveLetter((char)path.charAt(0)) && (path.length() == 1 || path.length() == 2 && path.charAt(1) == ':');
    }

    private static boolean isIncompleteUnc(String path) {
        if (path.startsWith("\\\\")) {
            int p = path.indexOf(92, 2);
            return p < 0 || p == path.length() - 1;
        }
        return false;
    }

    private static String trimUncRoot(String path) {
        return path.startsWith("\\\\") ? StringUtil.trimTrailing((String)path, (char)'\\') : path;
    }

    public LocalFsFinder withBaseDir(@Nullable Path baseDir) {
        this.myBaseDir = baseDir;
        return this;
    }

    public void setBaseDir(@Nullable File baseDir) {
        this.withBaseDir(baseDir != null ? baseDir.toPath() : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/ex/LocalFsFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/ex/LocalFsFinder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static final class VfsFile
    extends LookupFileWithMacro {
        private final VirtualFile myFile;

        public VfsFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                VfsFile.$$$reportNull$$$0(0);
            }
            this.myFile = file2;
            RefreshQueue.getInstance().refresh(true, false, null, new VirtualFile[]{file2});
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        @Override
        public String getName() {
            return this.myFile.getParent() == null && this.myFile.getName().isEmpty() ? "/" : this.myFile.getName();
        }

        @Override
        public boolean isDirectory() {
            return this.myFile.isDirectory();
        }

        @Override
        public FileLookup.LookupFile getParent() {
            VirtualFile parent = this.myFile.getParent();
            return parent != null ? new VfsFile(parent) : null;
        }

        @Override
        public String getAbsolutePath() {
            return this.myFile.getParent() == null && this.myFile.getName().isEmpty() ? "/" : this.myFile.getPresentableUrl();
        }

        @Override
        public List<FileLookup.LookupFile> getChildren(FileLookup.LookupFilter filter2) {
            VirtualFile[] kids = this.myFile.getChildren();
            ArrayList<FileLookup.LookupFile> result2 = new ArrayList<FileLookup.LookupFile>(kids.length);
            for (VirtualFile each : kids) {
                VfsFile eachFile = new VfsFile(each);
                if (!filter2.isAccepted(eachFile)) continue;
                result2.add(eachFile);
            }
            result2.sort((o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (!this.myFile.isCaseSensitive() ? 1 : 0) != 0));
            return result2;
        }

        @Override
        public boolean exists() {
            return this.myFile.exists();
        }

        @Override
        public Icon getIcon() {
            return this.myFile.isDirectory() ? PlatformIcons.FOLDER_ICON : VirtualFilePresentation.getIcon((VirtualFile)this.myFile);
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.myFile.equals(((VfsFile)o).myFile);
        }

        public int hashCode() {
            return this.myFile.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileChooser/ex/LocalFsFinder$VfsFile", "<init>"));
        }
    }

    private static final class WindowsRootsFile
    extends LookupFileWithMacro {
        private static final WindowsRootsFile TOP_ALL = new WindowsRootsFile();
        private static final WindowsRootsFile TOP_WSL = new WindowsRootsFile();
        private static final WindowsRootsFile INCOMPLETE_DRIVES = new WindowsRootsFile();
        private static final WindowsRootsFile INCOMPLETE_WSL = new WindowsRootsFile();

        private WindowsRootsFile() {
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public String getAbsolutePath() {
            return "";
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public List<FileLookup.LookupFile> getChildren(FileLookup.LookupFilter filter2) {
            try {
                ArrayList<FileLookup.LookupFile> result2 = new ArrayList<FileLookup.LookupFile>();
                if (this == TOP_ALL || this == INCOMPLETE_DRIVES) {
                    for (Path root : FileSystems.getDefault().getRootDirectories()) {
                        IoFile file2 = new IoFile(root);
                        if (!filter2.isAccepted(file2)) continue;
                        result2.add(file2);
                    }
                }
                if (this != INCOMPLETE_DRIVES && WSLUtil.isSystemCompatible()) {
                    List<WSLDistribution> vms = WslDistributionManager.getInstance().getInstalledDistributionsFuture().get(200L, TimeUnit.MILLISECONDS);
                    for (WSLDistribution vm : vms) {
                        IoFile file3 = new IoFile(vm.getUNCRootPath());
                        if (!filter2.isAccepted(file3)) continue;
                        result2.add(file3);
                    }
                }
                result2.sort((o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)false));
                return result2;
            }
            catch (Exception ignore) {
                return List.of();
            }
        }

        @Override
        @Nullable
        public FileLookup.LookupFile getParent() {
            return null;
        }

        @Override
        public boolean exists() {
            return this == TOP_ALL || this == TOP_WSL;
        }

        @Override
        public Icon getIcon() {
            return PlatformIcons.FOLDER_ICON;
        }
    }

    public static final class IoFile
    extends LookupFileWithMacro {
        private final Path myFile;

        public IoFile(@NotNull Path file2) {
            if (file2 == null) {
                IoFile.$$$reportNull$$$0(0);
            }
            this.myFile = file2;
        }

        public Path getFile() {
            return this.myFile;
        }

        @Override
        public String getName() {
            return LocalFsFinder.trimUncRoot(NioFiles.getFileName((Path)this.myFile));
        }

        @Override
        public boolean isDirectory() {
            return Files.isDirectory(this.myFile, new LinkOption[0]);
        }

        @Override
        public FileLookup.LookupFile getParent() {
            Path parent = this.myFile.getParent();
            if (parent != null) {
                return new IoFile(parent);
            }
            if (this.myFile.toString().startsWith("\\\\")) {
                return WindowsRootsFile.TOP_ALL;
            }
            return null;
        }

        @Override
        public String getAbsolutePath() {
            return LocalFsFinder.trimUncRoot(this.myFile.toAbsolutePath().toString());
        }

        @Override
        public List<FileLookup.LookupFile> getChildren(FileLookup.LookupFilter filter2) {
            List files2 = NioFiles.list((Path)this.myFile);
            ArrayList<FileLookup.LookupFile> result2 = new ArrayList<FileLookup.LookupFile>(files2.size());
            for (Path each : files2) {
                IoFile file2 = new IoFile(each);
                if (!filter2.isAccepted(file2)) continue;
                result2.add(file2);
            }
            result2.sort((o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)SystemInfo.isFileSystemCaseSensitive));
            return result2;
        }

        @Override
        public boolean exists() {
            return Files.exists(this.myFile, new LinkOption[0]);
        }

        @Override
        public Icon getIcon() {
            return Files.isDirectory(this.myFile, new LinkOption[0]) ? PlatformIcons.FOLDER_ICON : FileTypeRegistry.getInstance().getFileTypeByFileName(this.myFile.toString()).getIcon();
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.myFile.equals(((IoFile)o).myFile);
        }

        public int hashCode() {
            return this.myFile.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileChooser/ex/LocalFsFinder$IoFile", "<init>"));
        }
    }

    @ApiStatus.Internal
    public static abstract class LookupFileWithMacro
    implements FileLookup.LookupFile {
        private String myMacro;

        @Override
        public final void setMacro(String macro) {
            this.myMacro = macro;
        }

        @Override
        public final String getMacro() {
            return this.myMacro;
        }
    }

    public static final class FileChooserFilter
    implements FileLookup.LookupFilter {
        private final FileChooserDescriptor myDescriptor;
        private final boolean myShowHidden;

        public FileChooserFilter(FileChooserDescriptor descriptor, boolean showHidden) {
            this.myShowHidden = showHidden;
            this.myDescriptor = descriptor;
        }

        @Override
        public boolean isAccepted(FileLookup.LookupFile file2) {
            if (file2 instanceof VfsFile) {
                VfsFile vfsFile = (VfsFile)file2;
                VirtualFile vFile = vfsFile.getFile();
                return this.myDescriptor.isFileVisible(vFile, this.myShowHidden);
            }
            return false;
        }
    }
}

