/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImplKt;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public final class LargeFileEditorProvider
extends TextEditorProvider {
    static final Key<Boolean> IS_LARGE = Key.create((String)"IS_LARGE");

    @Override
    public boolean accept(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(1);
        }
        return LargeFileEditorProvider.isTextFile(file2) && SingleRootFileViewProvider.isTooLargeForContentLoading((VirtualFile)file2) && (!Experiments.getInstance().isFeatureEnabled("new.large.text.file.viewer") || file2.getFileType().isBinary() || !file2.isInLocalFileSystem());
    }

    @Override
    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(3);
        }
        if (file2.getFileType().isBinary()) {
            return new LargeBinaryFileEditor(file2);
        }
        AsyncEditorLoader asyncLoader = TextEditorImplKt.createAsyncEditorLoader(this, project2, file2, null);
        EditorImpl editor2 = (EditorImpl)TextEditorImplKt.createEditorImpl(project2, file2, asyncLoader).getFirst();
        editor2.setViewer(true);
        TextEditorImpl testEditor = new TextEditorImpl(project2, file2, new TextEditorComponent(file2, editor2), asyncLoader, true);
        testEditor.putUserData(IS_LARGE, true);
        TextEditorImpl textEditorImpl = testEditor;
        if (textEditorImpl == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(4);
        }
        return textEditorImpl;
    }

    @Override
    @NotNull
    public String getEditorTypeId() {
        return "LargeFileEditor";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static final class LargeBinaryFileEditor
    extends UserDataHolderBase
    implements FileEditor {
        private final VirtualFile file;

        LargeBinaryFileEditor(VirtualFile file2) {
            this.file = file2;
        }

        @NotNull
        public JComponent getComponent() {
            JLabel label2 = new JLabel(IdeBundle.message((String)"binary.file.too.large", (Object[])new Object[]{this.file.getPath(), StringUtil.formatFileSize((long)this.file.getLength())}));
            label2.setHorizontalAlignment(0);
            JLabel jLabel = label2;
            if (jLabel == null) {
                LargeBinaryFileEditor.$$$reportNull$$$0(0);
            }
            return jLabel;
        }

        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @NotNull
        public String getName() {
            String string = IdeBundle.message((String)"large.file.editor.name", (Object[])new Object[0]);
            if (string == null) {
                LargeBinaryFileEditor.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public FileEditorState getState(@NotNull FileEditorStateLevel level) {
            if (level == null) {
                LargeBinaryFileEditor.$$$reportNull$$$0(2);
            }
            return new TextEditorState();
        }

        public void setState(@NotNull FileEditorState state2) {
            if (state2 == null) {
                LargeBinaryFileEditor.$$$reportNull$$$0(3);
            }
        }

        public boolean isModified() {
            return false;
        }

        public boolean isValid() {
            return this.file.isValid();
        }

        public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                LargeBinaryFileEditor.$$$reportNull$$$0(4);
            }
        }

        public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                LargeBinaryFileEditor.$$$reportNull$$$0(5);
            }
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                LargeBinaryFileEditor.$$$reportNull$$$0(6);
            }
            return virtualFile;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeBinaryFileEditor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeBinaryFileEditor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getState";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addPropertyChangeListener";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removePropertyChangeListener";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

