/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterFreePainterAreaState;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.EditorHighlighterUpdater;
import com.intellij.openapi.fileEditor.impl.text.FileEditorDropHandler;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponentKt;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002:\u000389:B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ-\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ\u0016\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0015\u0010#\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%J\b\u0010&\u001a\u00020\u0012H\u0016J\u000e\u0010,\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010/\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u000202H\u0016J\n\u00103\u001a\u0004\u0018\u000104H\u0016J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000206H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0005\u001a\u00020\u00068\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u000eR\u0011\u0010-\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u000eR\u0014\u0010.\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u000e\u00a8\u0006;"}, d2={"Lcom/intellij/openapi/fileEditor/impl/text/TextEditorComponent;", "Ljavax/swing/JLayeredPane;", "Lcom/intellij/openapi/actionSystem/UiCompatibleDataProvider;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editorImpl", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "value", "", "isModified", "()Z", "isValid", "isDisposed", "listenChanges", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "asyncLoader", "Lcom/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader;", "textEditor", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "listenChanges$intellij_platform_ide_impl", "add", "Ljava/awt/Component;", "comp", "constraints", "", "__add", "component", "addLoadingDecoratorUi", "Ljavax/swing/JComponent;", "addLoadingDecoratorUi$intellij_platform_ide_impl", "dispose", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "isModifiedImpl", "updateModifiedProperty", "isEditorValid", "isEditorValidImpl", "updateValidProperty", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getBackground", "Ljava/awt/Color;", "getComponentGraphics", "Ljava/awt/Graphics;", "g", "MyDocumentListener", "MyFileTypeListener", "MyVirtualFileListener", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public class TextEditorComponent
extends JLayeredPane
implements UiCompatibleDataProvider {
    @NotNull
    private final VirtualFile file;
    @JvmField
    @NotNull
    public final EditorImpl editorImpl;
    private boolean isModified;
    private boolean isValid;
    private volatile boolean isDisposed;

    public TextEditorComponent(@NotNull VirtualFile file2, @NotNull EditorImpl editorImpl) {
        GridBagConstraints gridBagConstraints;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editorImpl, (String)"editorImpl");
        this.file = file2;
        this.editorImpl = editorImpl;
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
        EditorImpl editor2 = this.editorImpl;
        editor2.getComponent().setFocusable(false);
        MarkupModelEx markupModelEx = editor2.getMarkupModel();
        Intrinsics.checkNotNull((Object)markupModelEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorMarkupModel");
        ((EditorMarkupModel)markupModelEx).setErrorStripeVisible(true);
        editor2.getGutterComponentEx().setRightFreePaintersAreaState(EditorGutterFreePainterAreaState.SHOW);
        editor2.setFile(this.file);
        editor2.setContextMenuGroupId("EditorPopupMenu");
        editor2.setDropHandler(new FileEditorDropHandler(editor2));
        GridBagConstraints gridBagConstraints2 = gridBagConstraints = new GridBagConstraints();
        Component component2 = editor2.getComponent();
        TextEditorComponent textEditorComponent = this;
        boolean bl = false;
        it.gridx = 0;
        it.gridy = 0;
        it.weightx = 1.0;
        it.weighty = 1.0;
        it.fill = 1;
        Unit unit = Unit.INSTANCE;
        super.add(component2, gridBagConstraints);
        this.isModified = this.isModifiedImpl();
        this.isValid = this.isEditorValidImpl();
        TextEditorComponentKt.access$getLOG$p().assertTrue(this.isValid);
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    public final boolean isModified() {
        return this.isModified;
    }

    public final boolean isDisposed() {
        return this.isDisposed;
    }

    public final void listenChanges$intellij_platform_ide_impl(@NotNull Disposable parentDisposable, @NotNull AsyncEditorLoader asyncLoader, @NotNull TextEditorImpl textEditor, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)asyncLoader, (String)"asyncLoader");
        Intrinsics.checkNotNullParameter((Object)((Object)textEditor), (String)"textEditor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        SimpleMessageBusConnection messageBusConnection = project2.getMessageBus().connect(asyncLoader.coroutineScope);
        EditorHighlighterUpdater editorHighlighterUpdater = new EditorHighlighterUpdater(project2, parentDisposable, messageBusConnection, this.getEditor(), this.file, asyncLoader);
        MyVirtualFileListener virtualFileListener = new MyVirtualFileListener(editorHighlighterUpdater, textEditor);
        VirtualFileSystem virtualFileSystem = this.file.getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getFileSystem(...)");
        VirtualFileSystem fileSystem = virtualFileSystem;
        fileSystem.addVirtualFileListener((VirtualFileListener)virtualFileListener);
        MyDocumentListener documentListener2 = new MyDocumentListener(textEditor);
        this.getEditor().getDocument().addDocumentListener((DocumentListener)documentListener2);
        JobKt.getJob((CoroutineContext)asyncLoader.coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> TextEditorComponent.listenChanges$lambda$0(fileSystem, virtualFileListener, this, documentListener2, arg_0));
        Topic topic = FileTypeManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new MyFileTypeListener(textEditor));
    }

    @Override
    @NotNull
    public final Component add(@NotNull Component comp) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        throw new IllegalCallerException();
    }

    @Override
    public final void add(@NotNull Component comp, @NotNull Object constraints) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        throw new IllegalCallerException();
    }

    @ApiStatus.Internal
    public final void __add(@NotNull Component component2, @NotNull Object constraints) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        super.add(component2, constraints);
    }

    public final void addLoadingDecoratorUi$intellij_platform_ide_impl(@NotNull JComponent component2) {
        GridBagConstraints gridBagConstraints;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Integer n = JLayeredPane.DRAG_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"DRAG_LAYER");
        JLayeredPane.putLayer(component2, ((Number)n).intValue());
        GridBagConstraints gridBagConstraints2 = gridBagConstraints = new GridBagConstraints();
        Component component3 = component2;
        TextEditorComponent textEditorComponent = this;
        boolean bl = false;
        it.gridx = 0;
        it.gridy = 0;
        it.anchor = 10;
        Unit unit = Unit.INSTANCE;
        super.add(component3, gridBagConstraints);
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor((Editor)this.editorImpl);
        this.isDisposed = true;
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editorImpl;
    }

    private final boolean isModifiedImpl() {
        return FileDocumentManager.getInstance().isFileModified(this.file);
    }

    public final void updateModifiedProperty(@NotNull TextEditorImpl textEditor) {
        Intrinsics.checkNotNullParameter((Object)((Object)textEditor), (String)"textEditor");
        boolean oldModified = this.isModified;
        this.isModified = this.isModifiedImpl();
        String string = FileEditor.getPropModified();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPropModified(...)");
        textEditor.firePropertyChange(string, oldModified, this.isModified);
    }

    public final boolean isEditorValid() {
        return this.isValid && !this.editorImpl.isDisposed();
    }

    private final boolean isEditorValidImpl() {
        return FileDocumentManager.getInstance().getDocument(this.file) != null;
    }

    private final void updateValidProperty(TextEditorImpl textEditor) {
        boolean oldValid = this.isValid;
        this.isValid = this.isEditorValidImpl();
        String string = FileEditor.getPropValid();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPropValid(...)");
        textEditor.firePropertyChange(string, oldValid, this.isValid);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (this.editorImpl.isDisposed()) {
            return;
        }
        DataKey dataKey = CommonDataKeys.EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"EDITOR");
        sink.set(dataKey, (Object)this.editorImpl);
        DataKey dataKey2 = CommonDataKeys.CARET;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"CARET");
        sink.set(dataKey2, (Object)this.editorImpl.getCaretModel().getCurrentCaret());
        DataKey dataKey3 = CommonDataKeys.VIRTUAL_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"VIRTUAL_FILE");
        sink.set(dataKey3, (Object)this.file);
    }

    @Override
    @Nullable
    public Color getBackground() {
        Object object = this.editorImpl;
        if (object == null || (object = ((EditorImpl)object).getBackgroundColor()) == null) {
            object = super.getBackground();
        }
        return object;
    }

    @Override
    @NotNull
    protected Graphics getComponentGraphics(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D graphics2D = JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(g));
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"runGlobalCGTransform(...)");
        return graphics2D;
    }

    private static final Unit listenChanges$lambda$0(VirtualFileSystem $fileSystem, MyVirtualFileListener $virtualFileListener, TextEditorComponent this$0, MyDocumentListener $documentListener, Throwable it) {
        $fileSystem.removeVirtualFileListener((VirtualFileListener)$virtualFileListener);
        this$0.getEditor().getDocument().removeDocumentListener((DocumentListener)$documentListener);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/fileEditor/impl/text/TextEditorComponent$MyDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "textEditor", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorImpl;", "<init>", "(Lcom/intellij/openapi/fileEditor/impl/text/TextEditorComponent;Lcom/intellij/openapi/fileEditor/impl/text/TextEditorImpl;)V", "updateRunnable", "Ljava/lang/Runnable;", "isUpdateScheduled", "", "documentChanged", "", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.platform.ide.impl"})
    private final class MyDocumentListener
    implements DocumentListener {
        @NotNull
        private final TextEditorImpl textEditor;
        @NotNull
        private final Runnable updateRunnable;
        private boolean isUpdateScheduled;

        public MyDocumentListener(TextEditorImpl textEditor) {
            Intrinsics.checkNotNullParameter((Object)((Object)textEditor), (String)"textEditor");
            this.textEditor = textEditor;
            this.updateRunnable = () -> MyDocumentListener.updateRunnable$lambda$0(this, TextEditorComponent.this);
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!this.isUpdateScheduled) {
                ApplicationManager.getApplication().invokeLater(this.updateRunnable);
                this.isUpdateScheduled = true;
            }
        }

        private static final void updateRunnable$lambda$0(MyDocumentListener this$0, TextEditorComponent this$1) {
            this$0.isUpdateScheduled = false;
            this$1.updateModifiedProperty(this$0.textEditor);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/fileEditor/impl/text/TextEditorComponent$MyFileTypeListener;", "Lcom/intellij/openapi/fileTypes/FileTypeListener;", "textEditor", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorImpl;", "<init>", "(Lcom/intellij/openapi/fileEditor/impl/text/TextEditorComponent;Lcom/intellij/openapi/fileEditor/impl/text/TextEditorImpl;)V", "fileTypesChanged", "", "event", "Lcom/intellij/openapi/fileTypes/FileTypeEvent;", "intellij.platform.ide.impl"})
    private final class MyFileTypeListener
    implements FileTypeListener {
        @NotNull
        private final TextEditorImpl textEditor;

        public MyFileTypeListener(TextEditorImpl textEditor) {
            Intrinsics.checkNotNullParameter((Object)((Object)textEditor), (String)"textEditor");
            this.textEditor = textEditor;
        }

        public void fileTypesChanged(@NotNull FileTypeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TextEditorComponent.this.updateValidProperty(this.textEditor);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/fileEditor/impl/text/TextEditorComponent$MyVirtualFileListener;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "editorHighlighterUpdater", "Lcom/intellij/openapi/fileEditor/impl/text/EditorHighlighterUpdater;", "textEditor", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorImpl;", "<init>", "(Lcom/intellij/openapi/fileEditor/impl/text/TextEditorComponent;Lcom/intellij/openapi/fileEditor/impl/text/EditorHighlighterUpdater;Lcom/intellij/openapi/fileEditor/impl/text/TextEditorImpl;)V", "propertyChanged", "", "e", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "contentsChanged", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "intellij.platform.ide.impl"})
    private final class MyVirtualFileListener
    implements VirtualFileListener {
        @NotNull
        private final EditorHighlighterUpdater editorHighlighterUpdater;
        @NotNull
        private final TextEditorImpl textEditor;

        public MyVirtualFileListener(@NotNull EditorHighlighterUpdater editorHighlighterUpdater, TextEditorImpl textEditor) {
            Intrinsics.checkNotNullParameter((Object)editorHighlighterUpdater, (String)"editorHighlighterUpdater");
            Intrinsics.checkNotNullParameter((Object)((Object)textEditor), (String)"textEditor");
            this.editorHighlighterUpdater = editorHighlighterUpdater;
            this.textEditor = textEditor;
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (Intrinsics.areEqual((Object)e.getPropertyName(), (Object)"name")) {
                TextEditorComponent.this.updateValidProperty(this.textEditor);
                if (Intrinsics.areEqual((Object)e.getFile(), (Object)TextEditorComponent.this.getFile()) && (Intrinsics.areEqual((Object)"FileContentUtilCore.saveOrReload", (Object)e.getRequestor()) || !Intrinsics.areEqual((Object)e.getOldValue(), (Object)e.getNewValue()))) {
                    this.editorHighlighterUpdater.updateHighlighters();
                }
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.isFromSave()) {
                ThreadingAssertions.assertEventDispatchThread();
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                VirtualFile file2 = virtualFile;
                TextEditorComponentKt.access$getLOG$p().assertTrue(file2.isValid());
                if (Intrinsics.areEqual((Object)file2, (Object)TextEditorComponent.this.getFile())) {
                    TextEditorComponent.this.updateModifiedProperty(this.textEditor);
                }
            }
        }
    }
}

