/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.ChooseActionsDialog;
import com.intellij.openapi.keymap.impl.ui.QuickListContent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class QuickListPanel {
    private final CollectionListModel<String> myActionsModel;
    private final QuickListContent content;
    private final JBList<String> myActionsList;
    final JTextField myName;
    QuickList item;

    QuickListPanel(final @NotNull CollectionListModel<QuickList> model2) {
        if (model2 == null) {
            QuickListPanel.$$$reportNull$$$0(0);
        }
        this.myActionsModel = new MyCollectionListModel();
        this.myActionsList = new JBList(this.myActionsModel);
        this.myActionsList.setCellRenderer((ListCellRenderer)new MyListCellRenderer());
        this.myActionsList.getEmptyText().setText(KeyMapBundle.message((String)"no.actions", (Object[])new Object[0]));
        this.myActionsList.setEnabled(true);
        this.content = new QuickListContent(ToolbarDecorator.createDecorator(this.myActionsList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                List items2 = model2.getItems();
                ChooseActionsDialog dialog2 = new ChooseActionsDialog((Component)QuickListPanel.this.myActionsList, KeymapManager.getInstance().getActiveKeymap(), items2.toArray(new QuickList[0]));
                if (dialog2.showAndGet()) {
                    String[] ids;
                    for (String id2 : ids = dialog2.getTreeSelectedActionIds()) {
                        QuickListPanel.this.includeActionId(id2);
                    }
                    List list2 = QuickListPanel.this.myActionsModel.getItems();
                    int size2 = list2.size();
                    ListSelectionModel selectionModel = QuickListPanel.this.myActionsList.getSelectionModel();
                    if (size2 > 0) {
                        selectionModel.removeIndexInterval(0, size2 - 1);
                    }
                    for (String id1 : ids) {
                        int idx = list2.lastIndexOf(id1);
                        if (idx < 0) continue;
                        selectionModel.addSelectionInterval(idx, idx);
                    }
                }
            }
        }).addExtraAction((AnAction)new DumbAwareAction(KeyMapBundle.message((String)"keymap.action.add.separator", (Object[])new Object[0]), null, AllIcons.General.SeparatorH){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                QuickListPanel.this.myActionsModel.add((Object)"QuickList.$Separator$");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/QuickListPanel$1", "actionPerformed"));
            }
        }).setButtonComparator(new String[]{CommonActionsPanel.Buttons.ADD.getText(), KeyMapBundle.message((String)"keymap.action.add.separator", (Object[])new Object[0]), CommonActionsPanel.Buttons.REMOVE.getText(), CommonActionsPanel.Buttons.UP.getText(), CommonActionsPanel.Buttons.DOWN.getText()}).createPanel());
        this.myName = this.content.name;
    }

    public void apply() {
        String[] ids;
        if (this.item == null) {
            return;
        }
        this.item.setName(this.myName.getText().trim());
        this.item.setDescription(this.content.description.getText().trim());
        ListModel model2 = this.myActionsList.getModel();
        int size2 = model2.getSize();
        if (size2 == 0) {
            ids = ArrayUtilRt.EMPTY_STRING_ARRAY;
        } else {
            ids = new String[size2];
            for (int i2 = 0; i2 < size2; ++i2) {
                ids[i2] = (String)model2.getElementAt(i2);
            }
        }
        this.item.setActionIds(ids);
    }

    public void setItem(@Nullable QuickList item) {
        this.apply();
        this.item = item;
        if (item == null) {
            return;
        }
        this.myName.setText(item.getDisplayName());
        this.myName.setEnabled(QuickListsManager.getInstance().getSchemeManager().isMetadataEditable((Object)item));
        this.content.description.setText(item.getDescription());
        this.myActionsModel.removeAll();
        for (String id2 : item.getActionIds()) {
            this.includeActionId(id2);
        }
    }

    private void includeActionId(@NotNull String id2) {
        if (id2 == null) {
            QuickListPanel.$$$reportNull$$$0(1);
        }
        if ("QuickList.$Separator$".equals(id2) || this.myActionsModel.getElementIndex((Object)id2) == -1) {
            this.myActionsModel.add((Object)id2);
        }
    }

    public JPanel getPanel() {
        return this.content.getContent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/QuickListPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "includeActionId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyCollectionListModel
    extends CollectionListModel<String> {
        private MyCollectionListModel() {
            super((Object[])new String[0]);
        }

        public void exchangeRows(int oldIndex, int newIndex) {
            String element = (String)this.getElementAt(oldIndex);
            this.remove(oldIndex);
            this.add(newIndex, element);
        }
    }

    private static final class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList list2, Object value, int index, boolean selected, boolean focused) {
            if (list2 == null) {
                MyListCellRenderer.$$$reportNull$$$0(0);
            }
            super.getListCellRendererComponent((JList<?>)list2, value, index, selected, focused);
            Icon icon2 = null;
            String actionId = (String)value;
            if ("QuickList.$Separator$".equals(actionId)) {
                this.setText("-------------");
            } else {
                Icon actionIcon;
                AnAction action2 = ActionManager.getInstance().getAction(actionId);
                this.setText(action2 != null ? action2.getTemplatePresentation().getText() : actionId);
                if (action2 != null && (actionIcon = action2.getTemplatePresentation().getIcon()) != null) {
                    icon2 = actionIcon;
                }
                if (actionId.startsWith("QuickList.")) {
                    icon2 = null;
                }
                this.setIcon(ActionsTree.getEvenIcon(icon2));
            }
            MyListCellRenderer myListCellRenderer = this;
            if (myListCellRenderer == null) {
                MyListCellRenderer.$$$reportNull$$$0(1);
            }
            return myListCellRenderer;
        }

        @Override
        public Dimension getPreferredSize() {
            return UIUtil.updateListRowHeight((Dimension)super.getPreferredSize());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/QuickListPanel$MyListCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/QuickListPanel$MyListCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getListCellRendererComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getListCellRendererComponent";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

