/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a7\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0003\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"findExtensionPoint", "Lcom/intellij/openapi/extensions/ExtensionPoint;", "", "area", "Lcom/intellij/openapi/extensions/ExtensionsArea;", "name", "", "collect", "", "configurableWrappers", "", "Lcom/intellij/openapi/options/ex/ConfigurableWrapper;", "configurablesWithEpDependencies", "Lcom/intellij/openapi/options/Configurable$WithEpDependencies;", "configurables", "", "Lcom/intellij/openapi/options/Configurable;", "(Ljava/util/List;Ljava/util/List;[Lcom/intellij/openapi/options/Configurable;)V", "intellij.platform.ide.impl"})
public final class EpBasedConfigurableGroupKt {
    private static final ExtensionPoint<Object> findExtensionPoint(ExtensionsArea area, String name2) {
        if (area.hasExtensionPoint(name2)) {
            return area.getExtensionPoint(name2);
        }
        return ApplicationManager.getApplication().getExtensionArea().getExtensionPoint(name2);
    }

    @ApiStatus.Internal
    private static final void collect(List<ConfigurableWrapper> configurableWrappers, List<Configurable.WithEpDependencies> configurablesWithEpDependencies, Configurable[] configurables2) {
        for (Configurable configurable : configurables2) {
            Configurable[] configurableArray;
            Intrinsics.checkNotNull((Object)configurable);
            Configurable configurable2 = configurable;
            if (configurable2 instanceof ConfigurableWrapper) {
                Class providerClass;
                ConfigurableEP<?> ep;
                Intrinsics.checkNotNullExpressionValue(((ConfigurableWrapper)configurable2).getExtensionPoint(), (String)"getExtensionPoint(...)");
                if (ep.childrenEPName != null || ep.dynamic) {
                    configurableWrappers.add((ConfigurableWrapper)configurable2);
                }
                if (((ConfigurableWrapper)configurable2).getProviderClass() != null && (providerClass = ep.findClassOrNull(((ConfigurableWrapper)configurable2).getProviderClass())) != null && Configurable.WithEpDependencies.class.isAssignableFrom(providerClass)) {
                    configurableWrappers.add((ConfigurableWrapper)configurable2);
                }
            } else if (configurable2 instanceof Configurable.WithEpDependencies) {
                configurablesWithEpDependencies.add((Configurable.WithEpDependencies)configurable2);
            }
            if (!(configurable2 instanceof Configurable.Composite)) continue;
            try {
                configurableArray = ((Configurable.Composite)configurable2).getConfigurables();
                Intrinsics.checkNotNull((Object)configurableArray);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                ConfigurableWrapper.LOG.error("Cannot get children " + configurable2, e);
                continue;
            }
            Configurable[] children2 = configurableArray;
            EpBasedConfigurableGroupKt.collect(configurableWrappers, configurablesWithEpDependencies, children2);
        }
    }

    public static final /* synthetic */ void access$collect(List configurableWrappers, List configurablesWithEpDependencies, Configurable[] configurables2) {
        EpBasedConfigurableGroupKt.collect(configurableWrappers, configurablesWithEpDependencies, configurables2);
    }

    public static final /* synthetic */ ExtensionPoint access$findExtensionPoint(ExtensionsArea area, String name2) {
        return EpBasedConfigurableGroupKt.findExtensionPoint(area, name2);
    }
}

