/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsEventLogGroup;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ$\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\bJ\u001e\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001cJ$\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\b2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010\"\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fJ\b\u0010#\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/project/DumbModeBlockedFunctionalityCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "FUNCTIONALITY_SOURCE", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/openapi/project/DumbModeBlockedFunctionality;", "EXECUTED_WHEN_SMART", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "FUNCTIONALITY_BLOCKED", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "ACTION_FAILED", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "logActionBlocked", "", "project", "Lcom/intellij/openapi/project/Project;", "actionId", "logActionsBlocked", "actionIds", "", "executedAfterBlock", "", "lastEqualityObjectReference", "Ljava/util/concurrent/atomic/AtomicReference;", "", "logFunctionalityBlocked", "functionality", "logFunctionalityBlockedWithCoalescing", "equalityObject", "doLogFunctionalityBlocked", "logActionFailedToExecute", "getGroup", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDumbModeBlockedFunctionalityCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumbModeBlockedFunctionalityCollector.kt\ncom/intellij/openapi/project/DumbModeBlockedFunctionalityCollector\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n23#2:93\n*S KotlinDebug\n*F\n+ 1 DumbModeBlockedFunctionalityCollector.kt\ncom/intellij/openapi/project/DumbModeBlockedFunctionalityCollector\n*L\n72#1:93\n*E\n"})
public final class DumbModeBlockedFunctionalityCollector
extends CounterUsagesCollector {
    @NotNull
    public static final DumbModeBlockedFunctionalityCollector INSTANCE = new DumbModeBlockedFunctionalityCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("dumb.mode.blocked.functionality", 11, null, 4, null);
    @NotNull
    private static final EnumEventField<DumbModeBlockedFunctionality> FUNCTIONALITY_SOURCE = EventFields.Enum$default((String)"functionality", DumbModeBlockedFunctionality.class, null, (int)4, null);
    @NotNull
    private static final BooleanEventField EXECUTED_WHEN_SMART = EventFields.Boolean((String)"executed_when_smart");
    @NotNull
    private static final VarargEventId FUNCTIONALITY_BLOCKED;
    @NotNull
    private static final EventId1<String> ACTION_FAILED;
    @NotNull
    private static final AtomicReference<Object> lastEqualityObjectReference;

    private DumbModeBlockedFunctionalityCollector() {
    }

    public final void logActionBlocked(@NotNull Project project2, @NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        lastEqualityObjectReference.set(null);
        EventPair[] eventPairArray = new EventPair[]{ActionsEventLogGroup.ACTION_ID.with((Object)actionId), FUNCTIONALITY_SOURCE.with((Object)DumbModeBlockedFunctionality.Action)};
        FUNCTIONALITY_BLOCKED.log(project2, eventPairArray);
    }

    public final void logActionsBlocked(@NotNull Project project2, @NotNull List<String> actionIds, boolean executedAfterBlock) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(actionIds, (String)"actionIds");
        lastEqualityObjectReference.set(null);
        switch (actionIds.size()) {
            case 0: {
                EventPair[] eventPairArray = new EventPair[]{FUNCTIONALITY_SOURCE.with((Object)DumbModeBlockedFunctionality.ActionWithoutId), EXECUTED_WHEN_SMART.with((Object)executedAfterBlock)};
                FUNCTIONALITY_BLOCKED.log(project2, eventPairArray);
                break;
            }
            case 1: {
                EventPair[] eventPairArray = new EventPair[]{ActionsEventLogGroup.ACTION_ID.with((Object)actionIds.get(0)), FUNCTIONALITY_SOURCE.with((Object)DumbModeBlockedFunctionality.Action), EXECUTED_WHEN_SMART.with((Object)executedAfterBlock)};
                FUNCTIONALITY_BLOCKED.log(project2, eventPairArray);
                break;
            }
            default: {
                EventPair[] eventPairArray = new EventPair[]{FUNCTIONALITY_SOURCE.with((Object)DumbModeBlockedFunctionality.MultipleActionIds), EXECUTED_WHEN_SMART.with((Object)executedAfterBlock)};
                FUNCTIONALITY_BLOCKED.log(project2, eventPairArray);
            }
        }
    }

    public final void logFunctionalityBlocked(@NotNull Project project2, @NotNull DumbModeBlockedFunctionality functionality) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)functionality, (String)"functionality");
        this.doLogFunctionalityBlocked(project2, functionality, null);
    }

    public final void logFunctionalityBlockedWithCoalescing(@NotNull Project project2, @NotNull DumbModeBlockedFunctionality functionality, @NotNull Object equalityObject) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)functionality, (String)"functionality");
        Intrinsics.checkNotNullParameter((Object)equalityObject, (String)"equalityObject");
        this.doLogFunctionalityBlocked(project2, functionality, equalityObject);
    }

    private final void doLogFunctionalityBlocked(Project project2, DumbModeBlockedFunctionality functionality, Object equalityObject) {
        if (functionality == DumbModeBlockedFunctionality.Action) {
            DumbModeBlockedFunctionalityCollector $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DumbModeBlockedFunctionalityCollector.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Use DumbModeBlockingFunctionalityCollector.Companion.logActionBlocked instead");
        }
        if (equalityObject == null) {
            lastEqualityObjectReference.set(null);
        } else if (Intrinsics.areEqual((Object)equalityObject, (Object)lastEqualityObjectReference.getAndSet(equalityObject))) {
            return;
        }
        EventPair[] eventPairArray = new EventPair[]{FUNCTIONALITY_SOURCE.with((Object)functionality)};
        FUNCTIONALITY_BLOCKED.log(project2, eventPairArray);
    }

    static /* synthetic */ void doLogFunctionalityBlocked$default(DumbModeBlockedFunctionalityCollector dumbModeBlockedFunctionalityCollector, Project project2, DumbModeBlockedFunctionality dumbModeBlockedFunctionality, Object object, int n, Object object2) {
        if ((n & 4) != 0) {
            object = null;
        }
        dumbModeBlockedFunctionalityCollector.doLogFunctionalityBlocked(project2, dumbModeBlockedFunctionality, object);
    }

    public final void logActionFailedToExecute(@NotNull Project project2, @Nullable String actionId) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ACTION_FAILED.log(project2, (Object)actionId);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    static {
        EventField[] eventFieldArray = new EventField[]{ActionsEventLogGroup.ACTION_ID, FUNCTIONALITY_SOURCE, EXECUTED_WHEN_SMART};
        FUNCTIONALITY_BLOCKED = GROUP.registerVarargEvent("functionality.blocked", eventFieldArray);
        ACTION_FAILED = GROUP.registerEvent("action.failed.due.to.dumb.mode", (EventField)ActionsEventLogGroup.ACTION_ID);
        lastEqualityObjectReference = new AtomicReference<Object>(null);
    }
}

