/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.eventLog.fus.MachineIdManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.JetBrainsPermanentInstallationID;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.updateSettings.impl.UpdateRequestParametersProvider;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.Url;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class DefaultUpdateRequestParametersProvider
implements UpdateRequestParametersProvider {
    private static final NullableLazyValue<String> ourMachineId = NullableLazyValue.lazyNullable(() -> MachineIdManager.INSTANCE.getAnonymizedMachineId("JetBrainsUpdates"));

    @Override
    @NotNull
    public Url amendUpdateRequest(@NotNull Url url) {
        LicensingFacade facade2;
        String machineId;
        if (url == null) {
            DefaultUpdateRequestParametersProvider.$$$reportNull$$$0(0);
        }
        if ("file".equals(url.getScheme())) {
            Url url2 = url;
            if (url2 == null) {
                DefaultUpdateRequestParametersProvider.$$$reportNull$$$0(1);
            }
            return url2;
        }
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("build", ApplicationInfo.getInstance().getBuild().asString());
        parameters.put("os", SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION);
        if (ApplicationInfoEx.getInstanceEx().isEAP()) {
            parameters.put("eap", "");
        }
        parameters.put("uid", JetBrainsPermanentInstallationID.get());
        if (!PropertiesComponent.getInstance().getBoolean("machine.id.disabled", false) && (machineId = (String)ourMachineId.getValue()) != null) {
            parameters.put("mid", machineId);
        }
        if (ExternalUpdateManager.ACTUAL != null) {
            String name2 = ExternalUpdateManager.ACTUAL == ExternalUpdateManager.TOOLBOX ? "Toolbox" : ExternalUpdateManager.ACTUAL.toolName;
            parameters.put("manager", name2);
        }
        if ((facade2 = LicensingFacade.getInstance()) != null) {
            String userBucket;
            String metadata;
            String subType = facade2.subType;
            if (subType != null) {
                parameters.put("license", subType);
            }
            if ((metadata = facade2.metadata) != null) {
                parameters.put("metadata", metadata);
            }
            if ((userBucket = facade2.userBucket) != null) {
                parameters.put("userBucket", userBucket);
            }
        }
        Url url3 = url.addParameters(parameters);
        if (url3 == null) {
            DefaultUpdateRequestParametersProvider.$$$reportNull$$$0(2);
        }
        return url3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/DefaultUpdateRequestParametersProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/DefaultUpdateRequestParametersProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "amendUpdateRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "amendUpdateRequest";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

