/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.DynamicBundle;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerFacade;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.platform.ide.customization.ExternalProductResourceUrls;
import com.intellij.util.Url;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.system.OS;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001e\u0010\u0015\u001a\u00020\u00162\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0006\u0010\u0017\u001a\u00020\u0018J)\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010\f0\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateInstaller;", "", "<init>", "()V", "UPDATER_MAIN_CLASS", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PATCH_FILE_NAME", "UPDATER_ENTRY", "downloadPatchChain", "", "Ljava/nio/file/Path;", "chain", "Lcom/intellij/openapi/util/BuildNumber;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "downloadPluginUpdates", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "downloaders", "", "installPluginUpdates", "", "cleanupPatch", "", "preparePatchCommand", "", "patchFiles", "(Ljava/util/List;Lcom/intellij/openapi/progress/ProgressIndicator;)[Ljava/lang/String;", "getTempDir", "kotlin.jvm.PlatformType", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nUpdateInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateInstaller.kt\ncom/intellij/openapi/updateSettings/impl/UpdateInstaller\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,185:1\n42#2,3:186\n1#3:189\n37#4,2:190\n13#5:192\n*S KotlinDebug\n*F\n+ 1 UpdateInstaller.kt\ncom/intellij/openapi/updateSettings/impl/UpdateInstaller\n*L\n77#1:186,3\n180#1:190,2\n32#1:192\n*E\n"})
public final class UpdateInstaller {
    @NotNull
    public static final UpdateInstaller INSTANCE = new UpdateInstaller();
    @NotNull
    public static final String UPDATER_MAIN_CLASS = "com.intellij.updater.Runner";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String PATCH_FILE_NAME = "patch-file.zip";
    @NotNull
    private static final String UPDATER_ENTRY = "com/intellij/updater/Runner.class";

    private UpdateInstaller() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final List<Path> downloadPatchChain(@NotNull List<BuildNumber> chain, @NotNull ProgressIndicator indicator2) throws IOException {
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        indicator2.setText(IdeBundle.message((String)"update.downloading.patch.progress", (Object[])new Object[0]));
        List files2 = new ArrayList();
        double share = 1.0 / (double)(chain.size() - 1);
        int n = chain.size();
        for (int i2 = 1; i2 < n; ++i2) {
            Url url;
            BuildNumber from = chain.get(i2 - 1);
            BuildNumber to = chain.get(i2);
            Path patchFile = INSTANCE.getTempDir().resolve("patch-" + from.withoutProductCode().asString() + "-" + to.withoutProductCode().asString() + ".jar");
            if (ExternalProductResourceUrls.Companion.getInstance().computePatchUrl(from, to) == null) {
                throw new IllegalStateException(("Metadata contains information about patch '" + from + "' -> '" + to + "', but 'computePatchUrl' returns 'null'").toString());
            }
            DelegatingProgressIndicator partIndicator2 = new DelegatingProgressIndicator(indicator2, i2, share){
                final /* synthetic */ int $i;
                final /* synthetic */ double $share;
                {
                    this.$i = $i;
                    this.$share = $share;
                    super($indicator);
                }

                public void setFraction(double fraction) {
                    super.setFraction((double)(this.$i - 1) * this.$share + fraction / this.$share);
                }
            };
            LOG.info("downloading " + url);
            HttpRequests.request((Url)url).gzip(false).saveToFile(patchFile, (ProgressIndicator)partIndicator2);
            try {
                Closeable closeable = new ZipFile(patchFile.toFile());
                Throwable throwable = null;
                try {
                    ZipFile it = (ZipFile)closeable;
                    boolean bl = false;
                    if (it.getEntry(PATCH_FILE_NAME) == null || it.getEntry(UPDATER_ENTRY) == null) {
                        throw new IOException("Corrupted patch file: " + patchFile);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (ZipException e) {
                throw new IOException("Corrupted patch file: " + patchFile, e);
            }
            Intrinsics.checkNotNull((Object)patchFile);
            files2.add(patchFile);
        }
        return files2;
    }

    @JvmStatic
    @RequiresBackgroundThread
    @NotNull
    public static final List<PluginDownloader> downloadPluginUpdates(@NotNull Collection<PluginDownloader> downloaders, @NotNull ProgressIndicator indicator2) {
        Intrinsics.checkNotNullParameter(downloaders, (String)"downloaders");
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        indicator2.setText(IdeBundle.message((String)"update.downloading.plugins.progress", (Object[])new Object[0]));
        boolean $i$f$service = false;
        Class<UpdateCheckerFacade> serviceClass$iv = UpdateCheckerFacade.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        UpdateCheckerFacade updateChecker = (UpdateCheckerFacade)object;
        updateChecker.saveDisabledToUpdatePlugins();
        Set<PluginId> disabledToUpdate = updateChecker.getDisabledToUpdate();
        List readyToInstall = new ArrayList();
        for (PluginDownloader downloader : downloaders) {
            try {
                if (!disabledToUpdate.contains(downloader.getId()) && downloader.prepareToInstall(indicator2)) {
                    ((Collection)readyToInstall).add(downloader);
                }
                indicator2.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
        return readyToInstall;
    }

    @JvmStatic
    @RequiresBackgroundThread
    public static final boolean installPluginUpdates(@NotNull Collection<PluginDownloader> downloaders, @NotNull ProgressIndicator indicator2) {
        Intrinsics.checkNotNullParameter(downloaders, (String)"downloaders");
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        List<PluginDownloader> downloadedPluginUpdates = UpdateInstaller.downloadPluginUpdates(downloaders, indicator2);
        if (downloadedPluginUpdates.isEmpty()) {
            return false;
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> UpdateInstaller.installPluginUpdates$lambda$0(downloadedPluginUpdates));
        return true;
    }

    public final void cleanupPatch() {
        NioFiles.deleteRecursively((Path)this.getTempDir());
    }

    @JvmStatic
    @NotNull
    public static final String[] preparePatchCommand(@NotNull List<? extends Path> patchFiles, @NotNull ProgressIndicator indicator2) throws IOException {
        String it;
        Iterable<Path> launcher;
        Intrinsics.checkNotNullParameter(patchFiles, (String)"patchFiles");
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        indicator2.setText(IdeBundle.message((String)"update.preparing.patch.progress", (Object[])new Object[0]));
        Path tempDir = INSTANCE.getTempDir();
        if (PathManager.isUnderHomeDirectory((Path)tempDir)) {
            throw new IOException("Temp directory inside installation: " + tempDir);
        }
        Files.createDirectories(tempDir, new FileAttribute[0]);
        Path jre = Path.of(System.getProperty("java.home"), new String[0]);
        if (PathManager.isUnderHomeDirectory((Path)jre)) {
            Path jreCopy = tempDir.resolve("jre");
            NioFiles.deleteRecursively((Path)jreCopy);
            NioFiles.copyRecursively((Path)jre, (Path)jreCopy);
            jre = jreCopy;
        }
        List args = new ArrayList();
        Path path = PathManager.getHomeDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getHomeDir(...)");
        Path ideHome = path;
        if (OS.CURRENT == OS.Windows && !Files.isWritable(ideHome)) {
            launcher = PathManager.findBinFile((String)"launcher.exe");
            Path elevator = PathManager.findBinFile((String)"elevator.exe");
            if (launcher != null && elevator != null) {
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                args.add(((Object)Files.copy((Path)launcher, tempDir.resolve(launcher.getFileName()), copyOptionArray)).toString());
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(elevator, tempDir.resolve(elevator.getFileName()), copyOptionArray);
            }
        }
        ((Collection)args).add(((Object)jre.resolve(OS.CURRENT == OS.Windows ? "bin\\java.exe" : "bin/java")).toString());
        ((Collection)args).add("-Xmx2000m");
        ((Collection)args).add("-cp");
        ((Collection)args).add(CollectionsKt.last(patchFiles).toString());
        ((Collection)args).add("-Djna.nosys=true");
        ((Collection)args).add("-Djna.boot.library.path=");
        ((Collection)args).add("-Djna.debug_load=true");
        ((Collection)args).add("-Djna.debug_load.jna=true");
        ((Collection)args).add("-Djava.io.tmpdir=" + tempDir);
        ((Collection)args).add("-Didea.updater.log=" + PathManager.getLogDir());
        String string = System.getProperty("sun.java2d.metal");
        if (string != null) {
            it = string;
            boolean bl = false;
            ((Collection)args).add("-Dsun.java2d.metal=" + it);
        }
        String string2 = System.getProperty("awt.toolkit.name");
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            ((Collection)args).add("-Dawt.toolkit.name=" + it);
        }
        ((Collection)args).add("-Dswing.defaultlaf=" + UIManager.getSystemLookAndFeelClassName());
        ((Collection)args).add("-Duser.language=" + DynamicBundle.getLocale().getLanguage());
        ((Collection)args).add("-Duser.country=" + DynamicBundle.getLocale().getCountry());
        ((Collection)args).add(UPDATER_MAIN_CLASS);
        ((Collection)args).add(patchFiles.size() == 1 ? "install" : "batch-install");
        ((Collection)args).add(((Object)ideHome).toString());
        if (patchFiles.size() > 1) {
            launcher = args;
            Iterable iterable = patchFiles;
            String string3 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pathSeparator");
            launcher.add(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string3, null, null, (int)0, null, null, (int)62, null));
        }
        Collection $this$toTypedArray$iv = args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private final Path getTempDir() {
        return PathManager.getTempDir().resolve("patch-update");
    }

    private static final void installPluginUpdates$lambda$0(List $downloadedPluginUpdates) {
        for (PluginDownloader downloader : $downloadedPluginUpdates) {
            try {
                downloader.install();
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UpdateInstaller.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

